/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.hibernate;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.MatchMode;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.spi.TypedValue;

public class LikeExpression
extends org.hibernate.criterion.LikeExpression {
    protected MatchMode matchMode;
    private boolean escaped = false;

    public LikeExpression(String propertyName, String value, MatchMode matchMode) {
        super(propertyName, value, null, false);
        this.matchMode = matchMode;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        this.escapeValue(criteriaQuery.getFactory().getDialect());
        return super.toSqlString(criteria, criteriaQuery);
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        this.escapeValue(criteriaQuery.getFactory().getDialect());
        return super.getTypedValues(criteria, criteriaQuery);
    }

    protected String escape(String value, Character escapeChar, Dialect dialect) {
        if (escapeChar == null) {
            return value;
        }
        String escapeString = escapeChar.toString();
        value = value.replace(escapeString, escapeString + escapeString).replace("_", escapeString + "_").replace("%", escapeString + "%");
        if (dialect instanceof SQLServerDialect) {
            value = value.replace("[", escapeString + "[");
        }
        return value;
    }

    protected void escapeValue(Dialect dialect) {
        if (this.escaped) {
            return;
        }
        try {
            String value = (String)FieldUtils.readField((Object)((Object)this), (String)"value", (boolean)true);
            Character escapeChar = this.escapeChar(dialect);
            value = this.escape(value, escapeChar, dialect);
            if (MatchMode.EXACT == this.matchMode) {
                value = this.replaceWildcards(value, escapeChar);
            }
            if (this.matchMode != null) {
                value = this.matchMode.toMatchString(value);
            }
            FieldUtils.writeField((Object)((Object)this), (String)"value", (Object)value, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        this.escaped = true;
    }

    protected Character escapeChar(Dialect dialect) {
        if (dialect instanceof SQLServerDialect) {
            this.setEscapeChar(Character.valueOf('\\'));
            return Character.valueOf('\\');
        }
        if (dialect instanceof DB2Dialect) {
            this.setEscapeChar(Character.valueOf('\\'));
            return Character.valueOf('\\');
        }
        if (dialect instanceof HSQLDialect) {
            this.setEscapeChar(Character.valueOf('\\'));
            return Character.valueOf('\\');
        }
        if (dialect instanceof MySQLDialect) {
            return Character.valueOf('\\');
        }
        if (dialect instanceof Oracle8iDialect || dialect instanceof Oracle9Dialect) {
            this.setEscapeChar(Character.valueOf('\\'));
            return Character.valueOf('\\');
        }
        if (dialect instanceof PostgreSQL81Dialect) {
            return Character.valueOf('\\');
        }
        return null;
    }

    protected void setEscapeChar(Character escapeChar) {
        try {
            FieldUtils.writeField((Object)((Object)this), (String)"escapeChar", (Object)escapeChar, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String replaceWildcards(String value, Character escapeChar) {
        if (!value.contains("*") && !value.contains("?")) {
            return value;
        }
        String[] searchList = new String[]{"\\*", "\\?", "*", "?"};
        String[] replacementList = new String[]{"*", "?", "%", "_"};
        if (Character.valueOf('\\').equals(escapeChar)) {
            searchList = new String[]{"\\\\*", "\\\\?", "*", "?"};
        }
        return StringUtils.replaceEach((String)value, (String[])searchList, (String[])replacementList);
    }
}

