/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.initdb.AbstractObjectXML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.Cursor;
import jp.jasminesoft.jfc.initdb.HibernateResultListWrapper;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;

public class HibernateXML2DBLoaderDao
extends AbstractObjectXML2DBLoaderDao {
    private static final Logger logger = LogManager.getLogger(HibernateXML2DBLoaderDao.class);
    private Session session;
    private Transaction tx;
    int counter = 0;

    public HibernateXML2DBLoaderDao(Directory dir, String objclassname) throws Exception {
        super(dir, objclassname);
        this.open();
    }

    @Override
    public void evict(Object obj) {
        this.session.evict(obj);
    }

    private void open() {
        this.session = HibernateUtil.openSession();
        this.tx = this.session.beginTransaction();
        this.counter = 0;
    }

    @Override
    public void createTable() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropTable() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean insertObject(Object obj) throws Exception {
        this.session.save(obj);
        logger.debug("insert object " + obj.toString());
        if (HibernateUtil.JDBC_BATCH_SIZE > 0 && ++this.counter % HibernateUtil.JDBC_BATCH_SIZE == 0) {
            this.session.flush();
            this.session.clear();
        }
        return true;
    }

    @Override
    public int getTableStatus() throws Exception {
        ClassMetadata metadata = HibernateUtil.getSessionFactory().getClassMetadata(this.objclass);
        if (metadata == null) {
            return 0;
        }
        return 2;
    }

    @Override
    protected boolean updateObject(Object obj) throws Exception {
        this.session.update(obj);
        logger.debug("update object " + obj.toString());
        if (HibernateUtil.JDBC_BATCH_SIZE > 0 && ++this.counter % HibernateUtil.JDBC_BATCH_SIZE == 0) {
            this.session.flush();
            this.session.clear();
        }
        return true;
    }

    @Override
    public void rollback() {
        this.tx.rollback();
        this.close();
        this.open();
    }

    @Override
    public void commit() {
        this.tx.commit();
        this.close();
        this.open();
    }

    @Override
    public void close() {
        this.session.close();
    }

    @Override
    public Cursor selectAsCursor() throws Exception {
        ScrollableResults results = null;
        try {
            String expression = "select c from " + this.objclass.getName() + " as c";
            Query query = this.session.createQuery(expression);
            results = query.scroll(ScrollMode.FORWARD_ONLY);
        }
        catch (Exception e) {
            block5: {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (Exception e2) {
                        logger.debug("Failed to close results for table " + this.dir.getTablename() + ".", (Throwable)e2);
                        if (!logger.isDebugEnabled()) break block5;
                        e2.printStackTrace();
                    }
                }
            }
            throw e;
        }
        return new HibernateResultListWrapper(results);
    }
}

