/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import jp.jasminesoft.jfc.initdb.AbstractObjectXML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.Cursor;
import jp.jasminesoft.jfc.initdb.RelaxerJdbcXML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import jp.jasminesoft.jfc.master.app.InsertMasterProcessBean;
import jp.jasminesoft.jfc.master.app.ShowListMasterProcessBean;
import jp.jasminesoft.jfc.master.app.UpdateMasterProcessBean;
import jp.jasminesoft.jfc.model.master.Master;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MasterJdbcXML2DBLoaderDao
extends AbstractObjectXML2DBLoaderDao {
    private static final Logger logger = LogManager.getLogger(MasterJdbcXML2DBLoaderDao.class);
    private Connection con;
    private boolean tablenameIgnoreCase;

    public MasterJdbcXML2DBLoaderDao(Directory dir, String objclassname, Connection con) throws Exception {
        super(dir, objclassname);
        this.con = con;
    }

    public void setTablenameIgnoreCase(boolean tablenameIgnoreCase) {
        this.tablenameIgnoreCase = tablenameIgnoreCase;
    }

    public boolean isTablenameIgnoreCase() {
        return this.tablenameIgnoreCase;
    }

    @Override
    public void createTable() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropTable() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean insertObject(Object obj) throws Exception {
        String tableName = this.dir.getTablename();
        InsertMasterProcessBean pbean = new InsertMasterProcessBean();
        pbean.insertObject(this.con, tableName, (Master)obj);
        logger.debug("insert object " + obj.toString());
        return true;
    }

    @Override
    public int getTableStatus() throws Exception {
        return RelaxerJdbcXML2DBLoaderDao.getTableStatus(this.con, this.dir, this.isTablenameIgnoreCase());
    }

    @Override
    protected boolean updateObject(Object obj) throws Exception {
        String tableName = this.dir.getTablename();
        UpdateMasterProcessBean pbean = new UpdateMasterProcessBean();
        pbean.updateObject(this.con, tableName, (Master)obj);
        logger.debug("update object " + obj.toString());
        return true;
    }

    @Override
    public void rollback() {
        try {
            if (this.con == null || this.con.getAutoCommit()) {
                return;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to get auto commit value for table " + this.dir.getTablename() + ".", (Throwable)e);
            return;
        }
        try {
            this.con.rollback();
        }
        catch (SQLException er) {
            logger.warn("Failed to rollback table " + this.dir.getTablename() + ".", (Throwable)er);
        }
    }

    @Override
    public void commit() {
        try {
            if (this.con == null || this.con.getAutoCommit()) {
                return;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to get auto commit value for table " + this.dir.getTablename() + ".", (Throwable)e);
            return;
        }
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            logger.warn("Failed to commit table " + this.dir.getTablename() + ".", (Throwable)e);
        }
    }

    @Override
    public void close() {
        block3: {
            if (this.con == null) {
                return;
            }
            try {
                this.con.close();
            }
            catch (SQLException e) {
                logger.debug("Failed to close connection.", (Throwable)e);
                if (!logger.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    @Override
    public Cursor selectAsCursor() throws Exception {
        String tableName = this.dir.getTablename();
        ShowListMasterProcessBean pbean = new ShowListMasterProcessBean();
        List<Master> list = pbean.getMasterList(this.con, tableName);
        Iterator<Master> it = list.iterator();
        return new MasterJdbcResultListWrapper(it);
    }

    private class MasterJdbcResultListWrapper
    implements Cursor {
        private Iterator<Master> it;
        private Object nowobj;

        MasterJdbcResultListWrapper(Iterator<Master> it) {
            this.it = it;
        }

        @Override
        public Object getObject() throws Exception {
            return this.nowobj;
        }

        @Override
        public boolean next() throws Exception {
            if (!this.it.hasNext()) {
                return false;
            }
            this.nowobj = this.it.next();
            return true;
        }
    }
}

