/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.ResultListWrapper;
import jp.jasminesoft.jfc.initdb.Cursor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

class RelaxerJdbcResultListWrapper
implements ResultListWrapper,
Releasable,
Cursor {
    private static final Logger logger = LogManager.getLogger(RelaxerJdbcResultListWrapper.class);
    private ResultSet rs;
    private Statement st;
    private Object table;
    private Method makeDocumentMethod = null;
    private Constructor objectConstructor = null;

    RelaxerJdbcResultListWrapper(ResultSet rs, Statement st, Object table) {
        this.rs = rs;
        this.st = st;
        this.table = table;
    }

    @Override
    public boolean next() throws Exception {
        return this.rs.next();
    }

    @Override
    public Object getObject() throws Exception {
        if (this.makeDocumentMethod == null) {
            Class<?> tableclass = this.table.getClass();
            this.makeDocumentMethod = tableclass.getMethod("makeDocument", ResultSet.class);
        }
        Document doc = (Document)this.makeDocumentMethod.invoke(this.table, this.rs);
        if (this.objectConstructor == null) {
            Class<?> tableclass = this.table.getClass();
            Method selectMethod = tableclass.getMethod("select", new Class[0]);
            Class<?> rettype = selectMethod.getReturnType();
            if (!rettype.isArray()) {
                logger.error("Failed to process select method, selectmethod:" + selectMethod.toString() + " returntype:" + rettype);
                return null;
            }
            Class<?> comptype = rettype.getComponentType();
            this.objectConstructor = comptype.getConstructor(Document.class);
        }
        return this.objectConstructor.newInstance(doc);
    }

    @Override
    public void release() {
        block5: {
            block4: {
                try {
                    this.rs.close();
                }
                catch (Exception e) {
                    logger.debug("Failed to close result set.", (Throwable)e);
                    if (!logger.isDebugEnabled()) break block4;
                    e.printStackTrace();
                }
            }
            try {
                this.st.close();
            }
            catch (Exception e) {
                logger.debug("Failed to close statement.", (Throwable)e);
                if (!logger.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
    }

    public List getResultList(int start, int end) {
        try {
            return this.getResultListE(start, end);
        }
        catch (Exception e) {
            logger.debug("Failed to get result.", (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return Collections.EMPTY_LIST;
        }
    }

    private List getResultListE(int start, int end) throws Exception {
        int len = end - start;
        if (len <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (!this.rs.absolute(start + 1)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        do {
            Object obj;
            if ((obj = this.getObject()) == null) {
                return list;
            }
            list.add(obj);
        } while (++i < len && this.next());
        return list;
    }

    @Override
    public int getResultSize() {
        try {
            if (!this.rs.last()) {
                return 0;
            }
            return this.rs.getRow();
        }
        catch (Exception e) {
            logger.debug("Failed to get result size.", (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    @Override
    public boolean isIncludeResults(int start, int end) {
        return true;
    }
}

