/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.TableConfigManager;
import jp.jasminesoft.jfc.app.CacheManagerUtil;
import jp.jasminesoft.jfc.app.CommonService;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.seq.Seq;
import jp.jasminesoft.jfc.core.util.AbstractDomainSupport;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.initdb.Cursor;
import jp.jasminesoft.jfc.initdb.HibernateXML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.MasterJdbcXML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.PathUtil;
import jp.jasminesoft.jfc.initdb.RelaxerJdbcXML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.XML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.XMLLoader;
import jp.jasminesoft.jfc.initdb.autoconfiguration.DataSourceConfiguration;
import jp.jasminesoft.jfc.initdb.conf.Config;
import jp.jasminesoft.jfc.initdb.conf.Database;
import jp.jasminesoft.jfc.initdb.conf.DatasourceParam;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import jp.jasminesoft.jfc.initdb.conf.IConfigChoice;
import jp.jasminesoft.jfc.initdb.conf.Sequence;
import jp.jasminesoft.jfc.initdb.conf.Sql;
import jp.jasminesoft.jfc.migratedb.DBInfo;
import jp.jasminesoft.jfc.migratedb.command.CleanCommand;
import jp.jasminesoft.jfc.migratedb.command.InitCommand;
import jp.jasminesoft.jfc.migratedb.command.MigrateCommand;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.master.Master;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.JaxbUtil;
import jp.jasminesoft.util.LoopProcessTimeLogger;
import jp.jasminesoft.util.StringUtil;
import net.sf.ehcache.CacheManager;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.w3c.dom.Document;

public class XML2DBLoader
extends XMLLoader {
    private String dbtype;
    private String driver;
    private String url;
    private String user;
    private String pwd;
    private DatasourceParam[] dsparam;
    protected Sql[] sql;
    protected Sequence[] sequence;
    private Database db;
    protected ApplicationContext appctx;
    protected Path migratedbBaseDir = Paths.get("../../migratedb", new String[0]);
    protected Connection con;
    private static final Logger logger = LogManager.getLogger(XML2DBLoader.class);
    private long ptl_steptime = 60000L;
    private File configfile_parentdir;
    private boolean tablename_ignorecase;
    public static final Class<?>[] ApplicationContextAnnotatedClasses = new Class[]{DataSourceConfiguration.class};
    private final boolean formatddl = true;
    private final char formatddl_delim = (char)59;
    private Map<String, Boolean> isAutoSequenceDataExistMethodMap = new HashMap<String, Boolean>();

    @Override
    protected void executeAllDirectory(String command) {
        if (command.startsWith("sql")) {
            this.execute_sql(command);
        } else if (command.startsWith("sequence")) {
            this.execute_sequence(command);
        } else if (command.equals("driver")) {
            this.execute_driver(command);
        } else if (command.equals("driver_all")) {
            this.execute_driver_all(command);
        } else if (command.equals("driver_all12")) {
            this.execute_driver_all12(command);
        } else if (command.equals("clean-migrate")) {
            this.doCleanMigrate();
        } else {
            if (command.equals("export") && !this.getAlltable()) {
                if (this.hasContainsTablename("juser") && !this.hasContainsTablename("jprincipal")) {
                    this.addTablename("jprincipal");
                }
                if (this.hasContainsTablename("juser") && !this.hasContainsTablename("jfcpreferenceitem")) {
                    this.addTablename("jfcpreferenceitem");
                }
                if (!this.hasContainsTablename("seq")) {
                    this.addTablename("seq");
                }
            }
            super.executeAllDirectory(command);
            if (command.equals("migrate")) {
                this.doMigrate();
            }
        }
    }

    @Override
    protected void init(String filename) throws IllegalStateException {
        String dml;
        super.init(filename);
        this.configfile_parentdir = new File(filename).getParentFile();
        if (!this.db_init()) {
            throw new IllegalStateException();
        }
        if (this.appctx == null) {
            this.appctx = this.loadApplicationContext();
        }
        TableConfigManager manager = this.getTableConfigManager();
        manager.setQuoteId(this.db.getQuoteid());
        manager.setQuoteWhere(this.db.getQuotewhere());
        manager.setQuoteIdInWhere(this.db.getQuoteidinwhere());
        if (this.db.getJdbc2() != null) {
            manager.setJdbc2(Boolean.valueOf(this.db.getJdbc2()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.db.getType())) {
            manager.setDbtype(this.dbtype);
        }
        if ((dml = this.db.getSequenceDML()) != null) {
            manager.setSequenceDML(dml);
        }
    }

    public Class<?>[] getApplicationContextAnnotatedClasses() {
        return ApplicationContextAnnotatedClasses;
    }

    public String getDeployHomeDir() {
        throw new RuntimeException("override getDeployHomeDir method");
    }

    public String[] getApplicationContextLocations() {
        return new String[]{this.getDeployHomeDir() + "applicationContext.xml"};
    }

    private String[] getApplicationContextLocationsCanRead() {
        String[] locations = this.getApplicationContextLocations();
        ArrayList<String> list = new ArrayList<String>();
        for (String location : locations) {
            if (!new File(location).canRead()) continue;
            list.add(location);
        }
        locations = list.toArray(new String[list.size()]);
        return locations;
    }

    public ApplicationContext loadApplicationContext() {
        AnnotationConfigApplicationContext appctx = null;
        try {
            String[] locations = this.getApplicationContextLocationsCanRead();
            if (locations.length == 0) {
                logger.warn("ApplicationContext load error. Can't read files " + locations);
                return null;
            }
            appctx = new AnnotationConfigApplicationContext((Class[])this.getApplicationContextAnnotatedClasses());
            appctx = new FileSystemXmlApplicationContext(locations, (ApplicationContext)appctx);
            return appctx;
        }
        catch (Exception e) {
            logger.warn("ApplicationContext load error. ", (Throwable)e);
            return null;
        }
    }

    protected TableConfigManager getTableConfigManager() {
        return (TableConfigManager)this.appctx.getBean(TableConfigManager.class);
    }

    @Override
    protected void process_end(String filename) {
        if (this.con == null) {
            return;
        }
        try {
            this.con.close();
        }
        catch (SQLException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00112), LogCodeManager.getMessage(LogCode.JFC00112, new String[0]), (Throwable)e);
            logger.debug("driver: " + this.driver);
            logger.debug("url   : " + this.url);
            logger.debug("user  : " + this.user);
            logger.debug("pwd   : " + this.pwd);
        }
        if (this.getExecuteEnvironmentType() == XMLLoader.ExecuteEnvironmentType.commandline) {
            CacheManagerUtil.getCacheManager(this.appctx).clearAll();
            CacheManager.getInstance().shutdown();
        }
    }

    @Override
    protected void set_variable(Config config) {
        Database db;
        super.set_variable(config);
        this.db = db = config.getDatabase();
        this.dbtype = db.getType();
        this.driver = db.getDriver();
        this.url = db.getUrl();
        String catalinahome = System.getProperty("catalina.home");
        if (catalinahome == null) {
            catalinahome = "";
        }
        this.url = this.url.replace("${catalina.home}", catalinahome);
        this.user = db.getUser();
        this.pwd = db.getPassword();
        if (db.checkLogsteptime()) {
            this.ptl_steptime = db.getLogsteptime() * 1000;
        }
        this.tablename_ignorecase = db.checkTablenameIgnorecase() ? db.getTablenameIgnorecase() : db.getQuoteid() == null || db.getQuoteid().equals("");
        this.dsparam = db.getDatasourceParam();
        ArrayList<Sql> list_sql = new ArrayList<Sql>();
        ArrayList<Sequence> list_sequence = new ArrayList<Sequence>();
        IConfigChoice[] icc = config.getContent();
        if (icc != null) {
            for (int i = 0; i < icc.length; ++i) {
                if (icc[i] instanceof Sql) {
                    list_sql.add((Sql)icc[i]);
                }
                if (!(icc[i] instanceof Sequence)) continue;
                list_sequence.add((Sequence)icc[i]);
            }
            this.sql = list_sql.toArray(new Sql[0]);
            this.sequence = list_sequence.toArray(new Sequence[0]);
        }
    }

    protected boolean db_init() {
        boolean ret = false;
        if (this.driver == null || this.url == null || this.user == null || this.pwd == null) {
            return ret;
        }
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return ret;
        }
        try {
            this.con = dataSource.getConnection();
            logger.debug("Database Connection is processed successfully.");
            ret = true;
        }
        catch (SQLException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00113), LogCodeManager.getMessage(LogCode.JFC00113, new String[0]), (Throwable)e);
            logger.debug("driver: " + this.driver);
            logger.debug("url   : " + this.url);
            logger.debug("user  : " + this.user);
            logger.debug("pwd   : " + this.pwd);
        }
        return ret;
    }

    protected Connection createConnection() throws SQLException {
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new SQLException("Failed to get DataSource");
        }
        return dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() {
        InitialContext initCtx = null;
        DataSource dataSource = null;
        try {
            initCtx = new InitialContext();
            DataSource dataSource2 = dataSource = (DataSource)initCtx.lookup("java:comp/env/jdbc/jfc");
            return dataSource2;
        }
        catch (NamingException e) {
            logger.debug("Jndi naming error, ", (Throwable)e);
        }
        finally {
            if (initCtx != null) {
                block29: {
                    try {
                        initCtx.close();
                    }
                    catch (NamingException e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00107), LogCodeManager.getMessage(LogCode.JFC00107, new String[0]), (Throwable)e);
                        if (e.getRootCause() == null) break block29;
                        logger.debug("naming exception, root cause=", e.getRootCause());
                    }
                }
                initCtx = null;
            }
        }
        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        try {
            initCtx = new InitialContext();
            dataSource = this.createDataSource();
            initCtx.createSubcontext("java:comp");
            initCtx.createSubcontext("java:comp/env");
            initCtx.createSubcontext("java:comp/env/jdbc");
            initCtx.bind("java:comp/env/jdbc/jfc", (Object)dataSource);
            this.registerSubdatabaseDatasource(initCtx, dataSource);
            DataSource e = dataSource;
            return e;
        }
        catch (NamingException e) {
            logger.debug("Jndi naming error, ", (Throwable)e);
            DataSource dataSource3 = null;
            return dataSource3;
        }
        catch (Exception e) {
            logger.debug("Jndi naming error, ", (Throwable)e);
            DataSource dataSource4 = null;
            return dataSource4;
        }
        finally {
            block30: {
                if (initCtx != null) {
                    try {
                        initCtx.close();
                    }
                    catch (NamingException e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00107), LogCodeManager.getMessage(LogCode.JFC00107, new String[0]), (Throwable)e);
                        if (e.getRootCause() == null) break block30;
                        logger.debug("naming exception, root cause=", e.getRootCause());
                    }
                }
            }
        }
    }

    private void registerSubdatabaseDatasource(InitialContext initCtx, DataSource dataSource) throws NamingException {
        for (int i = 2; i < 10; ++i) {
            initCtx.bind("java:comp/env/jdbc/jfc" + i, (Object)dataSource);
        }
    }

    private DataSource createDataSource() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", this.driver);
        properties.setProperty("url", this.url);
        properties.setProperty("username", this.user);
        properties.setProperty("password", this.pwd);
        properties.setProperty("maxWait", "500");
        properties.setProperty("defaultAutoCommit", "false");
        if (this.dsparam != null) {
            for (int i = 0; i < this.dsparam.length; ++i) {
                properties.setProperty(this.dsparam[i].getKey(), this.dsparam[i].getContent());
            }
        }
        return BasicDataSourceFactory.createDataSource((Properties)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_sql(String command) {
        if (this.sql == null || this.sql.length == 0) {
            return;
        }
        Connection conn = null;
        Sql _sql = null;
        try {
            conn = this.createConnection();
            for (int i = 0; i < this.sql.length; ++i) {
                _sql = this.sql[i];
                this.execute_sql(command, conn, _sql);
            }
        }
        catch (Exception ex) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00713), LogCodeManager.getMessage(LogCode.JFC00713, _sql != null ? _sql.toString() : "", ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.debug("Failed to close connection.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_sql(String command, Connection conn, Sql sql) {
        if (sql.getAcceptcommand() == null && sql.getDenycommand() == null) {
            sql.setAcceptcommand(new String[]{"sql", "sql-auto-before"});
            sql.setDenycommand(new String[]{"all"});
        }
        if (!this.isExecute(sql)) {
            logger.debug(sql + " is not executable. skip.");
            return;
        }
        if (!this.isAcceptCommand(command, sql)) {
            logger.debug(sql + " is not acceptable. skip.");
            return;
        }
        Statement st = null;
        String query = "";
        try {
            if (sql.getFile() != null) {
                this.executeDDLFile(sql.getFile(), conn);
            } else {
                query = sql.getContent().trim();
                logger.debug("sql: " + query);
                st = conn.createStatement();
                st.execute(query);
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00714), LogCodeManager.getMessage(LogCode.JFC00714, query, e.getMessage()), (Throwable)e);
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                logger.debug("Failed to rollback.", (Throwable)ex);
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close statement.", (Throwable)ex0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDDLFile(String filename, Connection conn) throws IOException, SQLException {
        try (InputStream istream = null;){
            boolean iseof;
            File file = new File(this.configfile_parentdir, filename);
            istream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream, this.getDDLFileCharencoding()));
            Object[] status = new Object[3];
            do {
                this.getDdlOneLine(reader, status);
                String sql1 = (String)status[0];
                iseof = (Boolean)status[1];
                if (!StringUtils.isNotBlank((CharSequence)sql1)) continue;
                logger.debug("execute " + sql1);
                Statement st = conn.createStatement();
                try {
                    st.execute(sql1.trim());
                }
                finally {
                    st.close();
                    st = null;
                }
            } while (!iseof);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_sequence(String command) {
        if (this.sequence == null || this.sequence.length == 0) {
            return;
        }
        Connection conn = null;
        Sequence _sequence = null;
        try {
            conn = this.createConnection();
            for (int i = 0; i < this.sequence.length; ++i) {
                _sequence = this.sequence[i];
                this.execute_sequence(command, conn, _sequence);
            }
        }
        catch (Exception ex) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00715), LogCodeManager.getMessage(LogCode.JFC00715, _sequence != null ? _sequence.toString() : "", ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.debug("Failed to close connection.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_sequence(String command, Connection conn, Sequence sequence) {
        String seqName = sequence.getSeqname();
        if (seqName == null) {
            logger.debug(sequence + " seqName is null. skip.");
            return;
        }
        if (sequence.getAcceptcommand() == null && sequence.getDenycommand() == null) {
            sequence.setAcceptcommand(new String[]{"sequence"});
            sequence.setDenycommand(new String[]{"all"});
        }
        if (!this.isExecute(sequence)) {
            logger.debug(sequence + " is not executable. skip.");
            return;
        }
        if (!this.isAcceptCommand(command, sequence)) {
            logger.debug(sequence + " is not acceptable. skip.");
            return;
        }
        String tablename = sequence.getTablename();
        Statement st = null;
        try {
            st = conn.createStatement();
            Long start = sequence.getStartAsLong();
            if (tablename != null && sequence.getTablemaxcolumn() != null) {
                Long i_max = this.getMax(st, sequence.getTablename(), sequence.getTablemaxcolumn());
                long max = i_max == null ? 0L : i_max + 1L;
                if (start == null || start < max) {
                    start = max;
                }
            }
            this.createSequence(st, (long)start, sequence);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00716), LogCodeManager.getMessage(LogCode.JFC00716, sequence.toString(), e.getMessage()), (Throwable)e);
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                logger.debug("Failed to rollback.", (Throwable)ex);
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close statement.", (Throwable)ex0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getMax(Statement st, String tablename, String column) throws SQLException {
        long max;
        block8: {
            TableConfigManager manager = this.getTableConfigManager();
            String quoteid = manager.getQuoteId();
            StringBuffer selectmax = new StringBuffer();
            selectmax.append("SELECT MAX(");
            selectmax.append(quoteid);
            selectmax.append(column);
            selectmax.append(quoteid);
            selectmax.append(") FROM ");
            selectmax.append(quoteid);
            selectmax.append(tablename);
            selectmax.append(quoteid);
            String selectmaxstr = selectmax.toString();
            logger.debug("select max sql: " + selectmaxstr);
            try (ResultSet rs = st.executeQuery(selectmaxstr);){
                if (rs.isBeforeFirst() && !rs.next()) {
                    logger.debug("no column");
                    Long l = null;
                    return l;
                }
                if (rs.isFirst()) {
                    max = rs.getLong(1);
                    if (rs.wasNull()) {
                        logger.debug("column is null");
                        Long l = null;
                        return l;
                    }
                    break block8;
                }
                logger.debug("not first");
                Long l = null;
                return l;
            }
        }
        logger.debug("max value: " + max);
        return max;
    }

    protected void createSequence(Statement st, Long start, Sequence sequence) throws SQLException, IOException {
        String createsequencestr;
        String filename = sequence.getFile();
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            List<String> lines = Files.readAllLines(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);
            createsequencestr = lines.stream().collect(Collectors.joining("\n"));
        } else {
            createsequencestr = sequence.getContent();
        }
        if (StringUtils.isBlank((CharSequence)createsequencestr)) {
            return;
        }
        if (start != null) {
            createsequencestr = createsequencestr.replace("$START", String.valueOf(start));
        }
        logger.debug((Object)sequence);
        logger.debug("create seq sql: " + createsequencestr);
        st.execute(createsequencestr);
    }

    protected void dropSequence(Statement st, String seqName) throws SQLException {
        TableConfigManager manager = this.getTableConfigManager();
        String quoteid = manager.getQuoteId();
        StringBuffer dropsequence = new StringBuffer();
        dropsequence.append("DROP SEQUENCE ");
        dropsequence.append(quoteid);
        dropsequence.append(seqName);
        dropsequence.append(quoteid);
        String dropsequencestr = dropsequence.toString();
        logger.debug("drop seq sql: " + dropsequencestr);
        st.execute(dropsequencestr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_driver(String command) {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = this.createConnection();
            DatabaseMetaData dm = conn.getMetaData();
            if (dm == null) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00718), LogCodeManager.getMessage(LogCode.JFC00718, new String[0]));
            } else {
                this.showMessage("DatabaseProductName=" + dm.getDatabaseProductName());
                this.showMessage("DatabaseProductVersion=" + dm.getDatabaseProductVersion());
                this.showMessage("DriverMajorVersion=" + dm.getDriverMajorVersion());
                this.showMessage("DriverMinorVersion=" + dm.getDriverMinorVersion());
                this.showMessage("DriverName=" + dm.getDriverName());
                this.showMessage("DriverVersion=" + dm.getDriverVersion());
                int max = dm.getMaxTableNameLength();
                String desc = max == 0 ? "(unlimited or unknown)" : "";
                this.showMessage("MaxTableNameLength=" + max + desc);
                max = dm.getMaxColumnNameLength();
                desc = max == 0 ? "(unlimited or unknown)" : "";
                this.showMessage("MaxColumnNameLength=" + max + desc);
                String s = dm.getIdentifierQuoteString();
                desc = s != null && s.equals(" ") ? "(not supported)" : "";
                this.showMessage("IdentifierQuoteString=" + s + desc);
                rs = dm.getSchemas();
                this.showResultSet(rs, "Schemas");
                rs.close();
                rs = null;
                rs = dm.getCatalogs();
                this.showResultSet(rs, "Catalogs");
                rs.close();
                rs = null;
                rs = dm.getTableTypes();
                this.showResultSet(rs, "TableTypes");
                rs.close();
                rs = null;
            }
        }
        catch (Exception ex) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00717), LogCodeManager.getMessage(LogCode.JFC00717, ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close result set.", (Throwable)ex0);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close statement.", (Throwable)ex0);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close connection.", (Throwable)ex0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_driver_all(String command) {
        Connection conn = null;
        try {
            conn = this.createConnection();
            DatabaseMetaData dm = conn.getMetaData();
            if (dm == null) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00718), LogCodeManager.getMessage(LogCode.JFC00718, new String[0]));
            } else {
                this.showDatabaseMetaData(dm, true);
            }
        }
        catch (Exception ex) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00719), LogCodeManager.getMessage(LogCode.JFC00719, ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close connection.", (Throwable)ex0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_driver_all12(String command) {
        Connection conn = null;
        try {
            conn = this.createConnection();
            DatabaseMetaData dm = conn.getMetaData();
            if (dm == null) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00718), LogCodeManager.getMessage(LogCode.JFC00718, new String[0]));
            } else {
                this.showDatabaseMetaData(dm, false);
            }
        }
        catch (Exception ex) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00720), LogCodeManager.getMessage(LogCode.JFC00720, ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close connection.", (Throwable)ex0);
                }
            }
        }
    }

    private void showResultSet(ResultSet rs, String desc) throws SQLException {
        ResultSetMetaData rsmeta = rs.getMetaData();
        int columnslen = rsmeta.getColumnCount();
        String[] columns = new String[columnslen];
        for (int i = 0; i < columnslen; ++i) {
            columns[i] = rsmeta.getColumnName(i + 1);
        }
        int cnt = 0;
        while (rs.next()) {
            if (cnt == 0) {
                this.showMessage(desc);
            }
            StringBuffer buf = new StringBuffer();
            buf.append("  ");
            for (int i = 0; i < columnslen; ++i) {
                buf.append(columns[i]);
                buf.append(":");
                try {
                    buf.append(rs.getString(columns[i]));
                }
                catch (SQLException e) {
                    buf.append("SQLException " + columns[i] + " " + e.getMessage());
                }
                buf.append(" ");
            }
            this.showMessage(buf.toString());
            ++cnt;
        }
        if (cnt == 0) {
            this.showMessage(desc + " is none");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDatabaseMetaData(DatabaseMetaData dm, boolean use14) throws SQLException {
        int i;
        ResultSet rs = null;
        String[] resultset_msg = new String[]{"ResultSet.TYPE_FORWARD_ONLY", "ResultSet.TYPE_SCROLL_INSENSITIVE", "ResultSet.TYPE_SCROLL_SENSITIVE"};
        int[] resultset_value = new int[]{1003, 1004, 1005};
        String[] concur_msg = new String[]{"ResultSet.CONCUR_READ_ONLY", "ResultSet.CONCUR_UPDATABLE"};
        int[] concur_value = new int[]{1007, 1008};
        String[] transaction_msg = new String[]{"Connection.TRANSACTION_READ_UNCOMMITTED", "Connection.TRANSACTION_READ_COMMITTED", "Connection.TRANSACTION_REPEATABLE_READ", "Connection.TRANSACTION_SERIALIZABLE"};
        int[] transaction_value = new int[]{1, 2, 4, 8};
        String[] type_msg = new String[]{"Types.ARRAY", "Types.BIGINT", "Types.BINARY", "Types.BIT", "Types.BLOB", "Types.BOOLEAN", "Types.CHAR", "Types.CLOB", "Types.DATALINK", "Types.DATE", "Types.DECIMAL", "Types.DISTINCT", "Types.DOUBLE", "Types.FLOAT", "Types.INTEGER", "Types.JAVA_OBJECT", "Types.LONGVARBINARY", "Types.LONGVARCHAR", "Types.NULL", "Types.NUMERIC", "Types.OTHER", "Types.REAL", "Types.REF", "Types.SMALLINT", "Types.STRUCT", "Types.TIME", "Types.TIMESTAMP", "Types.TINYINT", "Types.VARBINARY", "Types.VARCHAR"};
        int[] type_value = new int[]{2003, -5, -2, -7, 2004, 16, 1, 2005, 70, 91, 3, 2001, 8, 6, 4, 2000, -4, -1, 0, 2, 1111, 7, 2006, 5, 2002, 92, 93, -6, -3, 12};
        try {
            this.showMessage("allProceduresAreCallable=" + dm.allProceduresAreCallable());
        }
        catch (SQLException e) {
            this.showMessage("SQLException allProceduresAreCallable " + e.getMessage());
        }
        try {
            this.showMessage("allTablesAreSelectable=" + dm.allTablesAreSelectable());
        }
        catch (SQLException e) {
            this.showMessage("SQLException allTablesAreSelectable " + e.getMessage());
        }
        try {
            this.showMessage("dataDefinitionCausesTransactionCommit=" + dm.dataDefinitionCausesTransactionCommit());
        }
        catch (SQLException e) {
            this.showMessage("SQLException dataDefinitionCausesTransactionCommit " + e.getMessage());
        }
        try {
            this.showMessage("dataDefinitionIgnoredInTransactions=" + dm.dataDefinitionIgnoredInTransactions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException dataDefinitionIgnoredInTransactions " + e.getMessage());
        }
        for (int i2 = 0; i2 < resultset_msg.length; ++i2) {
            try {
                this.showMessage("deletesAreDetected(" + resultset_msg[i2] + ")=" + dm.deletesAreDetected(resultset_value[i2]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException deletesAreDetected(" + resultset_msg[i2] + ") " + e.getMessage());
            }
        }
        try {
            this.showMessage("doesMaxRowSizeIncludeBlobs=" + dm.doesMaxRowSizeIncludeBlobs());
        }
        catch (SQLException e) {
            this.showMessage("SQLException doesMaxRowSizeIncludeBlobs " + e.getMessage());
        }
        try {
            rs = dm.getCatalogs();
            this.showResultSet(rs, "getCatalogs");
        }
        catch (SQLException e) {
            this.showMessage("SQLException getCatalogs " + e.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            rs = null;
        }
        try {
            this.showMessage("getCatalogSeparator=" + dm.getCatalogSeparator());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getCatalogSeparator " + e.getMessage());
        }
        try {
            this.showMessage("getCatalogTerm=" + dm.getCatalogTerm());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getCatalogTerm " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("getDatabaseMajorVersion=" + dm.getDatabaseMajorVersion());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException getDatabaseMajorVersion " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError getDatabaseMajorVersion " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("getDatabaseMinorVersion=" + dm.getDatabaseMinorVersion());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException getDatabaseMinorVersion " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError getDatabaseMinorVersion " + e.getMessage());
        }
        try {
            this.showMessage("getDatabaseProductName=" + dm.getDatabaseProductName());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getDatabaseProductName " + e.getMessage());
        }
        try {
            this.showMessage("getDatabaseProductVersion=" + dm.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getDatabaseProductVersion " + e.getMessage());
        }
        try {
            int transaction = dm.getDefaultTransactionIsolation();
            boolean isshow = false;
            for (int i3 = 0; i3 < transaction_value.length; ++i3) {
                if (transaction_value[i3] != transaction) continue;
                this.showMessage("getDefaultTransactionIsolation=" + transaction + "(" + transaction_msg[i3] + ")");
                isshow = true;
            }
            if (!isshow) {
                this.showMessage("getDefaultTransactionIsolation is unknown value " + transaction);
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException getDefaultTransactionIsolation " + e.getMessage());
        }
        this.showMessage("getDriverMajorVersion=" + dm.getDriverMajorVersion());
        this.showMessage("getDriverMinorVersion=" + dm.getDriverMinorVersion());
        try {
            this.showMessage("getDriverName=" + dm.getDriverName());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getDriverName " + e.getMessage());
        }
        try {
            this.showMessage("getDriverVersion=" + dm.getDriverVersion());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getDriverVersion " + e.getMessage());
        }
        try {
            this.showMessage("getExtraNameCharacters=" + dm.getExtraNameCharacters());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getExtraNameCharacters " + e.getMessage());
        }
        try {
            String s = dm.getIdentifierQuoteString();
            String desc = s != null && s.equals(" ") ? "(not supported)" : "";
            this.showMessage("getIdentifierQuoteString=" + s + desc);
        }
        catch (SQLException e) {
            this.showMessage("SQLException getIdentifierQuoteString " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("getJDBCMajorVersion=" + dm.getJDBCMajorVersion());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException getJDBCMajorVersion " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError getJDBCMajorVersion " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("getJDBCMinorVersion=" + dm.getJDBCMinorVersion());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException getJDBCMinorVersion " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError getJDBCMinorVersion " + e.getMessage());
        }
        try {
            this.showMessage("getMaxBinaryLiteralLength=" + dm.getMaxBinaryLiteralLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxBinaryLiteralLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxCatalogNameLength=" + dm.getMaxCatalogNameLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxCatalogNameLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxCharLiteralLength=" + dm.getMaxCharLiteralLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxCharLiteralLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxColumnNameLength=" + dm.getMaxColumnNameLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxColumnNameLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxColumnsInGroupBy=" + dm.getMaxColumnsInGroupBy());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxColumnsInGroupBy " + e.getMessage());
        }
        try {
            this.showMessage("getMaxColumnsInIndex=" + dm.getMaxColumnsInIndex());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxColumnsInIndex " + e.getMessage());
        }
        try {
            this.showMessage("getMaxColumnsInOrderBy=" + dm.getMaxColumnsInOrderBy());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxColumnsInOrderBy " + e.getMessage());
        }
        try {
            this.showMessage("getMaxColumnsInSelect=" + dm.getMaxColumnsInSelect());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxColumnsInSelect " + e.getMessage());
        }
        try {
            this.showMessage("getMaxColumnsInTable=" + dm.getMaxColumnsInTable());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxColumnsInTable " + e.getMessage());
        }
        try {
            this.showMessage("getMaxConnections=" + dm.getMaxConnections());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxConnections " + e.getMessage());
        }
        try {
            this.showMessage("getMaxCursorNameLength=" + dm.getMaxCursorNameLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxCursorNameLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxIndexLength=" + dm.getMaxIndexLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxIndexLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxProcedureNameLength=" + dm.getMaxProcedureNameLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxProcedureNameLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxRowSize=" + dm.getMaxRowSize());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxRowSize " + e.getMessage());
        }
        try {
            this.showMessage("getMaxSchemaNameLength=" + dm.getMaxSchemaNameLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxSchemaNameLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxStatementLength=" + dm.getMaxStatementLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxStatementLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxStatements=" + dm.getMaxStatements());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxStatements " + e.getMessage());
        }
        try {
            this.showMessage("getMaxTableNameLength=" + dm.getMaxTableNameLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxTableNameLength " + e.getMessage());
        }
        try {
            this.showMessage("getMaxTablesInSelect=" + dm.getMaxTablesInSelect());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxTablesInSelect " + e.getMessage());
        }
        try {
            this.showMessage("getMaxUserNameLength=" + dm.getMaxUserNameLength());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getMaxUserNameLength " + e.getMessage());
        }
        try {
            this.showMessage("getNumericFunctions=" + dm.getNumericFunctions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getNumericFunctions " + e.getMessage());
        }
        try {
            this.showMessage("getProcedureTerm=" + dm.getProcedureTerm());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getProcedureTerm " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("getResultSetHoldability=" + dm.getResultSetHoldability());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException getResultSetHoldability " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError getResultSetHoldability " + e.getMessage());
        }
        try {
            rs = dm.getSchemas();
            this.showResultSet(rs, "getSchemas");
        }
        catch (SQLException e) {
            this.showMessage("SQLException getSchemas " + e.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            rs = null;
        }
        try {
            this.showMessage("getSchemaTerm=" + dm.getSchemaTerm());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getSchemaTerm " + e.getMessage());
        }
        try {
            this.showMessage("getSearchStringEscape=" + dm.getSearchStringEscape());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getSearchStringEscape " + e.getMessage());
        }
        try {
            this.showMessage("getSQLKeywords=" + dm.getSQLKeywords());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getSQLKeywords " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("getSQLStateType=" + dm.getSQLStateType());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException getSQLStateType " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError getSQLStateType " + e.getMessage());
        }
        try {
            this.showMessage("getStringFunctions=" + dm.getStringFunctions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getStringFunctions " + e.getMessage());
        }
        try {
            this.showMessage("getSystemFunctions=" + dm.getSystemFunctions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getSystemFunctions " + e.getMessage());
        }
        try {
            rs = dm.getTableTypes();
            this.showResultSet(rs, "getTableTypes");
        }
        catch (SQLException e) {
            this.showMessage("SQLException getTableTypes " + e.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            rs = null;
        }
        try {
            this.showMessage("getTimeDateFunctions=" + dm.getTimeDateFunctions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getTimeDateFunctions " + e.getMessage());
        }
        try {
            rs = dm.getTypeInfo();
            this.showResultSet(rs, "getTypeInfo");
        }
        catch (SQLException e) {
            this.showMessage("SQLException getTypeInfo " + e.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            rs = null;
        }
        try {
            this.showMessage("getURL=" + dm.getURL());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getURL " + e.getMessage());
        }
        try {
            this.showMessage("getUserName=" + dm.getUserName());
        }
        catch (SQLException e) {
            this.showMessage("SQLException getUserName " + e.getMessage());
        }
        for (int i4 = 0; i4 < resultset_msg.length; ++i4) {
            try {
                this.showMessage("insertsAreDetected(" + resultset_msg[i4] + ")=" + dm.insertsAreDetected(resultset_value[i4]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException insertsAreDetected(" + resultset_msg[i4] + ") " + e.getMessage());
            }
        }
        try {
            this.showMessage("isCatalogAtStart=" + dm.isCatalogAtStart());
        }
        catch (SQLException e) {
            this.showMessage("SQLException isCatalogAtStart " + e.getMessage());
        }
        try {
            this.showMessage("isReadOnly=" + dm.isReadOnly());
        }
        catch (SQLException e) {
            this.showMessage("SQLException isReadOnly " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("locatorsUpdateCopy=" + dm.locatorsUpdateCopy());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException locatorsUpdateCopy " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError locatorsUpdateCopy " + e.getMessage());
        }
        try {
            this.showMessage("nullPlusNonNullIsNull=" + dm.nullPlusNonNullIsNull());
        }
        catch (SQLException e) {
            this.showMessage("SQLException nullPlusNonNullIsNull " + e.getMessage());
        }
        try {
            this.showMessage("nullsAreSortedAtEnd=" + dm.nullsAreSortedAtEnd());
        }
        catch (SQLException e) {
            this.showMessage("SQLException nullsAreSortedAtEnd " + e.getMessage());
        }
        try {
            this.showMessage("nullsAreSortedAtStart=" + dm.nullsAreSortedAtStart());
        }
        catch (SQLException e) {
            this.showMessage("SQLException nullsAreSortedAtStart " + e.getMessage());
        }
        try {
            this.showMessage("nullsAreSortedHigh=" + dm.nullsAreSortedHigh());
        }
        catch (SQLException e) {
            this.showMessage("SQLException nullsAreSortedHigh " + e.getMessage());
        }
        try {
            this.showMessage("nullsAreSortedLow=" + dm.nullsAreSortedLow());
        }
        catch (SQLException e) {
            this.showMessage("SQLException nullsAreSortedLow " + e.getMessage());
        }
        for (i = 0; i < resultset_msg.length; ++i) {
            try {
                this.showMessage("othersDeletesAreVisible(" + resultset_msg[i] + ")=" + dm.othersDeletesAreVisible(resultset_value[i]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException othersDeletesAreVisible(" + resultset_msg[i] + ") " + e.getMessage());
            }
        }
        for (i = 0; i < resultset_msg.length; ++i) {
            try {
                this.showMessage("othersInsertsAreVisible(" + resultset_msg[i] + ")=" + dm.othersInsertsAreVisible(resultset_value[i]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException othersInsertsAreVisible(" + resultset_msg[i] + ") " + e.getMessage());
            }
        }
        for (i = 0; i < resultset_msg.length; ++i) {
            try {
                this.showMessage("othersUpdatesAreVisible(" + resultset_msg[i] + ")=" + dm.othersUpdatesAreVisible(resultset_value[i]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException othersUpdatesAreVisible(" + resultset_msg[i] + ") " + e.getMessage());
            }
        }
        for (i = 0; i < resultset_msg.length; ++i) {
            try {
                this.showMessage("ownDeletesAreVisible(" + resultset_msg[i] + ")=" + dm.ownDeletesAreVisible(resultset_value[i]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException ownDeletesAreVisible(" + resultset_msg[i] + ") " + e.getMessage());
            }
        }
        for (i = 0; i < resultset_msg.length; ++i) {
            try {
                this.showMessage("ownInsertsAreVisible(" + resultset_msg[i] + ")=" + dm.ownInsertsAreVisible(resultset_value[i]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException ownInsertsAreVisible(" + resultset_msg[i] + ") " + e.getMessage());
            }
        }
        for (i = 0; i < resultset_msg.length; ++i) {
            try {
                this.showMessage("ownUpdatesAreVisible(" + resultset_msg[i] + ")=" + dm.ownUpdatesAreVisible(resultset_value[i]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException ownUpdatesAreVisible(" + resultset_msg[i] + ") " + e.getMessage());
            }
        }
        try {
            this.showMessage("storesLowerCaseIdentifiers=" + dm.storesLowerCaseIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException storesLowerCaseIdentifiers " + e.getMessage());
        }
        try {
            this.showMessage("storesLowerCaseQuotedIdentifiers=" + dm.storesLowerCaseQuotedIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException storesLowerCaseQuotedIdentifiers " + e.getMessage());
        }
        try {
            this.showMessage("storesMixedCaseIdentifiers=" + dm.storesMixedCaseIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException storesMixedCaseIdentifiers " + e.getMessage());
        }
        try {
            this.showMessage("storesMixedCaseQuotedIdentifiers=" + dm.storesMixedCaseQuotedIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException storesMixedCaseQuotedIdentifiers " + e.getMessage());
        }
        try {
            this.showMessage("storesUpperCaseIdentifiers=" + dm.storesUpperCaseIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException storesUpperCaseIdentifiers " + e.getMessage());
        }
        try {
            this.showMessage("storesUpperCaseQuotedIdentifiers=" + dm.storesUpperCaseQuotedIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException storesUpperCaseQuotedIdentifiers " + e.getMessage());
        }
        try {
            this.showMessage("supportsAlterTableWithAddColumn=" + dm.supportsAlterTableWithAddColumn());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsAlterTableWithAddColumn " + e.getMessage());
        }
        try {
            this.showMessage("supportsAlterTableWithDropColumn=" + dm.supportsAlterTableWithDropColumn());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsAlterTableWithDropColumn " + e.getMessage());
        }
        try {
            this.showMessage("supportsANSI92EntryLevelSQL=" + dm.supportsANSI92EntryLevelSQL());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsANSI92EntryLevelSQL " + e.getMessage());
        }
        try {
            this.showMessage("supportsANSI92FullSQL=" + dm.supportsANSI92FullSQL());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsANSI92FullSQL " + e.getMessage());
        }
        try {
            this.showMessage("supportsANSI92IntermediateSQL=" + dm.supportsANSI92IntermediateSQL());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsANSI92IntermediateSQL " + e.getMessage());
        }
        try {
            this.showMessage("supportsBatchUpdates=" + dm.supportsBatchUpdates());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsBatchUpdates " + e.getMessage());
        }
        try {
            this.showMessage("supportsCatalogsInDataManipulation=" + dm.supportsCatalogsInDataManipulation());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsCatalogsInDataManipulation " + e.getMessage());
        }
        try {
            this.showMessage("supportsCatalogsInIndexDefinitions=" + dm.supportsCatalogsInIndexDefinitions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsCatalogsInIndexDefinitions " + e.getMessage());
        }
        try {
            this.showMessage("supportsCatalogsInPrivilegeDefinitions=" + dm.supportsCatalogsInPrivilegeDefinitions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsCatalogsInPrivilegeDefinitions " + e.getMessage());
        }
        try {
            this.showMessage("supportsCatalogsInProcedureCalls=" + dm.supportsCatalogsInProcedureCalls());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsCatalogsInProcedureCalls " + e.getMessage());
        }
        try {
            this.showMessage("supportsCatalogsInTableDefinitions=" + dm.supportsCatalogsInTableDefinitions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsCatalogsInTableDefinitions " + e.getMessage());
        }
        try {
            this.showMessage("supportsColumnAliasing=" + dm.supportsColumnAliasing());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsColumnAliasing " + e.getMessage());
        }
        try {
            this.showMessage("supportsConvert=" + dm.supportsConvert());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsConvert " + e.getMessage());
        }
        this.showMessage("supportsConvert");
        StringBuffer buf = new StringBuffer("  ");
        for (int j = 0; j < type_value.length; ++j) {
            if (j % 10 == 0) {
                buf.append('|');
            }
            buf.append(j % 10);
        }
        this.showMessage(buf.toString());
        for (int i5 = 0; i5 < type_value.length; ++i5) {
            StringBuffer buf2 = new StringBuffer("  ");
            try {
                for (int j = 0; j < type_value.length; ++j) {
                    if (j % 10 == 0) {
                        buf2.append('|');
                    }
                    if (dm.supportsConvert(type_value[i5], type_value[j])) {
                        buf2.append('o');
                        continue;
                    }
                    buf2.append('x');
                }
                buf2.append(" ");
                buf2.append(i5);
                buf2.append(" ");
                buf2.append(type_msg[i5]);
                this.showMessage(buf2.toString());
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException supportsConvert(" + type_msg[i5] + ")" + buf2.toString() + " " + e.getMessage());
            }
        }
        try {
            this.showMessage("supportsCoreSQLGrammar=" + dm.supportsCoreSQLGrammar());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsCoreSQLGrammar " + e.getMessage());
        }
        try {
            this.showMessage("supportsCorrelatedSubqueries=" + dm.supportsCorrelatedSubqueries());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsCorrelatedSubqueries " + e.getMessage());
        }
        try {
            this.showMessage("supportsDataDefinitionAndDataManipulationTransactions=" + dm.supportsDataDefinitionAndDataManipulationTransactions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsDataDefinitionAndDataManipulationTransactions " + e.getMessage());
        }
        try {
            this.showMessage("supportsDataManipulationTransactionsOnly=" + dm.supportsDataManipulationTransactionsOnly());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsDataManipulationTransactionsOnly " + e.getMessage());
        }
        try {
            this.showMessage("supportsDifferentTableCorrelationNames=" + dm.supportsDifferentTableCorrelationNames());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsDifferentTableCorrelationNames " + e.getMessage());
        }
        try {
            this.showMessage("supportsExpressionsInOrderBy=" + dm.supportsExpressionsInOrderBy());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsExpressionsInOrderBy " + e.getMessage());
        }
        try {
            this.showMessage("supportsExtendedSQLGrammar=" + dm.supportsExtendedSQLGrammar());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsExtendedSQLGrammar " + e.getMessage());
        }
        try {
            this.showMessage("supportsFullOuterJoins=" + dm.supportsFullOuterJoins());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsFullOuterJoins " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("supportsGetGeneratedKeys=" + dm.supportsGetGeneratedKeys());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsGetGeneratedKeys " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError supportsGetGeneratedKeys " + e.getMessage());
        }
        try {
            this.showMessage("supportsGroupBy=" + dm.supportsGroupBy());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsGroupBy " + e.getMessage());
        }
        try {
            this.showMessage("supportsGroupByBeyondSelect=" + dm.supportsGroupByBeyondSelect());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsGroupByBeyondSelect " + e.getMessage());
        }
        try {
            this.showMessage("supportsGroupByUnrelated=" + dm.supportsGroupByUnrelated());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsGroupByUnrelated " + e.getMessage());
        }
        try {
            this.showMessage("supportsIntegrityEnhancementFacility=" + dm.supportsIntegrityEnhancementFacility());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsIntegrityEnhancementFacility " + e.getMessage());
        }
        try {
            this.showMessage("supportsLikeEscapeClause=" + dm.supportsLikeEscapeClause());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsLikeEscapeClause " + e.getMessage());
        }
        try {
            this.showMessage("supportsLimitedOuterJoins=" + dm.supportsLimitedOuterJoins());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsLimitedOuterJoins " + e.getMessage());
        }
        try {
            this.showMessage("supportsMinimumSQLGrammar=" + dm.supportsMinimumSQLGrammar());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsMinimumSQLGrammar " + e.getMessage());
        }
        try {
            this.showMessage("supportsMixedCaseIdentifiers=" + dm.supportsMixedCaseIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsMixedCaseIdentifiers " + e.getMessage());
        }
        try {
            this.showMessage("supportsMixedCaseQuotedIdentifiers=" + dm.supportsMixedCaseQuotedIdentifiers());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsMixedCaseQuotedIdentifiers " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("supportsMultipleOpenResults=" + dm.supportsMultipleOpenResults());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsMultipleOpenResults " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError supportsMultipleOpenResults " + e.getMessage());
        }
        try {
            this.showMessage("supportsMultipleResultSets=" + dm.supportsMultipleResultSets());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsMultipleResultSets " + e.getMessage());
        }
        try {
            this.showMessage("supportsMultipleTransactions=" + dm.supportsMultipleTransactions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsMultipleTransactions " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("supportsNamedParameters=" + dm.supportsNamedParameters());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsNamedParameters " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError supportsNamedParameters " + e.getMessage());
        }
        try {
            this.showMessage("supportsNonNullableColumns=" + dm.supportsNonNullableColumns());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsNonNullableColumns " + e.getMessage());
        }
        try {
            this.showMessage("supportsOpenCursorsAcrossCommit=" + dm.supportsOpenCursorsAcrossCommit());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsOpenCursorsAcrossCommit " + e.getMessage());
        }
        try {
            this.showMessage("supportsOpenCursorsAcrossRollback=" + dm.supportsOpenCursorsAcrossRollback());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsOpenCursorsAcrossRollback " + e.getMessage());
        }
        try {
            this.showMessage("supportsOpenStatementsAcrossCommit=" + dm.supportsOpenStatementsAcrossCommit());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsOpenStatementsAcrossCommit " + e.getMessage());
        }
        try {
            this.showMessage("supportsOpenStatementsAcrossRollback=" + dm.supportsOpenStatementsAcrossRollback());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsOpenStatementsAcrossRollback " + e.getMessage());
        }
        try {
            this.showMessage("supportsOrderByUnrelated=" + dm.supportsOrderByUnrelated());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsOrderByUnrelated " + e.getMessage());
        }
        try {
            this.showMessage("supportsOuterJoins=" + dm.supportsOuterJoins());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsOuterJoins " + e.getMessage());
        }
        try {
            this.showMessage("supportsPositionedDelete=" + dm.supportsPositionedDelete());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsPositionedDelete " + e.getMessage());
        }
        try {
            this.showMessage("supportsPositionedUpdate=" + dm.supportsPositionedUpdate());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsPositionedUpdate " + e.getMessage());
        }
        for (int i6 = 0; i6 < resultset_msg.length; ++i6) {
            for (int j = 0; j < concur_msg.length; ++j) {
                try {
                    this.showMessage("supportsResultSetConcurrency(" + resultset_msg[i6] + "," + concur_msg[j] + ")=" + dm.supportsResultSetConcurrency(resultset_value[i6], concur_value[j]));
                    continue;
                }
                catch (SQLException e) {
                    this.showMessage("SQLException supportsResultSetConcurrency(" + resultset_msg[i6] + "," + concur_msg[j] + ") " + e.getMessage());
                }
            }
        }
        if (use14) {
            int[] hold_value = new int[]{1, 2};
            String[] hold_msg = new String[]{"ResultSet.HOLD_CURSORS_OVER_COMMIT", "ResultSet.CLOSE_CURSORS_AT_COMMIT"};
            for (int i7 = 0; i7 < hold_msg.length; ++i7) {
                try {
                    this.showMessage("supportsResultSetHoldability(" + hold_msg[i7] + ")=" + dm.supportsResultSetHoldability(hold_value[i7]));
                    continue;
                }
                catch (SQLException e) {
                    this.showMessage("SQLException supportsResultSetHoldability(" + hold_msg[i7] + ") " + e.getMessage());
                    continue;
                }
                catch (AbstractMethodError e) {
                    this.showMessage("AbstractMethodError supportsResultSetHoldability(" + hold_msg[i7] + ") " + e.getMessage());
                }
            }
        }
        for (int i8 = 0; i8 < resultset_msg.length; ++i8) {
            try {
                this.showMessage("supportsResultSetType(" + resultset_msg[i8] + ")=" + dm.supportsResultSetType(resultset_value[i8]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException supportsResultSetType(" + resultset_msg[i8] + ") " + e.getMessage());
            }
        }
        try {
            if (use14) {
                this.showMessage("supportsSavepoints=" + dm.supportsSavepoints());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSavepoints " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError supportsSavepoints " + e.getMessage());
        }
        try {
            this.showMessage("supportsSchemasInDataManipulation=" + dm.supportsSchemasInDataManipulation());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSchemasInDataManipulation " + e.getMessage());
        }
        try {
            this.showMessage("supportsSchemasInIndexDefinitions=" + dm.supportsSchemasInIndexDefinitions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSchemasInIndexDefinitions " + e.getMessage());
        }
        try {
            this.showMessage("supportsSchemasInPrivilegeDefinitions=" + dm.supportsSchemasInPrivilegeDefinitions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSchemasInPrivilegeDefinitions " + e.getMessage());
        }
        try {
            this.showMessage("supportsSchemasInProcedureCalls=" + dm.supportsSchemasInProcedureCalls());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSchemasInProcedureCalls " + e.getMessage());
        }
        try {
            this.showMessage("supportsSchemasInTableDefinitions=" + dm.supportsSchemasInTableDefinitions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSchemasInTableDefinitions " + e.getMessage());
        }
        try {
            this.showMessage("supportsSelectForUpdate=" + dm.supportsSelectForUpdate());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSelectForUpdate " + e.getMessage());
        }
        try {
            if (use14) {
                this.showMessage("supportsStatementPooling=" + dm.supportsStatementPooling());
            }
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsStatementPooling " + e.getMessage());
        }
        catch (AbstractMethodError e) {
            this.showMessage("AbstractMethodError supportsStatementPooling " + e.getMessage());
        }
        catch (Exception e) {
            this.showMessage("Exception supportsStatementPooling " + e.getMessage());
        }
        try {
            this.showMessage("supportsStoredProcedures=" + dm.supportsStoredProcedures());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsStoredProcedures " + e.getMessage());
        }
        try {
            this.showMessage("supportsSubqueriesInComparisons=" + dm.supportsSubqueriesInComparisons());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSubqueriesInComparisons " + e.getMessage());
        }
        try {
            this.showMessage("supportsSubqueriesInExists=" + dm.supportsSubqueriesInExists());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSubqueriesInExists " + e.getMessage());
        }
        try {
            this.showMessage("supportsSubqueriesInIns=" + dm.supportsSubqueriesInIns());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSubqueriesInIns " + e.getMessage());
        }
        try {
            this.showMessage("supportsSubqueriesInQuantifieds=" + dm.supportsSubqueriesInQuantifieds());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsSubqueriesInQuantifieds " + e.getMessage());
        }
        try {
            this.showMessage("supportsTableCorrelationNames=" + dm.supportsTableCorrelationNames());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsTableCorrelationNames " + e.getMessage());
        }
        for (int i9 = 0; i9 < transaction_msg.length; ++i9) {
            try {
                this.showMessage("supportsTransactionIsolationLevel(" + transaction_msg[i9] + ")=" + dm.supportsTransactionIsolationLevel(transaction_value[i9]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException supportsTransactionIsolationLevel(" + transaction_msg[i9] + ") " + e.getMessage());
            }
        }
        try {
            this.showMessage("supportsTransactions=" + dm.supportsTransactions());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsTransactions " + e.getMessage());
        }
        try {
            this.showMessage("supportsUnion=" + dm.supportsUnion());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsUnion " + e.getMessage());
        }
        try {
            this.showMessage("supportsUnionAll=" + dm.supportsUnionAll());
        }
        catch (SQLException e) {
            this.showMessage("SQLException supportsUnionAll " + e.getMessage());
        }
        for (int i10 = 0; i10 < resultset_msg.length; ++i10) {
            try {
                this.showMessage("updatesAreDetected(" + resultset_msg[i10] + ")=" + dm.updatesAreDetected(resultset_value[i10]));
                continue;
            }
            catch (SQLException e) {
                this.showMessage("SQLException updatesAreDetected(" + resultset_msg[i10] + ") " + e.getMessage());
            }
        }
        try {
            this.showMessage("usesLocalFilePerTable=" + dm.usesLocalFilePerTable());
        }
        catch (SQLException e) {
            this.showMessage("SQLException usesLocalFilePerTable " + e.getMessage());
        }
    }

    @Override
    public void showHelpCommand() {
        super.showHelpCommand();
        this.showMessage("  sql                        - execute sql command.");
        this.showMessage("  sequence                   - execute sequence command.");
        this.showMessage("  driver                     - show JDBC Driver infomation");
        this.showMessage("  driver_all                 - show JDBC Driver infomation all");
        this.showMessage("  driver_all12               - show JDBC Driver infomation all, JDBC1.2");
    }

    @Override
    public boolean isAvailableCommand(String command) {
        if (command.equals("sql")) {
            return true;
        }
        if (command.equals("sequence")) {
            return true;
        }
        if (command.equals("driver")) {
            return true;
        }
        if (command.equals("driver_all")) {
            return true;
        }
        if (command.equals("driver_all12")) {
            return true;
        }
        return super.isAvailableCommand(command);
    }

    private void execute_ddlsql(String ddlfilename, Directory dir) throws Exception {
        String charenc = this.getDDLFileCharencoding();
        Connection conn = null;
        FileInputStream istream = null;
        Reader reader = null;
        Statement st = null;
        try {
            boolean iseof;
            conn = this.createConnection();
            st = conn.createStatement();
            File ddlfile = new File(this.configfile_parentdir, ddlfilename);
            istream = new FileInputStream(ddlfile);
            reader = new BufferedReader(new InputStreamReader((InputStream)istream, charenc));
            Object[] status = new Object[3];
            do {
                this.getDdlOneLine(reader, status);
                String sql = (String)status[0];
                iseof = (Boolean)status[1];
                String[] command_arg = (String[])status[2];
                if (command_arg != null) {
                    logger.debug("command:" + sql);
                    boolean iserrorcommand = true;
                    if (command_arg[0].equalsIgnoreCase("\\set") && command_arg[1].equalsIgnoreCase("AUTOCOMMIT")) {
                        if (command_arg[2].equalsIgnoreCase("on") || command_arg[2].equalsIgnoreCase("true")) {
                            conn.setAutoCommit(true);
                            iserrorcommand = false;
                        } else if (command_arg[2].equalsIgnoreCase("off") || command_arg[2].equalsIgnoreCase("false")) {
                            conn.setAutoCommit(false);
                            iserrorcommand = false;
                        }
                    }
                    if (!iserrorcommand) continue;
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00721), LogCodeManager.getMessage(LogCode.JFC00721, sql.toString()));
                    continue;
                }
                if (sql.equals("")) continue;
                if (dir.getReplaceddl()) {
                    String quoteid = this.getTableConfigManager().getQuoteId();
                    sql = sql.replace("\"", quoteid).replace("${tablename}", dir.getTablename());
                }
                logger.debug("sql:" + sql);
                try {
                    st.execute(sql);
                }
                catch (Exception e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00722), LogCodeManager.getMessage(LogCode.JFC00722, sql.toString(), e.getMessage()), (Throwable)e);
                    if (conn.getAutoCommit()) continue;
                    throw e;
                }
            } while (!iseof);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (Exception ex) {
            if (conn != null) {
                try {
                    if (!conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (SQLException e) {
                    logger.debug("Failed to rollback.", (Throwable)e);
                }
            }
            throw ex;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close statement.", (Throwable)ex0);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex0) {
                    logger.debug("Failed to close connection.", (Throwable)ex0);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex0) {
                    logger.debug("Failed to close reader.", (Throwable)ex0);
                    try {
                        istream.close();
                    }
                    catch (IOException ex1) {
                        logger.debug("Failed to close input stream.", (Throwable)ex1);
                    }
                }
            }
        }
    }

    private void getDdlOneLine(Reader reader, Object[] status) throws IOException {
        String[] command_arg;
        boolean iseof;
        StringBuffer buf;
        block8: {
            buf = new StringBuffer();
            iseof = false;
            command_arg = null;
            boolean isfirst = true;
            boolean isdelim = false;
            while (true) {
                int c;
                if ((c = reader.read()) == -1) {
                    iseof = true;
                    break block8;
                }
                buf.append((char)c);
                if (isfirst && c == 92) {
                    while (true) {
                        if ((c = reader.read()) == -1) {
                            iseof = true;
                            break;
                        }
                        if (c == 10 || c == 13) break;
                        buf.append((char)c);
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    StringTokenizer stk = new StringTokenizer(buf.toString());
                    while (stk.hasMoreTokens()) {
                        list.add(stk.nextToken());
                    }
                    command_arg = list.toArray(new String[list.size()]);
                    break block8;
                }
                isfirst = false;
                if (c == 59) {
                    isdelim = true;
                    continue;
                }
                if (isdelim && (c == 10 || c == 13)) break;
                isdelim = false;
            }
            isdelim = false;
        }
        String sql = buf.toString().trim();
        int sqllen = sql.length();
        if (command_arg == null && sqllen > 0 && sql.charAt(sqllen - 1) == ';') {
            sql = sql.substring(0, sqllen - 1);
        }
        status[0] = sql;
        status[1] = iseof;
        status[2] = command_arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(Directory dir, String tableclassname) {
        String ddlfilename = dir.getCreateddlfilename();
        if (ddlfilename != null) {
            try {
                this.execute_ddlsql(ddlfilename, dir);
                logger.log(LogCodeManager.getPriority(LogCode.JFC00723), LogCodeManager.getMessage(LogCode.JFC00723, dir.getTablename(), ddlfilename));
            }
            catch (Exception ex) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00724), LogCodeManager.getMessage(LogCode.JFC00724, ddlfilename, ex.getMessage()), (Throwable)ex);
            }
            return;
        }
        try (XML2DBLoaderDao dao = null;){
            dao = this.createXML2DBLoaderDao(dir, tableclassname);
            if (dao == null) {
                return;
            }
            dao.createTable();
            dao.commit();
            logger.log(LogCodeManager.getPriority(LogCode.JFC00725), LogCodeManager.getMessage(LogCode.JFC00725, dir.getTablename()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(Directory dir, String tableclassname) {
        String ddlfilename = dir.getDropddlfilename();
        if (ddlfilename != null) {
            try {
                this.execute_ddlsql(ddlfilename, dir);
                logger.log(LogCodeManager.getPriority(LogCode.JFC00727), LogCodeManager.getMessage(LogCode.JFC00727, dir.getTablename(), ddlfilename));
            }
            catch (Exception ex) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00728), LogCodeManager.getMessage(LogCode.JFC00728, dir.getTablename(), ex.getMessage()), (Throwable)ex);
            }
            return;
        }
        try (XML2DBLoaderDao dao = null;){
            dao = this.createXML2DBLoaderDao(dir, tableclassname);
            if (dao == null) {
                return;
            }
            dao.dropTable();
            dao.commit();
            logger.log(LogCodeManager.getPriority(LogCode.JFC00729), LogCodeManager.getMessage(LogCode.JFC00729, dir.getTablename()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTable(Directory dir, String tableclassname) {
        try (XML2DBLoaderDao dao = null;){
            dao = this.createXML2DBLoaderDao(dir, tableclassname);
            if (dao == null) {
                return;
            }
            logger.debug("model " + dir.getTablename() + " data 1");
            if (this._importTable(dir, tableclassname, dao, this.getExportDirPath(), this.getUseZipFile())) {
                return;
            }
            logger.debug("model " + dir.getTablename() + " data 2");
            if (this._importTable(dir, tableclassname, dao, this.getInitDirPath(), false)) {
                return;
            }
            logger.debug("model " + dir.getTablename() + " data is not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean _importTable(Directory dir, String tableclassname, XML2DBLoaderDao dao, String exportDirPath, boolean isUseZipFile) {
        d = null;
        if (!(isUseZipFile || (d = exportDirPath == null ? new File(dir.getContent()) : new File(exportDirPath, dir.getContent())) != null && d.isDirectory())) {
            XML2DBLoader.logger.log(LogCodeManager.getPriority(LogCode.JFC00731), LogCodeManager.getMessage(LogCode.JFC00731, new String[]{d.getAbsolutePath(), dir.getTablename()}));
            return false;
        }
        f = null;
        ptl = this.createLoopProcessTimeLogger("import " + dir.getTablename());
        autoseqlist = new ArrayList<File>();
        size = 0;
        cnt = 0;
        parent = null;
        if (isUseZipFile) {
            zipFile = new File(exportDirPath + ".zip");
            zin = null;
            zip_archive_in = null;
            try {
                zin = new BufferedInputStream(new FileInputStream(zipFile));
                zip_archive_in = new ZipArchiveInputStream((InputStream)zin);
                target = PathUtil.getModelIdFromDirectoryContent(dir.getContent());
                entry = null;
                baseDir = this.getZipFileBasedir(exportDirPath);
                match = false;
                tmp_cnt = 0;
                prev_modelId = null;
                while ((entry = zip_archive_in.getNextZipEntry()) != null) {
                    name = entry.getName();
                    modelId = PathUtil.getModelIdFromPath(name);
                    if (modelId.equals(target)) {
                        match = true;
                        tmp_cnt = cnt;
                        prev_modelId = modelId;
                        file = new File(this.getTemplateExportDirPath4ZipFile(baseDir + File.separator + entry.getName()));
                        if (entry.isDirectory()) {
                            if (!file.getParentFile().exists()) {
                                file.getParentFile().mkdirs();
                            }
                            file.mkdirs();
                            if (parent != null) continue;
                            parent = file;
                            continue;
                        }
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding());
                        try {
                            IOUtils.copy((InputStream)zip_archive_in, (Writer)out, (String)this.getEncoding());
                        }
                        finally {
                            out.close();
                        }
                        if (this.isAutoSequenceData(dir, tableclassname, file)) {
                            autoseqlist.add(file);
                            continue;
                        }
                        b = this.importTableWithoutSequence(file, dir, tableclassname, dao);
                        if (b) {
                            size = Integer.valueOf(this.props.getProperty("InitLoader.file.count." + target));
                            ptl.check(cnt, size);
                            ++cnt;
                            f = file;
                        }
                        file.delete();
                        continue;
                    }
                    if (!match) continue;
                    if (tmp_cnt == cnt) {
                        XML2DBLoader.logger.warn(prev_modelId + " has no import file. You may check the order of the files in zip file.");
                    }
                    prev_modelId = modelId;
                    break;
                }
                if (match) ** GOTO lbl115
                var22_32 = false;
                return var22_32;
            }
            catch (Exception e) {
                XML2DBLoader.logger.log(LogCodeManager.getPriority(LogCode.JFC00762), LogCodeManager.getMessage(LogCode.JFC00762, new String[]{zipFile.getName()}));
                if (!XML2DBLoader.logger.isDebugEnabled()) ** GOTO lbl115
                e.printStackTrace();
            }
            finally {
                if (zip_archive_in != null) {
                    try {
                        zip_archive_in.close();
                    }
                    catch (IOException var16_24) {
                    }
                    finally {
                        zip_archive_in = null;
                    }
                }
                if (zin != null) {
                    try {
                        zin.close();
                    }
                    catch (Exception var16_25) {
                    }
                    finally {
                        zin = null;
                    }
                }
            }
        } else {
            list = this.createTargetList(d);
            size = list.size();
            if (size == 0) {
                return false;
            }
            for (i = 0; i < size; ++i) {
                f = list.get(i);
                if (this.isAutoSequenceData(dir, tableclassname, f)) {
                    autoseqlist.add(f);
                    continue;
                }
                b = this.importTableWithoutSequence(f, dir, tableclassname, dao);
                if (!b) continue;
                ptl.check(cnt, size);
                ++cnt;
            }
        }
lbl115:
        // 4 sources

        dao.commit();
        this.updateSequenceByImportTable(dir, tableclassname);
        autoseqlist_size = autoseqlist.size();
        for (i = 0; i < autoseqlist_size; ++i) {
            f = (File)autoseqlist.get(i);
            ptl.check(cnt, size);
            ++cnt;
            this.importTableWithSequence(f, dir, tableclassname, dao);
            if (!isUseZipFile) continue;
            f.delete();
        }
        dao.commit();
        ptl.show(size);
        XML2DBLoader.logger.log(LogCodeManager.getPriority(LogCode.JFC00733), LogCodeManager.getMessage(LogCode.JFC00733, new String[]{dir.getTablename()}));
        return true;
    }

    private boolean importTableWithoutSequence(File f, Directory dir, String tableclassname, XML2DBLoaderDao dao) {
        try {
            Object o = this.beforeImport(dir, tableclassname, f);
            if (o == null) {
                logger.debug("beforeImport " + f + " is null. Skip.");
                this.errorImport(dir, tableclassname, f, null);
                this.actionErrorImport(this, dir, f, null);
                return true;
            }
            if (o instanceof String) {
                if (!dao.insert((String)o)) {
                    return true;
                }
            } else if (o instanceof File) {
                if (!dao.insert((File)o)) {
                    return true;
                }
            } else if (o instanceof Document) {
                Document _doc = (Document)o;
                if (!dao.insert(_doc)) {
                    return true;
                }
            } else if (!dao.insert(o)) {
                logger.debug("Illegal object " + o.getClass() + " " + o);
                this.errorImport(dir, tableclassname, f, null);
                this.actionErrorImport(this, dir, f, null);
                return true;
            }
            this.successImport(dir, tableclassname, f);
            this.actionSuccessImport(this, dir, f);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00732), LogCodeManager.getMessage(LogCode.JFC00732, f.getAbsolutePath(), e.getMessage()), (Throwable)e);
            this.errorImport(dir, tableclassname, f, e);
            this.actionErrorImport(this, dir, f, e);
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                logger.debug("table object " + dir.getTablename() + " throw Exception", t);
            }
            dao.rollback();
        }
        return true;
    }

    private void importTableWithSequence(File f, Directory dir, String tableclassname, XML2DBLoaderDao dao) {
        try {
            Object o = this.beforeImport(dir, tableclassname, f);
            if (o == null) {
                logger.debug("beforeImport " + f + " is null. Skip.");
                this.errorImport(dir, tableclassname, f, null);
                this.actionErrorImport(this, dir, f, null);
                return;
            }
            if (o instanceof String) {
                if (!dao.insert((String)o)) {
                    return;
                }
            } else if (o instanceof File) {
                if (!dao.insert((File)o)) {
                    return;
                }
            } else if (o instanceof Document) {
                if (!dao.insert((Document)o)) {
                    return;
                }
            } else if (!dao.insert(o)) {
                logger.debug("Illegal object " + o.getClass() + " " + o);
                this.errorImport(dir, tableclassname, f, null);
                this.actionErrorImport(this, dir, f, null);
                return;
            }
            this.successImport(dir, tableclassname, f);
            this.actionSuccessImport(this, dir, f);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00732), LogCodeManager.getMessage(LogCode.JFC00732, f.getAbsolutePath(), e.getMessage()), (Throwable)e);
            this.errorImport(dir, tableclassname, f, e);
            this.actionErrorImport(this, dir, f, e);
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                logger.debug("table object " + dir.getTablename() + " throw Exception", t);
            }
            dao.rollback();
        }
    }

    protected void successImport(Directory dir, String classname, File f) {
        try {
            String id = StringUtil.capFirst((String)PathUtil.getModelIdFromDirectoryContent(dir.getContent()));
            Object[] params = new Object[]{dir, classname, f};
            Class[] parameterTypes = new Class[]{Directory.class, String.class, File.class};
            MethodUtils.invokeMethod((Object)this, (String)("successImport_" + id), (Object[])params, (Class[])parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void errorImport(Directory dir, String classname, File f, Exception e) {
        try {
            String id = StringUtil.capFirst((String)PathUtil.getModelIdFromDirectoryContent(dir.getContent()));
            Object[] params = new Object[]{dir, classname, f};
            Class[] parameterTypes = new Class[]{Directory.class, String.class, File.class};
            MethodUtils.invokeMethod((Object)this, (String)("errorImport_" + id), (Object[])params, (Class[])parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void updateSequenceByImportTable(Directory dir, String classname) {
        try {
            String id = StringUtil.capFirst((String)PathUtil.getModelIdFromDirectoryContent(dir.getContent()));
            Object[] params = new Object[]{dir, classname};
            Class[] parameterTypes = new Class[]{Directory.class, String.class};
            MethodUtils.invokeMethod((Object)this, (String)("updateSequenceByImportTable_" + id), (Object[])params, (Class[])parameterTypes);
        }
        catch (NoSuchMethodException e) {
            logger.debug("NoSuchMethodException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.debug("IllegalAccessException", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.debug("InvocationTargetException", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.debug("IllegalArgumentException", (Throwable)e);
        }
    }

    protected boolean isAutoSequenceData(Directory dir, String classname, File f) {
        String key = PathUtil.getModelIdFromDirectoryContent(dir.getContent());
        Boolean b = this.isAutoSequenceDataExistMethodMap.get(key);
        if (b != null) {
            return b;
        }
        String id = null;
        try {
            id = StringUtil.capFirst((String)PathUtil.getModelIdFromDirectoryContent(dir.getContent()));
            Object[] params = new Object[]{dir, classname, f};
            Class[] parameterTypes = new Class[]{Directory.class, String.class, File.class};
            Object n_obj = MethodUtils.invokeMethod((Object)this, (String)("isAutoSequenceData_" + id), (Object[])params, (Class[])parameterTypes);
            if (n_obj != null && n_obj instanceof Boolean) {
                return (Boolean)n_obj;
            }
        }
        catch (NoSuchMethodException e) {
            logger.debug("NoSuchMethodException, id='" + id + "', dir=" + dir, (Throwable)e);
            this.isAutoSequenceDataExistMethodMap.put(key, Boolean.FALSE);
        }
        catch (IllegalAccessException e) {
            logger.debug("IllegalAccessException, id='" + id + "', dir=" + dir, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.debug("InvocationTargetException, id='" + id + "', dir=" + dir, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.debug("IllegalArgumentException, id='" + id + "', dir=" + dir, (Throwable)e);
        }
        return false;
    }

    public Object beforeImport(Directory dir, String classname, File f) {
        try {
            String id = StringUtil.capFirst((String)PathUtil.getModelIdFromDirectoryContent(dir.getContent()));
            Object[] params = new Object[]{dir, classname, f};
            Class[] parameterTypes = new Class[]{Directory.class, String.class, File.class};
            Object ret = MethodUtils.invokeMethod((Object)this, (String)("beforeImport_" + id), (Object[])params, (Class[])parameterTypes);
            return ret;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return f;
    }

    public Object beforeImport(String s, String tablename) {
        return s;
    }

    public <E extends ContainerBase<E>, PK extends Serializable> Document beforeUpdate(Directory dir, String classname, Document doc) throws Exception {
        ActionParameter p = this.createActionParameter();
        try {
            String objclassname = this.getObjectclassname(dir);
            Class<?> entityClass = Class.forName(objclassname);
            ContainerBase entity = (ContainerBase)JaxbUtil.unmarshal((Document)doc, entityClass);
            EntityHelper<?, ?> entityHelper = StoreModelUtils.entityHelper(entityClass, p);
            JFCEntityService<?, ?> entityService = StoreModelUtils.entityService(entityClass, p);
            Object newEntity = entityService.findById(entityHelper.getPrimarykey(entity));
            if (newEntity != null) {
                entityHelper.merge(newEntity, entity);
                entityHelper.beforeShow(newEntity, p);
                return ((ContainerBase)newEntity).makeDocument();
            }
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)e, (Throwable)e);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateTable(Directory dir, String tableclassname) {
        dao = null;
        try {
            dao = this.createXML2DBLoaderDao(dir, tableclassname);
            if (dao == null) {
                return;
            }
            d = null;
            exportDirPath = this.getExportDirPath();
            if (!(this.getUseZipFile() || (d = exportDirPath == null ? new File(dir.getContent()) : new File(exportDirPath, dir.getContent())) != null && d.isDirectory())) {
                XML2DBLoader.logger.log(LogCodeManager.getPriority(LogCode.JFC00736), LogCodeManager.getMessage(LogCode.JFC00736, new String[]{d.getAbsolutePath(), dir.getTablename()}));
                return;
            }
            builderf = DocumentBuilderFactory.newInstance();
            builder = builderf.newDocumentBuilder();
            ptl = this.createLoopProcessTimeLogger("update " + dir.getTablename());
            size = 0;
            parent = null;
            if (this.getUseZipFile()) {
                zip_archive_in = null;
                zin = null;
                zipFile = new File(exportDirPath + ".zip");
                try {
                    zin = new BufferedInputStream(new FileInputStream(zipFile));
                    zip_archive_in = new ZipArchiveInputStream((InputStream)zin);
                    cnt = 0;
                    target = PathUtil.getModelIdFromDirectoryContent(dir.getContent());
                    entry = null;
                    baseDir = this.getZipFileBasedir(exportDirPath);
                    match = false;
                    while ((entry = zip_archive_in.getNextZipEntry()) != null) {
                        name = entry.getName();
                        modelId = PathUtil.getModelIdFromPath(name);
                        if (modelId.equals(target)) {
                            match = true;
                            file = new File(this.getTemplateExportDirPath4ZipFile(baseDir + File.separator + entry.getName()));
                            if (entry.isDirectory()) {
                                if (!file.getParentFile().exists()) {
                                    file.getParentFile().mkdirs();
                                }
                                file.mkdirs();
                                if (parent != null) continue;
                                parent = file;
                                continue;
                            }
                            if (!file.getParentFile().exists()) {
                                file.getParentFile().mkdirs();
                            }
                            out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding());
                            try {
                                IOUtils.copy((InputStream)zip_archive_in, (Writer)out, (String)this.getEncoding());
                            }
                            finally {
                                out.close();
                            }
                            this.updateTable0(file, dir, tableclassname, dao, builder);
                            size = Integer.valueOf(this.props.getProperty("InitLoader.file.count." + target));
                            ptl.check(cnt, size);
                            ++cnt;
                            file.delete();
                            continue;
                        }
                        if (!match) continue;
                    }
                }
                catch (Exception e) {
                    XML2DBLoader.logger.log(LogCodeManager.getPriority(LogCode.JFC00762), LogCodeManager.getMessage(LogCode.JFC00762, new String[]{zipFile.getName()}));
                    if (!XML2DBLoader.logger.isDebugEnabled()) ** GOTO lbl98
                    e.printStackTrace();
                }
                finally {
                    if (zip_archive_in != null) {
                        try {
                            zip_archive_in.close();
                        }
                        catch (IOException var14_22) {
                        }
                        finally {
                            zip_archive_in = null;
                        }
                    }
                    if (zin != null) {
                        try {
                            zin.close();
                        }
                        catch (Exception var14_23) {
                        }
                        finally {
                            zin = null;
                        }
                    }
                }
            } else {
                list = this.createTargetList(d);
                size = list.size();
                for (i = 0; i < size; ++i) {
                    ptl.check(i, size);
                    f = list.get(i);
                    this.updateTable0(f, dir, tableclassname, dao, builder);
                }
            }
lbl98:
            // 5 sources

            dao.commit();
            ptl.show(size);
            XML2DBLoader.logger.log(LogCodeManager.getPriority(LogCode.JFC00737), LogCodeManager.getMessage(LogCode.JFC00737, new String[]{dir.getTablename()}));
        }
        catch (Exception e) {
            XML2DBLoader.logger.log(LogCodeManager.getPriority(LogCode.JFC00738), LogCodeManager.getMessage(LogCode.JFC00738, new String[]{dir.getTablename(), e.getMessage()}), (Throwable)e);
            if (e instanceof InvocationTargetException) {
                t = ((InvocationTargetException)e).getTargetException();
                XML2DBLoader.logger.debug("table object throw Exception", t);
            }
        }
        finally {
            if (dao != null) {
                dao.close();
            }
        }
    }

    private void updateTable0(File f, Directory dir, String tableclassname, XML2DBLoaderDao dao, DocumentBuilder builder) {
        try {
            Document doc = builder.parse(f);
            doc = this.beforeUpdate(dir, tableclassname, doc);
            dao.update(doc);
            this.actionSuccessUpdate(this, dir, f);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00732), LogCodeManager.getMessage(LogCode.JFC00732, f.getAbsolutePath(), e.getMessage()), (Throwable)e);
            this.actionErrorUpdate(this, dir, f, e);
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                logger.debug("table object " + dir.getTablename() + " throw Exception", t);
            }
            dao.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exportTable(Directory dir, String tableclassname) {
        XML2DBLoaderDao dao = null;
        int writenum = 0;
        Releasable releasable = null;
        try {
            Cursor cursor;
            dao = this.createXML2DBLoaderDao(dir, tableclassname);
            if (dao == null) {
                int n = -1;
                return n;
            }
            File d = null;
            String exportDirPath = this.getExportDirPath();
            String exportDirPath4ZipFile = null;
            if (this.getUseZipFile()) {
                exportDirPath4ZipFile = this.getExportDirPath4ZipFile();
            }
            if (!this.getUseZipFile()) {
                d = exportDirPath == null ? new File(dir.getContent()) : new File(exportDirPath, File.separator + dir.getContent());
                if (!d.exists()) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00739), LogCodeManager.getMessage(LogCode.JFC00739, d.getAbsolutePath()));
                    if (!d.mkdirs()) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00740), LogCodeManager.getMessage(LogCode.JFC00740, d.getAbsolutePath(), dir.getTablename()));
                        int n = -1;
                        return n;
                    }
                }
                if (!d.isDirectory()) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00741), LogCodeManager.getMessage(LogCode.JFC00741, d.getAbsolutePath(), dir.getTablename()));
                    int n = -1;
                    return n;
                }
            }
            if ((cursor = dao.selectAsCursor()) instanceof Releasable) {
                releasable = (Releasable)((Object)cursor);
            }
            File f = null;
            String path = null;
            String document = null;
            FileOutputStream ostream = null;
            OutputStreamWriter writer = null;
            LoopProcessTimeLogger ptl = this.createLoopProcessTimeLogger("export " + dir.getTablename());
            ptl.setMessage("{0} {1} at {3} sec. process {4} at {5} sec.");
            int i = 1;
            while (cursor.next()) {
                ptl.check(i);
                try {
                    Object data = cursor.getObject();
                    document = this.makeTextDocument(data);
                    dao.evict(data);
                    String file_num = Integer.toString(i);
                    if ("jdbc_master".equals(dir.getStorage()) && data instanceof Master) {
                        file_num = ((Master)data).getIdAsString();
                    }
                    if (this.getUseZipFile() && this.zip_archive_out != null) {
                        ZipArchiveEntry ze;
                        String dname = dir.getContent();
                        if (i == 1) {
                            ze = new ZipArchiveEntry(exportDirPath4ZipFile + "/" + dname + "/");
                            this.zip_archive_out.putArchiveEntry((ArchiveEntry)ze);
                            this.zip_archive_out.closeArchiveEntry();
                        }
                        path = exportDirPath4ZipFile + "/" + dname + "/item_" + file_num + ".xml";
                        ze = new ZipArchiveEntry(path);
                        this.zip_archive_out.putArchiveEntry((ArchiveEntry)ze);
                        StringBuilder content = new StringBuilder();
                        content.append(document);
                        StringReader reader = new StringReader(content.toString());
                        IOUtils.copy((Reader)reader, (OutputStream)this.zip_archive_out, (String)this.getEncoding());
                        this.zip_archive_out.closeArchiveEntry();
                    } else {
                        f = new File(d, "item_" + file_num + ".xml");
                        path = f.getAbsolutePath();
                        ostream = new FileOutputStream(f);
                        writer = new OutputStreamWriter((OutputStream)ostream, this.getEncoding());
                        writer.write(document);
                    }
                    ++writenum;
                    this.actionSuccessExport(this, dir, f);
                }
                catch (Exception e) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00732), LogCodeManager.getMessage(LogCode.JFC00732, path, e.getMessage()), (Throwable)e);
                    this.actionErrorExport(this, dir, f, e);
                    if (e instanceof InvocationTargetException) {
                        Throwable t = ((InvocationTargetException)e).getTargetException();
                        logger.debug("table object " + dir.getTablename() + " throw Exception ", t);
                    }
                }
                finally {
                    if (!this.getUseZipFile()) {
                        if (writer != null) {
                            try {
                                writer.close();
                                writer = null;
                                ostream = null;
                            }
                            catch (Exception e) {
                                logger.debug("Failed to close writer.", (Throwable)e);
                            }
                        }
                        if (ostream != null) {
                            try {
                                ostream.close();
                                ostream = null;
                            }
                            catch (Exception e) {
                                logger.debug("Failed to close ostream.", (Throwable)e);
                            }
                        }
                        writer = null;
                        ostream = null;
                    }
                }
                ++i;
            }
            ptl.show(i - 1);
            logger.log(LogCodeManager.getPriority(LogCode.JFC00742), LogCodeManager.getMessage(LogCode.JFC00742, String.valueOf(writenum), dir.getTablename()));
            this.exportSequenceByExportTable(dir, tableclassname);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00743), LogCodeManager.getMessage(LogCode.JFC00743, dir.getTablename(), e.getMessage()), (Throwable)e);
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                logger.debug("table object " + dir.getTablename() + " throw Exception", t);
            }
            e.printStackTrace();
        }
        finally {
            if (releasable != null) {
                releasable.release();
            }
            if (dao != null) {
                dao.close();
            }
        }
        return writenum;
    }

    protected void exportSequenceByExportTable(Directory dir, String classname) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportSequenceByExportTable(Directory dir, String classname, String seqName) throws Exception {
        if (StringUtils.isBlank((CharSequence)seqName)) {
            return;
        }
        Sequence sequenceitem = null;
        for (int i = 0; i < this.sequence.length; ++i) {
            if (!this.sequence[i].getSeqname().equals(seqName)) continue;
            sequenceitem = this.sequence[i];
            break;
        }
        if (sequenceitem == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.createConnection();
            ActionParameter p = ActionParameter.createActionParameter(logger, "initdb", null);
            long seq_value = CommonService.getSequenceAsLong(p, seqName);
            stmt = conn.createStatement();
            this.dropSequence(stmt, seqName);
            this.createSequence(stmt, seq_value, sequenceitem);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            this.createExportSeqFile(seqName, seq_value);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00744), LogCodeManager.getMessage(LogCode.JFC00744, e.getMessage()));
            this.actionErrorExport(this, dir, null, e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.debug("Failed to close statement.", (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException se) {
                    logger.debug("Failed to close connection.", (Throwable)se);
                }
            }
        }
    }

    protected void createExportSeqFile(String seqName, long seq_value) {
        if (StringUtils.isBlank((CharSequence)seqName)) {
            return;
        }
        Directory dir = this.getDirectory("seq");
        if (dir == null) {
            return;
        }
        if (this.getUseZipFile()) {
            this.createExportSeqFile_ZipFile(seqName, seq_value, dir);
        } else {
            this.createExportSeqFile_File(seqName, seq_value, dir);
        }
    }

    private void createExportSeqFile_ZipFile(String seqName, long seq_value, Directory dir) {
        block3: {
            if (this.zip_archive_out == null) {
                return;
            }
            String exportDirPath4ZipFile = this.getExportDirPath4ZipFile();
            String dname = dir.getContent();
            String path = exportDirPath4ZipFile + "/" + dname + "/" + seqName + ".xml";
            try {
                ZipArchiveEntry ze = new ZipArchiveEntry(path);
                this.zip_archive_out.putArchiveEntry((ArchiveEntry)ze);
                StringBuilder content = new StringBuilder();
                Seq seq = new Seq();
                seq.setName(seqName);
                seq.setNumber(seq_value);
                content.append(seq.makeTextDocument());
                StringReader reader = new StringReader(content.toString());
                IOUtils.copy((Reader)reader, (OutputStream)this.zip_archive_out, (String)this.getEncoding());
                this.zip_archive_out.closeArchiveEntry();
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00732), LogCodeManager.getMessage(LogCode.JFC00732, path, e.getMessage()), (Throwable)e);
                if (!(e instanceof InvocationTargetException)) break block3;
                Throwable t = ((InvocationTargetException)e).getTargetException();
                logger.debug("table object " + dir.getTablename() + " throw Exception ", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExportSeqFile_File(String seqName, long seq_value, Directory dir) {
        File d = null;
        String exportDirPath = this.getExportDirPath();
        d = exportDirPath == null ? new File(dir.getContent()) : new File(exportDirPath, dir.getContent());
        if (!d.exists()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00739), LogCodeManager.getMessage(LogCode.JFC00739, d.getAbsolutePath()));
            if (!d.mkdirs()) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00740), LogCodeManager.getMessage(LogCode.JFC00740, d.getAbsolutePath(), dir.getTablename()));
                return;
            }
        }
        if (!d.isDirectory()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00741), LogCodeManager.getMessage(LogCode.JFC00741, d.getAbsolutePath(), dir.getTablename()));
            return;
        }
        File f = null;
        FileOutputStream ostream = null;
        OutputStreamWriter writer = null;
        try {
            Seq seq = new Seq();
            seq.setName(seqName);
            seq.setNumber(seq_value);
            f = new File(d, seqName + ".xml");
            ostream = new FileOutputStream(f);
            writer = new OutputStreamWriter((OutputStream)ostream, this.getEncoding());
            writer.write(seq.makeTextDocument());
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00732), LogCodeManager.getMessage(LogCode.JFC00732, f.getAbsolutePath(), e.getMessage()), (Throwable)e);
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                logger.debug("table object " + dir.getTablename() + " throw Exception ", t);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                    ostream = null;
                }
                catch (Exception e) {
                    logger.debug("Failed to close writer.", (Throwable)e);
                }
            }
            if (ostream != null) {
                try {
                    ostream.close();
                    ostream = null;
                }
                catch (Exception e) {
                    logger.debug("Failed to close ostream.", (Throwable)e);
                }
            }
            writer = null;
            ostream = null;
        }
    }

    @Override
    public void doCreate(Directory dir) {
        if (dir == null) {
            return;
        }
        String tablename = dir.getTablename();
        String tableclassname = this.getTableclassname(tablename);
        if (this.isCheckExistsTable() && StringUtils.isNotBlank((CharSequence)tablename)) {
            try {
                int status = this.getTableStatus(dir, tableclassname);
                if (status == 1) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00745), LogCodeManager.getMessage(LogCode.JFC00745, tablename));
                    return;
                }
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00746), LogCodeManager.getMessage(LogCode.JFC00746, tablename, e.getMessage()), (Throwable)e);
                return;
            }
        }
        this.createTable(dir, tableclassname);
    }

    @Override
    public void doDrop(Directory dir) {
        if (dir == null) {
            return;
        }
        String tablename = dir.getTablename();
        String tableclassname = this.getTableclassname(tablename);
        if (this.isCheckExistsTable() && StringUtils.isNotBlank((CharSequence)tablename)) {
            try {
                int status = this.getTableStatus(dir, tableclassname);
                if (status == 0) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00747), LogCodeManager.getMessage(LogCode.JFC00747, tablename));
                    return;
                }
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00748), LogCodeManager.getMessage(LogCode.JFC00748, tablename, e.getMessage()), (Throwable)e);
                return;
            }
        }
        this.dropTable(dir, tableclassname);
    }

    @Override
    public void doImport(Directory dir) {
        if (dir == null) {
            return;
        }
        String tablename = dir.getTablename();
        String tableclassname = this.getTableclassname(tablename);
        if (this.isCheckExistsTable() && StringUtils.isNotBlank((CharSequence)tablename)) {
            try {
                int status = this.getTableStatus(dir, tableclassname);
                if (status == 0) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00749), LogCodeManager.getMessage(LogCode.JFC00749, tablename));
                    return;
                }
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00750), LogCodeManager.getMessage(LogCode.JFC00750, tablename, e.getMessage()), (Throwable)e);
                return;
            }
        }
        this.importTable(dir, tableclassname);
    }

    @Override
    public void doUpdate(Directory dir) {
        if (dir == null) {
            return;
        }
        String tablename = dir.getTablename();
        String tableclassname = this.getTableclassname(tablename);
        if (this.isCheckExistsTable() && StringUtils.isNotBlank((CharSequence)tablename)) {
            try {
                int status = this.getTableStatus(dir, tableclassname);
                if (status == 0) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00751), LogCodeManager.getMessage(LogCode.JFC00751, tablename));
                    return;
                }
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00752), LogCodeManager.getMessage(LogCode.JFC00752, tablename), (Throwable)e);
                return;
            }
        }
        this.updateTable(dir, tableclassname);
    }

    protected void doMigrate() {
        DBInfo dbInfo = this.dbInfo();
        Path migratedbDir = this.migratedbDir();
        if (Files.notExists(migratedbDir, new LinkOption[0])) {
            migratedbDir.toFile().mkdirs();
            new InitCommand().execute(dbInfo, migratedbDir, this.ddlBuffer.toString());
        } else {
            if (!Files.isDirectory(migratedbDir, new LinkOption[0])) {
                throw new IllegalStateException(migratedbDir.toString() + " must be directory.");
            }
            new MigrateCommand().execute(dbInfo, migratedbDir, this.ddlBuffer.toString());
        }
    }

    protected void doCleanMigrate() {
        new CleanCommand().execute(this.dbInfo(), this.migratedbDir());
    }

    private DBInfo dbInfo() {
        DBInfo dbInfo = new DBInfo(this.getDataSource(), this.getDbType());
        Integer domainId = this.getDomainId();
        if (domainId != null) {
            dbInfo.setDomainId(domainId);
        }
        return dbInfo;
    }

    private Integer getDomainId() {
        AbstractDomainSupport domainSupport = (AbstractDomainSupport)this.appctx.getBean("DomainSupport", AbstractDomainSupport.class);
        return domainSupport.id();
    }

    public Path migratedbDir() {
        Integer domainId = this.getDomainId();
        if (domainId != null) {
            return Paths.get(this.migratedbBaseDir.toString(), "domain" + domainId.toString());
        }
        return this.migratedbBaseDir;
    }

    public void setMigratedbBaseDir(Path migratedbBaseDir) {
        this.migratedbBaseDir = migratedbBaseDir;
    }

    @Override
    public void doExport(Directory dir) {
        int num;
        if (dir == null) {
            return;
        }
        String tablename = dir.getTablename();
        String tableclassname = this.getTableclassname(tablename);
        if (this.isCheckExistsTable() && StringUtils.isNotBlank((CharSequence)tablename)) {
            try {
                int status = this.getTableStatus(dir, tableclassname);
                if (status == 0) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00753), LogCodeManager.getMessage(LogCode.JFC00753, tablename));
                    return;
                }
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00754), LogCodeManager.getMessage(LogCode.JFC00754, tablename), (Throwable)e);
                return;
            }
        }
        if ((num = this.exportTable(dir, tableclassname)) >= 0) {
            String target = PathUtil.getModelIdFromDirectoryContent(dir.getContent());
            this.props.setProperty("InitLoader.file.count." + target, String.valueOf(num));
        }
    }

    public String getTableclassname(String tablename) {
        return this.getTableConfigManager().getTableclassname(tablename);
    }

    protected int getTableStatus(Directory dir, String tableclassname) throws Exception {
        try (XML2DBLoaderDao dao = null;){
            dao = this.createXML2DBLoaderDao(dir, tableclassname);
            if (dao == null) {
                throw new IllegalStateException("Failed to get XML2DBLoaderDao object.");
            }
            int n = dao.getTableStatus();
            return n;
        }
    }

    protected boolean isTablenameIgnoreCase() {
        return this.tablename_ignorecase;
    }

    protected LoopProcessTimeLogger createLoopProcessTimeLogger(String name) {
        LoopProcessTimeLogger ptl = new LoopProcessTimeLogger(name);
        ptl.setDisplaySource(0);
        ptl.setSteptime(this.ptl_steptime);
        return ptl;
    }

    protected String makeTextDocument(Object obj) throws Exception {
        Class<?> dataclass = obj.getClass();
        Method makeTextDocumentMethod = dataclass.getMethod("makeTextDocument", new Class[0]);
        String document = (String)makeTextDocumentMethod.invoke(obj, new Object[0]);
        return document;
    }

    protected XML2DBLoaderDao createXML2DBLoaderDao(Directory dir, String tableclassname) throws Exception {
        String storage = dir.getStorage();
        if (storage != null && storage.equals("hibernate")) {
            String objclassname = this.getObjectclassname(dir);
            if (objclassname == null) {
                logger.debug("Unknown object " + dir.getTablename());
                return null;
            }
            return new HibernateXML2DBLoaderDao(dir, objclassname);
        }
        if (storage != null && storage.equals("jdbc_master")) {
            String objclassname = this.getObjectclassname(dir);
            if (objclassname == null) {
                logger.debug("Unknown object " + dir.getTablename());
                return null;
            }
            Connection conn = this.createConnection();
            MasterJdbcXML2DBLoaderDao dao = new MasterJdbcXML2DBLoaderDao(dir, objclassname, conn);
            dao.setTablenameIgnoreCase(this.isTablenameIgnoreCase());
            return dao;
        }
        if (tableclassname == null) {
            logger.debug("Unknown table " + dir.getTablename());
            return null;
        }
        Connection conn = this.createConnection();
        RelaxerJdbcXML2DBLoaderDao dao = new RelaxerJdbcXML2DBLoaderDao(dir, tableclassname, conn);
        dao.setTablenameIgnoreCase(this.isTablenameIgnoreCase());
        return dao;
    }

    protected String getObjectclassname(Directory dir) {
        return this.getTableConfigManager().getObjectclassname(dir.getTablename());
    }

    protected Long getExportedSequenceData(String seqName) {
        return this.getExportedSequenceData(seqName, this.getExportDirPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Long getExportedSequenceData(String seqName, String exportDirPath) {
        if (StringUtils.isBlank((CharSequence)seqName)) {
            return null;
        }
        Directory dir = this.getDirectory("seq");
        if (dir == null) {
            return null;
        }
        File d = null;
        if (!(this.getUseZipFile() || (d = exportDirPath == null ? new File(dir.getContent()) : new File(exportDirPath, dir.getContent())) != null && d.isDirectory())) {
            return null;
        }
        if (this.getUseZipFile()) {
            Long ret = null;
            ZipArchiveInputStream zip_archive_in = null;
            BufferedInputStream zin = null;
            File zipFile = new File(exportDirPath + ".zip");
            try {
                zin = new BufferedInputStream(new FileInputStream(zipFile));
                zip_archive_in = new ZipArchiveInputStream((InputStream)zin);
                String target = PathUtil.getModelIdFromDirectoryContent(dir.getContent());
                ZipArchiveEntry entry = null;
                String baseDir = this.getZipFileBasedir(exportDirPath);
                while ((entry = zip_archive_in.getNextZipEntry()) != null) {
                    String name = entry.getName();
                    String modelId = PathUtil.getModelIdFromPath(name);
                    if (!modelId.equals(target)) continue;
                    File file = new File(this.getTemplateExportDirPath4ZipFile(baseDir + File.separator + entry.getName()));
                    if (entry.isDirectory()) {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        file.mkdirs();
                        continue;
                    }
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding());){
                        IOUtils.copy((InputStream)zip_archive_in, (Writer)out, (String)this.getEncoding());
                    }
                    Document doc = this.getDocument(dir, file);
                    if (doc == null) continue;
                    Seq seq = (Seq)JaxbUtil.unmarshal((Document)doc, Seq.class);
                    if (seqName.equals(seq.getName())) {
                        ret = seq.getNumber() - 1L;
                        break;
                    }
                    file.delete();
                }
                if (ret == null) {
                    logger.debug("ret is null in zip file " + zipFile.getAbsolutePath());
                }
                Long l = ret;
                return l;
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00762), LogCodeManager.getMessage(LogCode.JFC00762, zipFile.getName()));
                if (!logger.isDebugEnabled()) return null;
                e.printStackTrace();
                return null;
            }
            finally {
                if (zip_archive_in != null) {
                    try {
                        zip_archive_in.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        zip_archive_in = null;
                    }
                }
                if (zin != null) {
                    try {
                        ((InputStream)zin).close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        zin = null;
                    }
                }
            }
        }
        for (File f : this.createTargetList(d)) {
            Document doc = this.getDocument(dir, f);
            if (doc == null) continue;
            try {
                Seq seq = (Seq)JaxbUtil.unmarshal((Document)doc, Seq.class);
                if (!seqName.equals(seq.getName())) continue;
                return seq.getNumber() - 1L;
            }
            catch (JAXBException jAXBException) {
            }
        }
        return null;
    }

    String getDbType() {
        return this.dbtype;
    }

    String getDriver() {
        return this.driver;
    }

    public Directory getDirectory(String tablename) {
        if (this.dirs == null || StringUtils.isBlank((CharSequence)tablename)) {
            return null;
        }
        for (Directory dir : this.dirs) {
            if (dir == null || !tablename.equals(dir.getTablename())) continue;
            return dir;
        }
        return null;
    }

    public ActionParameter createActionParameter() {
        return null;
    }

    public ActionParameter createActionParameter(Connection conn) {
        return null;
    }

    @Override
    protected void preprocess(String command, String config_file) {
        super.preprocess(command, config_file);
        if ("sql".equals(command)) {
            this.preprocess_sql(config_file);
            return;
        }
        if ("sequence".equals(command)) {
            this.preprocess_sequence(config_file);
            return;
        }
        if ("driver".equals(command)) {
            this.preprocess_driver(config_file);
            return;
        }
        if ("driver_all".equals(command)) {
            this.preprocess_driver_all(config_file);
            return;
        }
        if ("driver_all12".equals(command)) {
            this.preprocess_driver_all12(config_file);
            return;
        }
    }

    protected void preprocess_sql(String config_file) {
    }

    protected void preprocess_sequence(String config_file) {
    }

    protected void preprocess_driver(String config_file) {
    }

    protected void preprocess_driver_all(String config_file) {
    }

    protected void preprocess_driver_all12(String config_file) {
    }

    public static long NEXTVALUE(long number, Class<?> seq_type) {
        if (seq_type.equals(Integer.TYPE)) {
            number = number >= Integer.MAX_VALUE ? Integer.MIN_VALUE : ++number;
        } else if (seq_type.equals(Long.TYPE)) {
            number = number >= Long.MAX_VALUE ? Long.MIN_VALUE : ++number;
        } else if (seq_type.equals(Short.TYPE)) {
            number = number >= 32767L ? -32768L : ++number;
        } else if (seq_type.equals(Byte.TYPE)) {
            number = number >= 127L ? -128L : ++number;
        }
        return number;
    }
}

