/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb.conf;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.core.support.xml.DomUtils;
import jp.jasminesoft.jfc.initdb.conf.ConnectionInterface;
import jp.jasminesoft.jfc.initdb.conf.Database;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import jp.jasminesoft.jfc.initdb.conf.IConfigChoice;
import jp.jasminesoft.jfc.initdb.conf.Sequence;
import jp.jasminesoft.jfc.initdb.conf.Sql;
import org.w3c.dom.Document;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="config")
@XmlType(propOrder={"database_", "connectionInterface_", "content_"})
public class Config
implements Serializable,
Cloneable {
    @XmlElement(name="database")
    @JsonProperty(value="database")
    private Database database_;
    @XmlElement(name="connection_interface")
    @JsonProperty(value="connection_interface")
    private ConnectionInterface connectionInterface_;
    @XmlElementRefs(value={@XmlElementRef(name="sql", type=Sql.class), @XmlElementRef(name="sequence", type=Sequence.class), @XmlElementRef(name="directory", type=Directory.class)})
    private List<IConfigChoice> content_ = new ArrayList<IConfigChoice>();

    public Config() {
    }

    public Config(Config source) {
        this.setup(source);
    }

    public void setup(Config source) {
        if (source.database_ != null) {
            this.setDatabase((Database)source.getDatabase().clone());
        }
        if (source.connectionInterface_ != null) {
            this.setConnectionInterface((ConnectionInterface)source.getConnectionInterface().clone());
        }
        this.content_.clear();
        int size = source.content_.size();
        for (int i = 0; i < size; ++i) {
            this.addContent((IConfigChoice)source.getContent(i).clone());
        }
    }

    public Object clone() {
        return new Config(this);
    }

    public Document makeDocument() throws ParserConfigurationException {
        return DomUtils.makeDocument(this.toString());
    }

    public final Database getDatabase() {
        return this.database_;
    }

    public final void setDatabase(Database database) {
        this.database_ = database;
    }

    public final ConnectionInterface getConnectionInterface() {
        return this.connectionInterface_;
    }

    public final void setConnectionInterface(ConnectionInterface connectionInterface) {
        this.connectionInterface_ = connectionInterface;
    }

    public final IConfigChoice[] getContent() {
        IConfigChoice[] array = new IConfigChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IConfigChoice[] content) {
        this.content_.clear();
        for (int i = 0; i < content.length; ++i) {
            this.addContent(content[i]);
        }
    }

    public final void setContent(IConfigChoice content) {
        this.content_.clear();
        this.addContent(content);
    }

    public final void addContent(IConfigChoice content) {
        this.content_.add(content);
    }

    public final void addContent(IConfigChoice[] content) {
        for (int i = 0; i < content.length; ++i) {
            this.addContent(content[i]);
        }
    }

    public final int sizeContent() {
        return this.content_.size();
    }

    public final IConfigChoice getContent(int index) {
        return this.content_.get(index);
    }

    public final void setContent(int index, IConfigChoice content) {
        this.content_.set(index, content);
    }

    public final void addContent(int index, IConfigChoice content) {
        this.content_.add(index, content);
    }

    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    public final void removeContent(IConfigChoice content) {
        this.content_.remove(content);
    }

    public final void clearContent() {
        this.content_.clear();
    }

    public String makeTextDocument() {
        StringBuilder buffer = new StringBuilder();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuilder buffer) {
        StringWriter writer = new StringWriter();
        try {
            JAXB.marshal((Object)this, (Writer)writer);
            buffer.append(writer.toString());
        }
        catch (DataBindingException dataBindingException) {
            // empty catch block
        }
    }

    public void makeTextElement(Writer buffer) throws IOException {
        try {
            JAXB.marshal((Object)this, (Writer)buffer);
        }
        catch (DataBindingException dataBindingException) {
            // empty catch block
        }
    }

    public void makeTextElement(PrintWriter buffer) {
        StringWriter writer = new StringWriter();
        try {
            JAXB.marshal((Object)this, (Writer)writer);
            buffer.print(writer.toString());
        }
        catch (DataBindingException dataBindingException) {
            // empty catch block
        }
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

