/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.job.TaskException;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.SystemlogCondition;
import jp.jasminesoft.jfc.model.systemlog.SystemlogKind;
import jp.jasminesoft.jfc.model.systemlog.SystemlogManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlertMailFromLogTask {
    protected static final String CR = System.getProperty("line.separator");
    private static final Logger logger = LogManager.getLogger((String)AlertMailFromLogTask.class.getName());
    private String logType;
    private String keyword;
    private String interval;
    private String script;
    private boolean doNotSendEmptyMessage;
    private boolean debug;
    private SystemlogManager logman;
    private static final SimpleDateFormat LOGDATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean getDoNotSendEmptyMessage() {
        return this.doNotSendEmptyMessage;
    }

    public void setDoNotSendEmptyMessage(boolean doNotSendEmptyMessage) {
        this.doNotSendEmptyMessage = doNotSendEmptyMessage;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected boolean isDebug() {
        return this.debug;
    }

    public SystemlogManager getSystemlogManager() {
        return this.logman;
    }

    public void setSystemlogManager(SystemlogManager logman) {
        this.logman = logman;
    }

    public String execute(ActionParameter p) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String errmsg = this.init(paramMap);
        if (StringUtils.isNotBlank((CharSequence)errmsg)) {
            throw new TaskException(errmsg);
        }
        if (this.debug) {
            System.out.println(paramMap);
        }
        StringBuilder sb = new StringBuilder();
        int count = this.process(paramMap, sb);
        if (StringUtils.isBlank((CharSequence)sb.toString())) {
            if (logger.isDebugEnabled()) {
                logger.debug("No log content.");
            }
            if (this.doNotSendEmptyMessage) {
                return "";
            }
            sb.append("No log content.");
        } else {
            sb.append(CR + "There are " + count + " rows in this mail." + CR);
        }
        sb.insert(0, "Log date : " + LOGDATE_FORMAT.format(new Date()) + CR + CR);
        if (this.debug) {
            System.out.println(sb.toString());
        }
        return sb.toString();
    }

    protected int process(Map<String, String> paramMap, StringBuilder sb) {
        SystemlogManager logman = this.getSystemlogManager();
        SystemlogCondition cond = new SystemlogCondition();
        SystemlogKind logkind = logman.createLogKind(paramMap);
        cond.setLogKind(logkind);
        if (StringUtils.isBlank((CharSequence)this.logType)) {
            cond.setLogType("ERROR");
        } else if (this.logType.equalsIgnoreCase("DEBUG")) {
            cond.setLogType("DEBUG INFO WARN ERROR FATAL");
        } else if (this.logType.equalsIgnoreCase("INFO")) {
            cond.setLogType("INFO WARN ERROR FATAL");
        } else if (this.logType.equalsIgnoreCase("WARN")) {
            cond.setLogType("WARN ERROR FATAL");
        } else if (this.logType.equalsIgnoreCase("ERROR")) {
            cond.setLogType("ERROR FATAL");
        } else if (this.logType.equalsIgnoreCase("FATAL")) {
            cond.setLogType("FATAL");
        } else if (!this.logType.equalsIgnoreCase("ALL")) {
            sb.append("Invalid log type, " + this.logType);
            return 0;
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyword)) {
            cond.setKeyword(this.keyword);
        }
        if (StringUtils.isNotBlank((CharSequence)this.interval) && !this.setIntervalCondition(cond, this.interval, sb)) {
            return 0;
        }
        LogCheckInterface scriptObj = null;
        if (StringUtils.isNotBlank((CharSequence)this.script)) {
            try {
                scriptObj = this.initScript("js", this.script);
            }
            catch (Exception e) {
                logger.warn("Invalid initialize script.", (Throwable)e);
                sb.append("Invalid initialize script. " + e.getMessage());
                throw new TaskException("Invalid initialize script. " + e.getMessage());
            }
            if (scriptObj == null) {
                logger.warn("Invalid initialize script, not found js engine.");
                sb.append("Invalid initialize script, not found js engine.");
                throw new TaskException("Invalid initialize script, not found js engine.");
            }
        }
        Systemlog[] logdata = logman.getLogData(cond);
        int cnt = 0;
        for (Systemlog log : logdata) {
            if (scriptObj != null && !scriptObj.checkLog(log)) continue;
            ++cnt;
            sb.append(log);
            sb.append(CR);
        }
        return cnt;
    }

    protected boolean setIntervalCondition(SystemlogCondition cond, String interval, StringBuilder sb) {
        Calendar nowdate = Calendar.getInstance();
        return this.setIntervalCondition(cond, interval, sb, nowdate);
    }

    private boolean setIntervalCondition(SystemlogCondition cond, String interval, StringBuilder sb, Calendar nowdate) {
        int logminutes;
        try {
            logminutes = this.getMinutesByInterval(interval);
        }
        catch (NumberFormatException e) {
            sb.append("Invalid interval, require number value " + interval);
            return false;
        }
        if (logminutes > 1440 || logminutes <= 0) {
            sb.append("Invalid interval value '" + interval + "'. require 0 < interval <= 24 hours.");
            return false;
        }
        int nowminutes = nowdate.get(12);
        int nowhour = nowdate.get(11);
        int cnt = (nowhour * 60 + nowminutes) / logminutes;
        int adjust = nowminutes % logminutes;
        if (cnt == 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowdate.getTime());
            cal.set(11, 0);
            cal.set(12, 0 + adjust);
            cal.set(13, 0);
            cal.set(14, 0);
            cond.setEndLogDate(cal.getTime());
            cal.add(12, -logminutes);
            cond.setBeginLogDate(cal.getTime());
            cond.setTargetDay(cal.getTime());
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(nowdate.getTime());
            cal.set(11, cnt * logminutes / 60);
            cal.set(12, (cnt + 1) * logminutes % 60 + adjust);
            cal.set(13, 0);
            cal.set(14, 0);
            cond.setEndLogDate(cal.getTime());
            cal.add(12, -logminutes);
            cond.setBeginLogDate(cal.getTime());
            cond.setTargetDay(cal.getTime());
        }
        return true;
    }

    protected int getMinutesByInterval(String interval) throws NumberFormatException {
        if (interval.endsWith("h")) {
            String interval1 = interval.substring(0, interval.length() - 1);
            int logminutes = Integer.parseInt(interval1);
            return logminutes *= 60;
        }
        if (interval.endsWith("m")) {
            String interval1 = interval.substring(0, interval.length() - 1);
            return Integer.parseInt(interval1);
        }
        String interval1 = interval;
        return Integer.parseInt(interval1);
    }

    protected LogCheckInterface initScript(String engineName, String script) throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(engineName);
        if (engine == null) {
            return null;
        }
        if (!(engine instanceof Invocable)) {
            return null;
        }
        engine.eval(script);
        Invocable inv = (Invocable)((Object)engine);
        LogCheckInterface lci = inv.getInterface(LogCheckInterface.class);
        return lci;
    }

    protected String init(Map<String, String> paramMap) {
        paramMap.put("basedir", JFCUtils.getCatalinaHomeDir());
        paramMap.putAll(this.getSystemlogManager().getDefaultLogKinds().getParamMap());
        return null;
    }

    public static void test() {
        AlertMailFromLogTask task = new AlertMailFromLogTask();
        String[] interval = new String[]{"3h", "1h", "1m", "1"};
        int[] minutes = new int[]{180, 60, 1, 1};
        int[] hourofday = new int[]{0, 3, 6, 9, 12, 15, 18, 21};
        for (int i = 0; i < interval.length; ++i) {
            logger.info("interval " + interval[i]);
            int logminutes = task.getMinutesByInterval(interval[i]);
            if (logminutes != minutes[i]) {
                logger.error("wrong value " + interval + " is " + logminutes);
            }
            SystemlogCondition cond = new SystemlogCondition();
            Calendar nowdate = Calendar.getInstance();
            for (int j = 0; j < hourofday.length; ++j) {
                nowdate.set(11, hourofday[j]);
                logger.info("nowdate " + nowdate);
                StringBuilder sb = new StringBuilder();
                if (!task.setIntervalCondition(cond, interval[i], sb, nowdate)) {
                    logger.error("wrong value " + sb.toString());
                }
                logger.info("cond.getBeginLogDate " + cond.getBeginLogDate());
                logger.info("cond.getEndLogDate " + cond.getEndLogDate());
                logger.info("cond.getTargetDay " + cond.getTargetDay());
            }
        }
    }

    public static interface LogCheckInterface {
        public boolean checkLog(Systemlog var1);
    }
}

