/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.job.TaskException;
import org.apache.commons.lang.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckDiskTask {
    private static final Logger logger = LogManager.getLogger((String)CheckDiskTask.class.getName());
    private int defaultCutoff;

    public int getDefaultCutoff() {
        return this.defaultCutoff;
    }

    public void setDefaultCutoff(int defaultCutoff) {
        this.defaultCutoff = defaultCutoff;
    }

    public String execute(ActionParameter p) {
        if (!SystemUtils.isJavaVersionAtLeast((int)6)) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00923), LogCodeManager.getMessage(LogCode.JFC00923, p.user, this.getClass().getName()));
            throw new TaskException("Failed. JVM Version needs 6 or higher.");
        }
        int available = 0;
        File file = new File(".");
        try {
            Class<File> clazz = File.class;
            Method method = clazz.getMethod("getTotalSpace", new Class[0]);
            Object result = method.invoke((Object)file, null);
            long total_space = (Long)result;
            method = clazz.getMethod("getFreeSpace", new Class[0]);
            result = method.invoke((Object)file, null);
            long free_space = (Long)result;
            method = clazz.getMethod("getUsableSpace", new Class[0]);
            result = method.invoke((Object)file, null);
            long usable_space = (Long)result;
            double total_space_gb = (double)total_space / 1.0E9;
            double free_space_gb = (double)free_space / 1.0E9;
            double usable_space_gb = (double)usable_space / 1.0E9;
            available = (int)(free_space_gb / total_space_gb * 100.0);
            if (available < 100 - this.defaultCutoff) {
                NumberFormat nf = NumberFormat.getIntegerInstance();
                nf.setMaximumFractionDigits(2);
                StringBuilder sb = new StringBuilder();
                sb.append("Disk size is ").append(100 - available).append("% full -- ");
                sb.append(nf.format(total_space_gb - free_space_gb)).append("G");
                sb.append(" of ");
                sb.append(nf.format(total_space_gb)).append("G");
                sb.append(" used, ");
                if (usable_space_gb > 1.0) {
                    sb.append(nf.format(usable_space_gb)).append("G");
                } else {
                    usable_space_gb = (double)usable_space / 1000000.0;
                    sb.append(nf.format(usable_space_gb)).append("M");
                }
                sb.append(" remain.");
                return sb.toString();
            }
        }
        catch (Exception e) {
            throw new TaskException(e.getMessage());
        }
        return "";
    }
}

