/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.io.IOException;
import jp.jasminesoft.jfc.job.FileProcessTask;
import jp.jasminesoft.jfc.job.TaskException;
import jp.jasminesoft.util.FileCopy;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class CopyFileTask
extends FileProcessTask {
    protected String dest;
    protected boolean isOverride = true;

    public String getSrc() {
        return this.targetDirectory;
    }

    public void setSrc(String src) {
        this.targetDirectory = src;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public boolean getOverride() {
        return this.isOverride;
    }

    public void setOverride(boolean isOverride) {
        this.isOverride = isOverride;
    }

    @Override
    protected boolean isIgnoreZeroSizeFile() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        if (StringUtils.isBlank((CharSequence)this.dest)) {
            throw new TaskException("Failed. No destination is specified.");
        }
        if (this.baseDirectory.isDirectory() && this.wildcard == null) {
            File destdir = new File(this.dest);
            if (!destdir.exists()) {
                destdir.mkdir();
            } else {
                this.dest = this.dest + File.separator + this.baseDirectory.getName();
                destdir = new File(this.dest);
                destdir.mkdir();
            }
        }
    }

    @Override
    protected String getParameterMessage() {
        StringBuilder sb = new StringBuilder(super.getParameterMessage());
        sb.append(" src=" + this.targetDirectory + ",dest=" + this.dest + ",override=" + this.isOverride);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processFile(File src) {
        boolean ret = false;
        File dest = this.createDestinationFile(src);
        if (dest.exists()) {
            if (!this.isOverride) {
                return ret;
            }
            if (!dest.canWrite()) {
                this.errorFileList.add(this.getFilenameWithoutBaseDirectory(src));
                return ret;
            }
            if (dest.isDirectory()) {
                dest = new File(dest.getAbsolutePath() + File.separator + src.getName());
            }
        }
        try {
            FileCopy.copyFile((File)src, (File)dest);
            String s = this.getFilenameWithoutBaseDirectory(src);
            this.processedFileList.add(s);
            ret = true;
            return ret;
        }
        catch (IOException e) {
            this.errorFileList.add(this.getFilenameWithoutBaseDirectory(src));
        }
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    @Override
    protected void processDirectory_before(File src) {
        File dest = this.createDestinationFile(src);
        if (!dest.exists()) {
            dest.mkdir();
            this.processedFileList.add(this.getFilenameWithoutBaseDirectory(src));
        }
    }

    private File createDestinationFile(File src) {
        String src_path = src.getAbsolutePath();
        String dest_path = StringUtil.replace((String)src_path, (String)this.baseDirectory.getAbsolutePath(), (String)this.dest);
        return new File(dest_path);
    }
}

