/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.io.FileFilter;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.job.TaskException;
import jp.jasminesoft.util.ExcelFunction;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FileProcessTask {
    protected static final String CR = System.getProperty("line.separator");
    private static final Logger logger = LogManager.getLogger((String)FileProcessTask.class.getName());
    protected File baseDirectory;
    protected List<String> excludeList = new ArrayList<String>();
    protected List<String> processedFileList = new ArrayList<String>();
    protected List<String> errorFileList = new ArrayList<String>();
    protected Calendar limit;
    protected IOFileFilter filter;
    protected int totalCount;
    protected int errorCount;
    protected String targetDirectory;
    protected String mtime;
    protected String mdate;
    protected String wildcard;
    protected boolean dealOlderFile = true;
    protected boolean recursiveDir = true;
    protected boolean chooseLatest = false;
    protected boolean debug;

    public String getDir() {
        return this.targetDirectory;
    }

    public void setDir(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getMtime() {
        return this.mtime;
    }

    public void setMtime(String mtime) {
        this.mtime = mtime;
    }

    public String getMdate() {
        return this.mdate;
    }

    public void setMdate(String mdate) {
        this.mdate = mdate;
    }

    public boolean getDealOlderFile() {
        return this.dealOlderFile;
    }

    public void setDealOlderFile(boolean dealOlderFile) {
        this.dealOlderFile = dealOlderFile;
    }

    public boolean getRecursiveDir() {
        return this.recursiveDir;
    }

    public void setRecursiveDir(boolean recursiveDir) {
        this.recursiveDir = recursiveDir;
    }

    public boolean getChooseLatest() {
        return this.chooseLatest;
    }

    public void setChooseLatest(boolean chooseLatest) {
        this.chooseLatest = chooseLatest;
    }

    public boolean isChooseLatest() {
        return this.chooseLatest;
    }

    public String getExclude() {
        StringBuilder sb = new StringBuilder();
        String[] array = this.getExcludes();
        if (array == null || array.length == 0) {
            return "";
        }
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String[] getExcludes() {
        return this.excludeList.toArray(new String[0]);
    }

    public void addExclude(String exclude) {
        this.excludeList.add(exclude);
    }

    public void setExclude(String exclude) {
        String[] tokens;
        for (String token : tokens = exclude.split(" ")) {
            this.excludeList.add(token);
        }
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected boolean isDebug() {
        return this.debug;
    }

    public String execute(ActionParameter p) {
        this.init();
        if (this.isDebug()) {
            logger.debug(this.getClass().getName() + " parameter list: " + this.getParameterMessage());
        }
        try {
            this.process(this.baseDirectory);
        }
        finally {
            this.finish();
        }
        return this.createMessage();
    }

    protected boolean process(File dir) {
        logger.debug("dir " + dir.getAbsolutePath() + ", filter=" + this.filter);
        boolean ret = false;
        File[] files = this.getFiles(dir);
        logger.debug("files " + (files == null ? "null" : Arrays.asList(files)));
        if (files == null) {
            return true;
        }
        logger.debug("limit:" + this.limit);
        List<File> targets = this.getTargetFiles(files);
        for (File file : targets) {
            if (file.isDirectory()) {
                if (!this.recursiveDir) continue;
                logger.debug("** processDirectory," + file);
                ret = this.processDirectory(file);
                continue;
            }
            logger.debug("** processFile," + file);
            ret = this.processFile(file);
        }
        return ret;
    }

    protected List<File> getTargetFiles(File[] files) {
        ArrayList<File> targets = new ArrayList<File>();
        for (File file : files) {
            logger.debug(" * file=" + file.getAbsolutePath());
            if (this.limit != null && !FileProcessTask.isLimitPass(this.dealOlderFile, this.limit, file) || this.excludeList.size() > 0 && this.excludeFileCheck(file)) continue;
            if (this.isIgnoreZeroSizeFile() && file.length() == 0L && file.isFile()) {
                logger.debug("* file " + file.getName() + " is 0 byte. skip.");
                continue;
            }
            if (this.isIgnoreNotReadableFile() && !file.canRead()) {
                logger.debug("File " + file.getName() + " is not readable. Skip.");
                logger.log(LogCodeManager.getPriority(LogCode.JFC00916), LogCodeManager.getMessage(LogCode.JFC00916, file.getName()));
                continue;
            }
            if (this.isIgnoreNotWritableFile() && !file.canWrite()) {
                logger.debug("File " + file.getName() + " is not writable. Skip");
                logger.log(LogCodeManager.getPriority(LogCode.JFC00917), LogCodeManager.getMessage(LogCode.JFC00917, file.getName()));
                continue;
            }
            targets.add(file);
        }
        if (this.isChooseLatest()) {
            File latest = this.chooseLatest(targets);
            targets = new ArrayList();
            if (latest != null) {
                targets.add(latest);
            }
        }
        return targets;
    }

    protected File[] getFiles(File dir) {
        File[] files = dir.isDirectory() ? (this.filter != null ? dir.listFiles((FileFilter)this.filter) : dir.listFiles()) : new File[]{dir};
        return files;
    }

    protected boolean excludeFileCheck(File file) {
        boolean excludeFlag = false;
        for (String exclude : this.excludeList) {
            if (!file.getName().matches(exclude)) continue;
            logger.debug("file " + file.getName() + " is excluded. skip.");
            excludeFlag = true;
            break;
        }
        return excludeFlag;
    }

    protected static boolean isLimitPass(boolean dealOlderFile, Calendar limit, File file) {
        logger.debug(" * file=" + file.getAbsolutePath());
        Calendar fcal = Calendar.getInstance();
        fcal.setTime(new Date(file.lastModified()));
        boolean ret = true;
        if (dealOlderFile) {
            if (limit.before(fcal)) {
                logger.info("(admin@localhost) file " + file.getAbsolutePath() + " is newer than limit. skip");
                ret = false;
            }
        } else if (limit.after(fcal)) {
            logger.info("(admin@localhost) file " + file.getAbsolutePath() + " is older than limit. skip");
            ret = false;
        }
        return ret;
    }

    protected File chooseLatest(List<File> targets) {
        File latest = null;
        for (File file : targets) {
            if (latest == null) {
                latest = file;
                continue;
            }
            if (latest.lastModified() >= file.lastModified()) continue;
            latest = file;
        }
        return latest;
    }

    protected void init() {
        logger.debug("** targetDirectory=" + this.targetDirectory);
        logger.debug("** mtime=" + this.mtime);
        logger.debug("** mdate=" + this.mdate);
        if (StringUtils.isBlank((CharSequence)this.targetDirectory)) {
            throw new TaskException("Failed. No target is specified.");
        }
        Calendar now = Calendar.getInstance();
        if (StringUtils.isNotBlank((CharSequence)this.mtime)) {
            Time t = ExcelFunction.TIMEVALUE((String)this.mtime);
            if (t != null) {
                Calendar tcal = Calendar.getInstance();
                tcal.setTimeInMillis(t.getTime());
                this.limit = (Calendar)now.clone();
                this.limit.add(11, tcal.get(11) * -1);
                this.limit.add(12, tcal.get(12) * -1);
                this.limit.add(13, tcal.get(13) * -1);
            } else {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00918), LogCodeManager.getMessage(LogCode.JFC00918, this.mtime));
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.mdate)) {
            try {
                int amount = Integer.parseInt(this.mdate) * -1;
                this.limit = (Calendar)now.clone();
                this.limit.add(5, amount);
            }
            catch (NumberFormatException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00919), LogCodeManager.getMessage(LogCode.JFC00919, this.mdate));
            }
        }
        this.baseDirectory = new File(this.targetDirectory);
        logger.info("(admin@localhost) target directory is " + this.baseDirectory.getAbsolutePath());
        if (!JFCUtils.waitUntilCanRead(this.baseDirectory)) {
            throw new TaskException("Failed. " + this.baseDirectory + " is not existed.");
        }
    }

    public void appendFilter(IOFileFilter newfilter) {
        this.filter = this.filter == null ? newfilter : new AndFileFilter(this.filter, newfilter);
    }

    protected String getParameterMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.limit != null) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH24:mm:ss");
            sb.append("limit=").append(fmt.format(this.limit.getTime())).append(",");
        }
        if (this.excludeList != null && this.excludeList.size() > 0) {
            sb.append("excludeList=" + this.excludeList);
        }
        return sb.toString();
    }

    protected boolean isIgnoreNotReadableFile() {
        return true;
    }

    protected boolean isIgnoreNotWritableFile() {
        return true;
    }

    protected boolean isIgnoreZeroSizeFile() {
        return true;
    }

    protected String getFilenameWithoutBaseDirectory(File file) {
        String filePath = file.getAbsolutePath();
        logger.debug("** filePath=" + filePath);
        String dirPath = this.baseDirectory.getAbsolutePath();
        logger.debug("** dirPath=" + dirPath);
        String name = null;
        int ptr = filePath.indexOf(dirPath);
        if (ptr == 0) {
            name = filePath.length() == dirPath.length() ? file.getName() : filePath.substring(dirPath.length() + 1);
        }
        logger.debug("** name=" + name);
        return name;
    }

    protected abstract boolean processFile(File var1);

    protected boolean processDirectory(File file) {
        this.processDirectory_before(file);
        boolean ret = this.process(file);
        this.processDirectory_after(file, ret);
        return ret;
    }

    protected void processDirectory_before(File file) {
    }

    protected void processDirectory_after(File file, boolean status) {
    }

    protected String createMessage() {
        String classname = this.getClass().getName();
        StringBuilder sb = new StringBuilder();
        sb.append(classname).append(" is finished. total file is " + this.totalCount).append(", error file is " + this.errorCount + ".").append(CR);
        if (this.isDebug() && this.totalCount > 0 && this.totalCount > this.errorCount) {
            sb.append("Success file list is below:").append(CR);
            for (String s : this.processedFileList) {
                sb.append(" ").append(s).append(CR);
            }
        }
        if (this.isDebug() && this.errorCount > 0) {
            sb.append("Error file list is below:").append(CR);
            for (String s : this.errorFileList) {
                sb.append(" ").append(s).append(CR);
            }
        }
        return sb.toString();
    }

    protected void finish() {
        this.totalCount = this.processedFileList.size() + this.errorFileList.size();
        this.errorCount = this.errorFileList.size();
    }
}

