/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.initdb.XMLLoaderActionListener;
import jp.jasminesoft.jfc.job.ExportTask;
import jp.jasminesoft.jfc.job.TaskException;
import jp.jasminesoft.jfc.service.InitLoaderBaseService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImportTask
extends ExportTask {
    private static final Logger logger = LogManager.getLogger((String)ImportTask.class.getName());
    private String dir;
    private boolean needsDropTable;

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public boolean getDrop() {
        return this.needsDropTable;
    }

    public void setDrop(boolean needsDropTable) {
        this.needsDropTable = needsDropTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(ActionParameter p) {
        InitLoaderBaseService service = this.getInitLoaderBaseService(p);
        File exportDir = new File(service.getExportParentPath());
        if (exportDir == null || !exportDir.isDirectory()) {
            if (this.isDebug()) {
                logger.debug(this.getClass().getName() + " export directory is not found." + service.getExportParentPath());
            }
            throw new TaskException("Failed. No export directory is found. " + service.getExportParentPath());
        }
        File selectedDirectory = null;
        if (this.dir != null) {
            this.dir = exportDir.getPath() + File.separator + this.dir;
            File f = new File(this.dir);
            if (!f.exists()) {
                throw new TaskException("Failed. No directory is found. " + this.dir);
            }
            if (!f.isDirectory() && !this.dir.endsWith(".zip")) {
                throw new TaskException("Failed. " + this.dir + " is not directory.");
            }
            selectedDirectory = f;
        } else {
            String[] lists;
            for (String s : lists = exportDir.list()) {
                File autoImportMarker;
                File f = new File(exportDir.getPath() + File.separator + s);
                if (!f.getName().startsWith(service.getExportDirectoryPrefix()) || f.getName().equals("data_init") || f.getName().equals("data_build") || selectedDirectory != null && selectedDirectory.lastModified() >= f.lastModified() || (autoImportMarker = new File(f.getPath() + File.separator + ".autoimport")).exists()) continue;
                selectedDirectory = f;
            }
        }
        if (selectedDirectory == null) {
            throw new TaskException("Failed. No directory to import is available. skip.");
        }
        if (this.isDebug()) {
            logger.debug(this.getClass().getName() + " selected directory is " + selectedDirectory.getPath());
        }
        String[][] tableList = service.getTableList(p);
        Set<String> targetSet = this.getTargetTableSet(this.getTarget(), tableList, this.getExclude());
        targetSet.remove("juser");
        targetSet.remove("jprincipal");
        if (this.needsDropTable) {
            String[] args1 = new String[]{"drop", "-t", this.getTargetTableString(targetSet), "-c", service.getConfigPath()};
            XMLLoaderActionListener listener = service.createXMLLoaderActionListener(p);
            service.do_execute(args1, listener);
            String[] args2 = new String[]{"create", "-t", this.getTargetTableString(targetSet), "-c", service.getConfigPath()};
            service.do_execute(args2, listener);
        }
        String[] args = new String[]{"import", "-t", this.getTargetTableString(targetSet), "-c", service.getConfigPath(), "-d", selectedDirectory.getPath()};
        XMLLoaderActionListener listener = service.createXMLLoaderActionListener(p);
        service.do_execute(args, listener);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String importMark = sdf.format(new Date());
        try (PrintWriter out = null;){
            out = new PrintWriter(selectedDirectory.getPath() + File.separator + ".autoimport");
            out.println(importMark);
        }
        return "Import task is finished.";
    }
}

