/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.JFCAppMode;
import jp.jasminesoft.jfc.JFCAppModeManager;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.CacheManagerBaseMethodImpl_threadLocal;
import jp.jasminesoft.jfc.app.CacheManagerUtil;
import jp.jasminesoft.jfc.app.MailSendProcessBean;
import jp.jasminesoft.jfc.autoconfiguration.ClearThreadLocalScopeServletRequestListener;
import jp.jasminesoft.jfc.core.util.ThreadLocalUtils;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import jp.jasminesoft.jfc.model.mailmessage.Attachment;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.jfc.service.LogonService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.web.context.support.ServletContextResourceLoader;

public abstract class JFCBaseJobBean
extends QuartzJobBean {
    private static final Logger logger = LogManager.getLogger((String)JFCBaseJobBean.class.getName());
    protected static final String CR = System.getProperty("line.separator");
    public static final String JobNameKey = "__jfcjob_jobname";
    public static final String JobUsernameKey = "__jfcjob_username";
    public static final String JobPasswordKey = "__jfcjob_password";
    public static final String IgnoreSaveJfcjobstatus = "__jfcjob_ignoreSaveJfcjobstatus";
    public static final String IgnoreLeaveJfcjobstatus = "__jfcjob_ignoreLeaveJfcjobstatus";
    public static final String JobAppctxKey = "__jfcjob_appctx";
    public static final String JobScriptFileResloaderKey = "__jfcjob_script_fileresloader";
    public static final String LocaleKey = "locale";
    public static final String DataMapKey = "__jfcjob_dataMap";
    private boolean debug;
    private String username;
    protected static final String ATTACHMENT_FILES_DATAMAP_KEY = JFCBaseJobBean.class.getName() + "__ATTACHMENT_FILES_DATAMAP_KEY";

    protected boolean isDebug() {
        return this.debug;
    }

    protected boolean isUseDatabase() {
        return false;
    }

    public Permission getPermission() {
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean useMaintenanceMode() {
        return true;
    }

    public boolean isEnableStartInLimitBackgroundProcessStartMode() {
        return false;
    }

    protected boolean checkMaintenance(Map<String, Object> dataMap) {
        boolean ret = false;
        String is_maintenance_str = (String)dataMap.get("maintenance");
        if (is_maintenance_str != null) {
            ret = Boolean.parseBoolean(is_maintenance_str);
        }
        return ret;
    }

    protected MaintenanceModeOption getMaintenanceModeOption(Map<String, Object> dataMap) {
        String maintenanceOption = (String)dataMap.get("maintenanceOption");
        if (StringUtils.isNotBlank((CharSequence)maintenanceOption)) {
            if (maintenanceOption.equalsIgnoreCase("logout")) {
                return MaintenanceModeOption.ForceLogout;
            }
            if (maintenanceOption.equalsIgnoreCase("fail")) {
                return MaintenanceModeOption.Failure;
            }
        }
        return MaintenanceModeOption.None;
    }

    public String[] getLockModelIds() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public String[] getClearCacheModelIds() {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext ctx) throws JobExecutionException {
        JobDataMap dataMap = new JobDataMap((Map)ctx.getJobDetail().getJobDataMap());
        try {
            Object appctx = ctx.getScheduler().getContext().get((Object)JobAppctxKey);
            if (appctx == null) {
                logger.error("applicationContext is null, check set __jfcjob_appctx in scheduler bean applicationContextSchedulerContextKey property.");
            }
            dataMap.put(JobAppctxKey, appctx);
        }
        catch (SchedulerException e) {
            String msg = "Failed get applicationContext";
            logger.error("Failed get applicationContext", (Throwable)e);
            throw new JobExecutionException(msg);
        }
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put(JobExecutionContext.class.getName(), ctx);
        HashMap<String, Object> ctxMap = new HashMap<String, Object>();
        try {
            dataMap.put("exectype", IJfcjobstatus.Exectype.Schedule.toString());
            this.setJobScriptFileResloader((Map<String, Object>)dataMap);
            this.executeInternal(jobMap, (Map<String, Object>)dataMap, ctxMap);
        }
        finally {
            for (Map.Entry entry : ctxMap.entrySet()) {
                ctx.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void setJobScriptFileResloader(Map<String, Object> dataMap) {
        ApplicationContext appctx = (ApplicationContext)dataMap.get(JobAppctxKey);
        ServletContext context = (ServletContext)appctx.getBean(ServletContext.class);
        ServletContextResourceLoader resloader = new ServletContextResourceLoader(context);
        dataMap.put(JobScriptFileResloaderKey, resloader);
    }

    public void executeFromQueue(Map<String, Object> jobMap, Map<String, Object> dataMap, Map<String, Object> ctxMap) throws JobExecutionException {
        dataMap.put("exectype", IJfcjobstatus.Exectype.Queue.toString());
        this.setJobScriptFileResloader(dataMap);
        this.executeInternal(jobMap, dataMap, ctxMap);
    }

    public void executeInternal(Map<String, Object> jobMap, Map<String, Object> dataMap, Map<String, Object> ctxMap) throws JobExecutionException {
        logger.debug("start");
        ApplicationContext appctx = (ApplicationContext)dataMap.get(JobAppctxKey);
        JFCAppModeManager appmodeManager = (JFCAppModeManager)appctx.getBean(JFCAppModeManager.class);
        if (!this.isEnableStartInLimitBackgroundProcessStartMode() && appmodeManager.getMode() == JFCAppMode.LimitBackgroundProcessStart) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00928), LogCodeManager.getMessage(LogCode.JFC00928, new String[0]));
            throw new JobExecutionException();
        }
        JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)appctx.getBean(JfcjobstatusRegistryService.class);
        boolean ignoreSaveJfcjobstatus = service.getIgnoreSaveJfcjobstatus();
        this.username = (String)dataMap.get(JobUsernameKey);
        ActionParameter p = null;
        try {
            p = this.createActionParameter(appctx, dataMap);
        }
        catch (JobExecutionException e) {
            if (!ignoreSaveJfcjobstatus) {
                p = JFCUtils.createActionParameter(appctx);
                String errormsg = (String)dataMap.get("errormessage");
                ActionParameterContainer container = (ActionParameterContainer)p.appctx.getBean("ActionParameterContainer", ActionParameterContainer.class);
                container.set(p);
                service.saveEndJfcjobstatus(p, dataMap, IJfcjobstatus.Statustype.Aborted, errormsg);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("failed, occur Exception", (Throwable)e);
                e.printStackTrace();
            }
            throw e;
        }
        p.request.setAttribute(DataMapKey, dataMap);
        ActionParameterContainer container = (ActionParameterContainer)p.appctx.getBean("ActionParameterContainer", ActionParameterContainer.class);
        container.set(p);
        IJfcjobstatus jobstatus = null;
        try {
            if (!ignoreSaveJfcjobstatus) {
                jobstatus = service.saveProcessingJfcjobstatus(p, dataMap);
                p.request.setAttribute(IJfcjobstatus.class.getName(), (Object)jobstatus);
            }
            this._executeInternal(jobMap, dataMap, ctxMap, p);
            if (!ignoreSaveJfcjobstatus) {
                jobstatus = (IJfcjobstatus)p.request.getAttribute(IJfcjobstatus.class.getName());
                if (service.findByIdJfcjobstatus(p, jobstatus.getId()) == null) {
                    jobstatus = null;
                }
                if (jobstatus != null) {
                    boolean ignoreLeave = JFCBaseJobBean.getIgnoreLeaveJfcjobstatus(service, dataMap);
                    service.updateEndJfcjobstatus(p, jobstatus, IJfcjobstatus.Statustype.End, ignoreLeave);
                }
                p.request.setAttribute(IJfcjobstatus.class.getName(), null);
            }
            logger.debug("success");
        }
        catch (JobExecutionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("failed, occur Exception", (Throwable)e);
                e.printStackTrace();
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug("failed, occur Exception", e);
                e.printStackTrace();
            }
            throw e;
        }
        finally {
            if (!ignoreSaveJfcjobstatus && (jobstatus = (IJfcjobstatus)p.request.getAttribute(IJfcjobstatus.class.getName())) != null) {
                service.updateEndJfcjobstatus(p, jobstatus, IJfcjobstatus.Statustype.Aborted);
            }
            this.clearThreadLocal(p.appctx);
        }
    }

    protected void clearThreadLocal(ApplicationContext appctx) {
        CacheManagerBaseMethodImpl_threadLocal.removeCache();
        ThreadLocalUtils.clear();
        ClearThreadLocalScopeServletRequestListener.clear(appctx);
    }

    public static boolean getIgnoreLeaveJfcjobstatus(JfcjobstatusRegistryService service, Map<String, Object> dataMap) {
        Object ignoreLeaveObj;
        String exectype = (String)dataMap.get("exectype");
        boolean ignoreLeave = service.getDefaultIgnoreLeaveJfcjobstatus(exectype);
        if (logger.isDebugEnabled()) {
            logger.debug("exectype " + exectype);
            logger.debug("defaultIgnoreLeave " + ignoreLeave);
        }
        if ((ignoreLeaveObj = dataMap.get(IgnoreLeaveJfcjobstatus)) == null) {
            ignoreLeaveObj = dataMap.get(IgnoreSaveJfcjobstatus);
        }
        if (ignoreLeaveObj != null) {
            ignoreLeave = ignoreLeaveObj instanceof Boolean ? (Boolean)ignoreLeaveObj : (ignoreLeaveObj instanceof String ? Boolean.valueOf((String)ignoreLeaveObj) : true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ignoreLeave " + ignoreLeave);
        }
        return ignoreLeave;
    }

    protected void _executeInternal(Map<String, Object> jobMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        String _debug_str = (String)dataMap.get("debug");
        if (StringUtils.isNotBlank((CharSequence)_debug_str)) {
            this.debug = Boolean.parseBoolean(_debug_str);
        }
        Set<String> clearCacheModelIdSet = this.createClearCacheModelIdSet((String)dataMap.get("cache"));
        List<LockObject> lockObjectList = this.createLockObjectList((String)dataMap.get("lock"), p);
        this.checkPermission(dataMap, p);
        String ret = null;
        JFCAppModeManager appModeManager = (JFCAppModeManager)p.appctx.getBean(JFCAppModeManager.class);
        boolean isMaintenance = this.checkMaintenance(dataMap);
        try {
            boolean isJobEnable = true;
            if (this.useMaintenanceMode() && isMaintenance) {
                isJobEnable = this.processMaintenanceMode(dataMap, p, appModeManager);
            }
            if (isJobEnable) {
                ret = this.executeInternal0(jobMap, dataMap, ctxMap, p);
                ctxMap.put("jobComplete", new Boolean(true));
            }
        }
        catch (JobExecutionException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00911), LogCodeManager.getMessage(LogCode.JFC00911, p.user, StringUtils.defaultString((String)e.getMessage())), (Throwable)e);
            ret = this.setErrorMessage(dataMap, ret, e);
            throw e;
        }
        catch (Throwable e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00911), LogCodeManager.getMessage(LogCode.JFC00911, p.user, StringUtils.defaultString((String)e.getMessage())), e);
            ret = this.setErrorMessage(dataMap, ret, e);
            throw new JobExecutionException(e.getMessage());
        }
        finally {
            this.releaseLockObject(p, lockObjectList);
            this.clearCache(clearCacheModelIdSet, p);
            boolean status = this.do_sendmail(ret, dataMap, p);
            if (!status) {
                if (StringUtils.isBlank((CharSequence)ret)) {
                    logger.debug("No message is returned.");
                } else {
                    String message = ret.replace(IOUtils.LINE_SEPARATOR_WINDOWS, System.lineSeparator());
                    logger.info("(" + this.username + "@localhost)" + message);
                }
            }
            if (this.useMaintenanceMode() && isMaintenance) {
                appModeManager.setMode(JFCAppMode.Normal, this.getUsername());
                logger.log(LogCodeManager.getPriority(LogCode.JFC90014), LogCodeManager.getMessage(LogCode.JFC90014, p.user, new String[0]));
            }
            if (p.user != null) {
                p.user.logoff();
            }
        }
    }

    protected Set<String> createClearCacheModelIdSet(String input_id) {
        TreeSet<String> clearCacheModelIdSet = new TreeSet<String>();
        clearCacheModelIdSet.addAll(Arrays.asList(this.getClearCacheModelIds()));
        if (StringUtils.isNotBlank((CharSequence)input_id)) {
            String[] ids = StringUtils.split((String)input_id, (String)" ");
            clearCacheModelIdSet.addAll(Arrays.asList(ids));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("clear cache model:" + clearCacheModelIdSet);
        }
        return clearCacheModelIdSet;
    }

    protected ActionParameter createActionParameter(ApplicationContext appctx, Map<String, Object> dataMap) throws JobExecutionException {
        ActionParameter p = null;
        try {
            String locale = (String)dataMap.get(LocaleKey);
            if (StringUtils.isBlank((CharSequence)locale)) {
                locale = JFCUtils.getLocaleString();
            }
            User user = this.logon(appctx, dataMap, locale);
            p = JFCUtils.createActionParameter(user, appctx);
            p.locale = locale;
            ResourceLoader resloader = (ResourceLoader)dataMap.get(JobScriptFileResloaderKey);
            p.request.setAttribute("__jfc_script_fileresloader", (Object)resloader);
        }
        catch (JobExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("occur Exception", (Throwable)e);
            throw new JobExecutionException(e.getMessage());
        }
        return p;
    }

    protected User logon(ApplicationContext appctx, Map<String, Object> dataMap, String locale) throws JobExecutionException {
        if (!StringUtils.isNotBlank((CharSequence)this.username)) {
            return null;
        }
        Jfcerrors errors = new Jfcerrors();
        LogonService logonService = (LogonService)appctx.getBean("logonService", LogonService.class);
        JFCErrorManager errorManager = (JFCErrorManager)appctx.getBean(JFCErrorManager.class);
        logonService.setJFCErrorManager(errorManager);
        JfcConfig jfcConfig = (JfcConfig)appctx.getBean(JfcConfig.class);
        logonService.setJFCConfig(jfcConfig);
        LogonStatusManager lsman = (LogonStatusManager)appctx.getBean(LogonStatusManager.class);
        logonService.setLogonStatusManager(lsman);
        User user = logonService.logon(this.username, "", errors, locale, "JFCAppJob", null, false);
        if (errors.sizeJfcerror() > 0) {
            logger.error("Failed to log on by user " + this.username);
            StringBuilder sb = null;
            for (Jfcerror e : errors.getJfcerror()) {
                logger.error(e.getContent());
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append("\n");
                }
                sb.append(e.getContent());
            }
            dataMap.put("errormessage", sb.toString());
            throw new JobExecutionException(sb.toString());
        }
        if (user == null) {
            logger.error("Failed to log on by user " + this.username);
            throw new JobExecutionException("Failed to log on by user " + this.username);
        }
        user.setSaveLastAccessTimeAtLogoff(false);
        return user;
    }

    protected List<LockObject> createLockObjectList(String input_id, ActionParameter p) throws JobExecutionException {
        TreeSet<String> lockModelIdSet = new TreeSet<String>();
        lockModelIdSet.addAll(Arrays.asList(this.getLockModelIds()));
        if (StringUtils.isNotBlank((CharSequence)input_id)) {
            String[] ids = StringUtils.split((String)input_id, (String)" ");
            lockModelIdSet.addAll(Arrays.asList(ids));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("lock model:" + lockModelIdSet);
        }
        ArrayList<LockObject> lockObjectList = new ArrayList<LockObject>();
        if (lockModelIdSet.size() == 0) {
            return lockObjectList;
        }
        LockManager lman = LockManagerFactory.getLockManager(p);
        String sessionid = p.request.getSession().getId();
        for (String id : lockModelIdSet) {
            LockObject lo = lman.createLockObjectForAll(id, sessionid, p.user);
            LockObject _lo = null;
            _lo = lman.addLockObject(lo);
            if (_lo == null) {
                logger.debug(lo + " LockManager locks the object successfully.");
                lockObjectList.add(lo);
                continue;
            }
            if (_lo.equals(lo)) {
                logger.debug(lo + " LockManager has already locked the same key.");
                continue;
            }
            boolean isLockSuccess = false;
            String lockusername = _lo.getUsername();
            if (p.user != null && lockusername != null && lockusername.equals(p.user.getUsername())) {
                if (lman.releaseLockObject(_lo)) {
                    logger.debug(_lo + " is released the lock automatically.");
                }
                if ((_lo = lman.addLockObject(lo)) == null) {
                    logger.debug(lo + " LockManager locks the object successfully. (second challenge)");
                    isLockSuccess = true;
                    lockObjectList.add(lo);
                } else if (_lo.equals(lo)) {
                    logger.debug(lo + " LockManager has already locked the same key. (second challenge)");
                    isLockSuccess = true;
                }
            }
            if (isLockSuccess) continue;
            logger.log(LogCodeManager.getPriority(LogCode.JFC00069), LogCodeManager.getMessage(LogCode.JFC00069, p.user, lo.toString()));
            logger.debug("_lo (locked object) is " + _lo);
            if (p.user != null) {
                p.user.logoff();
            }
            throw new JobExecutionException("Lock Error.");
        }
        return lockObjectList;
    }

    protected void checkPermission(Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        Permission perm = null;
        String permname = (String)dataMap.get("permname");
        String permactions = (String)dataMap.get("permaction");
        perm = StringUtils.isNotBlank((CharSequence)permname) && StringUtils.isNotBlank((CharSequence)permactions) ? new JFCAppPermission(permname, permactions) : this.getPermission();
        CheckPermission checkp = CheckPermissionFactory.getCheckPermission();
        if (perm != null && !checkp.process(p.user, perm)) {
            if (p.user != null) {
                p.user.logoff();
            }
            throw new JobExecutionException("Insufficient privileges");
        }
    }

    protected boolean processMaintenanceMode(Map<String, Object> dataMap, ActionParameter p, JFCAppModeManager appModeManager) throws JobExecutionException {
        boolean isJobEnable = this.checkMaintenanceModeOption(dataMap, p, appModeManager);
        if (this.useMaintenanceMode()) {
            JFCAppMode mode = JFCAppMode.Maintenance;
            appModeManager.setMode(mode, this.getUsername());
            logger.log(LogCodeManager.getPriority(LogCode.JFC90013), LogCodeManager.getMessage(LogCode.JFC90013, p.user, mode.toString()));
        }
        return isJobEnable;
    }

    protected boolean checkMaintenanceModeOption(Map<String, Object> dataMap, ActionParameter p, JFCAppModeManager appModeManager) throws JobExecutionException {
        boolean isJobEnable = true;
        MaintenanceModeOption option = this.getMaintenanceModeOption(dataMap);
        if (option == MaintenanceModeOption.Failure) {
            int count = appModeManager.checkLogon(this.getUsername());
            if (count > 0) {
                isJobEnable = false;
            }
        } else if (option == MaintenanceModeOption.ForceLogout) {
            try {
                StringBuilder sb = new StringBuilder();
                appModeManager.logoffAll(this.getUsername(), sb);
            }
            catch (IllegalStateException e) {
                throw new JobExecutionException("Failed to logout users, " + e.getMessage(), (Throwable)e);
            }
        }
        return isJobEnable;
    }

    protected String setErrorMessage(Map<String, Object> dataMap, String ret, Throwable e) {
        String setErrorMessage = (String)dataMap.get("mail:setErrorMessage");
        boolean isSetErrorMessage = true;
        if (StringUtils.isNotBlank((CharSequence)setErrorMessage) && !Boolean.valueOf(setErrorMessage).booleanValue()) {
            isSetErrorMessage = false;
        }
        if (isSetErrorMessage) {
            ret = e.getMessage();
        }
        return ret;
    }

    protected void releaseLockObject(ActionParameter p, List<LockObject> lockObjectList) {
        if (lockObjectList.size() == 0) {
            return;
        }
        LockManager lman = LockManagerFactory.getLockManager(p);
        for (LockObject lo : lockObjectList) {
            if (lman.releaseLockObject(lo)) {
                logger.debug(lo + " success to release lock.");
                continue;
            }
            logger.debug(lo + " failed to release lock.");
        }
    }

    protected void clearCache(Set<String> clearCacheModelIdSet, ActionParameter p) {
        if (clearCacheModelIdSet.size() == 0) {
            return;
        }
        String[] ids = clearCacheModelIdSet.toArray(new String[clearCacheModelIdSet.size()]);
        CacheManagerUtil.clear(ids, p);
    }

    protected boolean isSendmail(String message, Map<String, Object> dataMap, ActionParameter p) {
        String doNotSendEmptyMessage_ = (String)dataMap.get("mail:doNotSendEmptyMessage");
        if (doNotSendEmptyMessage_ != null && new Boolean(doNotSendEmptyMessage_).booleanValue() && StringUtils.isBlank((CharSequence)message)) {
            return false;
        }
        String doNotSendKeyword = (String)dataMap.get("mail:doNotSendKeyword");
        String doNotSendKeywordRegexp = (String)dataMap.get("mail:doNotSendKeywordRegexp");
        boolean useDoNotSendKeyword = false;
        boolean containDoNotSendKeyword = false;
        if (StringUtils.isNotBlank((CharSequence)doNotSendKeyword) || StringUtils.isNotBlank((CharSequence)doNotSendKeywordRegexp)) {
            useDoNotSendKeyword = true;
            try {
                containDoNotSendKeyword = this.checkKeyword(message, doNotSendKeyword, doNotSendKeywordRegexp);
            }
            catch (PatternSyntaxException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00927), LogCodeManager.getMessage(LogCode.JFC00927, p.user, "mail:doNotSendKeywordRegexp", doNotSendKeywordRegexp, e.getMessage()));
                return false;
            }
        }
        String doSendKeyword = (String)dataMap.get("mail:doSendKeyword");
        String doSendKeywordRegexp = (String)dataMap.get("mail:doSendKeywordRegexp");
        boolean useDoSendKeyword = false;
        boolean containDoSendKeyword = false;
        if (StringUtils.isNotBlank((CharSequence)doSendKeyword) || StringUtils.isNotBlank((CharSequence)doSendKeywordRegexp)) {
            useDoSendKeyword = true;
            try {
                containDoSendKeyword = this.checkKeyword(message, doSendKeyword, doSendKeywordRegexp);
            }
            catch (PatternSyntaxException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00927), LogCodeManager.getMessage(LogCode.JFC00927, p.user, "mail:doSendKeywordRegexp", doSendKeywordRegexp, e.getMessage()));
                return false;
            }
        }
        return !useDoNotSendKeyword && !useDoSendKeyword || !(!useDoNotSendKeyword && useDoSendKeyword ? !containDoSendKeyword : (useDoNotSendKeyword && !useDoSendKeyword ? containDoNotSendKeyword : !containDoSendKeyword && containDoNotSendKeyword));
    }

    private boolean checkKeyword(String message, String keyword, String keywordRegexp) {
        Pattern pat;
        if (StringUtils.isNotBlank((CharSequence)keyword) && message.indexOf(keyword) >= 0) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)keywordRegexp) && (pat = Pattern.compile(keywordRegexp)).matcher(message).find();
    }

    private boolean do_sendmail(String message, Map<String, Object> dataMap, ActionParameter p) {
        String contenttype_body;
        if (!this.isSendmail(message, dataMap, p)) {
            return false;
        }
        String to_ = (String)dataMap.get("mail:to");
        if (StringUtils.isBlank((CharSequence)to_)) {
            return false;
        }
        String mailhost_ = (String)dataMap.get("mail:host");
        String protocol_ = (String)dataMap.get("mail:protocol");
        String auth_ = (String)dataMap.get("mail:auth");
        String auth_user_ = (String)dataMap.get("mail:auth_user");
        String auth_password_ = (String)dataMap.get("mail:auth_password");
        String popauth_mailhost_ = (String)dataMap.get("mail:popauth_mailhost");
        String popauth_protocol_ = (String)dataMap.get("mail:popauth_protocol");
        String popauth_useapop_str_ = (String)dataMap.get("mail:popauth_useapop");
        Boolean popauth_useapop_ = null;
        if (popauth_useapop_str_ != null && new Boolean(popauth_useapop_str_).booleanValue()) {
            popauth_useapop_ = Boolean.TRUE;
        }
        String popauth_user_ = (String)dataMap.get("mail:popauth_user");
        String popauth_password_ = (String)dataMap.get("mail:popauth_password");
        String from_ = (String)dataMap.get("mail:from");
        if (StringUtils.isBlank((CharSequence)from_)) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC90013), LogCodeManager.getMessage(LogCode.JFC90013, p.user, to_));
            return false;
        }
        String subject_ = (String)dataMap.get("mail:subject");
        if (StringUtils.isBlank((CharSequence)subject_)) {
            subject_ = "Message from Wagby Job Manager";
        }
        String cc_ = (String)dataMap.get("mail:cc");
        String bcc_ = (String)dataMap.get("mail:bcc");
        List atta = (List)dataMap.get(ATTACHMENT_FILES_DATAMAP_KEY);
        Attachment[] attachments = null;
        if (atta != null && atta.size() > 0) {
            attachments = atta.toArray(new Attachment[atta.size()]);
        }
        if ((contenttype_body = (String)dataMap.get("mail:contenttype_body")) == null) {
            contenttype_body = "text/plain";
        }
        MailSendProcessBean mbean = (MailSendProcessBean)p.appctx.getBean(MailSendProcessBean.class);
        mbean.setActionParameter(p);
        if (StringUtils.isNotBlank((CharSequence)mailhost_)) {
            mbean.setParameter("mailhost", mailhost_);
        }
        if (StringUtils.isNotBlank((CharSequence)protocol_)) {
            mbean.setParameter("protocol", protocol_);
        }
        if (StringUtils.isNotBlank((CharSequence)auth_)) {
            mbean.setParameter("auth", Boolean.valueOf(auth_));
        }
        if (StringUtils.isNotBlank((CharSequence)auth_user_)) {
            mbean.setParameter("auth_user", auth_user_);
        }
        if (StringUtils.isNotBlank((CharSequence)auth_password_)) {
            mbean.setParameter("auth_password", auth_password_);
        }
        if (StringUtils.isNotBlank((CharSequence)popauth_mailhost_)) {
            mbean.setParameter("popauth_mailhost", popauth_mailhost_);
            mbean.setParameter("popauth_protocol", popauth_protocol_);
            mbean.setParameter("popauth_useapop", popauth_useapop_);
            mbean.setParameter("popauth_user", popauth_user_);
            mbean.setParameter("popauth_password", popauth_password_);
        }
        mbean.setParameter("from", from_);
        mbean.setParameter("to", to_);
        mbean.setParameter("subject", subject_);
        mbean.setParameter("body", message);
        mbean.setParameter("contenttype_body", contenttype_body);
        if (StringUtils.isNotBlank((CharSequence)cc_)) {
            mbean.setParameter("cc", cc_);
        }
        if (StringUtils.isNotBlank((CharSequence)bcc_)) {
            mbean.setParameter("bcc", bcc_);
        }
        if (attachments != null) {
            mbean.setParameter("attachment", attachments);
        }
        try {
            Object o = mbean.process();
            if (o != null && o instanceof String) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00914), LogCodeManager.getMessage(LogCode.JFC00914, p.user, to_, (String)o));
                return false;
            }
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00915), LogCodeManager.getMessage(LogCode.JFC00915, p.user, to_, e.getMessage()));
            logger.debug("", (Throwable)e);
            return false;
        }
        return true;
    }

    protected String getLogHeader() {
        return "(" + this.username + "@localhost)";
    }

    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        JobExecutionContext ctx = (JobExecutionContext)jobparamMap.get(JobExecutionContext.class.getName());
        return this.executeInternal0(ctx, p);
    }

    protected String executeInternal0(JobExecutionContext ctx, ActionParameter p) throws JobExecutionException {
        throw new IllegalStateException("Not implemented executeInternal0 method");
    }

    public Boolean getBoolean(Object s) {
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return new Boolean((String)s);
    }

    public Integer getIntValue(Object s) {
        if (s instanceof Integer) {
            return (Integer)s;
        }
        return new Integer((String)s);
    }

    protected static enum MaintenanceModeOption {
        None,
        ForceLogout,
        Failure;

    }
}

