/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.JFCAppMode;
import jp.jasminesoft.jfc.JFCAppModeManager;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCQuartzJobManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class JfcjobstatusRegistryService {
    private static final Logger logger = LogManager.getLogger((String)JfcjobstatusRegistryService.class.getName());
    public static final String FilenameFooter = "Jshfilename";
    private static final String SkipupdatetimeKey = "__jfc_control.skipUpdatetime";
    public static final String ErrorMessageKey = "errormessage";
    @Autowired
    private ApplicationContext appctx;
    @Autowired
    JFCAppModeManager appmodeManager;
    @Autowired
    JFCErrorManager errorManager;
    @Autowired
    JFCQuartzJobManager jobManager;
    @Autowired
    @Qualifier(value="DownloadFileObjectFactory")
    private DownloadFileObjectFactory dfofactory;
    @Value(value="${wagby.JfcjobstatusRegistryService.leaveJfcjobstatus.thread:false}")
    public boolean leaveJfcjobstatusThread = false;
    @Value(value="${wagby.JfcjobstatusRegistryService.leaveJfcjobstatus.schedule:false}")
    public boolean leaveJfcjobstatusSchedule = false;
    @Value(value="${wagby.JfcjobstatusRegistryService.jobstatusCountInterval:10000}")
    public long jobstatusCountInterval = 10000L;

    public long getJobstatusCountInterval() {
        return this.jobstatusCountInterval;
    }

    public void setJobstatusCountInterval(long jobstatusCountInterval) {
        this.jobstatusCountInterval = jobstatusCountInterval;
    }

    public boolean isEnableSendMessage(String exchange, String destinationName, String jobname, Map<String, Object> jobparamMap, ActionParameter p) {
        if (this.appmodeManager.getMode() == JFCAppMode.LimitBackgroundProcessStart) {
            try {
                JFCBaseJobBean jobbean = this.jobManager.getJobBean(p, jobname);
                if (jobbean != null && jobbean.isEnableStartInLimitBackgroundProcessStartMode()) {
                    return true;
                }
            }
            catch (InstantiationException e) {
                logger.error("error instantiation", (Throwable)e);
                throw new RuntimeException();
            }
            catch (IllegalAccessException e) {
                logger.error("error illegal access", (Throwable)e);
                throw new RuntimeException();
            }
            Object[] ep = new Object[]{p.user.getUsername()};
            p.errors.addJfcerror(this.errorManager.getJfcerror("error.JfcjobstatusRegistryService.limitBackgroundProcessStart", ep, p.locale));
            throw new RuntimeException();
        }
        return true;
    }

    public boolean isEnableSendMessage(ActionParameter p) {
        if (this.appmodeManager.getMode() == JFCAppMode.LimitBackgroundProcessStart) {
            Object[] ep = new Object[]{p.user.getUsername()};
            p.errors.addJfcerror(this.errorManager.getJfcerror("error.JfcjobstatusRegistryService.limitBackgroundProcessStart", ep, p.locale));
            throw new RuntimeException();
        }
        return true;
    }

    public void sendJobMessage(String exchange, String routingKey, String jobname, Map<String, Object> jobparamMap, ActionParameter p) {
        logger.debug("start");
        throw new IllegalStateException();
    }

    protected Map<String, Object> createParamMap(String jobname, Map<String, Object> jobparamMap, ActionParameter p, String username) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("__jfcjob_jobname", jobname);
        paramMap.put("__jfcjob_username", username);
        paramMap.put("__jfcjob_jobparam", jobparamMap);
        paramMap.put("locale", p.locale);
        return paramMap;
    }

    public IJfcjobstatus getJfcjobstatus(ActionParameter p, Map<String, Object> paramMap) {
        IJfcjobstatus jobstatus = (IJfcjobstatus)paramMap.get(IJfcjobstatus.class.getName());
        if (jobstatus != null) {
            return jobstatus;
        }
        Integer jobstatusid = (Integer)paramMap.get(IJfcjobstatus.class.getName() + "_id");
        if (jobstatusid != null) {
            jobstatus = this.findByIdJfcjobstatus(p, jobstatusid);
            paramMap.put(IJfcjobstatus.class.getName(), jobstatus);
            return jobstatus;
        }
        return null;
    }

    public IJfcjobstatus saveProcessingJfcjobstatus(ActionParameter p, Map<String, Object> paramMap) {
        IJfcjobstatus jobstatus;
        if (logger.isDebugEnabled()) {
            logger.debug("paramMap = " + paramMap);
        }
        if ((jobstatus = this.getJfcjobstatus(p, paramMap)) != null) {
            this.updateProcessingJfcjobstatus(p, jobstatus);
            return jobstatus;
        }
        jobstatus = this.createJfcjobstatus(p, paramMap);
        this.setProcessingJfcjobstatus(jobstatus);
        this.insertJfcjobstatus(p, jobstatus);
        paramMap.put(IJfcjobstatus.class.getName(), jobstatus);
        return jobstatus;
    }

    public void updateProcessingJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus) {
        this.setProcessingJfcjobstatus(jobstatus);
        this.updateJfcjobstatus(p, jobstatus);
    }

    public IJfcjobstatus createJfcjobstatus(ActionParameter p, Map<String, Object> paramMap) {
        EntityHelper jfcjobstatusEntityHelper = (EntityHelper)p.appctx.getBean("JfcjobstatusHelper", EntityHelper.class);
        IJfcjobstatus jobstatus = (IJfcjobstatus)((Object)jfcjobstatusEntityHelper.initialize(p));
        jobstatus.setExectype((String)paramMap.get("exectype"));
        jobstatus.setJobname((String)paramMap.get("__jfcjob_jobname"));
        jobstatus.setUsername((String)paramMap.get("__jfcjob_username"));
        return jobstatus;
    }

    public void setProcessingJfcjobstatus(IJfcjobstatus jobstatus) {
        jobstatus.setStatustype(IJfcjobstatus.Statustype.Processing.toString());
        jobstatus.setProgress(0L);
        jobstatus.setMaximum(1L);
        jobstatus.setStartdatetime(ExcelFunction.NOW());
    }

    public IJfcjobstatus saveEndJfcjobstatus(ActionParameter p, Map<String, Object> paramMap, IJfcjobstatus.Statustype statustype, String errormessage) {
        IJfcjobstatus jobstatus;
        if (logger.isDebugEnabled()) {
            logger.debug("paramMap = " + paramMap);
        }
        if ((jobstatus = this.getJfcjobstatus(p, paramMap)) != null) {
            this.updateEndJfcjobstatus(p, jobstatus, statustype, errormessage);
            return jobstatus;
        }
        jobstatus = this.createJfcjobstatus(p, paramMap);
        this.setEndJfcjobstatus(jobstatus, statustype, errormessage);
        this.insertJfcjobstatus(p, jobstatus);
        paramMap.put(IJfcjobstatus.class.getName(), jobstatus);
        return jobstatus;
    }

    public IJfcjobstatus updateEndJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus, IJfcjobstatus.Statustype statustype) {
        return this.updateEndJfcjobstatus(p, jobstatus, statustype, null, false);
    }

    public IJfcjobstatus updateEndJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus, IJfcjobstatus.Statustype statustype, boolean ignoreLeave) {
        return this.updateEndJfcjobstatus(p, jobstatus, statustype, null, ignoreLeave);
    }

    public IJfcjobstatus updateEndJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus, IJfcjobstatus.Statustype statustype, String errormessage) {
        return this.updateEndJfcjobstatus(p, jobstatus, statustype, errormessage, false);
    }

    public IJfcjobstatus updateEndJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus, IJfcjobstatus.Statustype statustype, String errormessage, boolean ignoreLeave) {
        if (ignoreLeave) {
            this.deleteJfcjobstatus(p, jobstatus);
            return jobstatus;
        }
        this.setEndJfcjobstatus(jobstatus, statustype, errormessage);
        this.updateJfcjobstatus(p, jobstatus);
        return jobstatus;
    }

    public IJfcjobstatus setEndJfcjobstatus(IJfcjobstatus jobstatus, IJfcjobstatus.Statustype statustype, String errormessage) {
        IJfcjobstatus.Statustype nowstatustype;
        String nowstatustypes = jobstatus.getStatustype();
        IJfcjobstatus.Statustype statustype2 = nowstatustype = nowstatustypes != null ? IJfcjobstatus.Statustype.valueOf(nowstatustypes) : null;
        if (nowstatustype != null && nowstatustype != IJfcjobstatus.Statustype.End && nowstatustype != IJfcjobstatus.Statustype.Aborted) {
            jobstatus.setStatustype(statustype.toString());
            if (statustype == IJfcjobstatus.Statustype.End) {
                jobstatus.setProgress(jobstatus.getMaximum());
            }
        }
        if (errormessage != null) {
            String nowerrmsg = this.getInfo(jobstatus, ErrorMessageKey);
            nowerrmsg = nowerrmsg == null ? errormessage : nowerrmsg + "\n" + errormessage;
            this.addInfo(jobstatus, ErrorMessageKey, errormessage);
        }
        return jobstatus;
    }

    protected void deleteJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus) {
        JFCEntityService jfcjobstatusEntityService = (JFCEntityService)p.appctx.getBean("JfcjobstatusEntityService", JFCEntityService.class);
        jfcjobstatusEntityService.delete(jobstatus.getId(), true);
    }

    public IJfcjobstatus findByIdJfcjobstatus(ActionParameter p, Integer id) {
        JFCEntityService jfcjobstatusEntityService = (JFCEntityService)p.appctx.getBean("JfcjobstatusEntityService", JFCEntityService.class);
        return (IJfcjobstatus)jfcjobstatusEntityService.findById(id);
    }

    public void insertJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus) {
        this.insertJfcjobstatusInDb(p, jobstatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertJfcjobstatusInDb(ActionParameter p, IJfcjobstatus jobstatus) {
        JFCEntityService jfcjobstatusEntityService = (JFCEntityService)p.appctx.getBean("JfcjobstatusEntityService", JFCEntityService.class);
        Map<String, Object> volatilityValue = JFCUtils.getVolatilityValueToRequestObject(p.request);
        JFCUtils.resetVolatilityValueToRequestObject(p.request);
        boolean containsSkipupdatetime = p.pageMap.containsKey(SkipupdatetimeKey);
        Object skipUpdatetime = p.pageMap.remove(SkipupdatetimeKey);
        try {
            jfcjobstatusEntityService.insert((ContainerBase)((Object)jobstatus));
        }
        finally {
            JFCUtils.setVolatilityValueToRequestObject(p.request, volatilityValue);
            if (containsSkipupdatetime) {
                p.pageMap.put(SkipupdatetimeKey, skipUpdatetime);
            }
        }
    }

    public void updateJfcjobstatus(ActionParameter p, IJfcjobstatus jobstatus) {
        this.updateJfcjobstatusInDb(p, jobstatus);
    }

    public void updateJfcjobstatusInterval(ActionParameter p, IJfcjobstatus jobstatus) {
        if (jobstatus.getStatustype() != IJfcjobstatus.Statustype.Processing.toString()) {
            this.updateJfcjobstatusInDb(p, jobstatus);
        } else {
            Timestamp updatedt = jobstatus.getUpdatedatetime();
            if (updatedt == null) {
                this.updateJfcjobstatusInDb(p, jobstatus);
            } else if (updatedt.getTime() + this.jobstatusCountInterval < System.currentTimeMillis()) {
                this.updateJfcjobstatusInDb(p, jobstatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJfcjobstatusInDb(ActionParameter p, IJfcjobstatus jobstatus) {
        JFCEntityService jfcjobstatusEntityService = (JFCEntityService)p.appctx.getBean("JfcjobstatusEntityService", JFCEntityService.class);
        Map<String, Object> volatilityValue = JFCUtils.getVolatilityValueToRequestObject(p.request);
        JFCUtils.resetVolatilityValueToRequestObject(p.request);
        boolean containsSkipupdatetime = p.pageMap.containsKey(SkipupdatetimeKey);
        Object skipUpdatetime = p.pageMap.remove(SkipupdatetimeKey);
        try {
            jfcjobstatusEntityService.update((ContainerBase)((Object)jobstatus), false);
        }
        finally {
            JFCUtils.setVolatilityValueToRequestObject(p.request, volatilityValue);
            if (containsSkipupdatetime) {
                p.pageMap.put(SkipupdatetimeKey, skipUpdatetime);
            }
        }
    }

    public Map<String, String> getInfos(IJfcjobstatus jobstatus) {
        Object[] infos = this.getInfoObjects(jobstatus);
        if (infos == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (Object info : infos) {
                Method InfoGetKeyMethod = info.getClass().getMethod("getKey", new Class[0]);
                String key = (String)InfoGetKeyMethod.invoke(info, new Object[0]);
                Method InfoGetValueMethod = info.getClass().getMethod("getValue", new Class[0]);
                String value = (String)InfoGetValueMethod.invoke(info, new Object[0]);
                map.put(key, value);
            }
            return map;
        }
        catch (NoSuchMethodException e) {
            logger.error("occur Exception", (Throwable)e);
            return null;
        }
        catch (SecurityException e) {
            logger.error("occur Exception", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error("occur Exception", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.error("occur Exception", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error("occur Exception", (Throwable)e);
            return null;
        }
    }

    public Object[] getInfoObjects(IJfcjobstatus jobstatus) {
        Object[] infos = null;
        try {
            Method GetInfoMethod = jobstatus.getClass().getMethod("getInfo", new Class[0]);
            infos = (Object[])GetInfoMethod.invoke((Object)jobstatus, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error("occur Exception", (Throwable)e);
            return infos;
        }
        catch (SecurityException e) {
            logger.error("occur Exception", (Throwable)e);
            return infos;
        }
        catch (IllegalAccessException e) {
            logger.error("occur Exception", (Throwable)e);
            return infos;
        }
        catch (IllegalArgumentException e) {
            logger.error("occur Exception", (Throwable)e);
            return infos;
        }
        catch (InvocationTargetException e) {
            logger.error("occur Exception", (Throwable)e);
            return infos;
        }
        return infos;
    }

    public String getInfo(IJfcjobstatus jobstatus, String key) {
        Object info = this.getInfoObject(jobstatus, key);
        if (info == null) {
            return null;
        }
        String value = null;
        try {
            Method InfoGetValueMethod = info.getClass().getMethod("getValue", new Class[0]);
            value = (String)InfoGetValueMethod.invoke(info, new Object[0]);
            return value;
        }
        catch (NoSuchMethodException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (SecurityException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (IllegalAccessException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (IllegalArgumentException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (InvocationTargetException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
    }

    public Object getInfoObject(IJfcjobstatus jobstatus, String key) {
        Object value = null;
        try {
            Object[] infos = this.getInfoObjects(jobstatus);
            if (infos == null || infos.length == 0) {
                return value;
            }
            Method InfoGetKeyMethod = infos[0].getClass().getMethod("getKey", new Class[0]);
            for (Object info : infos) {
                String ikey = (String)InfoGetKeyMethod.invoke(info, new Object[0]);
                if (ikey == null || !ikey.equals(key)) continue;
                return info;
            }
        }
        catch (NoSuchMethodException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (SecurityException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (IllegalAccessException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (IllegalArgumentException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        catch (InvocationTargetException e) {
            logger.error("occur Exception", (Throwable)e);
            return value;
        }
        return value;
    }

    public void addInfo(IJfcjobstatus jobstatus, String key, String value) {
        try {
            Object info = this.getInfoObject(jobstatus, key);
            if (info != null) {
                Class<?> infoClass = info.getClass();
                Method InfoSetValueMethod = infoClass.getMethod("setValue", String.class);
                InfoSetValueMethod.invoke(info, value);
                return;
            }
            Class<?> jobstatusClass = jobstatus.getClass();
            Class<?> infoClass = this.getInfoClass(jobstatusClass);
            info = this.createInfoObject(key, value, infoClass);
            Method AddInfoMethod = jobstatusClass.getMethod("addInfo", infoClass);
            AddInfoMethod.invoke((Object)jobstatus, info);
        }
        catch (NoSuchMethodException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (SecurityException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (IllegalArgumentException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (InvocationTargetException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (InstantiationException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
    }

    public void addInfoFilename(IJfcjobstatus jobstatus, String key, String fname, File filepath) {
        this.addInfo(jobstatus, key + FilenameFooter, filepath.toString());
        this.addInfo(jobstatus, key, fname);
    }

    protected Class<?> getInfoClass(Class<?> jobstatusClass) throws NoSuchMethodException {
        Method GetInfoMethod = jobstatusClass.getMethod("getInfo", Integer.TYPE);
        Class<?> infoClass = GetInfoMethod.getReturnType();
        return infoClass;
    }

    protected Object createInfoObject(String key, String value, Class<?> infoClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object info = infoClass.newInstance();
        Method InfoSetKeyMethod = infoClass.getMethod("setKey", String.class);
        Method InfoSetValueMethod = infoClass.getMethod("setValue", String.class);
        InfoSetKeyMethod.invoke(info, key);
        InfoSetValueMethod.invoke(info, value);
        return info;
    }

    public void setInfos(IJfcjobstatus jobstatus, Map<String, String> infos) {
        try {
            Class<?> jobstatusClass = jobstatus.getClass();
            Class<?> infoClass = this.getInfoClass(jobstatusClass);
            ArrayList<Object> infoobjs = new ArrayList<Object>();
            for (Map.Entry<String, String> entry : infos.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                infoobjs.add(this.createInfoObject(key, value, infoClass));
            }
            Object[] infoobjary = Array.newInstance(infoClass, infoobjs.size());
            infoobjary = infoobjs.toArray((Object[])infoobjary);
            Method setInfoMethod = jobstatusClass.getMethod("setInfo", infoobjary.getClass());
            setInfoMethod.invoke((Object)jobstatus, new Object[]{infoobjary});
        }
        catch (NoSuchMethodException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (SecurityException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (IllegalArgumentException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (InvocationTargetException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
        catch (InstantiationException e) {
            logger.error("occur Exception", (Throwable)e);
            return;
        }
    }

    public void copy(IJfcjobstatus src, IJfcjobstatus dst) {
        src.setId(dst.getId());
        src.setJobname(dst.getJobname());
        src.setUsername(dst.getUsername());
        src.setStatustype(dst.getStatustype());
        src.setExectype(dst.getExectype());
        src.setInsertdatetime(dst.getInsertdatetime());
        src.setUpdatedatetime(dst.getUpdatedatetime());
        src.setStartdatetime(dst.getStartdatetime());
        src.setProgress(dst.getProgressAsLong());
        src.setMaximum(dst.getMaximumAsLong());
        this.setInfos(dst, this.getInfos(src));
    }

    public Map<String, String> convertPresentationInfo(String urlbase, IJfcjobstatus jobstatus, Map<String, Object> item, HttpServletRequest request) {
        Object[] oa;
        Map<String, String> infos = this.getInfos(jobstatus);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("progress", Long.toString(jobstatus.getProgress()));
        data.put("maximum", Long.toString(jobstatus.getMaximum()));
        for (Map.Entry<String, String> entry : infos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.endsWith(FilenameFooter)) continue;
            String filepath = infos.get(key + FilenameFooter);
            if (filepath != null) {
                try (DownloadFileObject st = this.dfofactory.create(filepath, request);){
                    if (st != null && st.canRead()) {
                        String url = urlbase + key;
                        data.put(key + FilenameFooter, url);
                    }
                }
            }
            data.put(key, value);
        }
        String statustype = "";
        if (item.get("statustype") instanceof Object[] && (oa = (Object[])item.get("statustype")) != null && oa.length > 0 && oa[0] instanceof String) {
            statustype = (String)oa[0];
        }
        if (infos.get(ErrorMessageKey) != null) {
            String key = "__jfc_common.JfcjobstatusRegistryService.errormessage_in_statustype";
            ActionParameterContainer pc = (ActionParameterContainer)this.appctx.getBean(ActionParameterContainer.class);
            String errormessage = JFCUtils.Message(pc.get(), "__jfc_common.JfcjobstatusRegistryService.errormessage_in_statustype");
            String s = statustype + errormessage;
            data.put("statustype_with_error", s);
        } else {
            data.put("statustype_with_error", statustype);
        }
        return data;
    }

    public void download(IJfcjobstatus jobstatus, String itemname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fname = this.getInfo(jobstatus, itemname);
        String filepath = this.getInfo(jobstatus, itemname + FilenameFooter);
        if (fname == null || filepath == null) {
            throw new IllegalStateException();
        }
        logger.debug("Start download " + fname);
        try (DownloadFileObject st = this.dfofactory.create(filepath, request);){
            this.download2(request, response, fname, filepath, st);
        }
        logger.debug("Finished download " + fname);
    }

    protected void download2(HttpServletRequest request, HttpServletResponse response, String fname, String filepath, DownloadFileObject st) throws IOException {
        if (st == null) {
            logger.info("target file is null. filepath:" + filepath);
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        if (!st.canRead()) {
            logger.info("target file " + st.getDescription() + " can not read. filepath:" + filepath);
            this.sendRedirectFileNotFound(request, response);
            return;
        }
        response.setHeader("Expires", this.getHTTPDate());
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, private");
        URL redirecturl = st.getRedirectUrl();
        if (redirecturl != null) {
            logger.debug("redirect download " + fname);
            response.sendRedirect(redirecturl.toString());
            return;
        }
        response.setContentLengthLong(st.length());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)fname, (HttpServletRequest)request, (String)"inline"));
        try (BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            st.write(output);
        }
        catch (IOException e) {
            logger.error("Failed download " + fname, (Throwable)e);
            throw e;
        }
    }

    protected void sendRedirectFileNotFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.encodeUrl(request, "fileNotFound.jsp"));
    }

    protected String encodeUrl(HttpServletRequest request, String url) {
        return url;
    }

    private String getHTTPDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter.format(new Date());
    }

    public boolean getIgnoreSaveJfcjobstatus() {
        return false;
    }

    public boolean getDefaultIgnoreLeaveJfcjobstatus(String exectype) {
        if (exectype == null) {
            return false;
        }
        if (exectype.equals(IJfcjobstatus.Exectype.Schedule.toString())) {
            return !this.leaveJfcjobstatusSchedule;
        }
        if (exectype.equals(IJfcjobstatus.Exectype.Thread.toString())) {
            return !this.leaveJfcjobstatusThread;
        }
        return false;
    }
}

