/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.jasminesoft.util.StringConvKigouH2ZFilter;
import jp.jasminesoft.util.StringConvKigouZ2HFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailBodyParser {
    private static String CRLF = "\r\n";
    private boolean debug = false;
    private static final Logger logger = LogManager.getLogger((String)MailBodyParser.class.getName());
    private HeaderValuePair[] contents;
    private char dataStartChar;
    private char dataEndChar;
    private Map<String, Set<String>> firstCharacterOfHeaderMap;
    private boolean zenkakuHankakuEqualFlag;

    public void setDataStartChar(char dataStartChar) {
        this.dataStartChar = dataStartChar;
    }

    public void setDataEndChar(char dataEndChar) {
        this.dataEndChar = dataEndChar;
    }

    public void setZenkakuHankakuEqual(boolean b) {
        this.zenkakuHankakuEqualFlag = b;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public MailBodyParser(String[] labels, String[][] init) {
        if (this.debug) {
            for (String label : labels) {
                logger.info("label:" + label);
            }
            if (init != null && init.length > 0) {
                for (int i = 0; i < init.length; ++i) {
                    logger.info("init[" + i + "]:" + init[i][0] + "=" + init[i][1]);
                }
            }
        }
        TreeMap<Integer, HashSet<String>> labelMap = new TreeMap<Integer, HashSet<String>>();
        for (String label : labels) {
            Integer key = label.length() * -1;
            HashSet<String> set = (HashSet<String>)labelMap.get(key);
            if (set == null) {
                set = new HashSet<String>();
                labelMap.put(key, set);
            }
            set.add(label);
        }
        ArrayList list = new ArrayList();
        for (Map.Entry entry : labelMap.entrySet()) {
            list.addAll((Collection)entry.getValue());
        }
        this.contents = new HeaderValuePair[list.size()];
        for (int i = 0; i < this.contents.length; ++i) {
            String header = (String)list.get(i);
            String value = null;
            if (init != null && init.length > 0) {
                for (int j = 0; j < init.length; ++j) {
                    if (!init[j][0].equals(header)) continue;
                    value = init[j][1];
                    break;
                }
            }
            this.contents[i] = new HeaderValuePair(header, value);
            if (!this.debug) continue;
            logger.info("contents[" + i + "] " + this.contents[i]);
        }
        this.dataStartChar = (char)32;
        this.dataEndChar = CRLF.charAt(0);
        this.firstCharacterOfHeaderMap = new HashMap<String, Set<String>>();
        for (HeaderValuePair p : this.contents) {
            String header = p.getHeader();
            if (header.length() == 0) continue;
            String firstCharacter = header.substring(0, 1);
            Set<String> _set = this.firstCharacterOfHeaderMap.get(firstCharacter);
            if (_set == null) {
                _set = new HashSet<String>();
                this.firstCharacterOfHeaderMap.put(firstCharacter, _set);
            }
            _set.add(header);
        }
    }

    public void parse(String cnt) {
        if (cnt == null || cnt.length() == 0) {
            return;
        }
        char dataStartChar0 = this.dataStartChar;
        char dataEndChar0 = this.dataEndChar;
        if (this.debug) {
            logger.info("dataStartChar0=" + dataStartChar0);
            logger.info("dataEndChar0=" + dataEndChar0);
            logger.info("zenkakuHankakuEqualFlag=" + this.zenkakuHankakuEqualFlag);
        }
        if (this.zenkakuHankakuEqualFlag) {
            String ns;
            StringConvKigouH2ZFilter kigouH2Z = new StringConvKigouH2ZFilter();
            StringConvKigouZ2HFilter kigouZ2H = new StringConvKigouZ2HFilter();
            String s = String.valueOf(this.dataStartChar);
            if (!s.equals(ns = kigouH2Z.filter(s))) {
                dataStartChar0 = ns.charAt(0);
            } else {
                ns = kigouZ2H.filter(s);
                if (!s.equals(ns)) {
                    dataStartChar0 = ns.charAt(0);
                }
            }
            String e = String.valueOf(this.dataEndChar);
            String ne = kigouH2Z.filter(e);
            if (!e.equals(ne)) {
                dataEndChar0 = ne.charAt(0);
            } else {
                ne = kigouZ2H.filter(e);
                if (!e.equals(ne)) {
                    dataEndChar0 = ne.charAt(0);
                }
            }
            if (this.debug) {
                logger.info("[2] dataStartChar0=" + dataStartChar0);
                logger.info("[2] dataEndChar0=" + dataEndChar0);
            }
        }
        Status status = Status.SearchingNextHeader;
        int length = cnt.length();
        StringBuilder headerBuf = new StringBuilder();
        StringBuilder contentBuf = new StringBuilder();
        Set<String> headerCandidateSet = null;
        HeaderValuePair targetHeaderValue = null;
        for (int i = 0; i < length; ++i) {
            char c = cnt.charAt(i);
            if (status == Status.Header) {
                String _header;
                if (this.debug) {
                    logger.info("[" + c + "]");
                }
                if (c == this.dataStartChar || c == dataStartChar0) {
                    _header = headerBuf.toString();
                    if (this.debug) {
                        logger.info("_header=" + _header);
                    }
                    for (HeaderValuePair p : this.contents) {
                        if (!p.getHeader().equals(_header)) continue;
                        targetHeaderValue = p;
                        status = Status.Value;
                        if (!this.debug) break;
                        logger.info("find pair.");
                        break;
                    }
                    if (targetHeaderValue != null) continue;
                    _header = headerBuf.toString() + c;
                    boolean appendFlag = false;
                    for (String headerCandidate : headerCandidateSet) {
                        if (this.debug) {
                            logger.info("[a] candidate='" + headerCandidate + "', _header='" + _header + "'");
                        }
                        if (!headerCandidate.startsWith(_header)) continue;
                        if (!appendFlag) {
                            headerBuf.append(c);
                            appendFlag = true;
                        }
                        if (!this.debug) continue;
                        logger.info("headerBuf(1)=" + headerBuf);
                    }
                    continue;
                }
                _header = headerBuf.toString() + c;
                boolean appendFlag = false;
                for (String headerCandidate : headerCandidateSet) {
                    if (this.debug) {
                        logger.info("[b] candidate='" + headerCandidate + "', _header='" + _header + "'");
                    }
                    if (!headerCandidate.startsWith(_header)) continue;
                    if (!appendFlag) {
                        headerBuf.append(c);
                        appendFlag = true;
                    }
                    if (!this.debug) continue;
                    logger.info("headerBuf(2)=" + headerBuf);
                }
                if (appendFlag || Character.isWhitespace(c)) continue;
                status = Status.SearchingNextHeader;
                continue;
            }
            if (status == Status.Value) {
                if (this.debug) {
                    logger.info("<" + c + ">");
                }
                if (c == this.dataEndChar || c == dataEndChar0) {
                    String _value = contentBuf.toString();
                    if (targetHeaderValue != null) {
                        targetHeaderValue.setValue(_value);
                        if (this.debug) {
                            logger.info("targetHeaderValue=" + targetHeaderValue);
                        }
                    }
                    headerBuf = null;
                    contentBuf = null;
                    targetHeaderValue = null;
                    status = Status.SearchingNextHeader;
                    continue;
                }
                contentBuf.append(c);
                continue;
            }
            if (status != Status.SearchingNextHeader || !this.firstCharacterOfHeaderMap.containsKey(String.valueOf(c))) continue;
            status = Status.Header;
            headerBuf = new StringBuilder();
            contentBuf = new StringBuilder();
            headerCandidateSet = this.firstCharacterOfHeaderMap.get(String.valueOf(c));
            headerBuf.append(c);
            if (!this.debug) continue;
            logger.info("!" + c + "!");
        }
    }

    public String[] getHeaderPart() {
        return this.getPartProcess(new PartRule(){

            @Override
            String adapt(HeaderValuePair pair) {
                return pair.getHeader();
            }
        });
    }

    public String[] getDataPart() {
        return this.getPartProcess(new PartRule(){

            @Override
            String adapt(HeaderValuePair pair) {
                return pair.getValue();
            }
        });
    }

    private String[] getPartProcess(PartRule rule) {
        int length = this.contents.length;
        String[] ret = new String[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = rule.adapt(this.contents[i]);
        }
        return ret;
    }

    public static void main(String[] args) {
        MailBodyParser.test1();
        MailBodyParser.test2();
        MailBodyParser.test3();
        MailBodyParser.test4();
        MailBodyParser.test5();
        MailBodyParser.test6();
        MailBodyParser.test7();
        MailBodyParser.test8();
        MailBodyParser.test9();
        MailBodyParser.test10();
        MailBodyParser.test11();
        MailBodyParser.test12();
        MailBodyParser.test13();
    }

    private static void test1() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f \u540d", "\u4f4f \u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u6c0f \u540d \u5c71\u7530 \u592a\u90ce" + CRLF + "\u4f4f \u6240 \u6c96\u7e04\u770c" + CRLF + "\u96fb\u8a71\u756a\u53f7 000-000-0000" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        MailBodyParser.process_test(parser, labels, init, cnt, "test1");
    }

    private static void test2() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f \u540d", "\u4f4f \u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u6c0f \u540d \u5c71\u7530 \u592a\u90ce" + CRLF + "\u3000\u4f4f \u6240 \u6c96\u7e04\u770c" + CRLF + "\u96fb\u8a71\u756a\u53f7 000-000-0000" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        MailBodyParser.process_test(parser, labels, init, cnt, "test2");
    }

    private static void test3() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f \u540d", "\u4f4f \u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u3000\u6c0f \u540d \u5c71\u7530 \u592a\u90ce" + CRLF + "\u3000\u4f4f \u6240 \u6c96\u7e04\u770c" + CRLF + "  \u96fb\u8a71\u756a\u53f7 000-000-0000" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        MailBodyParser.process_test(parser, labels, init, cnt, "test3");
    }

    private static void test4() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f \u540d", "\u4f4f \u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u3000\u6c0f \u540d \u5c71 \u7530 \u592a \u90ce " + CRLF + "\u3000\u4f4f \u6240 \u6c96\u7e04\u770c\u3000" + CRLF + "  \u96fb\u8a71\u756a\u53f7 000-000-0000  " + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        MailBodyParser.process_test(parser, labels, init, cnt, "test4");
    }

    private static void test5() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f \u540d", "\u4f4f \u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u6c0f \u540d\uff1c\u5c71\u7530 \u592a\u90ce\uff1e\u3000" + CRLF + "\u3000\u4f4f \u6240\uff1c\u6c96\u7e04\u770c\uff1e" + CRLF + "  \u96fb\u8a71\u756a\u53f7\u3000\uff1c000-000-0000\uff1e" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        parser.setDataStartChar('<');
        parser.setDataEndChar('>');
        parser.setZenkakuHankakuEqual(true);
        MailBodyParser.process_test(parser, labels, init, cnt, "test5");
    }

    private static void test6() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f \u540d", "\u4f4f \u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u6c0f \u540d\uff1c\u5c71\u7530 \u592a\u90ce\uff1e\uff1e\u3000" + CRLF + "\u3000\u4f4f \u6240\uff1c\u6c96\u7e04\u770c\uff1e" + CRLF + "  \u96fb\u8a71\u756a\u53f7\u3000\uff1c000-000-0000\uff1e" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        parser.setDataStartChar('\uff1c');
        parser.setDataEndChar('\uff1e');
        MailBodyParser.process_test(parser, labels, init, cnt, "test6");
    }

    private static void test7() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f \u540d", "\u4f4f \u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u6c0f \u540d\uff1c\uff1c\u5c71\u7530 \u592a\u90ce\uff1e\uff1e\u3000" + CRLF + "\u3000\u4f4f \u6240\uff1c\u6c96 \u7e04 \u770c\uff1e" + CRLF + "  \u96fb\u8a71\u756a\u53f7\u3000\uff1c 000-000-0000 \uff1e" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        parser.setDataStartChar('\uff1c');
        parser.setDataEndChar('\uff1e');
        MailBodyParser.process_test(parser, labels, init, cnt, "test7");
    }

    private static void test8() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f\u540d", "\u4f4f\u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u6c0f \u540d \u5c71\u7530 \u592a\u90ce" + CRLF + "\u4f4f\u3000\u6240 \u6c96\u7e04\u770c" + CRLF + "\u96fb\u8a71\u756a\u53f7 000-000-0000" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        MailBodyParser.process_test(parser, labels, init, cnt, "test8");
    }

    private static void test9() {
        String[] labels = new String[]{"\u9867\u5ba2ID", "\u6c0f\u540d", "\u4f4f\u6240", "\u96fb\u8a71\u756a\u53f7", "\u5099\u8003"};
        String[][] init = new String[][]{{"\u9867\u5ba2ID", "-1"}};
        String cnt = "\u6c0f \u540d\u5c71\u7530 \u592a\u90ce" + CRLF + "\u4f4f\u3000\u6240\u6c96\u7e04\u770c" + CRLF + "\u96fb\u8a71\u756a\u53f7000-000-0000" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        MailBodyParser.process_test(parser, labels, init, cnt, "test9");
    }

    private static void test10() {
        String[] labels = new String[]{"\u6ce8\u6587ID", "\u72b6\u614b", "\u88fd\u54c1\u540d", "\u6ce8\u6587\u500b\u6570"};
        String[][] init = new String[][]{{"\u6ce8\u6587ID", "-1"}};
        String cnt = "\u72b6\u614b \u6ce8\u6587" + CRLF + "\u88fd\u54c1\u540d \u30de\u30f3\u30b4\u30fc" + CRLF + "\u6ce8\u6587\u500b\u6570 10" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        MailBodyParser.process_test(parser, labels, init, cnt, "test10");
    }

    private static void test11() {
        String[] labels = new String[]{"\u88fd\u54c1", "\u30e1\u30fc\u30eb\u756a\u53f7", "\u30b5\u30dd\u30fc\u30c8\u30ab\u30c6\u30b4\u30ea", "\u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8ID", "\u554f\u3044\u5408\u308f\u305b\u30a2\u30ab\u30a6\u30f3\u30c8", "\u30b9\u30c6\u30fc\u30bf\u30b9", "\u554f\u3044\u5408\u308f\u305b\u533a\u5206", "\u6d88\u8cbb\u30b5\u30dd\u30fc\u30c8\u30dd\u30a4\u30f3\u30c8", "\u89aa\u30e1\u30fc\u30eb\u756a\u53f7", "\u62c5\u5f53\u8005", "\u5bfe\u5fdc\u65e5", "\u5099\u8003", "\u95a2\u9023\u30d0\u30b0\u30ec\u30dd\u30fc\u30c8", "No", "\u30d0\u30b0\u30ec\u30dd\u30fc\u30c8ID", "\u30bf\u30a4\u30c8\u30eb", "\u4ef6\u540d", "\u9001\u4fe1\u8005", "\u9001\u4fe1\u65e5\u6642", "\u9001\u4fe1\u65e5", "\u5b9b\u5148", "CC", "\u672c\u6587", "\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u6709\u7121", "\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb", "No", "\u30d5\u30a1\u30a4\u30eb\u540d", "\u4f5c\u6210\u8005", "\u4f5c\u6210\u65e5", "\u66f4\u65b0\u8005", "\u66f4\u65b0\u65e5"};
        String[][] init = null;
        String cnt = "\u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8ID\uff1aE20091128_204651" + CRLF + "\u554f\u3044\u5408\u308f\u305b\u30a2\u30ab\u30a6\u30f3\u30c8\uff1aparts@beacon-it.co.jp" + CRLF + "" + CRLF + "" + CRLF + "Wagby \u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8\u3092\u3054\u5229\u7528\u3044\u305f\u3060\u304d\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044" + CRLF + "\u307e\u3059\u3002\u4ee5\u4e0b\u306e\u5185\u5bb9\u3067\u304a\u554f\u3044\u5408\u308f\u305b\u3092\u53d7\u4ed8\u3044\u305f\u3057\u307e\u3057\u305f\u3002" + CRLF + "" + CRLF + "-----\u3053\u3053\u304b\u3089" + CRLF + "\u25a0\u5185\u5bb9\u306e\u7a2e\u985e" + CRLF + "\u30e9\u30a4\u30bb\u30f3\u30b9\u30ad\u30fc\u304c\u52b9\u304b\u306a\u3044" + CRLF + "" + CRLF + "\u25a0\u8a73\u7d30" + CRLF + "\u958b\u767a\u30e9\u30a4\u30bb\u30f3\u30b9\u3067\u958b\u767a\u3057\u305fWagby\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u672c\u756a\u74b0\u5883\u306b\u30b3\u30d4\u30fc\u3057\u3066\u3001\u672c\u756a\u74b0\u5883\u306b\u5bfe\u3057\u3066\u3001\u5fa1\u793e\u3088\u308a\u8cfc\u5165\u3057\u305f\u300cWagby Pro Plus(\u8a8d\u8a3c\u63a5\u7d9a\u30e9\u30a4\u30bb\u30f3\u30b9)\u300d\u3092\u8a2d\u5b9a\u3057\u305f\u306e\u3060\u304c\u3001" + CRLF + "\u300c\u63a5\u7d9a\u306e\u6709\u52b9\u6642\u9593\u304c\u5207\u308c\u307e\u3057\u305f\uff08\u3082\u3057\u304f\u306f\u7ba1\u7406\u8005\u306b\u3088\u3063\u3066\u63a5\u7d9a\u304c\u89e3\u9664\u3055\u308c\u307e\u3057\u305f\uff09\u518d\u30ed\u30b0\u30aa\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u300d" + CRLF + "\u3068\u3044\u3046\u30a8\u30e9\u30fc\u304c\u51fa\u3066\u64cd\u4f5c\u304c\u3067\u304d\u306a\u304f\u306a\u3063\u3066\u3057\u307e\u3046\u3002" + CRLF + "" + CRLF + "\u958b\u767a\u306b\u4f7f\u7528\u3057\u3066\u3044\u308b\u30de\u30b7\u30f3\u306b\u8a2d\u5b9a\u3057\u3066\u3044\u308b\u30e9\u30a4\u30bb\u30f3\u30b9\u306f\u3001\u300cpackagename=&quot;jp.co.beacon_it.hyouka&quot; projectid=&quot;hyouka&quot;\u300d\u3002" + CRLF + "\u3053\u3053\u3067\u4f5c\u6210\u3057\u305fwagbyapp\u3092\u672c\u756a\u6a5f\u306eLinux\u306b\u30b3\u30d4\u30fc\u3057\u3066\u3001createApplicationID.sh\u3092\u5b9f\u884c\u3057\u3066\u3067\u304d\u305f appid.txt\u3092Wagby\u30e9\u30a4\u30bb\u30f3\u30b9\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u306b\u767b\u9332\u3057\u3066\u672c\u756a\u6a5f\u306e\u30e9\u30a4\u30bb\u30f3\u30b9\u30ad\u30fc\u3092\u751f\u6210\u3057\u307e\u3057\u305f\u3002" + CRLF + "" + CRLF + "\u672c\u756a\u6e96\u5099\u306e\u305f\u3081\u975e\u5e38\u306b\u6025\u3044\u3067\u304a\u308a\u307e\u3059\u3002" + CRLF + "\u3054\u56de\u7b54\u304a\u5f85\u3061\u3057\u3066\u304a\u308a\u307e\u3059\u3002" + CRLF + "" + CRLF + "\u25a0Wagby\u30d0\u30fc\u30b8\u30e7\u30f3" + CRLF + "6.5.1.3" + CRLF + "" + CRLF + "\u25a0Web\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u304c\u7a3c\u52d5\u3059\u308b\u30de\u30b7\u30f3\u306eOS" + CRLF + "CentOS 5.3" + CRLF + "" + CRLF + "\u25a0\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30de\u30b7\u30f3\u306eOS" + CRLF + "Windows XP SP2,3" + CRLF + "" + CRLF + "\u25a0\u30d6\u30e9\u30a6\u30b6" + CRLF + "Firefox 3.5.5" + CRLF + "" + CRLF + "\u25a0\u5916\u90e8\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9" + CRLF + "DB2" + CRLF + "" + CRLF + "-----\u3053\u3053\u307e\u3067" + CRLF + "" + CRLF + "\u3053\u306e\u30e1\u30fc\u30eb\u306f\u304a\u5ba2\u69d8\u306e\u304a\u554f\u3044\u5408\u308f\u305b\u5185\u5bb9\u3092\u3054\u78ba\u8a8d\u3057\u3066\u3044\u305f\u3060\u304f" + CRLF + "\u305f\u3081\u306e\u3082\u306e\u3067\u3059\u3002\u5f0a\u793e\u30b5\u30dd\u30fc\u30c8\u306b\u3066\u672c\u554f\u5408\u305b\u3092\u53d7\u4ed8\u5f8c\u3059\u3050\u306b" + CRLF + "\u96fb\u5b50\u30e1\u30fc\u30eb\u306b\u3066\u6700\u521d\u306e\u56de\u7b54\u3092\u884c\u3044\u307e\u3059\u3002" + CRLF + "\u306a\u304a\u3001\u3053\u306e\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u5143\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306f\u9001\u4fe1\u7528\u3067\u3059\u3002" + CRLF + "\u3053\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3078\u306e\u3054\u8fd4\u4fe1\u306f\u56de\u7b54\u3067\u304d\u307e\u305b\u3093\u306e\u3067\u3001\u3054\u6ce8\u610f" + CRLF + "\u304f\u3060\u3055\u3044\u3002" + CRLF + "" + CRLF + "---" + CRLF + "Wagby \u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        parser.setDataStartChar('\uff1a');
        MailBodyParser.process_test(parser, labels, init, cnt, "test11");
    }

    private static void test12() {
        String[] labels = new String[]{"\u88fd\u54c1", "\u30e1\u30fc\u30eb\u756a\u53f7", "\u30b5\u30dd\u30fc\u30c8\u30ab\u30c6\u30b4\u30ea", "\u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8ID", "\u554f\u3044\u5408\u308f\u305b\u30a2\u30ab\u30a6\u30f3\u30c8", "\u30b9\u30c6\u30fc\u30bf\u30b9", "\u554f\u3044\u5408\u308f\u305b\u533a\u5206", "\u6d88\u8cbb\u30b5\u30dd\u30fc\u30c8\u30dd\u30a4\u30f3\u30c8", "\u89aa\u30e1\u30fc\u30eb\u756a\u53f7", "\u62c5\u5f53\u8005", "\u5bfe\u5fdc\u65e5", "\u5099\u8003", "\u95a2\u9023\u30d0\u30b0\u30ec\u30dd\u30fc\u30c8", "No", "\u30d0\u30b0\u30ec\u30dd\u30fc\u30c8ID", "\u30bf\u30a4\u30c8\u30eb", "\u4ef6\u540d", "\u9001\u4fe1\u8005", "\u9001\u4fe1\u65e5\u6642", "\u9001\u4fe1\u65e5", "\u5b9b\u5148", "CC", "\u672c\u6587", "\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u6709\u7121", "\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb", "No", "\u30d5\u30a1\u30a4\u30eb\u540d", "\u4f5c\u6210\u8005", "\u4f5c\u6210\u65e5", "\u66f4\u65b0\u8005", "\u66f4\u65b0\u65e5"};
        String[][] init = null;
        String cnt = "\u30b8\u30e3\u30b9\u30df\u30f3\u30bd\u30d5\u30c8" + CRLF + "\u8d04 \u69d8" + CRLF + "" + CRLF + "\u3044\u3064\u3082\u304a\u4e16\u8a71\u306b\u306a\u3063\u3066\u304a\u308a\u307e\u3059\u3002" + CRLF + "\u30d3\u30fc\u30b3\u30f3IT\u306e\u9234\u6728\u96c4\u4ecb\u3067\u3059\u3002" + CRLF + "" + CRLF + "\u4f11\u65e5\u306b\u3082\u304b\u304b\u308f\u3089\u305a\u3054\u5bfe\u5fdc\u3044\u305f\u3060\u304d\u3001\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\u3002" + CRLF + "" + CRLF + "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u6e96\u5099\u3092\u6574\u3048\u3066\u3001\u5348\u5f8c\u304b\u3089\u4f5c\u696d\u3092\u518d\u958b\u3044\u305f\u3057\u307e\u3059\u3002" + CRLF + "" + CRLF + "\u6628\u65e5\u884c\u3063\u305f\u4f5c\u696d\u3067\u3001\u8d04\u69d8\u3088\u308a\u3054\u6307\u793a\u306e\u3042\u3063\u305f\u624b\u9806\u3067\u8a66\u3057\u3066\u307f\u307e\u3057\u305f\u304c\u3001" + CRLF + "\u300c\u63a5\u7d9a\u306e\u6709\u52b9\u6642\u9593\u304c\u5207\u308c\u307e\u3057\u305f\uff08\u3082\u3057\u304f\u306f\u7ba1\u7406\u8005\u306b\u3088\u3063\u3066\u63a5\u7d9a\u304c\u89e3\u9664\u3055\u308c\u307e\u3057\u305f\uff09\u518d\u30ed\u30b0\u30aa\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u300d" + CRLF + "\u306e\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u8868\u793a\u3055\u308c\u3066\u3057\u307e\u3044\u307e\u3059\u3002" + CRLF + "\u30ed\u30b0\u30a4\u30f3\u306f\u3067\u304d\u308b\u306e\u3067\u3059\u304c\u3001\u30e1\u30cb\u30e5\u30fc\u304b\u3089\u3069\u306e\u9805\u76ee\u3092\u9078\u629e\u3057\u3066\u3082\u3053\u306e\u30a8\u30e9\u30fc\u306b\u306a\u308a\u307e\u3059\u3002" + CRLF + "" + CRLF + "\u3053\u306e\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u51fa\u308b\u5834\u5408\u306b\u8003\u3048\u3089\u308c\u308b\u53ef\u80fd\u6027\u3068\u3057\u3066\u3001\u3069\u306e\u3088\u3046\u306a\u554f\u984c\u304c" + CRLF + "\u8003\u3048\u3089\u308c\u308b\u306e\u3067\u3057\u3087\u3046\u304b\uff1f" + CRLF + "" + CRLF + "\u5348\u5f8c\u306e\u4f5c\u696d\u306b\u3066\u3001\u3082\u3046\u4e00\u5ea6\u540c\u3058\u624b\u9806\u3092\u8a66\u3057\u3066\u307f\u3088\u3046\u3068\u601d\u3044\u307e\u3059\u3002" + CRLF + "\u305d\u3057\u3066\u3001\u305d\u306e\u7d50\u679c\u3092\u3054\u5831\u544a\u3044\u305f\u3057\u307e\u3059\u3002" + CRLF + "" + CRLF + "\u3054\u9023\u7d61\u306f\u8d04\u69d8\u306b\u76f4\u63a5\u30e1\u30fc\u30eb\u3067\u3088\u308d\u3057\u3044\u3067\u3057\u3087\u3046\u304b\uff1f" + CRLF + "" + CRLF + "" + CRLF + "----- Original Message -----" + CRLF + "> \u30d3\u30fc\u30b3\u30f3IT" + CRLF + "> \u9234\u6728 \u69d8" + CRLF + ">" + CRLF + "> \u8d04@\u30b8\u30e3\u30b9\u30df\u30f3\u30bd\u30d5\u30c8\u3067\u3059\u3002\u304a\u4e16\u8a71\u306b\u306a\u3063\u3066\u304a\u308a\u307e\u3059\u3002" + CRLF + ">" + CRLF + "> \u672c\u65e5\u306f\u4ed6\u306e\u30e1\u30f3\u30d0\u30fc\u304c\u4f11\u3093\u3067\u304a\u308a\u307e\u3059\u306e\u3067\u3001\u79c1\u306e\u65b9\u3067" + CRLF + "> \u5bfe\u5fdc\u3055\u305b\u3066\u3044\u305f\u3060\u304d\u307e\u3059\u3002" + CRLF + ">" + CRLF + "> \u307e\u305a\u539f\u56e0\u5207\u308a\u5206\u3051\u306e\u305f\u3081\u3001\u3044\u3063\u305f\u3093\u672c\u756a\u6a5f\u7528\u3068\u3057\u3066" + CRLF + "> \u4f5c\u6210\u3057\u305f\u30e9\u30a4\u30bb\u30f3\u30b9\u30ad\u30fc\u30d5\u30a1\u30a4\u30eb\u3092\u3001\u5f0a\u793e\u30e9\u30a4\u30bb\u30f3\u30b9" + CRLF + "> \u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u304b\u3089\u3044\u3063\u305f\u3093\u524a\u9664\u3057\u3066\u3044\u305f\u3060\u3051\u307e\u3059" + CRLF + "> \u3067\u3057\u3087\u3046\u304b\u3002" + CRLF + ">" + CRLF + "> # \u7e70\u308a\u8fd4\u3057\u30b3\u30f3\u30c6\u30ca\u306e\u300c\u524a\u9664\u300d\u30dc\u30bf\u30f3\u306b\u3088\u308a" + CRLF + "> # \u3044\u3063\u305f\u3093\u30af\u30ea\u30a2\u3055\u308c\u307e\u3059\u3002" + CRLF + ">" + CRLF + "> \u305d\u306e\u5f8c\u3001\u7a2e\u5225\u300c\u672c\u756a\u6a5f\u300d\u3092\u9078\u629e\u3057\u3001\u518d\u5ea6 appid.txt" + CRLF + "> \u3092\u767b\u9332\u304f\u3060\u3055\u3044\u3002\u6539\u3081\u3066\u30e9\u30a4\u30bb\u30f3\u30b9\u30ad\u30fc\u30d5\u30a1\u30a4\u30eb\u304c" + CRLF + "> \u751f\u6210\u3055\u308c\u307e\u3059\u3002" + CRLF + ">" + CRLF + "> \u672c\u756a\u6a5f\u3078\u306e\u76f4\u63a5\u767b\u9332\u306f\u4ee5\u4e0b\u306e\u624b\u9806\u3068\u306a\u308a\u307e\u3059\u3002" + CRLF + "> wagby.com/support/systemman/licensekey.html" + CRLF + ">" + CRLF + "> \u767b\u9332\u5f8c\u3001\u6b21\u306e\u65b9\u6cd5\u3067\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002" + CRLF + "> wagby.com/support/systemman/licensekey.html#check" + CRLF + ">" + CRLF + "> \u305d\u308c\u3067\u306f\u3001\u3069\u3046\u305e\u3088\u308d\u3057\u304f\u304a\u9858\u3044\u81f4\u3057\u307e\u3059\u3002" + CRLF + ">" + CRLF + ">" + CRLF + "> On 2009/11/29, at 9:56, suzuki hisao wrote:" + CRLF + ">" + CRLF + "> > \u8d04\u3055\u307e" + CRLF + "> >" + CRLF + "> > \u30d3\u30fc\u30b3\u30f3IT\u306e\u9234\u6728\u3067\u3059\u3002\u3044\u3064\u3082\u304a\u4e16\u8a71\u306b\u306a\u3063\u3066\u304a\u308a\u307e\u3059\u3002" + CRLF + "> > \u304a\u4f11\u307f\u306e\u3068\u3053\u308d\u7533\u3057\u8a33\u3054\u3056\u3044\u307e\u305b\u3093\u3002" + CRLF + "> >" + CRLF + "> > \u672c\u4ef6\u3001\u4f55\u3068\u305e\u8fc5\u901f\u306a\u304a\u624b\u914d\u3092\u8cdc\u308a\u307e\u3059\u3088\u3046\u304a\u9858\u3044\u7533\u3057\u4e0a\u3052\u307e\u3059\u3002" + CRLF + "> > \u5f0a\u793e\u30e1\u30f3\u30d0\u30fc\u3082\u4f11\u65e5\u8fd4\u4e0a\u3067\u4f5c\u696d\u3092\u9032\u3081\u3066\u304a\u308a\u307e\u3059\u304c\u3001\u3053\u306e\u30e9\u30a4\u30bb\u30f3\u30b9\u90e8\u5206\u306b\u3064\u3044\u3066\u306f" + CRLF + "> > \u8cb4\u793e\u306e\u304a\u529b\u6dfb\u3048\u304c\u306a\u3044\u3068\u5148\u306b\u9032\u3080\u3053\u3068\u304c\u3067\u304d\u306a\u3044\u72b6\u6cc1\u3067\u3059\u3002" + CRLF + "> > \u304a\u4f11\u307f\u306e\u3068\u3053\u308d\u5927\u5909\u6050\u7e2e\u3067\u306f\u3054\u3056\u3044\u307e\u3059\u304c\u7d0d\u671f\u304c\u6708\u66dc\u3068\u306a\u3063\u3066\u304a\u308a\u307e\u3057\u3066\u3001\u672c\u65e5\u4e2d" + CRLF + "> > \u306b\u3082\u3069\u306a\u305f\u304b\u306b\u3054\u5bfe\u5fdc\u3044\u305f\u3060\u3051\u308c\u3070\u975e\u5e38\u306b\u6709\u308a\u96e3\u304f\u5b58\u3058\u307e\u3059\u3002" + CRLF + "> > \u4e0d\u53ef\u80fd\u3067\u3042\u308c\u3070\u6708\u66dc\u306e\u65e9\u3044\u6642\u9593\u3067\u306e\u3054\u5bfe\u5fdc\u3092\u304a\u9858\u3044\u3044\u305f\u3057\u307e\u3059\u3002" + CRLF + "> > \u306a\u304a\u5fc5\u8981\u3067\u3042\u308c\u3070\u4e0b\u8a18\u79c1\u306e\u643a\u5e2f\u306b\u3054\u9023\u7d61\u3044\u305f\u3060\u3051\u3070\u5e78\u3044\u3067\u3059\u3002" + CRLF + "> >" + CRLF + "> > 08012899862" + CRLF + "> > 07064352174" + CRLF + "> >" + CRLF + "> > \u52dd\u624b\u306a\u304a\u9858\u3044\u3067\u5fc3\u82e6\u3057\u3044\u9650\u308a\u3067\u3059\u304c\u3001\u5b9c\u3057\u304f\u304a\u9858\u3044\u7533\u3057\u4e0a\u3052\u307e\u3059\u3002" + CRLF + "> > \u4ee5\u4e0a" + CRLF + "> >" + CRLF + "> >" + CRLF + "> > \u4ef6\u540d: Wagby \u7dca\u6025\u30b5\u30dd\u30fc\u30c8 E20091128_204651" + CRLF + "> > \u65e5\u4ed8: Sat, 28 Nov 2009 20:46:51 +0900 (JST)" + CRLF + "> > \u9001\u4fe1\u8005: info@jasminesoft.co.jp" + CRLF + "> > \u5b9b\u5148: parts@beacon-it.co.jp" + CRLF + "> > Cc: wagby-support@jasminesoft.co.jp" + CRLF + "> >" + CRLF + "> >> \u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8ID\uff1aE20091128_204651" + CRLF + "> >> \u554f\u3044\u5408\u308f\u305b\u30a2\u30ab\u30a6\u30f3\u30c8\uff1aparts@beacon-it.co.jp" + CRLF + "> >>" + CRLF + "> >>" + CRLF + "> >> Wagby \u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8\u3092\u3054\u5229\u7528\u3044\u305f\u3060\u304d\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044" + CRLF + "> >> \u307e\u3059\u3002\u4ee5\u4e0b\u306e\u5185\u5bb9\u3067\u304a\u554f\u3044\u5408\u308f\u305b\u3092\u53d7\u4ed8\u3044\u305f\u3057\u307e\u3057\u305f\u3002" + CRLF + "> >>" + CRLF + "> >> -----\u3053\u3053\u304b\u3089" + CRLF + "> >> \u25a0\u5185\u5bb9\u306e\u7a2e\u985e" + CRLF + "> >> \u30e9\u30a4\u30bb\u30f3\u30b9\u30ad\u30fc\u304c\u52b9\u304b\u306a\u3044" + CRLF + "> >>" + CRLF + "> >> \u25a0\u8a73\u7d30" + CRLF + "> >> \u958b\u767a\u30e9\u30a4\u30bb\u30f3\u30b9\u3067\u958b\u767a\u3057\u305fWagby\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u672c\u756a\u74b0\u5883\u306b\u30b3\u30d4\u30fc\u3057\u3066\u3001\u672c\u756a\u74b0\u5883\u306b\u5bfe\u3057\u3066\u3001\u5fa1\u793e\u3088\u308a\u8cfc\u5165\u3057\u305f\u300cWagby Pro Plus(\u8a8d\u8a3c\u63a5\u7d9a\u30e9\u30a4\u30bb\u30f3\u30b9)\u300d\u3092\u8a2d\u5b9a\u3057\u305f\u306e\u3060\u304c\u3001" + CRLF + "> >> \u300c\u63a5\u7d9a\u306e\u6709\u52b9\u6642\u9593\u304c\u5207\u308c\u307e\u3057\u305f\uff08\u3082\u3057\u304f\u306f\u7ba1\u7406\u8005\u306b\u3088\u3063\u3066\u63a5\u7d9a\u304c\u89e3\u9664\u3055\u308c\u307e\u3057\u305f\uff09\u518d\u30ed\u30b0\u30aa\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u300d" + CRLF + "> >> \u3068\u3044\u3046\u30a8\u30e9\u30fc\u304c\u51fa\u3066\u64cd\u4f5c\u304c\u3067\u304d\u306a\u304f\u306a\u3063\u3066\u3057\u307e\u3046\u3002" + CRLF + "> >>" + CRLF + "> >> \u958b\u767a\u306b\u4f7f\u7528\u3057\u3066\u3044\u308b\u30de\u30b7\u30f3\u306b\u8a2d\u5b9a\u3057\u3066\u3044\u308b\u30e9\u30a4\u30bb\u30f3\u30b9\u306f\u3001\u300cpackagename=&quot;jp.co.beacon_it.hyouka&quot; projectid=&quot;hyouka&quot;\u300d\u3002" + CRLF + "> >> \u3053\u3053\u3067\u4f5c\u6210\u3057\u305fwagbyapp\u3092\u672c\u756a\u6a5f\u306eLinux\u306b\u30b3\u30d4\u30fc\u3057\u3066\u3001createApplicationID.sh\u3092\u5b9f\u884c\u3057\u3066\u3067\u304d\u305f appid.txt\u3092Wagby\u30e9\u30a4\u30bb\u30f3\u30b9\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u306b\u767b\u9332\u3057\u3066\u672c\u756a\u6a5f\u306e\u30e9\u30a4\u30bb\u30f3\u30b9\u30ad\u30fc\u3092\u751f\u6210\u3057\u307e\u3057\u305f\u3002" + CRLF + "> >>" + CRLF + "> >> \u672c\u756a\u6e96\u5099\u306e\u305f\u3081\u975e\u5e38\u306b\u6025\u3044\u3067\u304a\u308a\u307e\u3059\u3002" + CRLF + "> >> \u3054\u56de\u7b54\u304a\u5f85\u3061\u3057\u3066\u304a\u308a\u307e\u3059\u3002" + CRLF + "> >>" + CRLF + "> >> \u25a0Wagby\u30d0\u30fc\u30b8\u30e7\u30f3" + CRLF + "> >> 6.5.1.3" + CRLF + "> >>" + CRLF + "> >> \u25a0Web\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u304c\u7a3c\u52d5\u3059\u308b\u30de\u30b7\u30f3\u306eOS" + CRLF + "> >> CentOS 5.3" + CRLF + "> >>" + CRLF + "> >> \u25a0\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30de\u30b7\u30f3\u306eOS" + CRLF + "> >> Windows XP SP2,3" + CRLF + "> >>" + CRLF + "> >> \u25a0\u30d6\u30e9\u30a6\u30b6" + CRLF + "> >> Firefox 3.5.5" + CRLF + "> >>" + CRLF + "> >> \u25a0\u5916\u90e8\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9" + CRLF + "> >> DB2" + CRLF + "> >>" + CRLF + "> >> -----\u3053\u3053\u307e\u3067" + CRLF + "> >>" + CRLF + "> >> \u3053\u306e\u30e1\u30fc\u30eb\u306f\u304a\u5ba2\u69d8\u306e\u304a\u554f\u3044\u5408\u308f\u305b\u5185\u5bb9\u3092\u3054\u78ba\u8a8d\u3057\u3066\u3044\u305f\u3060\u304f" + CRLF + "> >> \u305f\u3081\u306e\u3082\u306e\u3067\u3059\u3002\u5f0a\u793e\u30b5\u30dd\u30fc\u30c8\u306b\u3066\u672c\u554f\u5408\u305b\u3092\u53d7\u4ed8\u5f8c\u3059\u3050\u306b" + CRLF + "> >> \u96fb\u5b50\u30e1\u30fc\u30eb\u306b\u3066\u6700\u521d\u306e\u56de\u7b54\u3092\u884c\u3044\u307e\u3059\u3002" + CRLF + "> >> \u306a\u304a\u3001\u3053\u306e\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u5143\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306f\u9001\u4fe1\u7528\u3067\u3059\u3002" + CRLF + "> >> \u3053\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3078\u306e\u3054\u8fd4\u4fe1\u306f\u56de\u7b54\u3067\u304d\u307e\u305b\u3093\u306e\u3067\u3001\u3054\u6ce8\u610f" + CRLF + "> >> \u304f\u3060\u3055\u3044\u3002" + CRLF + "> >>" + CRLF + "> >> ---" + CRLF + "> >> Wagby \u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30dd\u30fc\u30c8" + CRLF + ">" + CRLF + ">" + CRLF + "===================================================================" + CRLF + "\u25c6\u25c6\u25c6 \u7b2c20\u56de BeaconIT Forum \u6771\u4eac \u301011\u670812\u65e5\u301c12\u670811\u65e5\u3011\u958b\u50ac\u3000\u25c6\u25c6\u25c6" + CRLF + "\u4eca\u5e74\u306e\u30c6\u30fc\u30de\u306fUP!" + CRLF + "" + CRLF + "\u6771\u4eac\u4f1a\u5834\u3067\u306f\u3053\u308c\u307e\u3067\u306b\u306a\u3044\u500b\u5225\u30bb\u30c3\u30b7\u30e7\u30f3\u306e\u9023\u7d9a\u958b\u50ac\uff01" + CRLF + "\u30fbDay1\uff1a\u65b0\u5206\u91ce\u3010Enterprise Front-end Integration\u3011\u306e\u767a\u8868\uff01" + CRLF + "\u30fbDay2\uff1aTsunagi\u6280\u8853\u306b\u3088\u308b\u958b\u767a\u30d7\u30ed\u30bb\u30b9\u5909\u9769\uff01" + CRLF + "\u30fbDay3\uff1a\u516c\u8a8d\u4f1a\u8a08\u58eb \u6df1\u898b\u6d69\u4e00\u90ce\u6c0f\u306b\u3088\u308b\u3054\u8b1b\u6f14\uff01" + CRLF + "\u30fbDay4\uff1a\u6700\u65b0\u4e8b\u4f8b\u306e\u3054\u7d39\u4ecb\u3000" + CRLF + "\u30fbDay5\uff1aBeacon\u30e6\u30fc\u30b6\u4f1a\u3054\u5354\u529b\u306b\u3088\u308b\u30d1\u30cd\u30eb\u30c7\u30a3\u30b9\u30ab\u30c3\u30b7\u30e7\u30f3\u3000" + CRLF + "" + CRLF + "\u4f1a\u5834\uff1a\u30d3\u30fc\u30b3\u30f3IT\u65b0\u5bbf\u672c\u793e17\u968e" + CRLF + "\u76db\u308a\u6ca2\u5c71\u306e\u5185\u5bb9\u3067\u7686\u69d8\u306e\u304a\u8d8a\u3057\u3092\u304a\u5f85\u3061\u3057\u3066\u304a\u308a\u307e\u3059\u3002" + CRLF + " \u2193\u304a\u7533\u8fbc\u307f\u306f\u3053\u3061\u3089\u307e\u3067\uff01\u2193" + CRLF + "http://www.beacon-it.co.jp/semi_eve/events/forum20th.shtml" + CRLF + "\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212\u2212" + CRLF + " (\u682a)\u30d3\u30fc\u30b3\u30f3IT\u3000\u30de\u30fc\u30b1\u30c6\u30a3\u30f3\u30b0\u90e8" + CRLF + "\u9234\u6728\u96c4\u4ecb\u3000 yssuzuki@beacon-it.co.jp" + CRLF + " TEL\uff1a03-3340-2664\u3000FAX\uff1a03-3340-0266" + CRLF + "=====================================================================" + CRLF;
        MailBodyParser parser = new MailBodyParser(labels, init);
        parser.setDataStartChar('\uff1a');
        MailBodyParser.process_test(parser, labels, init, cnt, "test12");
    }

    private static void test13() {
        String[] labels = new String[]{"ID", "\u30a2\u30ab\u30a6\u30f3\u30c8", "\u6240\u5c5e\u30b0\u30eb\u30fc\u30d7", "\u65b0\u898f\u30d1\u30b9\u30ef\u30fc\u30c9", "\u65b0\u898f\u30d1\u30b9\u30ef\u30fc\u30c9(\u78ba\u8a8d\u7528)", "\u540d\u524d", "NAME", "\u6240\u5c5e\u4e8b\u696d\u90e8", "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9", "\u30a2\u30ab\u30a6\u30f3\u30c8\u30ed\u30c3\u30af\u60c5\u5831", "\u8868\u793a\u512a\u5148\u5ea6", "\u30d1\u30b9\u30ef\u30fc\u30c9\u66f4\u65b0\u65e5\u6642", "\u30d7\u30ea\u30f3\u30b7\u30d1\u30eb", "\u6700\u7d42\u30ed\u30b0\u30aa\u30f3\u65e5\u6642", "\u30ed\u30b0\u30aa\u30f3\u30eb\u30fc\u30eb", "No", "IP\u30a2\u30c9\u30ec\u30b9"};
        String[][] inits = new String[][]{{"ID", "-1"}};
        String cnt = "ID<1111>" + CRLF + "\u30a2\u30ab\u30a6\u30f3\u30c8<123456789>" + CRLF + "\u65b0\u898f\u30d1\u30b9\u30ef\u30fc\u30c9<thermal>" + CRLF + "\u65b0\u898f\u30d1\u30b9\u30ef\u30fc\u30c9(\u78ba\u8a8d\u7528)<thermal>" + CRLF + "\u540d\u524d<\u30e1\u30fc\u30eb\u30c6\u30b9\u30c8>" + CRLF + "NAME<Mailtest>" + CRLF + "\u6240\u5c5e\u4e8b\u696d\u90e8<\u30e1\u30fc\u30eb\u30c6\u30b9\u30c8\u4e8b\u696d\u90e8>" + CRLF + "\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9<nie@jasminesoft.co.jp>";
        MailBodyParser parser = new MailBodyParser(labels, inits);
        parser.setDataStartChar('<');
        parser.setDataEndChar('>');
        MailBodyParser.process_test(parser, labels, inits, cnt, "test13");
    }

    private static void process_test(MailBodyParser parser, String[] labels, String[][] init, String cnt, String title) {
        parser.parse(cnt);
        String[] header = parser.getHeaderPart();
        String[] data = parser.getDataPart();
        System.out.println("=== " + title + " ===");
        for (String s : header) {
            System.out.println("header='" + s + "'");
        }
        for (String s : data) {
            System.out.println("data='" + s + "'");
        }
    }

    private abstract class PartRule {
        private PartRule() {
        }

        abstract String adapt(HeaderValuePair var1);
    }

    private static class HeaderValuePair {
        private String header;
        private String value;

        public HeaderValuePair(String header, String value) {
            this.header = header;
            this.value = value;
        }

        public String getHeader() {
            return this.header != null ? this.header : "";
        }

        public String getValue() {
            return this.value != null ? this.value : "";
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.header + "=" + this.value;
        }
    }

    private static enum Status {
        Header,
        Value,
        SearchingNextHeader;

    }
}

