/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.job.TaskException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessExecTask {
    private static final Logger logger = LogManager.getLogger((String)ProcessExecTask.class.getName());
    private String cmd;
    private String dir;
    private Map<String, String> map;

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    public Integer executeWithExitcode(ActionParameter p) {
        return (Integer)this.execute0(p, -1, RetValue.ExitCode);
    }

    public Integer executeWithExitcode(ActionParameter p, int timeoutSec) {
        return (Integer)this.execute0(p, timeoutSec, RetValue.ExitCode);
    }

    public String execute(ActionParameter p) {
        return (String)this.execute0(p, -1, RetValue.Console);
    }

    public String execute(ActionParameter p, int timeoutSec) {
        return (String)this.execute0(p, timeoutSec, RetValue.Console);
    }

    private Object execute0(ActionParameter p, int timeoutSec, RetValue retValue) {
        Object ret;
        block25: {
            if (StringUtils.isBlank((CharSequence)this.cmd)) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00904), LogCodeManager.getMessage(LogCode.JFC00904, p.user, new String[0]));
                return "";
            }
            List<String> cmdList = ProcessExecTask.parseCommand(this.cmd);
            ret = null;
            Process process = null;
            try {
                ProcessBuilder pb = new ProcessBuilder(cmdList);
                if (StringUtils.isNotBlank((CharSequence)this.dir)) {
                    File directory = new File(this.dir);
                    if (!directory.exists()) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00905), LogCodeManager.getMessage(LogCode.JFC00905, p.user, directory.getAbsolutePath()));
                    } else if (!directory.isDirectory()) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00906), LogCodeManager.getMessage(LogCode.JFC00906, p.user, directory.getAbsolutePath()));
                    } else {
                        pb.directory(directory);
                    }
                }
                Map<String, String> environment = pb.environment();
                if (this.map != null) {
                    for (Map.Entry<String, String> o : this.map.entrySet()) {
                        int ptr;
                        String s;
                        Map.Entry<String, String> entry = o;
                        String key = entry.getKey();
                        if (!key.startsWith("env") || !StringUtils.isNotBlank((CharSequence)(s = entry.getValue())) || (ptr = (s = s.trim()).indexOf("=")) <= 0) continue;
                        String _key = s.substring(0, ptr).trim();
                        String _value = s.substring(ptr + 1);
                        if (StringUtils.isBlank((CharSequence)_value)) {
                            _value = null;
                        }
                        if (!StringUtils.isNotBlank((CharSequence)_key)) continue;
                        environment.put(_key, _value);
                    }
                }
                StringWriter out = new StringWriter();
                process = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    int c;
                    while ((c = br.read()) != -1) {
                        out.write((char)c);
                    }
                }
                catch (IOException c) {
                    // empty catch block
                }
                boolean end = true;
                if (timeoutSec > 0) {
                    end = process.waitFor(timeoutSec, TimeUnit.SECONDS);
                } else {
                    process.waitFor();
                }
                if (retValue == RetValue.Console) {
                    ret = out.toString();
                    break block25;
                }
                if (end) {
                    ret = process.exitValue();
                    break block25;
                }
                logger.log(LogCodeManager.getPriority(LogCode.JFC00931), LogCodeManager.getMessage(LogCode.JFC00931, p.user, cmdList.toString()));
                throw new TaskException("Failed to execute process." + cmdList.toString());
            }
            catch (IOException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00907), LogCodeManager.getMessage(LogCode.JFC00907, p.user, cmdList.toString(), e.getMessage()));
                logger.debug((Object)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new TaskException(e.getMessage());
            }
            catch (InterruptedException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00908), LogCodeManager.getMessage(LogCode.JFC00908, p.user, cmdList.toString(), e.getMessage()));
                logger.debug((Object)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new TaskException(e.getMessage());
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    private static List<String> parseCommand(String cmd) {
        ArrayList<String> list = new ArrayList<String>();
        boolean quoteMode = false;
        StringBuilder token = null;
        for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            if (token == null) {
                token = new StringBuilder();
            }
            if (c == '\"') {
                quoteMode = !quoteMode;
                token.append(c);
                continue;
            }
            if (c != ' ') {
                token.append(c);
                continue;
            }
            if (c != ' ') continue;
            if (!quoteMode) {
                list.add(token.toString());
                token = null;
                continue;
            }
            token.append(c);
        }
        if (token.length() > 0) {
            list.add(token.toString());
        }
        return list;
    }

    private static enum RetValue {
        Console,
        ExitCode;

    }
}

