/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.util.ObjectUtils;

public class SerializeJmsMessageConverter
extends SimpleMessageConverter {
    private static final Logger logger = LogManager.getLogger(SerializeJmsMessageConverter.class);

    protected MapMessage createMessageForMap(Map<?, ?> map, Session session) throws JMSException {
        MapMessage message = session.createMapMessage();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                throw new MessageConversionException("Cannot convert non-String key of type [" + ObjectUtils.nullSafeClassName(key) + "] to JMS MapMessage entry");
            }
            Object value = entry.getValue();
            if (value.getClass().isPrimitive() || value instanceof String) {
                message.setObject((String)key, entry.getValue());
                continue;
            }
            message.setBytes((String)key, this.serialize(value));
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(Object obj) throws JMSException {
        try {
            ByteArrayOutputStream baostream = new ByteArrayOutputStream();
            try (ObjectOutputStream oostream = null;){
                oostream = new ObjectOutputStream(baostream);
                oostream.writeObject(obj);
            }
            return baostream.toByteArray();
        }
        catch (IOException e) {
            String msg = "Failed serialize class " + obj.getClass();
            logger.error(msg, (Throwable)e);
            throw new JMSException(msg);
        }
    }

    protected Map<String, Object> extractMapFromMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration en = message.getMapNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object value = message.getObject(key);
            if (value instanceof byte[]) {
                map.put(key, this.deserialize((byte[])value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserialize(byte[] ba) throws JMSException {
        Object object;
        block7: {
            ByteArrayInputStream baistream = new ByteArrayInputStream(ba);
            ObjectInputStream oistream = null;
            try {
                oistream = new ObjectInputStream(baistream);
                object = oistream.readObject();
                if (oistream == null) break block7;
            }
            catch (Throwable throwable) {
                String msg;
                try {
                    if (oistream != null) {
                        oistream.close();
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    msg = "Class not found";
                    logger.error(msg, (Throwable)e);
                    throw new JMSException(msg);
                }
                catch (IOException e) {
                    msg = "Failed deserialize";
                    logger.error(msg, (Throwable)e);
                    throw new JMSException(msg);
                }
            }
            oistream.close();
        }
        return object;
    }
}

