/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import jp.jasminesoft.jfc.job.TaskException;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionException;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;

public class SpringBatchSimpleJobLauncher
extends JFCBaseJobBean {
    private static final Logger logger = LogManager.getLogger((String)SpringBatchSimpleJobLauncher.class.getName());
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();

    @Override
    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        if (!SystemUtils.isJavaVersionAtLeast((int)6)) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00923), LogCodeManager.getMessage(LogCode.JFC00923, p.user, ((Object)((Object)this)).getClass().getName()));
            return "Sprng Batch cannot run under this JVM.";
        }
        String _jobid = (String)dataMap.get("jobid");
        if (StringUtils.isBlank((CharSequence)_jobid)) {
            return "No Job ID is specified.";
        }
        Job job = (Job)p.appctx.getBean(_jobid);
        if (job == null) {
            return "Job '" + _jobid + "' is not found.";
        }
        Properties prop = new Properties();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String _key = entry.getKey();
            if (!_key.startsWith("param:")) continue;
            prop.setProperty(_key.substring("param:".length()), entry.getValue().toString());
        }
        prop.setProperty("__jfc_startDate", new Date().toString());
        JobParameters jobParameters = this.jobParametersConverter.getJobParameters(prop);
        String status = "";
        SimpleJobLauncher launcher = (SimpleJobLauncher)p.appctx.getBean("jobLauncher");
        try {
            JobExecution jobExecution = launcher.run(job, jobParameters);
            status = jobExecution.getStatus().toString();
        }
        catch (JobExecutionAlreadyRunningException e) {
            status = e.getMessage();
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new TaskException(e.getMessage());
        }
        catch (JobRestartException e) {
            status = e.getMessage();
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new TaskException(e.getMessage());
        }
        catch (JobInstanceAlreadyCompleteException e) {
            status = e.getMessage();
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new TaskException(e.getMessage());
        }
        catch (JobParametersInvalidException e) {
            status = e.getMessage();
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new TaskException(e.getMessage());
        }
        return status;
    }
}

