/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitor2;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorManager;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.core.util.FileUtils;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.error.Jfcinfo;
import jp.jasminesoft.jfc.error.Jfcwarn;
import jp.jasminesoft.jfc.job.JFCBaseJobBean;
import jp.jasminesoft.jfc.job.JfcjobstatusRegistryService;
import jp.jasminesoft.jfc.model.jfcjobstatus.IJfcjobstatus;
import jp.jasminesoft.jfc.model.mailmessage.Attachment;
import jp.jasminesoft.util.MultiPartForm;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionException;

public class UploadUpdateJob
extends JFCBaseJobBean {
    private static final Logger logger = LogManager.getLogger((String)UploadUpdateJob.class.getName());
    private String _processfilename;
    private String _processDirname;
    private String _processDirfilter = ".*\\.(csv|tsv|xls|xlsx|zip)";
    private static final int _processDirfilterflag = 2;
    private Pattern _processDirfilterPattern;
    private Date startdate;
    private Date startfiledate;
    private int filecnt;
    private int totalfilecnt;
    private StringBuilder message;
    private String status;
    private boolean _isLockModel;
    private String modelid;
    private String monitorbid;
    private AbstractDbUploadUpdateRunnableMonitor2 monitor;
    private JFCErrorManager errorManager;
    private static final Object[] CheckMessageFormatTestData = new Object[]{new Date(), new Date(), 1, 2, "a.csv", "a", ".csv"};

    private String getUploadFilename(File pfile, Map<String, Object> dataMap) {
        String ufilename;
        String pfilename = (String)dataMap.get("processfilename");
        if (StringUtils.isNotBlank((CharSequence)pfilename) && new File(pfilename).equals(pfile) && StringUtils.isNotBlank((CharSequence)(ufilename = (String)dataMap.get("uploadfilename")))) {
            return ufilename;
        }
        return pfile.getName();
    }

    public String getProcessFilename() {
        return this._processfilename;
    }

    public String getProcessFilename(Map<String, Object> dataMap) {
        String pfilename = (String)dataMap.get("processfilename");
        if (StringUtils.isNotBlank((CharSequence)pfilename)) {
            return pfilename;
        }
        return this._processfilename;
    }

    public void setProcessFilename(String _processfilename) {
        this._processfilename = _processfilename;
    }

    public String getProcessDirname() {
        return this._processDirname;
    }

    public String getProcessDirname(Map<String, Object> dataMap) {
        String pdirname = (String)dataMap.get("processdirname");
        if (StringUtils.isNotBlank((CharSequence)pdirname)) {
            return pdirname;
        }
        return this._processDirname;
    }

    public void setProcessDirname(String _processDirname) {
        this._processDirname = _processDirname;
    }

    public String getProcessDirFilter() {
        return this._processDirfilter;
    }

    public String getProcessDirfilter(Map<String, Object> dataMap) {
        String pdirfilter = (String)dataMap.get("processdirfilter");
        if (StringUtils.isNotBlank((CharSequence)pdirfilter)) {
            return pdirfilter;
        }
        return this._processDirfilter;
    }

    public void setProcessDirFilter(String _processDirfilter) {
        this._processDirfilter = _processDirfilter;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setLockModel(boolean _isLockModel) {
        this._isLockModel = _isLockModel;
    }

    public String getModelId() {
        return this.modelid;
    }

    public void setModelId(String modelid) {
        this.modelid = modelid;
    }

    public String getMonitorBeanId() {
        return this.monitorbid;
    }

    public void setMonitorBeanId(String monitorbid) {
        this.monitorbid = monitorbid;
    }

    public AbstractDbUploadUpdateRunnableMonitor2 getMonitor() {
        return this.monitor;
    }

    public void setMonitor(AbstractDbUploadUpdateRunnableMonitor2 monitor) {
        this.monitor = monitor;
    }

    public void setErrorManager(JFCErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    @Override
    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        this.init(dataMap, p);
        this.startdate = new Date();
        File[] pfiles = null;
        pfiles = this.getProcessFile(dataMap, p);
        if (pfiles == null) {
            return "";
        }
        this.filecnt = 1;
        this.totalfilecnt = pfiles.length;
        IJfcjobstatus jobstatus = (IJfcjobstatus)p.request.getAttribute(IJfcjobstatus.class.getName());
        JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)p.appctx.getBean(JfcjobstatusRegistryService.class);
        this.message = new StringBuilder();
        StringBuilder errormessage = new StringBuilder();
        ArrayList<File> processfiles = null;
        String isAttachmentProcessfilesInMail = (String)dataMap.get("isAttachmentProcessfilesInMail");
        if (Boolean.valueOf(isAttachmentProcessfilesInMail).booleanValue()) {
            processfiles = new ArrayList<File>();
        }
        ArrayList<File> errorfiles = null;
        String isAttachmentErrorfilesInMail = (String)dataMap.get("isAttachmentErrorfilesInMail");
        if (Boolean.valueOf(isAttachmentErrorfilesInMail).booleanValue()) {
            errorfiles = new ArrayList<File>();
        }
        for (File pfile : pfiles) {
            if (jobstatus != null) {
                jobstatus.setStatustype(IJfcjobstatus.Statustype.Processing.toString());
                service.addInfo(jobstatus, "progressFileCount", Integer.toString(this.filecnt));
                service.addInfo(jobstatus, "maximumFileCount", Integer.toString(this.totalfilecnt));
                service.updateJfcjobstatus(p, jobstatus);
            }
            this.startfiledate = new Date();
            this.appendMessage("---------------------------------------------");
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.processing", pfile.toString(), p.locale);
            logger.info(msg);
            this.appendMessage(msg);
            File ppfile = this.renameProcessingFile(dataMap, p, pfile);
            if (ppfile == null) continue;
            try {
                String uploadfilename = this.getUploadFilename(pfile, dataMap);
                this.executeInternal0(ppfile, uploadfilename, dataMap, p);
                File processfile = this.monitor.getProcessFile();
                p.request.setAttribute("processfile", (Object)processfile);
                File errorfile = this.monitor.getErrorFile();
                p.request.setAttribute("errorfile", (Object)errorfile);
                this.postProcess(ppfile, pfile.getName(), dataMap, p);
                processfile = (File)p.request.getAttribute("processfile");
                errorfile = (File)p.request.getAttribute("errorfile");
                if (processfiles != null) {
                    processfiles.add(processfile);
                }
                if (errorfiles != null) {
                    errorfiles.add(errorfile);
                }
                if (jobstatus != null) {
                    if (this.filecnt == 1) {
                        service.addInfoFilename(jobstatus, "processfile", processfile.getName(), processfile);
                        service.addInfoFilename(jobstatus, "errorfile", errorfile.getName(), errorfile);
                    } else {
                        service.addInfoFilename(jobstatus, "processfile" + this.filecnt, processfile.getName(), processfile);
                        service.addInfoFilename(jobstatus, "errorfile" + this.filecnt, errorfile.getName(), errorfile);
                    }
                }
            }
            catch (JobExecutionException e) {
                logger.debug("occur Exception", (Throwable)e);
                msg = e.getMessage();
                logger.error(msg);
                this.appendMessage(msg);
                if (errormessage.length() > 0) {
                    errormessage.append("\n");
                }
                errormessage.append(msg);
                this.renameErrorFile(dataMap, p, ppfile, pfile.getName());
            }
            this.message.append("\n");
            ++this.filecnt;
        }
        ArrayList attachments = null;
        if (processfiles != null || errorfiles != null) {
            ArrayList attas = (ArrayList)dataMap.get(ATTACHMENT_FILES_DATAMAP_KEY);
            if (attas == null) {
                attas = new ArrayList();
                dataMap.put(ATTACHMENT_FILES_DATAMAP_KEY, attas);
            }
            attachments = attas;
        }
        if (processfiles != null) {
            this.addAttachments(processfiles, attachments);
        }
        if (errorfiles != null) {
            this.addAttachments(errorfiles, attachments);
        }
        if (errormessage.length() > 0) {
            this.setJobstatusErrorMessage(p, errormessage.toString());
        }
        return this.message.toString();
    }

    private void addAttachments(ArrayList<File> files, List<Attachment> attachments) {
        for (File file : files) {
            Attachment atta = new Attachment();
            atta.setOrder(attachments.size());
            atta.setFilename(file.getName());
            atta.setFilepath(file.toString());
            attachments.add(atta);
        }
    }

    public void setJobstatusErrorMessage(ActionParameter p, String errmsg) {
        IJfcjobstatus jobstatus = (IJfcjobstatus)p.request.getAttribute(IJfcjobstatus.class.getName());
        if (jobstatus == null) {
            return;
        }
        JfcjobstatusRegistryService service = (JfcjobstatusRegistryService)p.appctx.getBean(JfcjobstatusRegistryService.class);
        String nowerrmsg = service.getInfo(jobstatus, "errormessage");
        nowerrmsg = nowerrmsg == null ? errmsg : nowerrmsg + "\n" + errmsg;
        service.addInfo(jobstatus, "errormessage", nowerrmsg);
    }

    private File renameProcessingFile(Map<String, Object> dataMap, ActionParameter p, File pfile) {
        return this.renameFile(pfile, pfile.getName(), dataMap, p, "processingdir", "processingfilenameheader", "processingfilename", "processingfilenamefooter", ".processing", JFCUtils.getRValue("__jfc_common.uploadUpdateJob.renameProcessingFile.failedmessage", p.locale), false);
    }

    private File renameErrorFile(Map<String, Object> dataMap, ActionParameter p, File ppfile, String srcfilename) {
        return this.renameFile(ppfile, srcfilename, dataMap, p, "errordir", "errorfilenameheader", "errorfilename", "errorfilenamefooter", ".error", JFCUtils.getRValue("__jfc_common.uploadUpdateJob.renameErrorFile.failedmessage", p.locale), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal0(File pfile, String uploadfilename, Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        DbUploadUpdateRunnableMonitorManager manager = DbUploadUpdateRunnableMonitorManager.getInstance();
        if (!manager.checkMonitor(p, this.getStatus())) {
            throw new JobExecutionException(this.errorManager.getJfcerror("error.dbaccess.running", p.locale).getContent());
        }
        this.startdate = new Date();
        try {
            if (this.getMonitorBeanId() != null) {
                this.monitor = (AbstractDbUploadUpdateRunnableMonitor2)p.appctx.getBean(this.getMonitorBeanId());
            }
            this.monitor.setDeleteProcessFiles(this.isDeleteProcessFiles(dataMap, p));
            this.monitor.setUploadUpdateJob(true);
            long lastaccesstime = new Date().getTime();
            this.monitor.init(p, pfile, uploadfilename, null, null, lastaccesstime);
            manager.addMonitor(p, this.getStatus(), this.registLockModel(p), this.isLockModel(dataMap, p), this.monitor);
            this.execute(pfile, uploadfilename, dataMap, p);
            this.outputEndStatus(p);
        }
        finally {
            this.monitor.setEndStatus();
            manager.uncheckMonitor(p, this.getStatus());
        }
    }

    private void outputEndStatus(ActionParameter p) {
        Jfcinfo[] info;
        Jfcwarn[] warn;
        Jfcerror[] error;
        Object[] oa = new Object[]{this.monitor.getStartDate(), this.monitor.getEndDate(), this.monitor.getStatusString(), this.monitor.getProcessCount(), this.monitor.getInsertProcessCount(), this.monitor.getUpdateProcessCount(), this.monitor.getDeleteProcessCount(), this.monitor.getFailedProcessCount()};
        this.appendMessage("");
        this.appendMessage(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.results.1", oa, p.locale));
        this.appendMessage(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.results.2", oa, p.locale));
        Jfcerrors errors = this.monitor.getJfcerrors();
        for (Jfcerror c : error = errors.getJfcerror()) {
            this.appendMessage(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.results.errorheader", p.locale) + c.getContent());
        }
        for (Jfcwarn c : warn = errors.getJfcwarn()) {
            this.appendMessage(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.results.warnheader", p.locale) + c.getContent());
        }
        for (Jfcinfo c : info = errors.getJfcinfo()) {
            this.appendMessage(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.results.infoheader", p.locale) + c.getContent());
        }
        this.appendMessage("");
    }

    private void init(Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        String key = null;
        String value = null;
        try {
            key = "processdirfilter";
            value = this.getProcessDirfilter(dataMap);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this._processDirfilterPattern = Pattern.compile(value, 2);
            }
        }
        catch (RuntimeException e) {
            logger.debug("Runtime Exception", (Throwable)e);
            throw new JobExecutionException(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.illegal_jobparameter", key, value, p.locale));
        }
        String[] keys = new String[]{"processingdir", "processingfilenameheader", "processingfilename", "processingfilenamefooter", "errordir", "errorfilenameheader", "errorfilename", "errorfilenamefooter", "renamedir", "renamefilenameheader", "renamefilename", "renamefilenamefooter"};
        this.checkMessageFormat(dataMap, p, keys);
    }

    private void checkMessageFormat(Map<String, Object> dataMap, ActionParameter p, String[] keys) throws JobExecutionException {
        for (String key : keys) {
            String value = (String)dataMap.get(key);
            if (StringUtils.isBlank((CharSequence)value) || value.indexOf("{") < 0) continue;
            try {
                new MessageFormat(value).format(CheckMessageFormatTestData);
            }
            catch (RuntimeException e) {
                logger.debug("Runtime Exception", (Throwable)e);
                throw new JobExecutionException(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.illegal_jobparameter", key, value, p.locale));
            }
        }
    }

    private boolean isDeleteProcessFiles(Map<String, Object> dataMap, ActionParameter p) {
        String value;
        String mode = (String)dataMap.get("processedfilemode");
        return mode == null || !mode.equals("rename") || !StringUtils.isNotBlank((CharSequence)(value = (String)dataMap.get("renamedir")));
    }

    private File[] getProcessFile(Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        String pfilename = this.getProcessFilename(dataMap);
        if (StringUtils.isNotBlank((CharSequence)pfilename)) {
            File file = new File(pfilename);
            if (!file.exists()) {
                logger.info("No processfile " + file);
                return null;
            }
            return new File[]{file};
        }
        return this.getProcessFiles(dataMap, p);
    }

    protected File[] getProcessFiles(Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        String pdirname = this.getProcessDirname(dataMap);
        if (StringUtils.isBlank((CharSequence)pdirname)) {
            throw new JobExecutionException(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.nothing_processdirname", p.locale));
        }
        String pdirfilter = this.getProcessDirfilter(dataMap);
        File dir = new File(pdirname);
        File[] files = StringUtils.isBlank((CharSequence)pdirfilter) ? dir.listFiles() : dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                return UploadUpdateJob.this.acceptProcessDirFilter(file);
            }
        });
        if (files == null) {
            throw new JobExecutionException(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.failed_get_processdir", pdirname, p.locale));
        }
        if (files.length == 0) {
            logger.info("No processfile in processdir " + pdirname);
            return null;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return files;
    }

    protected boolean acceptProcessDirFilter(File file) {
        String name = file.getName();
        return this._processDirfilterPattern.matcher(name).matches();
    }

    private void execute(File file, String uploadfilename, Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        MultiPartForm multi = null;
        boolean isLockModel = this.isLockModel(dataMap, p);
        boolean isLockData = !isLockModel;
        LockObject lo = null;
        if (isLockModel) {
            lo = this.createLockModelObject(p);
        }
        boolean isStartMonitor = false;
        try {
            long lastaccesstime = new Date().getTime();
            p.request.setAttribute("__jfc_sessionid", (Object)p.request.getSession().getId());
            this.monitor.init(p, file, uploadfilename, multi, lo, lastaccesstime);
            this.monitor.setLockData(isLockData);
            try {
                this.monitor.readHeader();
            }
            catch (EOFException e) {
                logger.info("empty file " + file, (Throwable)e);
                throw new JobExecutionException(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.empty_file", p.locale).getContent());
            }
            catch (IOException e) {
                logger.info("failed read header " + file, (Throwable)e);
                throw new JobExecutionException(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.illegal_file", p.locale).getContent());
            }
            if (p.errors.sizeJfcerror() > 0) {
                Jfcerror[] error;
                logger.info("illegal header");
                for (Jfcerror c : error = p.errors.getJfcerror()) {
                    logger.info(c.getContent());
                    this.appendMessage(JFCUtils.getRValue("__jfc_common.uploadUpdateJob.results.errorheader", p.locale) + c.getContent());
                }
                throw new JobExecutionException(this.errorManager.getJfcerror("error.uploadUpdateProcessBean.illegal_header", p.locale).getContent());
            }
            isStartMonitor = true;
            this.monitor.run();
        }
        catch (Exception e) {
            logger.warn("failed to process", (Throwable)e);
            throw new JobExecutionException("Failed start process");
        }
        finally {
            if (!isStartMonitor) {
                this.monitor.processEnd();
            }
        }
    }

    private void postProcess(File file, String srcfilename, Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        String mode = (String)dataMap.get("processedfilemode");
        if (mode == null) {
            mode = "delete";
        }
        if (mode.equals("rename")) {
            if (this.rename(file, srcfilename, dataMap, p)) {
                return;
            }
        } else if (!mode.equals("delete")) {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.unknown_processedfilemode", mode, p.locale);
            logger.warn(msg);
            this.appendMessage(msg);
        }
        this.delete(file, dataMap, p);
    }

    private void appendMessage(String s) {
        this.message.append(s);
        this.message.append("\n");
    }

    private void delete(File file, Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        if (file.delete()) {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.delete.success", file.toString(), p.locale);
            logger.info(msg);
            this.appendMessage(msg);
        } else {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.delete.failed", file.toString(), p.locale);
            logger.warn(msg);
            this.appendMessage(msg);
        }
        this.showResultfile(p);
    }

    private void showResultfile(ActionParameter p) {
        File pfile = this.monitor.getProcessFile();
        File efile = this.monitor.getErrorFile();
        Object[] oa2 = new Object[]{pfile, efile};
        String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.show_resultfile", oa2, p.locale);
        logger.info(msg);
        this.appendMessage(msg);
        msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.show_errorfile", oa2, p.locale);
        logger.info(msg);
        this.appendMessage(msg);
    }

    private String filterFilename(String s) {
        return this.filterFilename(s, new Object[0]);
    }

    private String filterFilename(String s, Object[] oa1) {
        int i;
        if (StringUtils.isBlank((CharSequence)s)) {
            return s;
        }
        if (s.indexOf("{") < 0) {
            return s;
        }
        Object[] oa2 = new Object[]{this.startdate, this.startfiledate, this.filecnt, this.totalfilecnt};
        if (oa1 == null || oa1.length == 0) {
            return new MessageFormat(s).format(oa2);
        }
        Object[] oa = new Object[oa1.length + oa2.length];
        for (i = 0; i < oa2.length; ++i) {
            oa[i] = oa2[i];
        }
        for (i = 0; i < oa1.length; ++i) {
            oa[i + oa2.length] = oa1[i];
        }
        return new MessageFormat(s).format(oa);
    }

    private boolean rename(File file, String srcfilename, Map<String, Object> dataMap, ActionParameter p) throws JobExecutionException {
        String msg;
        if (this.renameProcessedFile(file, srcfilename, dataMap, p) == null) {
            return false;
        }
        File rdir = this.getRenameDir(file, dataMap, p);
        if (rdir == null) {
            this.showResultfile(p);
            return true;
        }
        File pfile = (File)p.request.getAttribute("processfile");
        Object[] oa1 = new Object[]{pfile, rdir};
        try {
            FileUtils.moveFileToDirectory((File)pfile, (File)rdir, (boolean)true);
            msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.rename.resultfile.success", oa1, p.locale);
            logger.info(msg);
            this.appendMessage(msg);
            pfile = new File(rdir, pfile.getName());
            p.request.setAttribute("processfile", (Object)pfile);
        }
        catch (IOException e) {
            logger.debug("occur Exception", (Throwable)e);
            msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.rename.resultfile.failed", oa1, p.locale);
            logger.warn(msg);
            this.appendMessage(msg);
        }
        File efile = (File)p.request.getAttribute("errorfile");
        Object[] oa2 = new Object[]{efile, rdir};
        try {
            FileUtils.moveFileToDirectory((File)efile, (File)rdir, (boolean)true);
            msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.rename.errorfile.success", oa2, p.locale);
            logger.info(msg);
            this.appendMessage(msg);
            efile = new File(rdir, efile.getName());
            p.request.setAttribute("errorfile", (Object)efile);
        }
        catch (IOException e) {
            logger.debug("occur Exception", (Throwable)e);
            msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.rename.errorfile.failed", oa2, p.locale);
            logger.warn(msg);
            this.appendMessage(msg);
        }
        return true;
    }

    private File getRenameDir(File file, Map<String, Object> dataMap, ActionParameter p) {
        String rdirname = (String)dataMap.get("renamedir");
        if (StringUtils.isBlank((CharSequence)(rdirname = this.filterFilename(rdirname)))) {
            return null;
        }
        return this.getRenameDir(file, rdirname, p);
    }

    private File getRenameDir(File file, String rdirname, ActionParameter p) {
        File rdir;
        try {
            rdir = JFCUtils.createFile(rdirname);
        }
        catch (IllegalStateException e) {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.rename.not_dir_renamedir", rdirname, p.locale);
            logger.warn(msg);
            this.appendMessage(msg);
            return null;
        }
        if (rdir == null) {
            rdir = new File(file.getParentFile(), rdirname);
        }
        if (!rdir.exists() && !rdir.mkdirs()) {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.rename.mkdirs_renamedir", rdir.toString(), p.locale);
            logger.warn(msg);
            this.appendMessage(msg);
            return null;
        }
        if (!rdir.isDirectory()) {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.rename.not_dir_renamedir", rdir.toString(), p.locale);
            logger.warn(msg);
            this.appendMessage(msg);
            return null;
        }
        return rdir;
    }

    private File renameProcessedFile(File file, String srcfilename, Map<String, Object> dataMap, ActionParameter p) {
        return this.renameFile(file, srcfilename, dataMap, p, "renamedir", "renamefilenameheader", "renamefilename", "renamefilenamefooter", ".processed", JFCUtils.getRValue("__jfc_common.uploadUpdateJob.renameProcessedFile.failedmessage", p.locale), true);
    }

    private File renameFile(File file, String srcfilename, Map<String, Object> dataMap, ActionParameter p, String dirkey, String headerkey, String filenamekey, String footerkey, String defaultfooter, String failedmessage, boolean isOutputSuccessMessage) {
        File dstfile;
        String rfilename;
        File rdir;
        boolean isChanged = false;
        String rdirname = (String)dataMap.get(dirkey);
        if (StringUtils.isNotBlank((CharSequence)(rdirname = this.filterFilename(rdirname)))) {
            rdir = this.getRenameDir(file, rdirname, p);
            if (rdir == null) {
                return null;
            }
            isChanged = true;
        } else {
            rdir = file.getParentFile();
        }
        StringBuilder fn = new StringBuilder();
        String rheader = (String)dataMap.get(headerkey);
        rheader = this.filterFilename(rheader);
        if (StringUtils.isNotBlank((CharSequence)rheader)) {
            fn.append(rheader);
            isChanged = true;
        }
        if (StringUtils.isNotBlank((CharSequence)(rfilename = (String)dataMap.get(filenamekey)))) {
            String ext;
            String namewoext;
            String name = srcfilename;
            int cnt = name.lastIndexOf(46);
            if (cnt >= 0) {
                namewoext = name.substring(0, cnt);
                ext = name.substring(cnt);
            } else {
                namewoext = name;
                ext = "";
            }
            Object[] oa = new Object[]{name, namewoext, ext};
            fn.append(this.filterFilename(rfilename, oa));
            isChanged = true;
        } else {
            fn.append(srcfilename);
        }
        String rfooter = (String)dataMap.get(footerkey);
        rfooter = this.filterFilename(rfooter);
        if (StringUtils.isNotBlank((CharSequence)rfooter)) {
            fn.append(rfooter);
            isChanged = true;
        }
        if (!isChanged) {
            fn.append(defaultfooter);
        }
        if (!this.renameFile(file, dstfile = new File(rdir, fn.toString()), failedmessage, isOutputSuccessMessage, p)) {
            return null;
        }
        return dstfile;
    }

    private boolean renameFile(File file, File dstfile, String failedmessage, boolean isOutputSuccessMessage, ActionParameter p) {
        Object[] oa = new Object[]{file, dstfile};
        if (dstfile.equals(file)) {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.renameFile.same_file", oa, p.locale) + failedmessage;
            logger.warn(msg);
            this.appendMessage(msg);
            return false;
        }
        if (dstfile.exists() && !dstfile.delete()) {
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.renameFile.failed_delete_dstfile", oa, p.locale) + failedmessage;
            logger.warn(msg);
            this.appendMessage(msg);
            return false;
        }
        try {
            FileUtils.moveFile((File)file, (File)dstfile);
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.renameFile.success", oa, p.locale);
            logger.info(msg);
            if (isOutputSuccessMessage) {
                this.appendMessage(msg);
            }
        }
        catch (IOException e) {
            logger.debug("occur Exception", (Throwable)e);
            String msg = JFCUtils.getRValue("__jfc_common.uploadUpdateJob.renameFile.failed", oa, p.locale) + failedmessage;
            logger.warn(msg);
            this.appendMessage(msg);
            return false;
        }
        return true;
    }

    public boolean isLockModel(Map<String, Object> dataMap, ActionParameter p) {
        String b = (String)dataMap.get("isLockModel");
        if (b != null) {
            return new Boolean(b);
        }
        return this._isLockModel;
    }

    protected LockObject createLockModelObject(ActionParameter p) throws JobExecutionException {
        LockManager lman = LockManagerFactory.getLockManager(p);
        LockObject lo = this.createLockObject(p, lman);
        if (lo == null) {
            String username = "";
            if (p.user != null) {
                username = p.user.getUsername();
            }
            Object[] ep = new Object[]{username};
            throw new JobExecutionException(this.errorManager.getJfcerror("error.parameter.invalid", ep, p.locale).getContent());
        }
        LockObject _lo = lman.addLockObject(lo);
        if (_lo != null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00069), LogCodeManager.getMessage(LogCode.JFC00069, p.user, lo.toString()));
            logger.debug("_lo (locked object) is " + _lo);
            Object[] ep = new Object[]{_lo.getUsername()};
            throw new JobExecutionException(this.errorManager.getJfcerror("error.dbaccess.lock", ep, p.locale).getContent());
        }
        logger.debug(lo + " LockManager locks the object successfully.");
        return lo;
    }

    public LockObject createLockObject(ActionParameter p, LockManager lman) {
        String modelname = this.registLockModel(p);
        if (modelname != null) {
            HttpSession session_ = p.request.getSession();
            String sessionid = session_.getId();
            LockObject lo = lman.createLockObjectForAll(modelname, sessionid, p.user);
            logger.debug("lo is " + lo);
            return lo;
        }
        return null;
    }

    public String registLockModel(ActionParameter p) {
        return this.modelid;
    }
}

