/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jp.jasminesoft.jfc.job.FileProcessTask;
import jp.jasminesoft.util.StringUtil;

public class ZipArchiveTask
extends FileProcessTask {
    private static final int DEFAULT_BUFSIZE = 4096;
    private int bufsize;
    protected boolean isRemoveAfterZipProcess = true;

    public int getBufsize() {
        return this.bufsize;
    }

    public void setBufsize(int bufsize) {
        this.bufsize = bufsize;
    }

    public boolean getRemove() {
        return this.isRemoveAfterZipProcess;
    }

    public void setRemove(boolean isRemoveAfterZipProcess) {
        this.isRemoveAfterZipProcess = isRemoveAfterZipProcess;
    }

    @Override
    protected boolean isIgnoreZeroSizeFile() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        if (this.bufsize <= 0) {
            this.bufsize = 4096;
        }
    }

    @Override
    protected String getParameterMessage() {
        StringBuilder sb = new StringBuilder(super.getParameterMessage());
        sb.append(" remove=" + this.isRemoveAfterZipProcess + ", bufsize=" + this.bufsize);
        return sb.toString();
    }

    @Override
    protected boolean processFile(File file) {
        boolean ret = false;
        if (this.archiveFile(file, this.baseDirectory)) {
            this.processedFileList.add(this.getFilenameWithoutBaseDirectory(file));
            ret = true;
        } else {
            this.errorFileList.add(this.getFilenameWithoutBaseDirectory(file));
        }
        return ret;
    }

    @Override
    protected boolean processDirectory(File file) {
        boolean ret = false;
        if (this.archiveDirectory(file, this.baseDirectory)) {
            this.processedFileList.add(this.getFilenameWithoutBaseDirectory(file));
            if (this.isRemoveAfterZipProcess) {
                file.delete();
            }
            ret = true;
        } else {
            this.errorFileList.add(this.getFilenameWithoutBaseDirectory(file));
        }
        return ret;
    }

    private String createZipEntryName(File file) {
        String name = this.getFilenameWithoutBaseDirectory(file);
        name = StringUtil.replaceAll((String)name, (String)File.separator, (String)"/");
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archiveFile(File file, File baseDirectory) {
        boolean status = true;
        ZipOutputStream zo = null;
        String zfilename = file.getAbsolutePath() + ".zip";
        try {
            zo = new ZipOutputStream(new FileOutputStream(zfilename));
            status = this.archiveFile0(file, baseDirectory, zo);
        }
        catch (FileNotFoundException e) {
            status = false;
        }
        finally {
            if (zo != null) {
                try {
                    zo.close();
                }
                catch (IOException iOException) {}
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archiveDirectory(File dir, File baseDirectory) {
        String zfilename = dir.getAbsolutePath() + ".zip";
        ZipOutputStream zo = null;
        boolean status = true;
        try {
            zo = new ZipOutputStream(new FileOutputStream(zfilename));
            boolean status0 = this.archiveDirectory(dir, zfilename, baseDirectory, zo);
            if (!status0) {
                status = false;
            }
        }
        catch (FileNotFoundException e) {
            status = false;
        }
        finally {
            if (zo != null) {
                try {
                    zo.close();
                }
                catch (IOException iOException) {}
            }
        }
        return status;
    }

    private boolean archiveDirectory(File dir, String zfilename, File baseDirectory, ZipOutputStream zo) {
        String[] lists;
        boolean status = true;
        for (String name : lists = dir.list()) {
            boolean status0 = true;
            File file = new File(dir.getAbsolutePath() + File.separator + name);
            if (file.isDirectory()) {
                status0 = this.archiveDirectory(file, zfilename, baseDirectory, zo);
            } else if (file.isFile()) {
                status0 = this.archiveFile0(file, baseDirectory, zo);
            }
            if (!status0) {
                status = false;
            }
            if (!this.isRemoveAfterZipProcess) continue;
            file.delete();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archiveFile0(File file, File baseDirectory, ZipOutputStream zo) {
        BufferedInputStream in = null;
        boolean status = true;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            String entryName = this.createZipEntryName(file);
            zo.putNextEntry(new ZipEntry(entryName));
            byte[] b = new byte[this.bufsize];
            int len = 0;
            while ((len = in.read(b)) != -1) {
                zo.write(b, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            status = false;
        }
        catch (IOException e) {
            status = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (this.isRemoveAfterZipProcess) {
                file.delete();
            }
        }
        return status;
    }
}

