/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.menu;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.core.util.AbstractDomainSupport;
import jp.jasminesoft.jfc.menu.IMenuChoice;
import jp.jasminesoft.jfc.menu.Img;
import jp.jasminesoft.jfc.menu.Item;
import jp.jasminesoft.jfc.menu.Menu;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.jfc.menu.Permission;
import jp.jasminesoft.jfc.menu.RVisitorBase;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateMyMenu
extends RVisitorBase {
    private static final Logger logger = LogManager.getLogger(CreateMyMenu.class);
    User user = null;
    String locale_str = null;
    Menubar menubar = null;
    Stack stack = null;
    CheckPermission checkp = null;
    Map paramMap = null;
    String encoding;
    static int count = 0;

    public CreateMyMenu(User user, String encoding, String locale, Map paramMap) {
        this.user = user;
        if (locale == null) {
            jp.jasminesoft.jfc.model.preference.Item item;
            if (user != null && (item = user.getPreferenceItem("locale")) != null) {
                this.locale_str = item.getContent();
            }
        } else {
            this.locale_str = locale;
        }
        if (this.locale_str == null || this.locale_str.length() == 0) {
            this.locale_str = JFCUtils.getLocaleString();
        }
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        this.encoding = encoding;
        this.paramMap = paramMap;
        this.menubar = new Menubar();
        this.stack = new Stack();
        this.checkp = CheckPermissionFactory.getCheckPermission();
    }

    @Override
    public boolean enter(Menubar visitable) {
        return true;
    }

    @Override
    public void leave(Menubar visitable) {
        logger.debug("leave(Menubar), stack:" + this.stack);
        int size = this.stack.size();
        boolean illegalFlag = false;
        for (int i = 0; i < size; ++i) {
            Object o = this.stack.elementAt(i);
            if (o instanceof Menu) {
                Menu menu = (Menu)o;
                IMenuChoice[] choice = menu.getContent();
                if (choice == null || choice.length <= 0) continue;
                this.menubar.addMenu((Menu)o);
                continue;
            }
            illegalFlag = true;
        }
        if (illegalFlag) {
            logger.debug((Object)this.stack);
        }
        this.stack.clear();
        this.stack = null;
    }

    @Override
    public boolean enter(Menu visitable) {
        Menu menu = new Menu();
        String rkey = visitable.getTitle();
        if (rkey != null && rkey.startsWith("__jfc_menutitle")) {
            String rvalue = JFCUtils.getRValue(rkey, this.locale_str);
            menu.setTitle(JFCUtils.replaceCRExpression(rvalue));
        } else {
            menu.setTitle(rkey);
        }
        menu.setImg(visitable.getImg());
        menu.setOrder(visitable.getOrder());
        menu.setColor(visitable.getColor());
        menu.setLabelcolor(visitable.getLabelcolor());
        rkey = visitable.getTooltip();
        if (rkey != null && rkey.startsWith("__jfc_menutooltip")) {
            menu.setTooltip(JFCUtils.getRValue(rkey, this.locale_str));
        } else {
            menu.setTooltip(rkey);
        }
        menu.setIconClass(visitable.getIconClass());
        this.stack.push(menu);
        this.stack.push(new Sentinel());
        logger.debug("enter(Menu), stack:" + this.stack);
        return true;
    }

    @Override
    public void leave(Menu visitable) {
        logger.debug("leave(Menu), stack:" + this.stack);
        ArrayList list = new ArrayList();
        Object o = null;
        boolean validFlag = true;
        while (true) {
            try {
                o = this.stack.pop();
            }
            catch (EmptyStackException e) {
                validFlag = false;
                break;
            }
            if (o instanceof Sentinel) break;
            list.add(o);
        }
        if (!validFlag || this.stack.size() == 0) {
            logger.warn("Invalid. " + list);
            return;
        }
        if (list.size() == 0) {
            o = this.stack.pop();
            return;
        }
        o = this.stack.peek();
        if (!(o instanceof Menu)) {
            logger.debug(o + " is not menu object.");
            return;
        }
        Menu menu = (Menu)o;
        for (int i = list.size() - 1; i >= 0; --i) {
            menu.addContent((IMenuChoice)list.get(i));
        }
        list.clear();
    }

    @Override
    public boolean enter(Img visitable) {
        return true;
    }

    @Override
    public void leave(Img visitable) {
    }

    @Override
    public boolean enter(Item visitable) {
        Permission[] permission = visitable.getPermission();
        if (this.isPermit(permission)) {
            Item item = new Item();
            item.setName(visitable.getName());
            String rkey = visitable.getDesc();
            if (rkey != null && rkey.startsWith("__jfc_menu")) {
                String rvalue = JFCUtils.getRValue(rkey, this.locale_str);
                item.setDesc(JFCUtils.replaceCRExpression(rvalue));
            } else {
                item.setDesc(rkey);
            }
            item.setForward(visitable.getForward());
            item.setOrder(visitable.getOrder());
            item.setColor(visitable.getColor());
            item.setLabelcolor(visitable.getLabelcolor());
            item.setUrl(this.addParameter(visitable.getUrl()));
            if (visitable.getTarget() != null) {
                item.setTarget(visitable.getTarget());
            }
            if ((rkey = visitable.getTooltip()) != null && rkey.startsWith("__jfc_menutooltip")) {
                item.setTooltip(JFCUtils.getRValue(rkey, this.locale_str));
            } else {
                item.setTooltip(rkey);
            }
            item.setImg(visitable.getImg());
            item.setIconClass(visitable.getIconClass());
            this.stack.push(item);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("enter(Item), stack:" + this.stack);
        }
        return true;
    }

    @Override
    public void leave(Item visitable) {
    }

    @Override
    public boolean enter(Permission visitable) {
        return true;
    }

    @Override
    public void leave(Permission visitable) {
    }

    private boolean isPermit(Permission[] permission) {
        boolean ret = true;
        if (permission == null) {
            return ret;
        }
        for (int i = 0; i < permission.length; ++i) {
            String name = permission[i].getName();
            String[] action = permission[i].getAction();
            HashSet<String> set = new HashSet<String>();
            if (action != null) {
                for (int j = 0; j < action.length; ++j) {
                    set.add(action[j]);
                }
            }
            StringBuffer sb = new StringBuffer();
            String[] as = set.toArray(new String[0]);
            for (int k = 0; k < as.length; ++k) {
                sb.append(as[k]);
                if (k >= as.length - 1) continue;
                sb.append(",");
            }
            String actions = sb.toString();
            JFCAppPermission perm = new JFCAppPermission(name, actions);
            ret = this.checkp.process(this.user, perm);
            if (ret) break;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addParameter(String url) {
        if (url == null) {
            return null;
        }
        url = this.replaceSpecificPattern(url);
        if (this.paramMap == null || this.paramMap.size() == 0) {
            return url;
        }
        StringBuffer sb = new StringBuffer(url);
        sb.append("?");
        boolean firstFlag = true;
        for (String key : this.paramMap.keySet()) {
            String value = (String)this.paramMap.get(key);
            if (key == null || key.length() <= 0) continue;
            if (!firstFlag) {
                sb.append("&");
            } else {
                firstFlag = false;
            }
            try {
                key = WebStringEncodeUtilities.encodeString((String)key, (String)this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            finally {
                sb.append(key);
            }
            sb.append("=");
            value = value == null ? "" : value;
            try {
                value = WebStringEncodeUtilities.encodeString((String)value, (String)this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            continue;
            finally {
                sb.append(value);
            }
        }
        return sb.toString();
    }

    private String replaceSpecificPattern(String url) {
        if (url.indexOf("${") < 0) {
            return url;
        }
        url = StringUtil.replaceAll((String)url, (String)"${username}", (String)this.user.getUsername());
        AbstractDomainSupport domainSupport = (AbstractDomainSupport)this.user.getApplicationContext().getBean("DomainSupport", AbstractDomainSupport.class);
        for (Map.Entry<String, String> entry : domainSupport.domainUrls().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            url = url.replace("${" + entry.getKey() + "}", entry.getValue());
            try {
                url = new URI(url).normalize().toString();
            }
            catch (URISyntaxException e) {
                logger.warn("Failed to nomalize url: " + url);
            }
        }
        return url;
    }

    public Menubar getMenubar() {
        return this.menubar;
    }

    static class Sentinel {
        Sentinel() {
        }

        public String toString() {
            return "<sentinel/>";
        }
    }
}

