/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.menu;

import java.util.Arrays;
import java.util.Comparator;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.menu.IMenuChoice;
import jp.jasminesoft.jfc.menu.Item;
import jp.jasminesoft.jfc.menu.Menu;
import jp.jasminesoft.jfc.menu.Menubar;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFCAppSubmenu {
    private static JFCAppSubmenu _instance = new JFCAppSubmenu();
    public static final int DEFAULT_ITEMNUM_IN_1PAGE = 15;
    private static final Logger logger = LogManager.getLogger();
    private int countNullMenuItemId = 0;

    private JFCAppSubmenu() {
    }

    public static JFCAppSubmenu getInstance() {
        return _instance;
    }

    public String create(User user, Menubar menubar, String jfc_locale) {
        StringBuilder sb = new StringBuilder();
        Menu[] menus = menubar.getMenu();
        if (jfc_locale == null || jfc_locale.length() == 0) {
            jfc_locale = JFCUtils.getLocaleString();
        }
        int menuNo = 1;
        for (Menu menu : menus) {
            String parentId = "submenu_parent" + menuNo;
            String childId = "submenu_child_parent" + menuNo;
            sb.append("<div id=\"").append(parentId).append("\" data-dojo-type=\"dijit/PopupMenuBarItem\">");
            sb.append("<span>").append(menu.getTitle()).append("</span>");
            sb.append("<div id=\"").append(childId).append("\" data-dojo-type=\"dijit/Menu\">");
            int subMenuNo = 1;
            IMenuChoice[] imcs = menu.getContent();
            if (imcs != null && imcs.length > 0) {
                Arrays.sort(imcs, new MenuComparator());
                for (IMenuChoice imc : imcs) {
                    if (imc instanceof Item) {
                        this.process((Item)imc, menuNo, sb);
                        continue;
                    }
                    if (!(imc instanceof Menu)) continue;
                    Menu menu0 = (Menu)imc;
                    this.process(menu0, menu0.getTitle(), 0, menuNo, subMenuNo++, jfc_locale, sb);
                }
            }
            sb.append("</div></div>");
            ++menuNo;
        }
        return sb.toString();
    }

    private void process(Item item, int menuNo, StringBuilder sb) {
        String id;
        String location = null;
        String url = item.getUrl();
        String name = item.getName();
        if (name == null) {
            ++this.countNullMenuItemId;
            id = "submenu_childurl_" + Long.toString(this.countNullMenuItemId);
        } else {
            id = "submenu_child_" + name;
        }
        location = url != null && url.length() > 0 ? url : "mainMenu.do?name=" + name;
        sb.append("<div id=\"").append(id).append("\" data-dojo-type=\"dijit/MenuItem\" onClick=\"");
        if (item.getTarget() == null) {
            sb.append("goPage('");
            sb.append(StringEscapeUtils.escapeHtml4((String)location));
            sb.append("');");
        } else {
            sb.append("openPage('");
            sb.append(StringEscapeUtils.escapeHtml4((String)location));
            sb.append("', ");
            if (item.getTarget().equals("_blank")) {
                sb.append("null");
            } else {
                sb.append(item.getTarget());
            }
            sb.append(");");
        }
        sb.append("\">");
        String desc = item.getDesc();
        if (desc != null && desc.length() > 0) {
            sb.append(desc);
        } else {
            sb.append(name);
        }
        sb.append("</div>");
    }

    private void process(Menu menu, String title, int pagenum, int menuNo, int subMenuNo, String jfc_locale, StringBuilder sb) {
        sb.append("<div data-dojo-type=\"dijit/PopupMenuItem\">");
        sb.append("<span>").append(title).append("</span>");
        sb.append("<div data-dojo-type=\"dijit/Menu\">");
        int nestedSubMenuNo = 1;
        IMenuChoice[] imcs = menu.getContent();
        if (imcs != null && imcs.length > 0) {
            Arrays.sort(imcs, new MenuComparator());
            for (int i = 0; i < imcs.length; ++i) {
                if (i < pagenum) continue;
                IMenuChoice imc = imcs[i];
                if (imc instanceof Item) {
                    this.process((Item)imc, menuNo, sb);
                    continue;
                }
                if (!(imc instanceof Menu)) continue;
                Menu menu0 = (Menu)imc;
                this.process(menu0, menu0.getTitle(), 0, menuNo, nestedSubMenuNo++, jfc_locale, sb);
            }
        }
        sb.append("</div></div>");
    }

    static class MenuComparator<T extends IMenuChoice>
    implements Comparator<T> {
        MenuComparator() {
        }

        @Override
        public int compare(T m1, T m2) {
            return m1.getOrder() - m2.getOrder();
        }
    }
}

