/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.menu;

import jp.jasminesoft.jfc.menu.IRNode;
import jp.jasminesoft.jfc.menu.IRVisitable;
import jp.jasminesoft.jfc.menu.IRVisitor;

public final class URVisitor {
    public static void traverse(IRNode node, IRVisitor visitor) {
        URVisitor.traverseDepth(node, visitor);
    }

    public static void traverseDepth(IRNode node, IRVisitor visitor) {
        IRVisitable visitable = (IRVisitable)((Object)node);
        if (visitable.enter(visitor)) {
            URVisitor.traverseDepthChildren(node, visitor);
            visitable.leave(visitor);
        }
    }

    public static void traverseDepthChildren(IRNode node, IRVisitor visitor) {
        URVisitor.traverseDepthChildren(node.rGetRNodes(), visitor);
    }

    public static void traverseDepthChildren(IRNode[] children, IRVisitor visitor) {
        for (int i = 0; i < children.length; ++i) {
            URVisitor.traverseDepth(children[i], visitor);
        }
    }

    public static void traverseBreadth(IRNode node, IRVisitor visitor) {
        IRVisitable visitable = (IRVisitable)((Object)node);
        if (visitable.enter(visitor)) {
            URVisitor.traverseBreadthChildren(node, visitor);
        }
        visitable.leave(visitor);
    }

    public static void traverseBreadthChildren(IRNode node, IRVisitor visitor) {
        int i;
        IRNode[] children = node.rGetRNodes();
        boolean[] enterResult = new boolean[children.length];
        for (i = 0; i < children.length; ++i) {
            IRVisitable visitable = (IRVisitable)((Object)children[i]);
            enterResult[i] = visitable.enter(visitor);
            visitable.leave(visitor);
        }
        for (i = 0; i < children.length; ++i) {
            IRNode child = children[i];
            if (!enterResult[i]) continue;
            URVisitor.traverseBreadthChildren(child, visitor);
        }
    }
}

