/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.meta;

import java.lang.reflect.Field;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.ListMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerMeta<C extends ContainerBase<C>>
implements ListMeta {
    private static final Logger logger = LogManager.getLogger(ContainerMeta.class);
    protected final EntityMeta<?> entityMeta;
    protected final Class<C> containerClass;
    protected final String name;
    protected final String table;

    public ContainerMeta(EntityMeta<?> entityMeta, Class<C> containerClass, String name, String table) {
        this.entityMeta = entityMeta;
        this.containerClass = containerClass;
        this.name = name;
        this.table = table;
    }

    public EntityMeta<?> entityMeta() {
        return this.entityMeta;
    }

    public Class<C> containerClass() {
        return this.containerClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String table() {
        return this.table;
    }

    public Class<C> getTypeClass() {
        return ClassUtils.getTypeClass(this);
    }

    public String itemName() {
        for (Field field : this.entityMeta().getClass().getFields()) {
            try {
                Object object = field.get(this.entityMeta());
                if (!(object instanceof ContainerMeta)) continue;
                ContainerMeta containerMeta = (ContainerMeta)object;
                if (!this.name().equals(containerMeta.name())) continue;
                return field.getName();
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        throw new IllegalStateException("Container name not found.");
    }
}

