/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.migratedb.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import jp.jasminesoft.jfc.migratedb.AbortException;
import jp.jasminesoft.jfc.migratedb.DBInfo;
import jp.jasminesoft.jfc.migratedb.DDLHistFile;
import jp.jasminesoft.jfc.migratedb.Version;
import jp.jasminesoft.jfc.migratedb.command.Command;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;

public class MigrateCommand
implements Command {
    private static final Logger logger = LogManager.getLogger((String)MigrateCommand.class.getName());

    @Override
    public void execute(DBInfo dbInfo, Path migratedbDir) {
        this.execute(dbInfo, migratedbDir, null);
    }

    public void execute(DBInfo dbInfo, Path migratedbDir, String allSQLContent) {
        logger.info("start migrate");
        Version version = new Version();
        logger.info("version: " + version);
        Path prevDDL = DDLHistFile.findLast(migratedbDir).getPath();
        logger.info("prevDDL: " + prevDDL);
        Path newDDL = DDLHistFile.create(version, migratedbDir, allSQLContent).getPath();
        logger.info("newDDL: " + newDDL);
        Path diffDir = migratedbDir.resolve("diff");
        this.createDiffFile(diffDir, version, dbInfo, prevDDL, newDDL);
        try {
            Flyway flyway = Flyway.configure().dataSource(dbInfo.dataSource()).table(dbInfo.table()).cleanDisabled(true).locations(new String[]{"filesystem:" + diffDir.toString()}).load();
            flyway.migrate();
        }
        catch (FlywayException ex) {
            throw new AbortException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u79fb\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        logger.info("end migrate");
    }

    private void createDiffFile(Path ddlDiffDir, Version version, DBInfo dbInfo, Path prevDDL, Path newDDL) {
        Path diffFile = ddlDiffDir.resolve("V" + version + "__.sql");
        try {
            if (Files.notExists(ddlDiffDir, new LinkOption[0])) {
                Files.createDirectory(ddlDiffDir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new AbortException("Error: can't create directory " + ddlDiffDir);
        }
        String dbType = dbInfo.getDbType();
        try {
            ProcessBuilder pb = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new ProcessBuilder("ddldiff.exe", dbType, prevDDL.toString(), newDDL.toString()) : new ProcessBuilder("./ddldiff", dbType, prevDDL.toString(), newDDL.toString());
            pb.redirectOutput(diffFile.toFile());
            Process process = pb.start();
            int result = process.waitFor();
            if (result != 0) {
                throw new AbortException("Error: ddldiff terminated with an incorrect exit code " + result);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException("Error: ddldiff terminated abnormally", ex);
        }
    }
}

