/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.xml.bind.JAXB;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.core.support.xml.DomUtils;
import jp.jasminesoft.jfc.model.RPathList;
import jp.jasminesoft.jfc.model.RStack;
import jp.jasminesoft.jfc.model.URelaxer;
import jp.jasminesoft.util.ClassUtils;
import jp.jasminesoft.util.SourceGeneratorUtil;
import org.apache.commons.beanutils.MethodUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class PresentationBase<T extends PresentationBase<T>> {
    public abstract void setup(RPathList var1);

    public void setup(Map map) {
        this.setup(new RPathList(map));
    }

    protected void setupAttributeString(RPathList paths, String itemname, String accessor) {
        String string = paths.getValue(itemname);
        if (string != null) {
            String setter = SourceGeneratorUtil.setterMethod((String)accessor);
            try {
                MethodUtils.invokeMethod((Object)this, (String)setter, (Object)string);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void setupSingleString(RPathList paths, String itemname, String accessor) {
        String string = paths.getValue(itemname);
        if (string != null) {
            String setter = SourceGeneratorUtil.setterMethod((String)accessor);
            try {
                MethodUtils.invokeMethod((Object)this, (String)setter, (Object)string);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void setupMultipleString(RPathList paths, String itemname, String accessor) {
        String adder = SourceGeneratorUtil.adderMethod((String)accessor);
        String[] strings = paths.getValues(itemname);
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            try {
                MethodUtils.invokeMethod((Object)this, (String)adder, (Object)string);
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected <C> void setupSingleValue(RPathList paths, String itemname, Class<C> clazz) {
        if (paths.hasNode(itemname)) {
            String setter = SourceGeneratorUtil.setterMethod((String)itemname);
            Object ref = ClassUtils.newInstance(clazz);
            try {
                MethodUtils.invokeMethod((Object)ref, (String)"setup", (Object)paths);
                MethodUtils.invokeMethod((Object)this, (String)setter, (Object)ref);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected <C> void setupMultipleValue(RPathList paths, String itemname, Class<C> clazz) {
        String adder = SourceGeneratorUtil.adderMethod((String)itemname);
        RPathList[] pathLists = paths.getRPathLists(itemname);
        for (int i = 0; i < pathLists.length; ++i) {
            Object ref = ClassUtils.newInstance(clazz);
            try {
                MethodUtils.invokeMethod((Object)ref, (String)"setup", (Object)pathLists[i]);
                MethodUtils.invokeMethod((Object)this, (String)adder, (Object)ref);
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public abstract Object plGet(String var1);

    public String plGetAsString(String path) {
        return URelaxer.getString(this.plGet(path));
    }

    public void plSet(String path, Object value) {
        boolean isLeaf = RPathList.isLeaf(path);
        String contextName = RPathList.getCurrentContextName(path);
        int index = RPathList.getCurrentContextIndex(path);
        String nextPath = RPathList.getNextPath(path);
        this.plSet0(path, value, isLeaf, contextName, index, nextPath);
    }

    public abstract void plSet0(String var1, Object var2, boolean var3, String var4, int var5, String var6);

    public void plAdd(String path, Object value) {
        boolean isLeaf = RPathList.isLeaf(path);
        String contextName = RPathList.getCurrentContextName(path);
        int index = RPathList.getCurrentContextIndex(path);
        String nextPath = RPathList.getNextPath(path);
        this.plAdd0(path, value, isLeaf, contextName, index, nextPath);
    }

    public abstract void plAdd0(String var1, Object var2, boolean var3, String var4, int var5, String var6);

    public void plSetByString(String path, String value) {
        boolean isLeaf = RPathList.isLeaf(path);
        String contextName = RPathList.getCurrentContextName(path);
        int index = RPathList.getCurrentContextIndex(path);
        String nextPath = RPathList.getNextPath(path);
        this.plSetByString0(path, value, isLeaf, contextName, index, nextPath);
    }

    public abstract void plSetByString0(String var1, String var2, boolean var3, String var4, int var5, String var6);

    public void plAddByString(String path, String value) {
        boolean isLeaf = RPathList.isLeaf(path);
        String contextName = RPathList.getCurrentContextName(path);
        int index = RPathList.getCurrentContextIndex(path);
        String nextPath = RPathList.getNextPath(path);
        this.plAddByString0(path, value, isLeaf, contextName, index, nextPath);
    }

    public abstract void plAddByString0(String var1, String var2, boolean var3, String var4, int var5, String var6);

    public Document makeDocument() throws ParserConfigurationException {
        return DomUtils.makeDocument(this.toString());
    }

    public void makeElement(Node parent) {
        try {
            Document document = this.makeDocument();
            parent.appendChild(document.getDocumentElement());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public String makeTextDocument() {
        StringBuilder buffer = new StringBuilder();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuilder buffer) {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this, (Writer)writer);
        buffer.append(writer.toString());
    }

    public void makeTextElement(Writer buffer) throws IOException {
        JAXB.marshal((Object)this, (Writer)buffer);
    }

    public void makeTextElement(PrintWriter buffer) {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this, (Writer)writer);
        buffer.print(writer.toString());
    }

    public void makeTextAttribute(StringBuilder buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String toString() {
        return this.makeTextDocument();
    }

    public static boolean isMatch(Element element) {
        return false;
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PresentationBase.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PresentationBase.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }

    private static String getPresentationBaseString(PresentationBase o) {
        return o.makeTextDocument();
    }

    public int hashCode() {
        return PresentationBase.getPresentationBaseString(this).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        return PresentationBase.getPresentationBaseString(this).equals(PresentationBase.getPresentationBaseString((PresentationBase)o));
    }
}

