/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.analyzer;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.model.systemlog.LogCodeCondition;
import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.SystemlogCondition;
import jp.jasminesoft.jfc.model.systemlog.SystemlogKind;
import jp.jasminesoft.jfc.model.systemlog.SystemlogManager;
import jp.jasminesoft.jfc.model.systemlog.analyzer.LogAnalyzer;
import jp.jasminesoft.jfc.model.systemlog.analyzer.UserAction;
import jp.jasminesoft.jfc.model.systemlog.analyzer.UserActionType;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;
import jp.jasminesoft.jfc.model.systemlog.util.LogFilterPresets;
import jp.jasminesoft.jfc.model.systemlog.util.TimeSpanUtil;
import jp.jasminesoft.util.ExcelFunction;
import org.apache.commons.lang3.ArrayUtils;

public class LogAnalyzerImpl
implements LogAnalyzer {
    private SystemlogManager slman_;
    private SystemlogKind logkind;
    private static final SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public SystemlogManager getSystemlogManager() {
        return this.slman_;
    }

    @Override
    public void setSystemlogManager(SystemlogManager slman_) {
        this.slman_ = slman_;
    }

    @Override
    public SystemlogKind getSystemlogKind() {
        return this.logkind;
    }

    @Override
    public void setSystemlogKind(SystemlogKind logkind) {
        this.logkind = logkind;
    }

    @Override
    public List<UserAction> getActivities(String userId, LocalDate ld) {
        if (userId == null || userId.trim().length() < 1) {
            throw new IllegalArgumentException("UserID is required.");
        }
        if (ld == null) {
            throw new IllegalArgumentException("Date is required.");
        }
        Date[] fromTo = TimeSpanUtil.getDateDurationOfOneDay(ld);
        return this.getActivities(userId, fromTo[0], fromTo[1], true);
    }

    private List<UserAction> getActivities(String userId, Date dateTimeFrom, Date dateTimeTo, boolean consolidateLogs) {
        if (dateTimeFrom == null || dateTimeTo == null) {
            throw new IllegalArgumentException("Date/time to begin/end should be set.");
        }
        Date[] days = TimeSpanUtil.getDatesBetween(dateTimeFrom, dateTimeTo);
        ArrayList<UserAction> all = new ArrayList<UserAction>();
        for (Date targetday : days) {
            List<UserAction> allPerDay = this.getActivitiesPerDay(targetday, userId, dateTimeFrom, dateTimeTo, consolidateLogs);
            if (allPerDay == null || allPerDay.size() <= 0) continue;
            all.addAll(allPerDay);
        }
        return all;
    }

    @Override
    public List<String> getUserIds(LocalDate ld) {
        if (ld == null) {
            throw new IllegalArgumentException("Date is required.");
        }
        Date[] fromTo = TimeSpanUtil.getDateDurationOfOneDay(ld);
        String[] users = this.getUserIds(fromTo[0], fromTo[1]);
        return Arrays.asList(users);
    }

    private String[] getUserIds(Date dateTimeFrom, Date dateTimeTo) {
        if (dateTimeFrom == null || dateTimeTo == null) {
            throw new IllegalArgumentException("Date/time to begin/end should be set.");
        }
        Date[] days = TimeSpanUtil.getDatesBetween(dateTimeFrom, dateTimeTo);
        TreeSet userIds = new TreeSet();
        Arrays.asList(days).forEach(targetday -> {
            SystemlogCondition cond = new SystemlogCondition();
            cond.setBeginLogDate(dateTimeFrom);
            cond.setEndLogDate(dateTimeTo);
            cond.setTargetDay((Date)targetday);
            cond.setLogKind(this.logkind);
            LogFilter filter_notsyslog = LogFilterPresets.filterToRemoveSysMessage();
            cond.addLogFilter(filter_notsyslog);
            Systemlog[] logs = this.slman_.getLogData(cond);
            if (logs == null || logs.length < 1) {
                return;
            }
            Set userIdSet = Arrays.stream(logs).map(log -> log.getUsername()).filter(username -> username != null && username.trim().length() > 0).distinct().map(userId -> userId.indexOf("@") > 0 ? userId.substring(0, userId.indexOf("@")) : userId).collect(Collectors.toSet());
            userIds.addAll(userIdSet);
        });
        return userIds.toArray(new String[0]);
    }

    private List<UserAction> getActivitiesPerDay(Date targetday, String userId, Date dateTimeFrom, Date dateTimeTo, boolean consolidateLogs) {
        SystemlogCondition cond = new SystemlogCondition();
        cond.setBeginLogDate(dateTimeFrom);
        cond.setEndLogDate(dateTimeTo);
        cond.setTargetDay(targetday);
        cond.setLogKind(this.logkind);
        LogFilter filter_userid = LogFilterPresets.filterToPickupByUserId(userId);
        LogFilter filter_notsyslog = LogFilterPresets.filterToRemoveSysMessage();
        cond.addLogFilter(filter_userid);
        cond.addLogFilter(filter_notsyslog);
        Systemlog[] logs = this.slman_.getLogData(cond);
        if (logs == null || logs.length < 1) {
            return null;
        }
        List<UserAction> userActions = Arrays.stream(logs).map(log -> new UserAction(userId, (Systemlog)log)).filter(log -> log.getAction() != UserActionType.IGNORE).collect(Collectors.toList());
        if (consolidateLogs) {
            userActions = this.removeCompleteDuplicates(userActions);
        }
        return userActions;
    }

    private List<UserAction> removeCompleteDuplicates(List<UserAction> userActions) {
        Collection col = userActions.stream().collect(Collectors.toMap(elm -> elm.toString(), elm -> elm, (e1, e2) -> e1, LinkedHashMap::new)).values();
        return new ArrayList<UserAction>(col);
    }

    @Override
    public int[] getCountByMonth(Date from_day, Date to_day, LogCodeCondition logCode) {
        String yyyyMMdd;
        int LIMIT_SIZE = Integer.MAX_VALUE;
        HashMap<String, Integer> logonPerMonthMap = new HashMap<String, Integer>();
        SystemlogCondition cond = new SystemlogCondition();
        cond.setKeyword(logCode.getMessage());
        cond.setLogType("INFO");
        cond.setLogKind(this.logkind);
        Date now = new Date();
        String now_date = sf.format(now);
        to_day = ExcelFunction.MOVEDAY((Date)to_day, (int)1);
        Date d = from_day;
        while (d.before(to_day)) {
            int count = 0;
            if (!d.after(now)) {
                yyyyMMdd = sf.format(d);
                if (logonPerMonthMap.containsKey(yyyyMMdd) && !yyyyMMdd.equals(now_date)) {
                    count = (Integer)logonPerMonthMap.get(yyyyMMdd);
                } else {
                    Systemlog[] logdata_ary;
                    cond.setTargetDay(d);
                    cond.setBeginNumber(-1);
                    cond.setEndNumber(-1);
                    for (Systemlog logdata : logdata_ary = this.slman_.getLogData(cond, Integer.MAX_VALUE)) {
                        String yyyyMMdd0 = sf.format(logdata.getDateTime());
                        if (!logonPerMonthMap.containsKey(yyyyMMdd0)) {
                            count = 1;
                            logonPerMonthMap.put(yyyyMMdd0, count);
                            continue;
                        }
                        count = (Integer)logonPerMonthMap.get(yyyyMMdd0);
                        logonPerMonthMap.put(yyyyMMdd0, ++count);
                    }
                }
            }
            d = ExcelFunction.MOVEDAY((Date)d, (int)1);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        Date d2 = from_day;
        while (d2.before(to_day)) {
            yyyyMMdd = sf.format(d2);
            if (!logonPerMonthMap.containsKey(yyyyMMdd)) {
                list.add(0);
            } else {
                list.add((Integer)logonPerMonthMap.get(yyyyMMdd));
            }
            d2 = ExcelFunction.MOVEDAY((Date)d2, (int)1);
        }
        Integer[] ret = list.toArray(new Integer[list.size()]);
        return ArrayUtils.toPrimitive((Integer[])ret);
    }

    @Override
    public int[] getCountByDay(Date from_day, Date to_day, LogCodeCondition logCode) {
        int LIMIT_SIZE = Integer.MAX_VALUE;
        HashMap<String, int[]> logonPerDayMap = new HashMap<String, int[]>();
        SystemlogCondition cond = new SystemlogCondition();
        cond.setKeyword(logCode.getMessage());
        cond.setLogType("INFO");
        cond.setLogKind(this.logkind);
        int[] countByHour = new int[24];
        Date now = new Date();
        String now_date = sf.format(now);
        to_day = ExcelFunction.MOVEDAY((Date)to_day, (int)1);
        Date d = from_day;
        while (d.before(to_day)) {
            if (!d.after(now)) {
                String yyyyMMdd = sf.format(d);
                if (logonPerDayMap.containsKey(yyyyMMdd) && !yyyyMMdd.equals(now_date)) {
                    int[] countByHourOnTargetDay = (int[])logonPerDayMap.get(yyyyMMdd);
                    countByHour = this.mergeArray(countByHour, countByHourOnTargetDay);
                } else {
                    cond.setTargetDay(d);
                    cond.setBeginNumber(-1);
                    cond.setEndNumber(-1);
                    Systemlog[] logdata_ary = this.slman_.getLogData(cond, Integer.MAX_VALUE);
                    int[] countByHourOnTargetDay = new int[24];
                    for (Systemlog logdata : logdata_ary) {
                        int hour;
                        int n = hour = this.getHour(logdata.getDateTime());
                        countByHourOnTargetDay[n] = countByHourOnTargetDay[n] + 1;
                    }
                    logonPerDayMap.put(yyyyMMdd, countByHourOnTargetDay);
                    countByHour = this.mergeArray(countByHour, countByHourOnTargetDay);
                }
            }
            d = ExcelFunction.MOVEDAY((Date)d, (int)1);
        }
        return countByHour;
    }

    private int[] mergeArray(int[] src, int[] base) {
        for (int i = 0; i < src.length; ++i) {
            int n = i;
            base[n] = base[n] + src[i];
        }
        return base;
    }

    private int getHour(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int hour = cal.get(11) - 1;
        if (hour < 0) {
            hour = 23;
        }
        return hour;
    }
}

