/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.model.systemlog.filter;

import jp.jasminesoft.jfc.model.systemlog.Systemlog;
import jp.jasminesoft.jfc.model.systemlog.filter.LogFilter;

public class UsernameLogFilter
extends LogFilter {
    private String userName;
    private MatchType matchType;

    public UsernameLogFilter(String name, MatchType matchType) {
        if (name == null || name.trim().length() < 1) {
            throw new IllegalArgumentException("user name should not be empty.");
        }
        this.userName = name;
    }

    @Override
    public boolean accept(Systemlog log) {
        if (log.getUsername() == null) {
            return false;
        }
        if (this.matchType == MatchType.Prefix) {
            return log.getUsername().startsWith(this.userName);
        }
        if (this.matchType == MatchType.Exact) {
            return log.getUsername().equals(this.userName);
        }
        return log.getUsername().indexOf(this.userName) >= 0;
    }

    public static enum MatchType {
        Prefix,
        Exact,
        Partial;

    }
}

