/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.WorkbookReportGenerator;

public abstract class AbstractReportGenerator
implements WorkbookReportGenerator {
    protected static final int MAX_ROW_NUM = 65536;
    private Boolean setFailedParametersToWhiteSpace = Boolean.TRUE;
    private SimpleDateFormat dateFomatter = null;

    @Override
    public void setFailedParametersToWhiteSpace(Boolean tf) {
        this.setFailedParametersToWhiteSpace = tf;
    }

    @Override
    public Boolean isFailedParametersToWhiteSpace() {
        return this.setFailedParametersToWhiteSpace;
    }

    @Override
    public void setDateFormat(String formatPattern) {
        if (formatPattern != null && formatPattern.trim().length() > 0) {
            this.dateFomatter = new SimpleDateFormat(formatPattern, Locale.JAPAN);
        }
    }

    protected SimpleDateFormat getDateFormat() {
        return this.dateFomatter;
    }

    @Override
    public void generate(File templateFile, File outputFile, Map<String, Object> params) throws IOException, ReportGeneratorException {
        this.generate(templateFile, outputFile, params, null);
    }

    @Override
    public void generate(File templateFile, OutputStream out, Map<String, Object> params) throws IOException, ReportGeneratorException {
        this.generate(templateFile, out, params, null);
    }

    @Override
    public void generate(File templateFile, File outputFile, Map<String, Object> params, Map<String, String> typeparams) throws IOException, ReportGeneratorException {
        if (outputFile == null) {
            throw new IllegalArgumentException(LogCodeManager.getMessage(LogCode.JFC00243, new String[0]));
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));){
            this.generate(templateFile, bos, params, typeparams);
            bos.flush();
        }
    }

    @Override
    public void generate(File templateFile, OutputStream out, Map<String, Object> params, Map<String, String> typeparams) throws IOException, ReportGeneratorException {
        if (templateFile == null || out == null || params == null) {
            throw new IllegalArgumentException(LogCodeManager.getMessage(LogCode.JFC00243, new String[0]));
        }
        try (ReportWorkbook rw = this.createReportWorkbook(templateFile, out);){
            this.generate(rw, params, typeparams, 0);
            rw.write();
        }
    }

    @Override
    public abstract void generate(ReportWorkbook var1, Map<String, Object> var2, Map<String, String> var3, int var4) throws IOException, ReportGeneratorException;

    @Override
    public abstract ReportWorkbook createReportWorkbook(File var1, OutputStream var2) throws IOException;
}

