/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellValueReplacerBase {
    private static final Logger LOGGER = LogManager.getLogger((String)CellValueReplacerBase.class.getName());
    private static String PARAM_REGEX_PATTERN = "\\$\\{[^\\}]*\\}";
    private static Pattern PATTERN = Pattern.compile(PARAM_REGEX_PATTERN);
    private static String PARAM_PATTERN_PREFIX = "${";
    private Boolean set_failed_params_to_whitespace_ = Boolean.TRUE;
    private SimpleDateFormat date_formatter_ = null;

    protected CellValueReplacerBase(Boolean failed_params_flag, SimpleDateFormat formatter) {
        this.set_failed_params_to_whitespace_ = failed_params_flag;
        this.date_formatter_ = formatter;
    }

    protected String[] replaceCellValue(CellValueReplacerBaseCell aCell, Map<String, Object> params, Map<String, String> typeparams) {
        String oldCellValue;
        String[] keys = null;
        String rstring = aCell.getString();
        if (StringUtils.isBlank((CharSequence)rstring)) {
            return keys;
        }
        String string = oldCellValue = rstring != null ? rstring : "";
        if (rstring.indexOf("_jshfilename:image") > 0) {
            return keys;
        }
        if (StringUtils.contains((CharSequence)rstring, (CharSequence)"_jshBarcode")) {
            return keys;
        }
        String newCellValue = null;
        if (oldCellValue != null && oldCellValue.trim().length() > 0 && oldCellValue.indexOf(PARAM_PATTERN_PREFIX) >= 0) {
            String key_;
            block27: {
                key_ = this.getKeyElement(oldCellValue = oldCellValue.trim());
                Object obj = params.get(key_);
                if (obj instanceof String) {
                    newCellValue = (String)obj;
                } else if (obj instanceof StringBuilder) {
                    newCellValue = ((StringBuilder)obj).toString();
                } else if (obj instanceof String[]) {
                    String[] strs = (String[])obj;
                    newCellValue = this.stringArray2String(strs);
                } else if (obj != null) {
                    try {
                        Method method = obj.getClass().getMethod("getContentAsString", null);
                        Object ret = method.invoke(obj, (Object[])null);
                        if (ret instanceof String) {
                            newCellValue = (String)ret;
                        }
                    }
                    catch (Exception ignore) {
                        LOGGER.debug("Couldn't find the method: 'getContentAsString'. The key is " + oldCellValue + ": " + ignore.getMessage());
                        if (!LOGGER.isDebugEnabled()) break block27;
                        ignore.printStackTrace();
                    }
                }
            }
            keys = new String[]{key_};
            if (newCellValue == null || newCellValue.trim().length() < 1) {
                int i;
                Matcher matcher = PATTERN.matcher(oldCellValue);
                ArrayList<String> array = new ArrayList<String>();
                while (matcher.find()) {
                    array.add(matcher.group());
                }
                int num = array.size();
                if (num < 1) {
                    this.resetCellValue(aCell);
                    return keys;
                }
                String[] paramChank = new String[num];
                String[] replacedParamChank = new String[num];
                paramChank = array.toArray(paramChank);
                HashSet<String> keySet_ = new HashSet<String>();
                for (i = 0; i < paramChank.length; ++i) {
                    block28: {
                        key_ = this.getKeyElement(paramChank[i]);
                        keySet_.add(key_);
                        Object obj2 = params.get(key_);
                        if (obj2 instanceof String) {
                            replacedParamChank[i] = (String)obj2;
                        } else if (obj2 instanceof String[]) {
                            replacedParamChank[i] = this.stringArray2String((String[])obj2);
                        } else if (obj2 != null) {
                            try {
                                Method method = obj2.getClass().getMethod("getContentAsString", null);
                                Object ret = method.invoke(obj2, (Object[])null);
                                if (ret instanceof String) {
                                    replacedParamChank[i] = (String)ret;
                                }
                            }
                            catch (Exception ignore) {
                                LOGGER.debug("Couldn't find the method: 'getContentAsString'. The key is " + oldCellValue + ": " + ignore.getMessage());
                                if (!LOGGER.isDebugEnabled()) break block28;
                                ignore.printStackTrace();
                            }
                        }
                    }
                    if (replacedParamChank[i] != null && replacedParamChank[i].trim().length() >= 1) continue;
                    replacedParamChank[i] = Boolean.TRUE.equals(this.set_failed_params_to_whitespace_) ? "" : paramChank[i];
                }
                keySet_.add(keys[0]);
                keys = keySet_.toArray(new String[0]);
                newCellValue = oldCellValue;
                for (i = 0; i < paramChank.length; ++i) {
                    newCellValue = StringUtils.replace((String)newCellValue, (String)paramChank[i], (String)replacedParamChank[i]);
                }
            }
            this.applyCellValueAndType(aCell, newCellValue, typeparams);
        }
        return keys;
    }

    private void applyCellValueAndType(CellValueReplacerBaseCell aCell, String cellValue, Map<String, String> typeparams) {
        String key;
        String typeStr = null;
        String rstring = aCell.getString();
        String string = key = rstring != null ? CellValueReplacerBase.getPlaceHolderName(rstring) : null;
        if (typeparams != null && typeparams.size() > 0 && (typeStr = typeparams.get(this.getKeyElement(key))) != null) {
            typeStr = typeStr.trim();
        }
        if (typeStr == null || typeStr.length() < 1) {
            typeStr = "string";
        } else if ((typeStr.equalsIgnoreCase("date") || typeStr.equalsIgnoreCase("time") || typeStr.equalsIgnoreCase("dateTime")) && !this.isWagbyR6ExpressionKey(key)) {
            typeStr = "string";
        }
        if (typeStr.equalsIgnoreCase("int") || typeStr.equalsIgnoreCase("short") || typeStr.equalsIgnoreCase("float") || typeStr.equalsIgnoreCase("double") || typeStr.equalsIgnoreCase("long")) {
            if (StringUtils.isNotBlank((CharSequence)cellValue)) {
                try {
                    double value = Double.parseDouble(cellValue);
                    aCell.setNumericValue(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.debug(e.getMessage() + " was specified to '" + typeStr + "', but couldn't change. It will be changed to String format.");
                    if (LOGGER.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    aCell.setStringValue(cellValue);
                }
            } else {
                aCell.setStringValue(cellValue);
            }
        } else if (typeStr.equalsIgnoreCase("date") || typeStr.equalsIgnoreCase("time") || typeStr.equalsIgnoreCase("dateTime")) {
            Date date;
            block26: {
                date = null;
                if (this.date_formatter_ != null) {
                    try {
                        date = this.date_formatter_.parse(cellValue);
                    }
                    catch (ParseException e) {
                        LOGGER.debug(e.getMessage() + " was specified to '" + typeStr + "', but couldn't change. Use default date value for Excel.");
                        if (!LOGGER.isDebugEnabled()) break block26;
                        e.printStackTrace();
                    }
                }
            }
            if (date == null) {
                if (typeStr.equalsIgnoreCase("date")) {
                    date = DateTimeUtil.getDate((String)cellValue);
                } else if (typeStr.equalsIgnoreCase("time")) {
                    date = DateTimeUtil.getTimeWithFormat((String)cellValue);
                    if (date != null) {
                        Calendar now = Calendar.getInstance();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(date);
                        cal.set(1, now.get(1));
                        cal.set(2, now.get(2));
                        cal.set(5, now.get(5));
                        date = cal.getTime();
                    }
                } else if (typeStr.equalsIgnoreCase("dateTime")) {
                    date = DateTimeUtil.getDateTimeWithFormat((String)cellValue);
                }
            }
            if (date == null) {
                aCell.setStringValue(cellValue);
            } else {
                aCell.setDateValue(date);
            }
        } else {
            if (cellValue == null) {
                cellValue = "";
            }
            aCell.setStringValue(cellValue);
        }
    }

    public static String getPlaceHolderName(String s) {
        String ret;
        String lasttoken;
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        boolean appendMode = false;
        for (int i = 0; i < len; ++i) {
            char c2;
            char c = s.charAt(i);
            if (c == '$' && i < len - 1 && (c2 = s.charAt(i + 1)) == '{') {
                appendMode = true;
            }
            if (appendMode) {
                sb.append(c);
            }
            if (c != '}' || !appendMode) continue;
            appendMode = false;
            break;
        }
        if ((lasttoken = StringUtil.partString((String)(ret = sb.toString()), (int)2, (String)".")) != null && lasttoken.endsWith("}") && (lasttoken = lasttoken.substring(0, lasttoken.length() - 1)).matches("[0-9]*")) {
            String ss = "." + lasttoken + "}";
            ret = ret.substring(0, ret.length() - ss.length());
            ret = ret + "}";
        }
        return ret;
    }

    private void resetCellValue(CellValueReplacerBaseCell aCell) {
        if (Boolean.TRUE.equals(this.set_failed_params_to_whitespace_)) {
            aCell.setEmptyStringValue();
        }
    }

    private String stringArray2String(String[] strs) {
        if (strs == null || strs.length < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null || strs[i].trim().length() <= 0) continue;
            sb.append(strs[i]);
            if (i == strs.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private final String getKeyElement(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return "";
        }
        if (key.startsWith("${e:") || key.startsWith("${E:")) {
            key = "${" + key.substring(4);
        }
        if (key.startsWith("${fmt:")) {
            key = "${" + key.substring(6);
        }
        return key;
    }

    private final boolean isWagbyR6ExpressionKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return key.startsWith("${e:") || key.startsWith("${E:");
    }

    public static interface CellValueReplacerBaseCell {
        public String getString();

        public void setNumericValue(double var1);

        public void setStringValue(String var1);

        public void setDateValue(Date var1);

        public void setEmptyStringValue();
    }
}

