/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.jexcelapi;

import java.io.IOException;
import java.util.List;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.CellValueReplacer;
import jxl.Cell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellUniter {
    private static final Logger LOGGER = LogManager.getLogger((String)CellUniter.class.getName());

    private CellUniter() {
    }

    public static synchronized void uniteColumnCellsAt(WritableSheet sheet, short column, int startRow, int endRow) throws IOException {
        int row;
        String previousCellValue = null;
        String currentCellValue = null;
        int mergeStartRow = 0;
        Cell[] currentRowCells = null;
        CellValueReplacer.CellValueReplacerCell replacerCell = null;
        for (row = startRow; row <= endRow; ++row) {
            currentRowCells = sheet.getRow(row);
            if (currentRowCells == null || currentRowCells.length == 0 || (currentCellValue = (replacerCell = new CellValueReplacer.CellValueReplacerCell(sheet, sheet.getCell((int)column, row))).getString()) == null) continue;
            if (currentCellValue.equals(previousCellValue)) {
                if (mergeStartRow == 0) {
                    mergeStartRow = row;
                }
            } else if (mergeStartRow > 0) {
                CellUniter.mergeCells(sheet, column, mergeStartRow - 1, column, row - 1);
                mergeStartRow = 0;
            }
            previousCellValue = currentCellValue;
        }
        if (mergeStartRow > 0) {
            CellUniter.mergeCells(sheet, column, mergeStartRow - 1, column, row - 1);
        }
    }

    public static synchronized void groupColumnCellsAt(WritableSheet sheet, List<Short> targetColumns, int startRow, int endRow) throws IOException {
        int row;
        Cell[] previousRowCells = null;
        Cell[] currentRowCells = null;
        int mergeStartRow = 0;
        Cell previousCell = null;
        Cell currentCell = null;
        boolean isGroupSameData = false;
        for (row = startRow; row <= endRow; ++row) {
            currentRowCells = sheet.getRow(row);
            if (previousRowCells == null || previousRowCells.length == 0 || currentRowCells == null || currentRowCells.length == 0) {
                previousRowCells = currentRowCells;
                continue;
            }
            for (Short column : targetColumns) {
                previousCell = previousRowCells[column];
                if (CellUniter.isMerge(sheet, previousCell, currentCell = currentRowCells[column])) {
                    isGroupSameData = true;
                    continue;
                }
                isGroupSameData = false;
                break;
            }
            if (isGroupSameData) {
                if (mergeStartRow == 0) {
                    mergeStartRow = row;
                }
            } else if (mergeStartRow > 0) {
                for (Short column : targetColumns) {
                    CellUniter.mergeCells(sheet, column.shortValue(), mergeStartRow - 1, column.shortValue(), row - 1);
                }
                mergeStartRow = 0;
            }
            previousRowCells = currentRowCells;
        }
        if (mergeStartRow > 0) {
            for (Short column : targetColumns) {
                CellUniter.mergeCells(sheet, column.shortValue(), mergeStartRow - 1, column.shortValue(), row - 1);
            }
        }
    }

    private static boolean isMerge(WritableSheet sheet, Cell previousCell, Cell currentCell) {
        if (previousCell == null || currentCell == null) {
            return false;
        }
        CellValueReplacer.CellValueReplacerCell previousReplacerCell = new CellValueReplacer.CellValueReplacerCell(sheet, previousCell);
        CellValueReplacer.CellValueReplacerCell currentReplacerCell = new CellValueReplacer.CellValueReplacerCell(sheet, currentCell);
        if (previousReplacerCell.getString() == null) {
            return false;
        }
        return previousReplacerCell.getString().equals(currentReplacerCell.getString());
    }

    private static void mergeCells(WritableSheet sheet, int startColumn, int startRow, int endColumn, int endRow) throws IOException {
        try {
            sheet.mergeCells(startColumn, startRow, endColumn, endRow);
        }
        catch (WriteException we) {
            LOGGER.debug("An error has occured in merge [" + startColumn + "," + startRow + "," + endColumn + "," + endRow + "] cells.", (Throwable)we);
            if (LOGGER.isDebugEnabled()) {
                we.printStackTrace();
            }
            throw new IOException(we.getMessage());
        }
    }
}

