/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.jexcelapi;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import jp.jasminesoft.jfc.repgen.CellValueReplacerBase;
import jxl.Cell;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class CellValueReplacer
extends CellValueReplacerBase {
    private static final Logger logger = LogManager.getLogger(CellValueReplacer.class);

    CellValueReplacer(Boolean failed_params_flag, SimpleDateFormat formatter) {
        super(failed_params_flag, formatter);
    }

    void replaceCellValue(WritableSheet sheet, Cell aCell, Map<String, Object> params, Map<String, String> typeparams) {
        super.replaceCellValue(new CellValueReplacerCell(sheet, aCell), params, typeparams);
    }

    public static class CellValueReplacerCell
    implements CellValueReplacerBase.CellValueReplacerBaseCell {
        private WritableSheet sheet;
        private Cell aCell;

        CellValueReplacerCell(WritableSheet sheet, Cell aCell) {
            this.sheet = sheet;
            this.aCell = aCell;
        }

        @Override
        public String getString() {
            return this.aCell.getContents();
        }

        @Override
        public void setNumericValue(double value) {
            int row;
            int col = this.aCell.getColumn();
            WritableCell wcell = this.sheet.getWritableCell(col, row = this.aCell.getRow());
            if (wcell instanceof Number) {
                Number ncell = (Number)wcell;
                ncell.setValue(value);
            } else if (this.aCell instanceof NumberCell) {
                Number ncell = new Number((NumberCell)this.aCell);
                ncell.setValue(value);
                this.addCell((WritableCell)ncell);
            } else {
                Number ncell = new Number(col, row, value, this.aCell.getCellFormat());
                this.addCell((WritableCell)ncell);
            }
        }

        @Override
        public void setStringValue(String cellValue) {
            int row;
            int col = this.aCell.getColumn();
            WritableCell wcell = this.sheet.getWritableCell(col, row = this.aCell.getRow());
            if (wcell instanceof Label) {
                Label ncell = (Label)wcell;
                ncell.setString(cellValue);
            } else if (this.aCell instanceof LabelCell) {
                Label ncell = new Label((LabelCell)this.aCell);
                ncell.setString(cellValue);
                this.addCell((WritableCell)ncell);
            } else {
                Label ncell = new Label(col, row, cellValue, this.aCell.getCellFormat());
                this.addCell((WritableCell)ncell);
            }
        }

        @Override
        public void setDateValue(Date date) {
            int row;
            int col = this.aCell.getColumn();
            WritableCell wcell = this.sheet.getWritableCell(col, row = this.aCell.getRow());
            if (wcell instanceof DateTime) {
                DateTime ncell = (DateTime)wcell;
                ncell.setDate(date);
            } else if (this.aCell instanceof DateCell) {
                DateTime ncell = new DateTime((DateCell)this.aCell);
                ncell.setDate(date);
                this.addCell((WritableCell)ncell);
            } else {
                DateTime ncell = new DateTime(col, row, date, this.aCell.getCellFormat());
                this.addCell((WritableCell)ncell);
            }
        }

        private void addCell(WritableCell ncell) {
            block4: {
                try {
                    this.sheet.addCell(ncell);
                }
                catch (RowsExceededException e) {
                    int col = this.aCell.getColumn();
                    int row = this.aCell.getRow();
                    logger.debug("Failed to set value report col:" + col + " row:" + row, (Throwable)e);
                    if (logger.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                }
                catch (WriteException e) {
                    int col = this.aCell.getColumn();
                    int row = this.aCell.getRow();
                    logger.debug("Failed to set value report col:" + col + " row:" + row, (Throwable)e);
                    if (!logger.isDebugEnabled()) break block4;
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void setEmptyStringValue() {
            this.setStringValue("");
        }
    }
}

