/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.jexcelapi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.repgen.AbstractReportGenerator;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.CellUniter;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.CellValueReplacer;
import jp.jasminesoft.jfc.repgen.excel.jexcelapi.ReportWorkbookImpl;
import jp.jasminesoft.jfc.repgen.util.PlaceHolderValueNormalizer;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.LabelCell;
import jxl.WorkbookSettings;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListReportGeneratorImpl
extends AbstractReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger((String)ListReportGeneratorImpl.class.getName());

    @Override
    public ReportWorkbook createReportWorkbook(File file, OutputStream out) throws IOException {
        return new ReportWorkbookImpl(file, out){

            @Override
            protected void initWorkbookSetting(WorkbookSettings settings) {
                super.initWorkbookSetting(settings);
                settings.setFormulaAdjust(false);
                settings.setMergedCellChecking(false);
            }
        };
    }

    @Override
    public void generate(ReportWorkbook rw, Map<String, Object> params, Map<String, String> typeparams, int sheetnum) throws IOException, ReportGeneratorException {
        if (!(rw instanceof ReportWorkbookImpl)) {
            LOGGER.log(LogCodeManager.getPriority(LogCode.JFC00244), LogCodeManager.getMessage(LogCode.JFC00244, rw.getClass().toString()));
            throw new IllegalArgumentException("Illegal ReportWorkbook class");
        }
        WritableWorkbook outWorkbook = ((ReportWorkbookImpl)rw).getWritableWorkbook();
        WritableSheet sheet = outWorkbook.getSheet(sheetnum);
        LOGGER.debug("Report will be created as Excel 'list' report.");
        this.generateList(sheet, params, typeparams);
    }

    protected void generateList(WritableSheet sheet, Map<String, Object> params1, Map<String, String> typeparams) throws IOException {
        int rowNum;
        PlaceHolderValueNormalizer.splitOverCellSizeValues(params1, typeparams);
        for (int i = rowNum = sheet.getRows(); i >= 0; --i) {
            Cell[] currentRowCells = this.getRowCells(sheet, i);
            if (currentRowCells == null || currentRowCells.length == 0) continue;
            if (this.isPlaceholder(currentRowCells)) {
                this.replaceCellValuesFixedPlaceHolder(sheet, currentRowCells, params1, typeparams);
                continue;
            }
            if (!this.isRowPlaceholder(currentRowCells)) continue;
            short[] unite_columns = this.checkUniteColumns(sheet, currentRowCells);
            Map<Integer, List<Short>> group_columnMap = this.checkGroupColumns(sheet, currentRowCells);
            int appendRowNum = this.appendRows(sheet, currentRowCells, params1, typeparams, i);
            if (unite_columns != null && unite_columns.length > 0) {
                for (int m = 0; m < unite_columns.length; ++m) {
                    CellUniter.uniteColumnCellsAt(sheet, unite_columns[m], i, i + appendRowNum);
                }
            }
            if (group_columnMap == null || group_columnMap.size() <= 0) continue;
            for (List<Short> columns : group_columnMap.values()) {
                CellUniter.groupColumnCellsAt(sheet, columns, i, i + appendRowNum);
            }
        }
    }

    protected int appendRows(WritableSheet sheet, Cell[] templateRowCells, Map<String, Object> params, Map<String, String> typeparams, int currentRowNum) throws IOException {
        SortedSet<Integer> keycntset = this.getKeyCountSet(params);
        Iterator it = keycntset.iterator();
        int i = 0;
        while (it.hasNext()) {
            i = (Integer)it.next();
            LOGGER.debug("appending(replacing) row #" + (currentRowNum + i));
            sheet.insertRow(currentRowNum + i + 1);
            this.replaceCellValues(sheet, templateRowCells, params, typeparams, i);
        }
        sheet.removeRow(currentRowNum);
        return i;
    }

    protected String getMatchPattern() {
        return "\\$\\{[0-9a-zA-Z\\-_.@\\$]*\\.([0-9]+)\\}";
    }

    protected SortedSet<Integer> getKeyCountSet(Map<String, Object> params) {
        Set<String> keyset = params.keySet();
        Iterator<String> ite = keyset.iterator();
        String tmp = null;
        TreeSet<Integer> keycntset = new TreeSet<Integer>();
        Pattern pat = Pattern.compile(this.getMatchPattern());
        while (ite.hasNext()) {
            Integer cntint;
            tmp = ite.next();
            Matcher matcher = pat.matcher(tmp);
            if (!matcher.matches()) continue;
            String cntstr = matcher.group(1);
            try {
                cntint = Integer.valueOf(cntstr);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("illegal number format " + tmp, (Throwable)e);
                if (!LOGGER.isDebugEnabled()) continue;
                e.printStackTrace();
                continue;
            }
            keycntset.add(cntint);
        }
        return keycntset;
    }

    protected void replaceCellValues(WritableSheet sheet, Cell[] templateRowCells, Map<String, Object> params, Map<String, String> typeparams, int placeholderNumber) throws IOException {
        CellValueReplacer replacer = new CellValueReplacer(this.isFailedParametersToWhiteSpace(), this.getDateFormat());
        String placeHolder = null;
        Label label = null;
        CellView templateCellView = sheet.getRowView(templateRowCells[0].getRow());
        for (Cell templateCell : templateRowCells) {
            int newCellColumn = templateCell.getColumn();
            int newCellRow = templateCell.getRow() + placeholderNumber + 1;
            if (!this.isRowPlaceholder(templateCell)) {
                try {
                    sheet.addCell(sheet.getWritableCell(templateCell.getColumn(), templateCell.getRow()).copyTo(newCellColumn, newCellRow));
                    continue;
                }
                catch (WriteException we) {
                    LOGGER.debug("Write Exception", (Throwable)we);
                    if (LOGGER.isDebugEnabled()) {
                        we.printStackTrace();
                    }
                    throw new IOException(we.getMessage());
                }
            }
            placeHolder = this.getValue(templateCell);
            placeHolder = placeHolder.replaceAll("\\.#\\}", "." + String.valueOf(placeholderNumber) + "}");
            placeHolder = placeHolder.replaceAll("\\.#\\.", "." + String.valueOf(placeholderNumber) + ".");
            label = new Label(newCellColumn, newCellRow, placeHolder);
            if (templateCell.getCellFeatures() != null) {
                label.setCellFeatures(new WritableCellFeatures(templateCell.getCellFeatures()));
            }
            label.setCellFormat(templateCell.getCellFormat());
            try {
                sheet.addCell((WritableCell)label);
                sheet.setRowView(newCellRow, templateCellView);
            }
            catch (WriteException we) {
                LOGGER.debug("Write Exception", (Throwable)we);
                if (LOGGER.isDebugEnabled()) {
                    we.printStackTrace();
                }
                throw new IOException(we.getMessage());
            }
            replacer.replaceCellValue(sheet, sheet.getCell(newCellColumn, newCellRow), params, typeparams);
        }
        replacer = null;
    }

    private void replaceCellValuesFixedPlaceHolder(WritableSheet sheet, Cell[] currentRowCells, Map<String, Object> params, Map<String, String> typeparams) {
        if (currentRowCells == null || currentRowCells.length == 0) {
            return;
        }
        if (!this.isPlaceholder(currentRowCells)) {
            return;
        }
        CellValueReplacer replacer = new CellValueReplacer(this.isFailedParametersToWhiteSpace(), this.getDateFormat());
        for (Cell cell : currentRowCells) {
            if (!this.isPlaceholder(cell)) continue;
            replacer.replaceCellValue(sheet, sheet.getCell(cell.getColumn(), cell.getRow()), params, typeparams);
        }
        replacer = null;
    }

    protected boolean isRowPlaceholder(Cell[] currentRowCells) {
        if (currentRowCells == null || currentRowCells.length == 0) {
            return false;
        }
        for (Cell cell : currentRowCells) {
            if (!this.isRowPlaceholder(cell)) continue;
            return true;
        }
        return false;
    }

    protected boolean isRowPlaceholder(Cell cell) {
        if (cell == null) {
            return false;
        }
        return StringUtils.startsWith((CharSequence)this.getValue(cell), (CharSequence)"${") && StringUtils.endsWith((CharSequence)this.getValue(cell), (CharSequence)".#}") && StringUtils.contains((CharSequence)this.getValue(cell), (CharSequence)"_lp.");
    }

    protected boolean isPlaceholder(Cell[] currentRowCells) {
        if (currentRowCells == null || currentRowCells.length == 0) {
            return false;
        }
        for (Cell cell : currentRowCells) {
            if (!this.isPlaceholder(cell)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlaceholder(Cell cell) {
        if (cell == null) {
            return false;
        }
        return StringUtils.startsWith((CharSequence)this.getValue(cell), (CharSequence)"${") && StringUtils.endsWith((CharSequence)this.getValue(cell), (CharSequence)"}") && !StringUtils.endsWith((CharSequence)this.getValue(cell), (CharSequence)".#}");
    }

    protected boolean isCellTypeString(Cell cell) {
        CellType cellType = cell.getType();
        return CellType.LABEL == cellType || CellType.STRING_FORMULA == cellType;
    }

    protected String getValue(Cell cell) {
        if (!this.isCellTypeString(cell)) {
            return "";
        }
        String content = cell.getContents();
        if (content == null) {
            return "";
        }
        return content.trim();
    }

    protected void setValue(WritableSheet sheet, Cell cell, String cellValue) throws WriteException {
        int row;
        int column = cell.getColumn();
        WritableCell wcell = sheet.getWritableCell(column, row = cell.getRow());
        if (wcell instanceof Label) {
            Label ncell = (Label)wcell;
            ncell.setString(cellValue);
        } else if (cell instanceof LabelCell) {
            Label ncell = new Label((LabelCell)cell);
            ncell.setString(cellValue);
            sheet.addCell((WritableCell)ncell);
        } else {
            Label ncell = new Label(column, row, cellValue, cell.getCellFormat());
            sheet.addCell((WritableCell)ncell);
        }
    }

    private short[] checkUniteColumns(WritableSheet sheet, Cell[] currentRowCells) throws IOException {
        if (currentRowCells == null || currentRowCells.length == 0) {
            return null;
        }
        ArrayList<Short> list = new ArrayList<Short>();
        Pattern pattern = Pattern.compile("\\$[Jj]\\$\\{.*\\.#\\}");
        Matcher matcher = null;
        String cellValue = null;
        Cell cell = null;
        for (short column = 0; column < currentRowCells.length; column = (short)((short)(column + 1))) {
            cell = currentRowCells[column];
            if (cell == null || !(matcher = pattern.matcher(cellValue = this.getValue(cell))).matches()) continue;
            list.add(column);
            try {
                this.setValue(sheet, cell, cellValue.replaceAll("\\$[jJ]", ""));
            }
            catch (WriteException we) {
                LOGGER.debug("Write Exception", (Throwable)we);
                if (LOGGER.isDebugEnabled()) {
                    we.printStackTrace();
                }
                throw new IOException(we.getMessage());
            }
            column = (short)(column + 1);
        }
        int num = list.size();
        if (num == 0) {
            return null;
        }
        short[] ret = new short[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = (Short)list.get(i);
        }
        return ret;
    }

    private Map<Integer, List<Short>> checkGroupColumns(WritableSheet sheet, Cell[] currentRowCells) throws IOException {
        if (currentRowCells == null || currentRowCells.length == 0) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\$[Gg]([0-9]+)");
        HashMap<Integer, List<Short>> map = new HashMap<Integer, List<Short>>();
        List<Short> list = null;
        Matcher matcher = null;
        Cell cell = null;
        String groupDefinedColumn = null;
        Integer columnNumber = null;
        for (short column = 0; column < currentRowCells.length; column = (short)((short)(column + 1))) {
            cell = currentRowCells[column];
            if (cell == null || !(matcher = pattern.matcher(this.getValue(cell))).find()) continue;
            groupDefinedColumn = matcher.group(1);
            try {
                columnNumber = Integer.valueOf(groupDefinedColumn);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("illegal number format " + groupDefinedColumn, (Throwable)e);
                if (!LOGGER.isDebugEnabled()) continue;
                e.printStackTrace();
                continue;
            }
            list = map.get(columnNumber);
            if (list == null) {
                list = new ArrayList<Short>();
                map.put(columnNumber, list);
            }
            list.add(column);
            try {
                this.setValue(sheet, cell, matcher.replaceAll(""));
                continue;
            }
            catch (WriteException we) {
                LOGGER.debug("Write Exception", (Throwable)we);
                if (LOGGER.isDebugEnabled()) {
                    we.printStackTrace();
                }
                throw new IOException(we.getMessage());
            }
        }
        return map;
    }

    protected Cell[] getRowCells(WritableSheet sheet, int rowNum) {
        int maxColumnNum = sheet.getColumns();
        Cell[] cells = new Cell[maxColumnNum];
        for (int columnNum = 0; columnNum < maxColumnNum; ++columnNum) {
            cells[columnNum] = sheet.getCell(columnNum, rowNum);
        }
        return cells;
    }
}

