/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import jp.jasminesoft.util.ComparableRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CellUniter {
    private static final Logger logger = LogManager.getLogger(CellUniter.class);

    private CellUniter() {
    }

    public static synchronized void uniteCellsAstrideRows(Sheet sheet) {
        CellRangeAddressMap cellRangeAddressMap = new CellRangeAddressMap();
        ArrayList prevRowCells = null;
        ArrayList<String> currRowCells = null;
        Row currentRow = null;
        Cell aCell = null;
        int rowNum = sheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            currentRow = sheet.getRow(i);
            if (currentRow == null) continue;
            int cellNum = currentRow.getLastCellNum();
            currRowCells = new ArrayList<String>();
            for (int j = 0; j < cellNum; ++j) {
                aCell = currentRow.getCell(j);
                if (aCell == null) continue;
                if (aCell.getCellType() != CellType.STRING) {
                    currRowCells.add(null);
                    continue;
                }
                RichTextString rstring = aCell.getRichStringCellValue();
                if (rstring != null) {
                    String s = rstring.getString();
                    s = s != null ? s.trim() : "";
                    currRowCells.add(s);
                    continue;
                }
                currRowCells.add(null);
            }
            if (prevRowCells != null && prevRowCells.size() == currRowCells.size()) {
                String prevRowCellVal = null;
                String currRowCellVal = null;
                int numCells = prevRowCells.size();
                for (int j = 0; j < numCells; ++j) {
                    prevRowCellVal = (String)prevRowCells.get(j);
                    currRowCellVal = (String)currRowCells.get(j);
                    if (prevRowCellVal == null || currRowCellVal == null || !prevRowCellVal.equals(currRowCellVal)) continue;
                    cellRangeAddressMap.addCellRangeAddress(i - 1, i, j);
                }
            }
            prevRowCells = new ArrayList(currRowCells);
        }
        cellRangeAddressMap.addMergedRegion(sheet);
    }

    public static synchronized void uniteColumnCellsAt(Sheet sheet, int target) {
        CellRangeAddressMap cellRangeAddressMap = new CellRangeAddressMap();
        String prevRowCellValue = null;
        Double prevRowCellValue_double = null;
        String currRowCellValue = null;
        Double currRowCellValue_double = null;
        Row currentRow = null;
        Cell aCell = null;
        int rowNum = sheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            currentRow = sheet.getRow(i);
            if (currentRow != null && (aCell = currentRow.getCell(target)) != null) {
                if (aCell.getCellType() == CellType.STRING) {
                    RichTextString rstring = aCell != null ? aCell.getRichStringCellValue() : null;
                    String string = currRowCellValue = rstring != null ? rstring.getString().trim() : "";
                    if (prevRowCellValue != null && prevRowCellValue.trim().length() > 0 && prevRowCellValue.equals(currRowCellValue)) {
                        cellRangeAddressMap.addCellRangeAddress(i - 1, i, target);
                    }
                    prevRowCellValue = currRowCellValue.toString();
                    continue;
                }
                if (aCell.getCellType() == CellType.NUMERIC) {
                    double d = aCell.getNumericCellValue();
                    currRowCellValue_double = d;
                    if (prevRowCellValue_double != null && prevRowCellValue_double.equals(currRowCellValue_double)) {
                        cellRangeAddressMap.addCellRangeAddress(i - 1, i, target);
                    }
                    prevRowCellValue_double = currRowCellValue_double;
                    continue;
                }
                prevRowCellValue = null;
                prevRowCellValue_double = null;
                currRowCellValue = null;
                currRowCellValue_double = null;
                continue;
            }
            prevRowCellValue = null;
            prevRowCellValue_double = null;
            currRowCellValue = null;
            currRowCellValue_double = null;
        }
        cellRangeAddressMap.addMergedRegion(sheet);
    }

    public static synchronized void groupColumnCellsAt(Sheet sheet, List<Integer> targets) {
        CellRangeAddressMap cellRangeAddressMap = new CellRangeAddressMap();
        Row prevRow = null;
        int rowNum = sheet.getLastRowNum();
        for (int i = 0; i <= rowNum; ++i) {
            Row currRow = sheet.getRow(i);
            if (CellUniter.isMerge(prevRow, currRow, targets)) {
                for (Integer target : targets) {
                    Cell prevCell = prevRow.getCell(target.intValue());
                    Cell currCell = currRow.getCell(target.intValue());
                    if (prevCell == null || currCell == null) continue;
                    cellRangeAddressMap.addCellRangeAddress(i - 1, i, target);
                }
            }
            prevRow = currRow;
        }
        cellRangeAddressMap.addMergedRegion(sheet);
    }

    private static boolean isMerge(Row prevRow, Row currRow, List<Integer> targets) {
        if (prevRow == null || currRow == null) {
            return false;
        }
        for (Integer target : targets) {
            Cell prevCell = prevRow.getCell(target.intValue());
            Cell currCell = currRow.getCell(target.intValue());
            if (prevCell == null) {
                if (currCell == null) continue;
                return false;
            }
            if (currCell == null) {
                return false;
            }
            if (CellUniter.isMerge(prevCell, currCell)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMerge(Cell prevCell, Cell currCell) {
        if (currCell.getCellType() == CellType.STRING) {
            String prevRowCellValue;
            if (prevCell.getCellType() != CellType.STRING) {
                return false;
            }
            RichTextString rstring = currCell != null ? currCell.getRichStringCellValue() : null;
            String currRowCellValue = rstring != null ? rstring.getString().trim() : "";
            rstring = prevCell != null ? prevCell.getRichStringCellValue() : null;
            String string = prevRowCellValue = rstring != null ? rstring.getString().trim() : "";
            if (prevRowCellValue.equals(currRowCellValue)) {
                return true;
            }
        } else if (currCell.getCellType() == CellType.NUMERIC) {
            if (prevCell.getCellType() != CellType.NUMERIC) {
                return false;
            }
            double currRowCellValue_double = currCell.getNumericCellValue();
            double prevRowCellValue_double = prevCell.getNumericCellValue();
            if (prevRowCellValue_double == currRowCellValue_double) {
                return true;
            }
        }
        return false;
    }

    private static class CellRangeAddressMap {
        private TreeMap<Integer, ComparableRange> cellRangeAddressMap = new TreeMap();

        private CellRangeAddressMap() {
        }

        public void addCellRangeAddress(int startrow, int endrow, int column) {
            ComparableRange range;
            if (startrow > endrow) {
                logger.warn("startrow > endrow. startrow:" + startrow + " endrow:" + endrow);
            }
            if ((range = this.cellRangeAddressMap.get(column)) == null) {
                range = new ComparableRange();
                this.cellRangeAddressMap.put(column, range);
            }
            range.addRange((Comparable)Integer.valueOf(startrow), (Comparable)Integer.valueOf(endrow));
        }

        public void addMergedRegion(Sheet sheet) {
            ArrayList<CellRangeAddress> cralist = new ArrayList<CellRangeAddress>(sheet.getMergedRegions());
            for (Integer column : this.cellRangeAddressMap.keySet()) {
                ComparableRange ragne = this.cellRangeAddressMap.get(column);
                for (ComparableRange.RangeItem item : ragne.getRangeItem()) {
                    Integer min = (Integer)item.getMinimum();
                    Integer max = (Integer)item.getMaximum();
                    this.addMergedRegion(sheet, min, max, column, cralist);
                }
            }
            int len = sheet.getNumMergedRegions();
            for (int i = len - 1; i >= 0; --i) {
                sheet.removeMergedRegion(i);
            }
            for (CellRangeAddress cra : cralist) {
                try {
                    sheet.addMergedRegion(cra);
                }
                catch (IllegalStateException e) {
                    logger.warn("failed add merged region", (Throwable)e);
                }
            }
        }

        private void addMergedRegion(Sheet sheet, int firstRow, int lastRow, int column, List<CellRangeAddress> cralist) {
            ArrayList<CellRangeAddress> newcralist = new ArrayList<CellRangeAddress>(cralist);
            int[] minMaxCR = this.getMinMaxColumnRow(firstRow, lastRow, column, column, newcralist);
            if (firstRow != minMaxCR[2] || lastRow != minMaxCR[3]) {
                logger.warn("merge over row area. merge cancel. firstRow:" + firstRow + " lastRow:" + lastRow + " column:" + column);
                this.outputMinMaxCRDebugLog("getMinMaxColumnRow results ", minMaxCR);
                return;
            }
            int firstColumn = minMaxCR[0];
            int lastColumn = minMaxCR[1];
            if (firstRow != (minMaxCR = this.getMinMaxColumnRow(firstRow, lastRow, firstColumn, lastColumn, newcralist))[2] || lastRow != minMaxCR[3] || firstColumn != minMaxCR[0] || lastColumn != minMaxCR[1]) {
                logger.warn("merge other area. merge cancel. firstRow:" + firstRow + " lastRow:" + lastRow + " firstColumn:" + firstColumn + " lastColumn:" + lastColumn);
                this.outputMinMaxCRDebugLog("getMinMaxColumnRow results ", minMaxCR);
                return;
            }
            cralist.clear();
            cralist.addAll(newcralist);
            cralist.add(new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn));
        }

        private void outputMinMaxCRDebugLog(String header, int[] minMaxCR) {
            logger.warn(header + " firstRow:" + minMaxCR[2] + " lastRow:" + minMaxCR[3] + " firstColumn:" + minMaxCR[0] + " lastColumn:" + minMaxCR[1]);
        }

        private int[] getMinMaxColumnRow(int firstRow, int lastRow, int firstColumn, int lastColumn, List<CellRangeAddress> cralist) {
            int[] minMaxColumn = new int[]{firstColumn, lastColumn, firstRow, lastRow};
            Iterator<CellRangeAddress> it = cralist.iterator();
            while (it.hasNext()) {
                CellRangeAddress cra = it.next();
                if (cra.getFirstColumn() > lastColumn || cra.getLastColumn() < firstColumn || cra.getFirstRow() > lastRow || cra.getLastRow() < firstRow) continue;
                it.remove();
                if (minMaxColumn[0] > cra.getFirstColumn()) {
                    minMaxColumn[0] = cra.getFirstColumn();
                }
                if (minMaxColumn[1] < cra.getLastColumn()) {
                    minMaxColumn[1] = cra.getLastColumn();
                }
                if (minMaxColumn[2] > cra.getFirstRow()) {
                    minMaxColumn[2] = cra.getFirstRow();
                }
                if (minMaxColumn[3] >= cra.getLastRow()) continue;
                minMaxColumn[3] = cra.getLastRow();
            }
            return minMaxColumn;
        }
    }
}

