/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.repgen.ReportGeneratorException;
import jp.jasminesoft.jfc.repgen.ReportWorkbook;
import jp.jasminesoft.jfc.repgen.excel.poi.CellUniter;
import jp.jasminesoft.jfc.repgen.excel.poi.CellUtil;
import jp.jasminesoft.jfc.repgen.excel.poi.CellValueReplacer;
import jp.jasminesoft.jfc.repgen.excel.poi.POIReportGenerator;
import jp.jasminesoft.jfc.repgen.excel.poi.ReportWorkbookImpl;
import jp.jasminesoft.jfc.repgen.excel.poi.RowUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ListReportGeneratorImpl
extends POIReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger((String)ListReportGeneratorImpl.class.getName());

    @Override
    public ReportWorkbook createReportWorkbook(File file, OutputStream out) throws IOException {
        if (file == null || out == null) {
            throw new IOException(LogCodeManager.getMessage(LogCode.JFC00243, new String[0]));
        }
        if (!file.exists()) {
            if (file.getName().equals("null")) {
                throw new IOException(LogCodeManager.getMessage(LogCode.JFC00251, new String[0]));
            }
            throw new IOException(LogCodeManager.getMessage(LogCode.JFC00250, file.getAbsolutePath()));
        }
        return new ReportWorkbookImpl(file, out);
    }

    @Override
    public void generate(ReportWorkbook rw, Map<String, Object> params, Map<String, String> typeparams, int sheetnum) throws IOException, ReportGeneratorException {
        if (!(rw instanceof ReportWorkbookImpl)) {
            LOGGER.log(LogCodeManager.getPriority(LogCode.JFC00244), LogCodeManager.getMessage(LogCode.JFC00244, rw.getClass().toString()));
            throw new IllegalArgumentException("Illegal ReportWorkbook class");
        }
        Workbook workbook = ((ReportWorkbookImpl)rw).getWorkbook();
        Sheet sheet = workbook.getSheetAt(sheetnum);
        LOGGER.debug("Report will be created as Excel 'list' report.");
        this.generateList(sheet, params, typeparams, workbook);
        Object sheetName = params.get("#sheetName");
        if (sheetName != null && sheetName instanceof String) {
            ((ReportWorkbookImpl)rw).setSheetName(sheetnum, sheetName.toString());
        }
        this.finish();
    }

    protected void generateList(Sheet sheet, Map<String, Object> params1, Map<String, String> typeparams, Workbook workbook) {
        Row currentRow = null;
        int rowNum = sheet.getLastRowNum();
        if (rowNum > 65536) {
            rowNum = 65536;
        }
        for (int i = 0; i <= rowNum; ++i) {
            int x;
            currentRow = sheet.getRow(i);
            if (currentRow != null && this.isPlaceHolderRow(currentRow)) {
                for (x = 0; x < i; ++x) {
                    LOGGER.debug("header part: row #" + x);
                    this.replaceCellValuesFixedPlaceHolder(sheet.getRow(x), params1, typeparams, sheet, workbook);
                }
                this.appendPlaceHolderRow(sheet, params1, typeparams, workbook, currentRow, rowNum, i);
                break;
            }
            if (currentRow == null || i != rowNum) continue;
            for (x = 0; x <= rowNum; ++x) {
                LOGGER.debug("header part: row #" + x);
                this.replaceCellValuesFixedPlaceHolder(sheet.getRow(x), params1, typeparams, sheet, workbook);
            }
        }
    }

    private void appendPlaceHolderRow(Sheet sheet, Map<String, Object> params1, Map<String, String> typeparams, Workbook workbook, Row currentRow, int rowNum, int i) {
        Sheet cloneSheet;
        ArrayList<Row> footerList = new ArrayList<Row>();
        TreeMap<Integer, Integer> unitedPatternMap = new TreeMap<Integer, Integer>();
        HashMap<String, List<String>> removeKeyMap = new HashMap<String, List<String>>();
        for (String key : params1.keySet()) {
            if (!key.endsWith(".0}")) continue;
            String prefix = key.substring("${".length() - 1, key.indexOf("."));
            ArrayList<String> list = (ArrayList<String>)removeKeyMap.get(prefix);
            if (list == null) {
                list = new ArrayList<String>();
                removeKeyMap.put(prefix, list);
            }
            list.add(key.substring(0, key.length() - ".0}".length()));
        }
        int sheetNum = workbook.getSheetIndex(sheet.getSheetName());
        if (sheet instanceof XSSFSheet) {
            cloneSheet = workbook.cloneSheet(sheetNum);
            currentRow = cloneSheet.getRow(i);
        } else {
            cloneSheet = sheet;
        }
        SortedSet<Integer> keycntset = this.getKeyCountSet(params1);
        Row footerRow = null;
        for (int h = i + 1; h <= rowNum; ++h) {
            LOGGER.debug("footer part: row #" + h);
            footerRow = cloneSheet.getRow(h);
            this.replaceCellValuesFixedPlaceHolder(footerRow, params1, typeparams, sheet, workbook);
            footerList.add(footerRow);
        }
        int maxnum = 0;
        int numMergedRegionSize = sheet.getNumMergedRegions();
        if (numMergedRegionSize > 0 && params1 != null && params1.size() > 0) {
            int n = maxnum = keycntset.size() > 0 ? Collections.max(keycntset) : 0;
            if (maxnum > 0) {
                this.moveMergedRegion(sheet, numMergedRegionSize, i, maxnum);
            }
        } else if (params1 != null && params1.size() > 0) {
            maxnum = keycntset.size() > 0 ? Collections.max(keycntset) : 0;
        }
        int[] unite_columns = this.checkUniteColumns(currentRow);
        Map<Integer, List<Integer>> group_columnMap = this.checkGroupColumns(currentRow);
        this.appendRows(currentRow, sheet, params1, typeparams, i, unitedPatternMap, removeKeyMap, workbook);
        if (unite_columns != null && unite_columns.length > 0) {
            for (int m = 0; m < unite_columns.length; ++m) {
                CellUniter.uniteColumnCellsAt(sheet, unite_columns[m]);
            }
        }
        if (group_columnMap.size() > 0) {
            for (List<Integer> columns : group_columnMap.values()) {
                CellUniter.groupColumnCellsAt(sheet, columns);
            }
        }
        int footerTargetRowNum = i + (keycntset.size() > 0 ? keycntset.size() : 1);
        this.appendFooter(sheet, footerList, footerTargetRowNum);
        if (keycntset.size() == 0) {
            RowUtil.cleanRow(sheet.getRow(rowNum));
        }
        if (cloneSheet != sheet) {
            int cloneSheetNum = workbook.getSheetIndex(cloneSheet.getSheetName());
            workbook.removeSheetAt(cloneSheetNum);
        }
        String printArea = workbook.getPrintArea(0);
        String n_printArea = null;
        boolean useFormulaPrintArea = false;
        if (printArea != null) {
            String numstr;
            int num;
            String part;
            int ptr3;
            int ptr2;
            int ptr = printArea.indexOf("!");
            if (ptr > 0) {
                String before = printArea.substring(0, ptr);
                String after = printArea.substring(ptr + 1);
                if (before.indexOf("(") >= 0 || after.indexOf("(") >= 0) {
                    useFormulaPrintArea = true;
                } else {
                    printArea = printArea.substring(ptr + 1);
                }
            }
            if (!useFormulaPrintArea && (ptr2 = printArea.indexOf(":")) > 0 && (ptr3 = (part = printArea.substring(ptr2 + 1)).lastIndexOf("$")) > 0 && (num = NumberUtils.toInt((String)(numstr = part.substring(ptr3 + 1)))) > 0 && maxnum > 0) {
                part = part.substring(0, ptr3 + 1) + (num += maxnum);
                n_printArea = printArea.substring(0, ptr2 + 1) + part;
            }
        }
        if (n_printArea != null && !useFormulaPrintArea) {
            if (cloneSheet != sheet) {
                workbook.setPrintArea(sheetNum == 0 ? 0 : sheetNum, n_printArea);
            } else {
                workbook.setPrintArea(sheetNum == 0 ? 0 : sheetNum - 1, n_printArea);
            }
        }
    }

    private void moveMergedRegion(Sheet sheet, int numMergedRegionSize, int i, int maxnum) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("numMergedRegionSize=" + numMergedRegionSize + ",i=" + i + ", maxnum=" + maxnum);
        }
        ArrayList<CellRangeAddress> listcra = new ArrayList<CellRangeAddress>();
        ArrayList<Integer> listindex = new ArrayList<Integer>();
        for (int s = 0; s < numMergedRegionSize; ++s) {
            CellRangeAddress _range = sheet.getMergedRegion(s);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("_range=" + _range.getFirstRow() + "::" + _range.getLastRow() + " " + _range);
            }
            if (_range.getFirstRow() < i + 1) continue;
            listcra.add(_range);
            listindex.add(s);
        }
        Collections.sort(listindex);
        Collections.reverse(listindex);
        Iterator iterator = listindex.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            sheet.removeMergedRegion(s);
        }
        listindex.clear();
        listindex = null;
        for (CellRangeAddress _range : listcra) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("move! " + _range);
            }
            _range.setFirstRow(_range.getFirstRow() + maxnum);
            _range.setLastRow(_range.getLastRow() + maxnum);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" to " + _range);
            }
            sheet.addMergedRegion(_range);
        }
        listcra.clear();
        listcra = null;
    }

    private void appendRows(Row templateRow, Sheet sheet, Map<String, Object> params, Map<String, String> typeparams, int currentRowNum, Map<Integer, Integer> unitedPatternMap, Map<String, List<String>> removeKeyMap, Workbook workbook) {
        SortedSet<Integer> keycntset = this.getKeyCountSet(params);
        if (keycntset.size() == 0) {
            return;
        }
        Iterator it = keycntset.iterator();
        while (it.hasNext()) {
            int i = (Integer)it.next();
            LOGGER.debug("appending(replacing) row #" + (currentRowNum + i));
            Row newRow = RowUtil.appendRow(sheet, templateRow, currentRowNum + i, unitedPatternMap);
            List<String> removeKeyList = this.replaceCellValues(newRow, params, typeparams, removeKeyMap, i);
            this.replaceCellValuesFixedPlaceHolder(newRow, params, typeparams, sheet, workbook);
            if (removeKeyList == null) continue;
            for (String removeKey : removeKeyList) {
                params.remove(removeKey);
                typeparams.remove(removeKey);
            }
        }
    }

    protected String getMatchPattern() {
        return "\\$\\{[0-9a-zA-Z\\-_.@\\$]*\\.([0-9]+)\\}";
    }

    protected SortedSet<Integer> getKeyCountSet(Map<String, Object> params) {
        Set<String> keyset = params.keySet();
        Iterator<String> ite = keyset.iterator();
        String tmp = null;
        TreeSet<Integer> keycntset = new TreeSet<Integer>();
        Pattern pat = Pattern.compile(this.getMatchPattern());
        while (ite.hasNext()) {
            Integer cntint;
            tmp = ite.next();
            Matcher matcher = pat.matcher(tmp);
            if (!matcher.matches()) continue;
            String cntstr = matcher.group(1);
            try {
                cntint = Integer.valueOf(cntstr);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("illegal number format " + tmp, (Throwable)e);
                if (!LOGGER.isDebugEnabled()) continue;
                e.printStackTrace();
                continue;
            }
            keycntset.add(cntint);
        }
        if (keycntset.size() == 0) {
            keycntset.add(0);
        }
        return keycntset;
    }

    private List<String> replaceCellValues(Row row, Map<String, Object> params, Map<String, String> typeparams, Map<String, List<String>> removeKeyMap, int placeholder_number) {
        CellValueReplacer replacer = new CellValueReplacer(this.isFailedParametersToWhiteSpace(), this.getDateFormat());
        Iterator<Cell> ite = this.getCellIterator(row);
        String tmpPlaceHolderValue = null;
        Cell aCell = null;
        String removeKeyPrefix = null;
        String removeKeySuffix = null;
        while (ite.hasNext()) {
            String[] stringArray;
            int n;
            int n2;
            aCell = ite.next();
            if (!this.isPlaceHolderCell(aCell)) continue;
            RichTextString rstring = aCell.getRichStringCellValue();
            tmpPlaceHolderValue = rstring != null ? rstring.getString() : "";
            tmpPlaceHolderValue = tmpPlaceHolderValue.replaceAll("\\.#\\}", "." + String.valueOf(placeholder_number) + "}");
            tmpPlaceHolderValue = tmpPlaceHolderValue.replaceAll("\\.#\\.", "." + String.valueOf(placeholder_number) + ".");
            CellUtil.setCellValue(aCell, tmpPlaceHolderValue);
            String[] removeKeys = replacer.replaceCellValue(aCell, params, typeparams);
            if (removeKeys == null || removeKeys.length <= 0 || removeKeyPrefix != null || (n2 = 0) >= (n = (stringArray = removeKeys).length)) continue;
            String removeKey = stringArray[n2];
            removeKeyPrefix = removeKey.substring("${".length() - 1, removeKey.indexOf("."));
            removeKeySuffix = removeKey.substring(removeKey.lastIndexOf("."));
        }
        replacer = null;
        List<String> removeKeyList = removeKeyPrefix != null ? removeKeyMap.get(removeKeyPrefix) : null;
        ArrayList<String> rlist = null;
        if (removeKeyList != null && removeKeyList.size() > 0 && removeKeySuffix != null) {
            for (String removeKey : removeKeyList) {
                String _removeKey = removeKey + removeKeySuffix;
                if (_removeKey.indexOf("_jshfilename") > 0 || removeKeyList.contains(removeKey + "_jshfilename")) continue;
                if (rlist == null) {
                    rlist = new ArrayList<String>();
                }
                rlist.add(_removeKey);
            }
        }
        return rlist;
    }

    private Iterator<Cell> getCellIterator(Row row) {
        Iterator ite = row.cellIterator();
        return ite;
    }

    private void replaceCellValuesFixedPlaceHolder(Row row, Map<String, Object> params, Map<String, String> typeparams, Sheet sheet, Workbook workbook) {
        if (row == null) {
            return;
        }
        CellValueReplacer replacer = new CellValueReplacer(this.isFailedParametersToWhiteSpace(), this.getDateFormat());
        Iterator<Cell> ite = this.getCellIterator(row);
        Cell aCell = null;
        while (ite.hasNext()) {
            String rstring;
            aCell = ite.next();
            if (aCell == null || aCell.getCellType() != CellType.STRING || (rstring = aCell.getStringCellValue()) != null && rstring.indexOf("${") >= 0 && rstring.indexOf(".#.") > 0) continue;
            boolean processedImage = this.replaceImage(aCell, params, typeparams, row.getRowNum(), sheet, workbook);
            boolean processedBarcode = false;
            if (!processedImage) {
                processedBarcode = this.replaceBarcode(aCell, params, typeparams, row.getRowNum(), sheet, workbook);
            }
            if (processedImage || processedBarcode) continue;
            replacer.replaceCellValue(aCell, params, typeparams);
        }
        replacer = null;
    }

    private boolean isPlaceHolderRow(Row row) {
        Cell cell = null;
        int cellnum = row.getLastCellNum();
        for (int i = 0; i < cellnum; ++i) {
            cell = row.getCell(i);
            if (!this.isPlaceHolderCell(cell)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPlaceHolderCell(Cell cell) {
        String tmpCellValue = null;
        if (cell != null && cell.getCellType() == CellType.STRING) {
            RichTextString rstring = cell.getRichStringCellValue();
            String string = tmpCellValue = rstring != null ? rstring.getString() : "";
            if (tmpCellValue != null && (tmpCellValue = tmpCellValue.trim()).indexOf("${") >= 0 && tmpCellValue.indexOf("_lp.") > 0 && tmpCellValue.indexOf(".#") > 0) {
                return true;
            }
        }
        return false;
    }

    private void appendFooter(Sheet sheet, ArrayList<Row> footerList, int currentRowNum) {
        Row tmpRow = null;
        int footerSize = footerList.size();
        for (int i = 0; i < footerSize; ++i) {
            LOGGER.debug("appending footer part: row #" + (currentRowNum + i));
            tmpRow = footerList.get(i);
            RowUtil.appendRow(sheet, tmpRow, currentRowNum + i);
        }
    }

    private int[] checkUniteColumns(Row row) {
        if (row == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        Cell cell = null;
        String tmpCellVal = null;
        int cellnum = row.getLastCellNum();
        for (int i = 0; i < cellnum; ++i) {
            cell = row.getCell(i);
            if (cell == null || cell.getCellType() != CellType.STRING) continue;
            RichTextString rstring = cell.getRichStringCellValue();
            String string = tmpCellVal = rstring != null ? rstring.getString() : "";
            if (tmpCellVal.indexOf("$J") == -1 && tmpCellVal.indexOf("$j") == -1) continue;
            list.add(i);
            tmpCellVal = tmpCellVal.replaceAll("\\$[jJ]", "");
            CellUtil.setCellValue(cell, tmpCellVal);
        }
        int num = list.size();
        if (num == 0) {
            return null;
        }
        int[] ret = new int[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    private Map<Integer, List<Integer>> checkGroupColumns(Row row) {
        Pattern pat = Pattern.compile("\\$[Gg]([0-9]+)");
        HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>();
        if (row == null) {
            return map;
        }
        int cellnum = row.getLastCellNum();
        for (int i = 0; i < cellnum; ++i) {
            Integer num;
            RichTextString rstring;
            String tmpCellVal;
            Matcher matcher;
            Cell cell = row.getCell(i);
            if (cell == null || cell.getCellType() != CellType.STRING || !(matcher = pat.matcher(tmpCellVal = (rstring = cell.getRichStringCellValue()) != null ? rstring.getString() : "")).find()) continue;
            String numstr = matcher.group(1);
            try {
                num = Integer.valueOf(numstr);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("illegal number format " + numstr, (Throwable)e);
                if (!LOGGER.isDebugEnabled()) continue;
                e.printStackTrace();
                continue;
            }
            List<Integer> list = map.get(num);
            if (list == null) {
                list = new ArrayList<Integer>();
                map.put(num, list);
            }
            list.add(i);
            tmpCellVal = matcher.replaceAll("");
            CellUtil.setCellValue(cell, tmpCellVal);
        }
        return map;
    }
}

