/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.repgen.AbstractReportGenerator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.xerces.impl.dv.util.Base64;

public abstract class POIReportGenerator
extends AbstractReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger((String)POIReportGenerator.class.getName());
    private boolean debug = false;
    protected Drawing patriarch = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean replaceImage(Cell aCell, Map<String, Object> params, Map<String, String> typeparams, int rows, Sheet sheet, Workbook workbook) {
        int pictureIndex;
        String paramkey;
        String rstring = aCell.getStringCellValue();
        if (this.debug) {
            System.out.println("<in> rstring=" + rstring);
        }
        if (rstring.indexOf("_jshfilename:image") < 0) {
            return false;
        }
        String option = rstring.substring(rstring.indexOf("_jshfilename:image") + "_jshfilename:image".length());
        if (params.containsKey("${resultsize}") || rstring.indexOf("_lp.") > 0) {
            option = option.substring(0, option.lastIndexOf("."));
        }
        if (this.debug) {
            System.out.println(">>> rstring=" + rstring + ",option=" + option);
        }
        String col2 = null;
        String row2 = null;
        String scale_x = null;
        String scale_y = null;
        if (StringUtils.isNotBlank((CharSequence)option)) {
            String[] tokens;
            if ((option = option.trim()).endsWith("}")) {
                option = option.substring(0, option.length() - 1);
            }
            rstring = rstring.replace(option, "");
            for (String token : tokens = option.split(":")) {
                int ptr = token.indexOf("=");
                if (ptr <= 0) continue;
                String _key = token.substring(0, ptr);
                String _value = token.substring(ptr + 1);
                if (_key.equals("col")) {
                    col2 = _value;
                    continue;
                }
                if (_key.equals("row")) {
                    row2 = _value;
                    continue;
                }
                if (_key.equals("sx")) {
                    scale_x = _value;
                    continue;
                }
                if (!_key.equals("sy")) continue;
                scale_y = _value;
            }
        }
        String rstring2 = rstring.replace("_jshfilename:image", "");
        rstring = rstring.replace(":image", "");
        String jshfilename = (String)params.get(rstring);
        if (this.debug) {
            System.out.println("jshfilename: " + rstring + "->" + jshfilename);
        }
        String filename = (String)params.get(rstring2);
        if (this.debug) {
            System.out.println("filename: " + rstring2 + "->" + filename);
        }
        if (params.get((paramkey = rstring.substring(0, rstring.length() - 1).trim()) + ":image:col}") != null) {
            col2 = (String)params.get(paramkey + ":image:col}");
        }
        if (params.get(paramkey + ":image:row}") != null) {
            row2 = (String)params.get(paramkey + ":image:row}");
        }
        if (params.get(paramkey + ":image:sx}") != null) {
            scale_x = (String)params.get(paramkey + ":image:sx}");
        }
        if (params.get(paramkey + ":image:sy}") != null) {
            scale_y = (String)params.get(paramkey + ":image:sy}");
        }
        if (this.debug) {
            System.out.println("rstring2=" + rstring2 + ",filename=" + filename + ",jshfilename=" + jshfilename + ",col=" + col2 + ",row=" + row2 + ",x=" + scale_x + ",y=" + scale_y);
        }
        if (filename == null) {
            aCell.setCellValue("");
            return false;
        }
        int ptr = filename != null ? filename.lastIndexOf(".") : -1;
        String ext = ptr > 0 ? filename.substring(ptr + 1) : null;
        Integer PICTURE_TYPE = this.getPictureType(ext);
        if (this.debug) {
            System.out.println("ptr=" + ptr + ",ext=" + ext + ",PICTURE_TYPE=" + PICTURE_TYPE);
        }
        if (PICTURE_TYPE == null) {
            aCell.setCellValue("");
            return false;
        }
        try {
            pictureIndex = this.readPicture(workbook, jshfilename, PICTURE_TYPE);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("FileNotFoudException", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("IOException", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            aCell.setCellValue("");
        }
        CreationHelper helper = workbook.getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setRow1(rows);
        anchor.setCol1(aCell.getColumnIndex());
        anchor.setRow2(rows + (row2 != null ? NumberUtils.toInt((String)row2) : 5));
        anchor.setCol2(aCell.getColumnIndex() + (col2 != null ? NumberUtils.toInt((String)col2) : 5));
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        if (this.patriarch == null) {
            this.patriarch = sheet.createDrawingPatriarch();
            if (this.debug) {
                System.out.println("!! call createDrawingPatriarch !");
            }
        }
        Picture picture = this.patriarch.createPicture(anchor, pictureIndex);
        if (scale_x != null && scale_y != null) {
            picture.resize(NumberUtils.toDouble((String)scale_x), NumberUtils.toDouble((String)scale_y));
        } else {
            picture.resize();
        }
        aCell.setCellValue("");
        return true;
    }

    private Integer getPictureType(String ext) {
        if (ext == null) {
            return null;
        }
        Integer PICTURE_TYPE = null;
        if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg")) {
            PICTURE_TYPE = 5;
        } else if (ext.equalsIgnoreCase("png")) {
            PICTURE_TYPE = 6;
        } else if (ext.equalsIgnoreCase("dib")) {
            PICTURE_TYPE = 7;
        } else if (ext.equalsIgnoreCase("emf")) {
            PICTURE_TYPE = 2;
        } else if (ext.equalsIgnoreCase("wmf")) {
            PICTURE_TYPE = 3;
        }
        return PICTURE_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPicture(Workbook workbook, String jshfilename, Integer PICTURE_TYPE) throws IOException {
        try (FileInputStream inputImage = null;){
            inputImage = new FileInputStream(jshfilename);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputImage);
            int n = workbook.addPicture(bytes, PICTURE_TYPE.intValue());
            return n;
        }
    }

    protected boolean replaceBarcode(Cell aCell, Map<String, Object> params, Map<String, String> typeparams, int rows, Sheet sheet, Workbook workbook) {
        String rstring = aCell.getStringCellValue();
        if (!StringUtils.contains((CharSequence)rstring, (CharSequence)"_jshBarcode")) {
            return false;
        }
        Map<String, String> options = this.getOptions(rstring);
        String barcode = (String)params.get(rstring = rstring.replaceAll("_jshBarcode(:col=\\d+)?(:row=\\d+)?(:sx=\\d\\.\\d:sy=\\d\\.\\d)?", ""));
        if (barcode == null) {
            aCell.setCellValue("");
            return false;
        }
        int pictureIndex = this.readBarcodeImage(workbook, barcode);
        aCell.setCellValue("");
        CreationHelper helper = workbook.getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        this.setAnchorProperty(anchor, rows, aCell, options);
        if (this.patriarch == null) {
            this.patriarch = sheet.createDrawingPatriarch();
        }
        Picture picture = this.patriarch.createPicture(anchor, pictureIndex);
        String scale_x = options.get("sx");
        String scale_y = options.get("sy");
        if (scale_x != null && scale_y != null) {
            picture.resize(NumberUtils.toDouble((String)scale_x), NumberUtils.toDouble((String)scale_y));
        } else {
            picture.resize(1.0, 1.0);
        }
        aCell.setCellValue("");
        return true;
    }

    protected Map<String, String> getOptions(String rstring) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (!StringUtils.contains((CharSequence)rstring, (CharSequence)"_jshBarcode:")) {
            return options;
        }
        String optionString = StringUtils.substringAfter((String)rstring, (String)"_jshBarcode:");
        optionString = StringUtils.substringBefore((String)optionString, (String)"}");
        String[] tokens = (optionString = optionString.trim()).split(":");
        if (tokens.length == 0) {
            return options;
        }
        for (String token : tokens) {
            String[] optionValues = token.split("=");
            if (optionValues.length == 0) continue;
            options.put(optionValues[0], optionValues[1]);
        }
        return options;
    }

    protected void setAnchorProperty(ClientAnchor anchor, int rows, Cell aCell, Map<String, String> options) {
        anchor.setRow1(rows);
        anchor.setCol1(aCell.getColumnIndex());
        anchor.setRow2(rows + NumberUtils.toInt((String)options.get("row"), (int)1));
        anchor.setCol2(aCell.getColumnIndex() + NumberUtils.toInt((String)options.get("col"), (int)1));
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        anchor.setDx1(20);
        anchor.setDy1(20);
        anchor.setDx2(-20);
        anchor.setDy2(-20);
    }

    private int readBarcodeImage(Workbook workbook, String barcode) {
        return workbook.addPicture(Base64.decode((String)barcode), 6);
    }

    protected void finish() {
        this.patriarch = null;
    }
}

