/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.repgen.excel.poi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class RowUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)RowUtil.class.getName());

    private RowUtil() {
    }

    public static Row appendRow(Sheet sheet, Row templateRow, int rowNum) {
        return RowUtil.appendRow(sheet, templateRow, rowNum, null);
    }

    public static Row appendRow(Sheet sheet, Row templateRow, int rowNum, Map<Integer, Integer> unitedPatternMap) {
        Row newRow = sheet.createRow(rowNum);
        if (templateRow == null) {
            return newRow;
        }
        newRow.setHeight(templateRow.getHeight());
        int numMergedRegionSize = sheet.getNumMergedRegions();
        if (unitedPatternMap != null && unitedPatternMap.size() == 0 && numMergedRegionSize > 0) {
            HashMap tmpMap = new HashMap();
            Iterator ite = templateRow.cellIterator();
            while (ite.hasNext()) {
                Cell aCell = (Cell)ite.next();
                int n = aCell.getColumnIndex();
                for (int k = 0; k < numMergedRegionSize; ++k) {
                    CellRangeAddress range = sheet.getMergedRegion(k);
                    if (!range.isInRange(rowNum, n)) continue;
                    int firstColumn = range.getFirstColumn();
                    HashSet<Integer> unitedCellsSet = (HashSet<Integer>)tmpMap.get(firstColumn);
                    if (unitedCellsSet == null) {
                        unitedCellsSet = new HashSet<Integer>();
                        tmpMap.put(firstColumn, unitedCellsSet);
                    }
                    if (n == firstColumn) continue;
                    unitedCellsSet.add(n);
                }
            }
            for (Map.Entry entry : tmpMap.entrySet()) {
                int firstColumn = (Integer)entry.getKey();
                Set unitedColumns = (Set)entry.getValue();
                if (unitedColumns == null || unitedColumns.size() <= 0) continue;
                int lastColumn = Integer.MIN_VALUE;
                Iterator iterator = unitedColumns.iterator();
                while (iterator.hasNext()) {
                    int t = (Integer)iterator.next();
                    if (t <= lastColumn) continue;
                    lastColumn = t;
                }
                if (firstColumn >= lastColumn) continue;
                unitedPatternMap.put(firstColumn, lastColumn);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("final, " + unitedPatternMap);
            }
        }
        int cellnum = templateRow.getLastCellNum();
        for (int i = 0; i < cellnum; ++i) {
            Cell templateCell = templateRow.getCell(i);
            RowUtil.appendCell(newRow, templateCell, i);
        }
        if (unitedPatternMap != null && unitedPatternMap.size() > 0) {
            for (Map.Entry<Integer, Integer> entry : unitedPatternMap.entrySet()) {
                int n = entry.getKey();
                int lastColumn = entry.getValue();
                CellRangeAddress region = new CellRangeAddress(rowNum + 1, rowNum + 1, n, lastColumn);
                sheet.addMergedRegion(region);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Merge cells in the " + (rowNum + 1) + "th row. (" + n + "," + lastColumn + ")");
            }
        }
        return newRow;
    }

    public static Cell appendCell(Row row, Cell templateCell, int cellNum) {
        Cell newCell = null;
        if (templateCell != null) {
            CellType celltype = templateCell.getCellType();
            newCell = row.createCell(cellNum, celltype);
            newCell.setCellStyle(templateCell.getCellStyle());
            if (celltype == CellType.FORMULA) {
                newCell.setCellFormula(templateCell.getCellFormula());
                celltype = templateCell.getCachedFormulaResultType();
            }
            RowUtil.setCellValue(templateCell, newCell, celltype);
        } else {
            newCell = row.createCell(cellNum, CellType.STRING);
            newCell.setCellValue("");
        }
        return newCell;
    }

    private static void setCellValue(Cell templateCell, Cell newCell, CellType celltype) {
        if (celltype == CellType.STRING) {
            newCell.setCellValue(templateCell.getRichStringCellValue());
        } else if (celltype == CellType.BOOLEAN) {
            newCell.setCellValue(templateCell.getBooleanCellValue());
        } else if (celltype == CellType.NUMERIC) {
            newCell.setCellValue(templateCell.getNumericCellValue());
        }
    }

    public static void cleanRow(Row currentRow) {
        if (currentRow == null) {
            return;
        }
        Cell aCell = null;
        int cellnum = currentRow.getLastCellNum();
        for (int i = 0; i < cellnum; ++i) {
            aCell = currentRow.getCell(i);
            if (aCell == null) continue;
            currentRow.removeCell(aCell);
        }
    }
}

