/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.service;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.JFCAppCallbackHandler;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCHttpServletResponse;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoBase;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.controller.LogonForm;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.jfc.service.LogonFormFilter;
import jp.jasminesoft.util.DateTimeUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class LogonService {
    private static final Logger logger = LogManager.getLogger((String)LogonService.class.getName());
    private static LogonFormFilter logonFormFilter;
    private ServletConfig servletConfig;
    @Autowired
    private ApplicationContext appctx;
    private JFCErrorManager errorManager;
    private JfcConfig jfcConfig;
    private LogonStatusManager lsman;
    private Set<String> sessionIdSet = new HashSet<String>();

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Autowired
    public void setJFCErrorManager(JFCErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public JFCErrorManager getJFCErrorManager() {
        return this.errorManager;
    }

    @Autowired
    public void setJFCConfig(JfcConfig jfcConfig) {
        this.jfcConfig = jfcConfig;
    }

    public JfcConfig getJFCConfig() {
        return this.jfcConfig;
    }

    @Autowired
    public void setLogonStatusManager(LogonStatusManager lsman) {
        this.lsman = lsman;
    }

    public LogonStatusManager getLogonStatusManager() {
        return this.lsman;
    }

    public List getRequestScopedInterceptors() {
        return null;
    }

    private String getSessionFixationProtection() {
        return "false";
    }

    private String getSessionFixationProtectionMigrateSessionAttributes() {
        return this.servletConfig.getServletContext().getInitParameter("SessionFixationProtectionMigrateSessionAttributes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(LogonForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String _userid = (String)request.getAttribute("userid");
        String _password = (String)request.getAttribute("password");
        String _language = (String)request.getAttribute("language");
        String _forward_url = (String)request.getAttribute("forward_url");
        String _error_forward_url = (String)request.getAttribute("error_forward_url");
        if (_userid == null && _password == null) {
            _userid = request.getParameter("userid");
            _password = request.getParameter("password");
        }
        if (_language == null) {
            _language = request.getParameter("language");
        }
        if (_language == null && request.getSession(false) != null) {
            HttpSession session = request.getSession();
            _language = (String)session.getAttribute("language");
            session.removeAttribute("language");
        }
        if (_forward_url == null) {
            _forward_url = request.getParameter("forward_url");
        }
        if (_error_forward_url == null) {
            _error_forward_url = request.getParameter("error_forward_url");
        }
        LogonForm logonform = form;
        if (StringUtils.isNotBlank((String)_userid) && StringUtils.isNotBlank((String)_password)) {
            logonform.setUser(_userid);
            logonform.setPass(_password);
        }
        if (StringUtils.isNotBlank((String)_language)) {
            logonform.setLang(_language);
        }
        if (StringUtils.isNotBlank((String)_forward_url)) {
            logonform.setForwardUrl(_forward_url);
        }
        if (StringUtils.isNotBlank((String)_error_forward_url)) {
            logonform.setErrorForwardUrl(_error_forward_url);
        }
        if (request.getSession(false) == null) {
            return this.logon(form, request, response);
        }
        Object object = JFCUtils.getSynchronizedLock(request.getSession());
        synchronized (object) {
            return this.logon(form, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String logon(LogonForm logonform, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object object;
        String locale = JFCUtils.getLocaleString(request);
        HttpSession session = this.initSession(request);
        String sessionid = request.getRequestedSessionId();
        if (sessionid != null) {
            boolean hasSessionId;
            object = this.sessionIdSet;
            synchronized (object) {
                hasSessionId = this.sessionIdSet.contains(sessionid);
                if (!hasSessionId) {
                    this.sessionIdSet.add(sessionid);
                }
            }
            if (hasSessionId) {
                Jfcerrors errors = new Jfcerrors();
                String username = logonform.getUser();
                errors.addJfcerror(this.errorManager.getJfcerror("error.username.doubleclicked", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00005), LogCodeManager.getMessage(LogCode.JFC00005, username));
                session.setAttribute("__jfc_jfcerrors", (Object)errors);
                return "input";
            }
        }
        try {
            ServletConfig config = this.getServletConfig();
            object = this.logon(config, logonform, request, response, null);
            return object;
        }
        finally {
            if (sessionid != null) {
                Set<String> set = this.sessionIdSet;
                synchronized (set) {
                    this.sessionIdSet.remove(sessionid);
                }
            }
        }
    }

    public String logon(ServletConfig config, LogonForm form, HttpServletRequest request, HttpServletResponse response, DataSource dataSource) throws IOException, ServletException {
        LogonForm logonform = form;
        String _remoteUser = request.getRemoteUser();
        if (_remoteUser == null) {
            _remoteUser = "";
        }
        logonform.setUser(_remoteUser);
        logonform.setPass("");
        if (logonFormFilter != null) {
            logonFormFilter.doFilter(logonform);
        }
        Jfcerrors errors = new Jfcerrors();
        String username = logonform.getUser();
        String locale_str = JFCUtils.getLocaleString(request);
        String forward_url = logonform.getForwardUrl();
        String error_forward_url = logonform.getErrorForwardUrl();
        this.outputNocache(config, response);
        HttpSession session = request.getSession(true);
        if (username == null) {
            return this.errorForward(request, error_forward_url, username);
        }
        this.beginLogin(config, request, response, dataSource);
        if (username.length() < 1) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.username.required", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00003), LogCodeManager.getMessage(LogCode.JFC00003, new String[0]));
            this.failureLogin(request, username);
            session.setAttribute("__jfc_jfcerrors", (Object)errors);
            return this.errorForward(request, error_forward_url, username);
        }
        if (username.indexOf(32) >= 0 || username.matches("\\s")) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.username.invalid.space", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00004), LogCodeManager.getMessage(LogCode.JFC00004, username));
            this.failureLogin(request, username);
            session.setAttribute("__jfc_jfcerrors", (Object)errors);
            return this.errorForward(request, error_forward_url, username);
        }
        String realIP = JFCUtils.getRealIP(request);
        User user = null;
        Object object = JFCUtils.getSynchronizedLock(session);
        synchronized (object) {
            String string = username.intern();
            synchronized (string) {
                user = this.logon(logonform, errors, locale_str, realIP);
                try {
                    session = request.getSession();
                    if (user == null || errors.sizeJfcerror() > 0) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00002), LogCodeManager.getMessage(LogCode.JFC00002, username));
                        this.failureLogin(request, username);
                        session.setAttribute("__jfc_jfcerrors", (Object)errors);
                        return this.errorForward(request, error_forward_url, username);
                    }
                    if (user != null) {
                        String __locale_str;
                        Item item;
                        String lang = logonform.getLang();
                        if (StringUtils.isNotBlank((String)lang)) {
                            String locale = JFCUtils.getLocaleStringByAcceptLanguage(lang);
                            user.setPreferenceItem("locale", locale);
                            user.savePreference();
                        }
                        if ((item = user.getPreferenceItem("locale")) != null && StringUtils.isNotEmpty((String)(__locale_str = item.getContent()))) {
                            Locale l = JFCUtils.createLocale(__locale_str);
                            if (l != null) {
                                locale_str = l.toString();
                            } else {
                                locale_str = JFCUtils.getLocaleString();
                                user.removePreferenceItem(item);
                            }
                        }
                    }
                    LoginContext lc = user.getLoginContext();
                    this.acceptLogin(request, username, logonform.getPass(), errors, locale_str);
                    if (errors.sizeJfcerror() > 0) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00006), LogCodeManager.getMessage(LogCode.JFC00006, username));
                        try {
                            lc.logout();
                        }
                        catch (LoginException item) {
                            // empty catch block
                        }
                        this.failureLogin(request, username);
                        session.setAttribute("__jfc_jfcerrors", (Object)errors);
                        return this.errorForward(request, error_forward_url, username);
                    }
                    this.showDebugInfo(lc);
                    logonform.reset(request);
                    int Session_Timeout = this.jfcConfig.getSessionTimeout();
                    session.setMaxInactiveInterval(Session_Timeout);
                    user.setSaveLastAccessTimeAtLogoff(this.jfcConfig.isSaveLastAccessTimeAtLogoff());
                    JFCUtils.setUserInSession(session, user);
                    this.lsman.registerUserObject(user);
                    JFCUtils.clearSessionCache(session);
                    this.successLogin(request, response, user, errors);
                    if (errors.sizeJfcerror() > 0) {
                        session.invalidate();
                        this.failureLogin(request, username, errors);
                        session.setAttribute("__jfc_jfcerrors", (Object)errors);
                        return this.errorForward(request, error_forward_url, username);
                    }
                    session.setAttribute("__jfc_jfcerrors", (Object)errors);
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00001), LogCodeManager.getMessage(LogCode.JFC00001, username, locale_str));
                    this.initializeInternetAccount(user, request, response);
                    if (response instanceof JFCHttpServletResponse) {
                        JFCHttpServletResponse jresponse = (JFCHttpServletResponse)response;
                        Map<String, Object> redirectMap = jresponse.getRedirectMap();
                        if (redirectMap == null) {
                            redirectMap = new HashMap<String, Object>();
                            jresponse.setRedirectMap(redirectMap);
                        }
                        jresponse.setHttpRequest(request);
                        redirectMap.put("__jfc_newlogon", Boolean.TRUE);
                    }
                    request.setAttribute("__jfc_newlogon", (Object)Boolean.TRUE);
                    String forward = null;
                    if (forward_url != null && forward_url.length() > 0) {
                        forward = this.getAfterLogonForward(request, forward_url, username);
                    }
                    if (forward == null && !JFCUtils.isInternetAccount(username)) {
                        forward = "logon.afterLogon";
                    }
                    if (forward == null) {
                        forward = "mainMenu";
                    }
                    return forward;
                }
                catch (RuntimeException e) {
                    if (session == null || StringUtils.isBlank((String)session.getId()) || !this.lsman.releaseUserObject(username, session.getId())) {
                        this.lsman.removeUserName(username);
                    }
                    throw e;
                }
            }
        }
    }

    protected HttpSession initSession(HttpServletRequest request) {
        if ("false".equalsIgnoreCase(this.getSessionFixationProtection())) {
            return request.getSession();
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return request.getSession();
        }
        HashMap<String, Object> oldSessionAttributesMap = new HashMap<String, Object>();
        if (!"false".equalsIgnoreCase(this.getSessionFixationProtectionMigrateSessionAttributes())) {
            Enumeration e = session.getAttributeNames();
            while (e.hasMoreElements()) {
                String attributeName = (String)e.nextElement();
                if (attributeName.equals("__jfc_user")) continue;
                oldSessionAttributesMap.put(attributeName, session.getAttribute(attributeName));
            }
        }
        session.invalidate();
        session = request.getSession(true);
        for (Map.Entry entry : oldSessionAttributesMap.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
        return session;
    }

    protected void initializeInternetAccount(User user, HttpServletRequest request, HttpServletResponse response) {
        if (!User.isIgnoreLogoncheck()) {
            return;
        }
        boolean isInternetAccount = user.isInternetAccount();
        Cookie cookie = new Cookie("__jfc_cookie_internet_account", String.valueOf(isInternetAccount));
        cookie.setPath(request.getContextPath());
        if (!user.isInternetAccount()) {
            cookie.setMaxAge(0);
        }
        response.addCookie(cookie);
    }

    public String getAfterLogonForward(HttpServletRequest request, String forward_url, String username) {
        String forward = null;
        forward = forward_url != null && (forward_url.indexOf("?") > 0 || forward_url.endsWith(".do")) ? "redirect:" + forward_url : "forward:" + forward_url;
        if (forward == null) {
            forward = "redirect:" + forward_url;
        }
        return forward;
    }

    public String errorForward(HttpServletRequest request, String error_forward_url, String username) {
        if (error_forward_url != null && error_forward_url.length() > 0) {
            String forward = this.getAfterLogonForward(request, error_forward_url, username);
            return forward;
        }
        return "logon.input";
    }

    protected void outputNocache(ServletConfig config, HttpServletResponse response) {
        if (response == null) {
            return;
        }
        response.setHeader("Expires", JFCUtils.getHTTPDate());
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, private");
        response.setHeader("Pragma", "no-cache");
    }

    protected boolean isOutputNocache() {
        return true;
    }

    private User logon(LogonForm form, Jfcerrors errors, String locale, String remoteaddress) {
        String username = form.getUser();
        String password = form.getPass();
        return this.logon(username, password, errors, locale, remoteaddress);
    }

    public User logon(String username, String password, Jfcerrors errors, String locale, String remoteaddress) {
        return this.logon(username, password, errors, locale, this.jfcConfig.getLogonModuleName(), remoteaddress);
    }

    public User logon(String username, String password, Jfcerrors errors, String locale, String logonModuleName, String remoteaddress) {
        return this.logon(username, password, errors, locale, logonModuleName, remoteaddress, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User logon(String username, String password, Jfcerrors errors, String locale, String logonModuleName, String remoteaddress, boolean isPasswordErrorCountProcess) {
        String string = username.intern();
        synchronized (string) {
            int Max_Logon;
            LoginContext lc = null;
            try {
                JFCAppCallbackHandler callback = new JFCAppCallbackHandler(username, password);
                lc = new LoginContext(logonModuleName, callback);
            }
            catch (LoginException le) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.unknown", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00007), LogCodeManager.getMessage(LogCode.JFC00007, username));
                logger.debug((Object)le);
                if (!logger.isDebugEnabled()) return null;
                le.printStackTrace();
                return null;
            }
            int mcount = this.jfcConfig.getUserinfoFailedpasswordCount();
            if (!isPasswordErrorCountProcess) {
                mcount = -1;
            }
            try {
                lc.login();
            }
            catch (AccountExpiredException aee) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.account.expired", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00008), LogCodeManager.getMessage(LogCode.JFC00008, username));
                logger.debug((Object)aee);
                if (!logger.isDebugEnabled()) return null;
                aee.printStackTrace();
                return null;
            }
            catch (CredentialExpiredException cee) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.credential.expired", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00009), LogCodeManager.getMessage(LogCode.JFC00009, username));
                logger.debug((Object)cee);
                if (!logger.isDebugEnabled()) return null;
                cee.printStackTrace();
                return null;
            }
            catch (FailedLoginException fle) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.password.mismatch", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00010), LogCodeManager.getMessage(LogCode.JFC00010, username));
                logger.debug((Object)fle);
                if (logger.isDebugEnabled()) {
                    fle.printStackTrace();
                }
                if (mcount <= 0) return null;
                UserInfo userinfo = UserInfoFactory.getUserInfo();
                if (userinfo != null) {
                    try {
                        UserInfoBase userinfobase = (UserInfoBase)userinfo;
                        IJuser juser = userinfobase.getJuser(username);
                        if (juser == null) return null;
                        if (juser.getPasswdErrCount() < 1) {
                            juser.setPasswdErrCount(1);
                        } else {
                            juser.setPasswdErrCount(juser.getPasswdErrCount() + 1);
                        }
                        userinfobase.updateJuser(juser);
                    }
                    catch (Exception e) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00011), LogCodeManager.getMessage(LogCode.JFC00011, username));
                    }
                    finally {
                        userinfo.close();
                    }
                } else {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00012), LogCodeManager.getMessage(LogCode.JFC00012, new String[0]));
                }
                return null;
            }
            catch (Exception e) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.unknown", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00013), LogCodeManager.getMessage(LogCode.JFC00013, username));
                logger.debug((Object)e);
                if (!logger.isDebugEnabled()) return null;
                e.printStackTrace();
                return null;
            }
            User user = new User(username, lc, logonModuleName, this.appctx);
            Subject subject = user.getLoginContext().getSubject();
            HashSet pSet = subject != null ? subject.getPrincipals() : new HashSet();
            for (Principal principal : pSet) {
                String __name = principal.getName();
                if (__name == null || __name.length() == 0 || !"jobAccount".equals(__name) || "JFCAppJob".equals(logonModuleName)) continue;
                errors.addJfcerror(this.errorManager.getJfcerror("error.password.mismatch", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00036), LogCodeManager.getMessage(LogCode.JFC00036, username));
                return null;
            }
            UserInfo userinfo = UserInfoFactory.getUserInfo();
            if (userinfo == null) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.unknown", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00017), LogCodeManager.getMessage(LogCode.JFC00017, username));
                return null;
            }
            try {
                boolean setLastLogonDateMethodCall;
                IJuser juser;
                block98: {
                    block96: {
                        juser = userinfo.getJuser(username);
                        if (juser == null) {
                            block95: {
                                logger.log(LogCodeManager.getPriority(LogCode.JFC00014), LogCodeManager.getMessage(LogCode.JFC00014, username));
                                try {
                                    lc.logout();
                                }
                                catch (LoginException e) {
                                    logger.debug("Logout failed, user " + username, (Throwable)e);
                                    if (!logger.isDebugEnabled()) break block95;
                                    e.printStackTrace();
                                }
                            }
                            User e = null;
                            return e;
                        }
                        if (remoteaddress != null) {
                            try {
                                block97: {
                                    if (this.checkRemoteAddress(remoteaddress, juser)) break block96;
                                    errors.addJfcerror(this.errorManager.getJfcerror("error.logon.rule.mismatch", locale));
                                    logger.log(LogCodeManager.getPriority(LogCode.JFC00035), LogCodeManager.getMessage(LogCode.JFC00035, username, remoteaddress));
                                    try {
                                        lc.logout();
                                    }
                                    catch (LoginException e) {
                                        logger.debug("Logout failed, user " + username, (Throwable)e);
                                        if (!logger.isDebugEnabled()) break block97;
                                        e.printStackTrace();
                                    }
                                }
                                User e = null;
                            }
                            catch (NoSuchMethodException e) {
                                break block96;
                            }
                            catch (SecurityException e) {
                                break block96;
                            }
                            catch (IllegalAccessException ex) {
                                logger.log(LogCodeManager.getPriority(LogCode.JFC00034), LogCodeManager.getMessage(LogCode.JFC00034, username));
                                logger.debug("Failed to check rule, user " + username, (Throwable)ex);
                                if (!logger.isDebugEnabled()) break block96;
                                ex.printStackTrace();
                                break block96;
                            }
                            catch (IllegalArgumentException ex) {
                                logger.log(LogCodeManager.getPriority(LogCode.JFC00034), LogCodeManager.getMessage(LogCode.JFC00034, username));
                                logger.debug("Failed to check rule, user " + username, (Throwable)ex);
                                if (!logger.isDebugEnabled()) break block96;
                                ex.printStackTrace();
                                break block96;
                            }
                            catch (InvocationTargetException ex) {
                                logger.log(LogCodeManager.getPriority(LogCode.JFC00034), LogCodeManager.getMessage(LogCode.JFC00034, username));
                                logger.debug("Failed to check rule, user " + username, (Throwable)ex);
                                if (!logger.isDebugEnabled()) break block96;
                                ex.printStackTrace();
                                break block96;
                            }
                            return e;
                        }
                    }
                    setLastLogonDateMethodCall = false;
                    if (!"JFCAppJob".equals(logonModuleName)) {
                        try {
                            Method method = juser.getClass().getDeclaredMethod("setLastLogonDate", Timestamp.class);
                            if (method != null) {
                                method.invoke((Object)juser, DateTimeUtil.getSQLTimestamp());
                                setLastLogonDateMethodCall = true;
                            }
                        }
                        catch (NoSuchMethodException method) {
                        }
                        catch (SecurityException method) {
                        }
                        catch (IllegalAccessException ex) {
                            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, username));
                            logger.debug("Failed to call setLastLogonDate method, user " + username, (Throwable)ex);
                            if (logger.isDebugEnabled()) {
                                ex.printStackTrace();
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, username));
                            logger.debug("Failed to call setLastLogonDate method, user " + username, (Throwable)ex);
                            if (logger.isDebugEnabled()) {
                                ex.printStackTrace();
                            }
                        }
                        catch (InvocationTargetException ex) {
                            logger.log(LogCodeManager.getPriority(LogCode.JFC00063), LogCodeManager.getMessage(LogCode.JFC00063, username));
                            logger.debug("Failed to call setLastLogonDate method, user " + username, (Throwable)ex);
                            if (!logger.isDebugEnabled()) break block98;
                            ex.printStackTrace();
                        }
                    }
                }
                user.setJuser(juser);
                boolean hasUpdateUserinfoFlag = false;
                if (mcount > 0) {
                    if (!LogonService.checkPermission(user) && mcount <= juser.getPasswdErrCount()) {
                        block99: {
                            juser.setValid(new Timestamp(System.currentTimeMillis()).toString());
                            juser.setPasswdErrCount(0);
                            userinfo.updateJuser(juser);
                            hasUpdateUserinfoFlag = true;
                            errors.addJfcerror(this.errorManager.getJfcerror("error.account.expired", locale));
                            logger.log(LogCodeManager.getPriority(LogCode.JFC00015), LogCodeManager.getMessage(LogCode.JFC00015, username));
                            try {
                                lc.logout();
                            }
                            catch (LoginException e) {
                                logger.debug("Logout failed, user " + username, (Throwable)e);
                                if (!logger.isDebugEnabled()) break block99;
                                e.printStackTrace();
                            }
                        }
                        User e = null;
                        return e;
                    }
                    if (juser.getPasswdErrCount() > 0) {
                        juser.setPasswdErrCount(0);
                        userinfo.updateJuser(juser);
                        hasUpdateUserinfoFlag = true;
                    }
                }
                if (setLastLogonDateMethodCall && !hasUpdateUserinfoFlag) {
                    userinfo.updateJuser(juser);
                }
            }
            catch (Exception e) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.unknown", locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00016), LogCodeManager.getMessage(LogCode.JFC00016, username));
                logger.debug((Object)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                User setLastLogonDateMethodCall = null;
                return setLastLogonDateMethodCall;
            }
            finally {
                userinfo.close();
            }
            int Max_Multiple_Logon = this.jfcConfig.getMaxMultipleLogon();
            if ("JFCAppJob".equals(logonModuleName)) {
                Max_Multiple_Logon = -1;
            }
            if (!this.lsman.addUserName(username, Max_Multiple_Logon)) {
                Object[] o = new Object[]{"" + Max_Multiple_Logon};
                if (this.jfcConfig.isAutoLogoff()) {
                    boolean ret = this.lsman.releaseLastUserObject(username);
                    if (!ret) {
                        errors.addJfcerror(this.errorManager.getJfcerror("error.logon.multiple.over", o, locale));
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00021), LogCodeManager.getMessage(LogCode.JFC00021, username));
                        try {
                            lc.logout();
                        }
                        catch (LoginException e) {
                            logger.debug("Logout failed, user " + username, (Throwable)e);
                            if (!logger.isDebugEnabled()) return null;
                            e.printStackTrace();
                        }
                        return null;
                    }
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00020), LogCodeManager.getMessage(LogCode.JFC00020, username, String.valueOf(Max_Multiple_Logon)));
                    if (!this.lsman.addUserName(username, Max_Multiple_Logon)) {
                        errors.addJfcerror(this.errorManager.getJfcerror("error.logon.multiple.over", o, locale));
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00021), LogCodeManager.getMessage(LogCode.JFC00021, username));
                        try {
                            lc.logout();
                        }
                        catch (LoginException e) {
                            logger.debug("Logout failed, user " + username, (Throwable)e);
                            if (!logger.isDebugEnabled()) return null;
                            e.printStackTrace();
                        }
                        return null;
                    }
                } else {
                    errors.addJfcerror(this.errorManager.getJfcerror("error.logon.multiple.over", o, locale));
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00022), LogCodeManager.getMessage(LogCode.JFC00022, username, String.valueOf(Max_Multiple_Logon)));
                    try {
                        lc.logout();
                    }
                    catch (LoginException e) {
                        logger.debug("Logout failed, user " + username, (Throwable)e);
                        if (!logger.isDebugEnabled()) return null;
                        e.printStackTrace();
                    }
                    return null;
                }
            }
            boolean isReleaseLogonUser = false;
            ArrayList<Principal> removeList = new ArrayList<Principal>();
            for (Principal principal : pSet) {
                String __name = principal.getName();
                if (__name == null || __name.length() == 0) continue;
                if ("releaseLogonUser".equals(__name)) {
                    isReleaseLogonUser = true;
                    continue;
                }
                if ("default".equals(__name) || "jshparam_all_users".equals(__name) || user.getUsername().equals(__name)) continue;
                removeList.add(principal);
            }
            if (isReleaseLogonUser && removeList.size() > 0) {
                isReleaseLogonUser = false;
            }
            if (!(this.lsman.checkSystemMaxLogon(Max_Logon = this.jfcConfig.getMaxLogon()) || isReleaseLogonUser && removeList.size() == 0)) {
                if (isReleaseLogonUser) {
                    logger.log(LogCodeManager.getPriority(LogCode.JFC00018), LogCodeManager.getMessage(LogCode.JFC00018, ((Object)removeList).toString()));
                }
                isReleaseLogonUser = false;
                errors.addJfcerror(this.errorManager.getJfcerror("error.logon.over", locale));
                long count = this.lsman.getSessionCount() + 1L;
                logger.log(LogCodeManager.getPriority(LogCode.JFC00019), LogCodeManager.getMessage(LogCode.JFC00019, username, String.valueOf(count), String.valueOf(Max_Logon)));
                try {
                    lc.logout();
                }
                catch (LoginException e) {
                    logger.debug("Logout failed, user " + username, (Throwable)e);
                    if (!logger.isDebugEnabled()) return null;
                    e.printStackTrace();
                }
                finally {
                    this.lsman.removeUserName(username);
                }
                return null;
            }
            if (!isReleaseLogonUser && !this.lsman.check(username)) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.logon.license.over", locale));
                try {
                    lc.logout();
                }
                catch (LoginException e) {
                    logger.debug("Logout failed, user " + username, (Throwable)e);
                    if (!logger.isDebugEnabled()) return null;
                    e.printStackTrace();
                }
                finally {
                    this.lsman.removeUserName(username);
                }
                return null;
            }
            if (this.checkMaxAccount(user, errors, locale)) return user;
            return null;
        }
    }

    private boolean checkRemoteAddress(String remoteaddress, IJuser juser) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        List<String> list = this.getRuleIpaddress(juser);
        if (list == null) {
            return true;
        }
        Pattern pat_ipv4 = Pattern.compile("^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        Pattern pat_ipv6 = Pattern.compile("^[0-9a-fA-F:.]*$");
        InetAddress remoteinetaddress = null;
        for (String ipaddress : list) {
            Pattern pattern;
            if (pat_ipv4.matcher(ipaddress).find() || pat_ipv6.matcher(ipaddress).find()) {
                if (remoteinetaddress == null) {
                    try {
                        remoteinetaddress = InetAddress.getByName(remoteaddress);
                    }
                    catch (UnknownHostException e) {
                        logger.warn("Unknown ipaddress " + remoteaddress);
                        logger.debug("skip. rule ipaddress:" + ipaddress);
                        continue;
                    }
                }
                try {
                    InetAddress inetaddress = InetAddress.getByName(ipaddress.trim());
                    if (remoteinetaddress.equals(inetaddress)) {
                        logger.debug("match inetaddress " + remoteinetaddress + ". rule inetaddress:" + inetaddress);
                        return true;
                    }
                    logger.debug("not match inetaddress " + remoteinetaddress + ". rule inetaddress:" + inetaddress);
                }
                catch (UnknownHostException e) {
                    logger.warn("Unknown rule ipaddress " + ipaddress);
                }
                continue;
            }
            try {
                pattern = Pattern.compile(ipaddress.trim());
            }
            catch (PatternSyntaxException e) {
                logger.warn("Illegal rule pattern " + ipaddress, (Throwable)e);
                continue;
            }
            Matcher matcher = pattern.matcher(remoteaddress);
            if (matcher.find()) {
                logger.debug("match ipaddress " + remoteaddress + ". rule regex:" + ipaddress);
                return true;
            }
            logger.debug("not match ipaddress " + remoteaddress + ". rule regex:" + ipaddress);
        }
        return false;
    }

    private List<String> splitAddress(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        block0: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '{') {
                while (c != '}') {
                    buf.append(c);
                    if (++i >= s.length()) break block0;
                    c = s.charAt(i);
                    if (c != '\\') continue;
                    buf.append(c);
                    if (++i >= s.length()) break block0;
                    c = s.charAt(i);
                    buf.append(c);
                    if (++i >= s.length()) break block0;
                    c = s.charAt(i);
                }
                buf.append(c);
                continue;
            }
            if (c == '[') {
                while (c != ']') {
                    buf.append(c);
                    if (++i >= s.length()) break block0;
                    c = s.charAt(i);
                    if (c != '\\') continue;
                    buf.append(c);
                    if (++i >= s.length()) break block0;
                    c = s.charAt(i);
                    buf.append(c);
                    if (++i >= s.length()) break block0;
                    c = s.charAt(i);
                }
                buf.append(c);
                continue;
            }
            if (c == '\\') {
                buf.append(c);
                if (++i >= s.length()) break;
                c = s.charAt(i);
                buf.append(c);
                continue;
            }
            if (c == ',') {
                list.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            if (list.size() == 0) {
                list.add(s);
            } else {
                list.add(buf.toString());
            }
        }
        return list;
    }

    private List<String> getRuleIpaddress(IJuser juser) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = juser.getClass().getDeclaredMethod("getRule", new Class[0]);
        if (method == null) {
            return null;
        }
        Object ary = method.invoke((Object)juser, new Object[0]);
        if (ary == null || !ary.getClass().isArray()) {
            return null;
        }
        int length = Array.getLength(ary);
        if (length <= 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            Object ret;
            Object obj = Array.get(ary, i);
            Method method2 = obj.getClass().getDeclaredMethod("getIpaddress", new Class[0]);
            if (method2 == null || !((ret = method2.invoke(obj, new Object[0])) instanceof String)) continue;
            list.addAll(this.splitAddress((String)ret));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkMaxAccount(User user, Jfcerrors errors, String locale) {
        if (JFCUtils.hasPrincipal(user, "all")) {
            return true;
        }
        if (!this.lsman.checkMaxAccount(user)) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.logon.license.max_account.over", locale));
            try {
                user.getLoginContext().logout();
            }
            catch (LoginException e) {
                logger.debug("Logout failed, user " + user.getUsername(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            finally {
                this.lsman.removeUserName(user.getUsername());
            }
            return false;
        }
        return true;
    }

    private void showDebugInfo(LoginContext lc) {
        logger.debug("-- LogonAction::showDebugInfo() --");
        Subject subject = lc.getSubject();
        Set<Principal> set = subject.getPrincipals();
        for (Principal p : set) {
            logger.debug((Object)p);
        }
        logger.debug("subject:" + subject);
    }

    public void beginLogin(ServletConfig config, HttpServletRequest request, HttpServletResponse response, DataSource dataSource) {
        if (dataSource == null) {
            logger.debug("Begin to create data source.");
            dataSource = JFCUtils.getDataSource();
            logger.debug("Finish to create data source. " + dataSource);
        }
    }

    public void acceptLogin(HttpServletRequest request, String username, String password, Jfcerrors errors, String locale) {
        if (this.acceptLogin(request, username, password)) {
            return;
        }
        errors.addJfcerror(this.errorManager.getJfcerror("error.password.mismatch", locale));
    }

    protected static boolean checkPermission(User user) {
        if (user == null) {
            return false;
        }
        CheckPermission checkp = CheckPermissionFactory.getCheckPermission();
        if (checkp == null) {
            return false;
        }
        Permission perm = LogonService.getPermission();
        return checkp.process(user, perm);
    }

    protected static Permission getPermission() {
        return User.UNLOCK_PERMISSION;
    }

    public boolean acceptLogin(HttpServletRequest request, String username, String password) {
        return this.acceptLogin(request, username);
    }

    public boolean acceptLogin(HttpServletRequest request, String username) {
        return true;
    }

    public void failureLogin(HttpServletRequest request, String username, Jfcerrors errors) {
        this.failureLogin(request, username);
    }

    public void failureLogin(HttpServletRequest request, String username) {
    }

    public void successLogin(HttpServletRequest request, HttpServletResponse response, User user, Jfcerrors errors) {
        this.successLogin(request, user.getUsername(), errors);
    }

    @Deprecated
    public void successLogin(HttpServletRequest request, String username, Jfcerrors errors) {
        this.successLogin(request, username);
    }

    @Deprecated
    public void successLogin(HttpServletRequest request, String username) {
    }

    static {
        String logonFormFilterClassname = PropertyManager.getProperty("jp.jasminesoft.jfc.LogonFormFilterName");
        if (StringUtils.isNotBlank((String)logonFormFilterClassname)) {
            try {
                Class<?> clazz = Class.forName(logonFormFilterClassname);
                logonFormFilter = (LogonFormFilter)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

