/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.service;

import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.controller.DbUpdateBaseController;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecalcService<E extends ContainerBase<E>, PK extends Serializable> {
    private static final Logger logger = LogManager.getLogger(RecalcService.class);
    protected String modelId;
    protected JFCEntityService<E, PK> entityService;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setEntityService(JFCEntityService<E, PK> entityService) {
        this.entityService = entityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recalc(ActionParameter p) {
        int counter = 0;
        p.request.setAttribute("__jfc_control.skip_input_check", (Object)Boolean.TRUE);
        if (StringUtils.isBlank((String)p.request.getParameter("updateuserflag"))) {
            p.pageMap.put("__jfc_control.skipUpdateuser", Boolean.TRUE);
        }
        if (StringUtils.isBlank((String)p.request.getParameter("updatetimeflag"))) {
            p.pageMap.put("__jfc_control.skipUpdatetime", Boolean.TRUE);
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(StoreModelUtils.getStoreModelClass(this.modelId, p));
        for (Serializable key : this.entityService.findKeys(criteria, -1, -1)) {
            DbUpdateBaseController controller = (DbUpdateBaseController)p.appctx.getBean("update" + StringUtil.capFirst((String)this.modelId) + "Controller", DbUpdateBaseController.class);
            if (!controller.checkPermission(p)) continue;
            String keyname = Stream.of(StoreModelUtils.primarykeyNames(this.modelId, p)).collect(Collectors.joining(PrimaryKeyUtils.PKEY_SEPARATOR()));
            String stringKey = PrimaryKeyUtils.toString(key);
            p.request.setAttribute("_" + keyname, (Object)stringKey);
            p.request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
            p.request.setAttribute("__jfc_control.recalc_mode." + this.modelId, (Object)Boolean.TRUE);
            try {
                p.action = "Update";
                controller.perform_db(p);
                p.action = "Send";
                controller.perform_db(p);
                p.errors.clearJfcinfo();
                ++counter;
            }
            catch (Exception e) {
                logger.error("Exception has occured in recalc, model=" + this.modelId + ", " + keyname + "=" + stringKey + " " + e.getMessage());
            }
            finally {
                if (controller == null) continue;
                controller.releaseLock(p);
            }
        }
        p.request.removeAttribute("__jfc_control.skip_input_check");
        return counter;
    }
}

