/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.tag;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.tag.CheckUsernameTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CheckJgroupidTag
extends CheckUsernameTag {
    private static final Logger logger = LogManager.getLogger((String)CheckJgroupidTag.class.getName());
    private int group = Integer.MIN_VALUE;
    private int[] groups;
    private boolean isSubGroup = false;

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public void setGroup(String str_group) {
        try {
            this.group = Integer.parseInt(str_group);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)nfe);
            this.group = Integer.MIN_VALUE;
        }
    }

    public int[] getGroups() {
        if (this.groups != null) {
            return (int[])this.groups.clone();
        }
        return null;
    }

    public void setGroups(int[] groups) {
        if (groups != null) {
            this.groups = (int[])groups.clone();
        }
    }

    public void setGroups(String[] str_groups) {
        this.groups = new int[str_groups.length];
        for (int i = 0; i < str_groups.length; ++i) {
            try {
                this.groups[i] = Integer.parseInt(str_groups[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)nfe);
                this.groups[i] = Integer.MIN_VALUE;
            }
        }
    }

    public void setSubGroup(String isSubGroup) {
        this.isSubGroup = Boolean.valueOf(isSubGroup);
    }

    public String getSubGroup() {
        return String.valueOf(this.isSubGroup);
    }

    @Override
    boolean check() {
        HttpServletRequest request;
        HttpSession session = this.pageContext.getSession();
        User userObj = JFCUtils.getUserInSession(session, request = (HttpServletRequest)this.pageContext.getRequest());
        if (userObj == null || !(userObj instanceof User)) {
            return false;
        }
        int[] user_groupid = this.isSubGroup ? userObj.getSubGroupIds() : userObj.getGroupId();
        if (user_groupid == null || user_groupid.length == 0) {
            return false;
        }
        for (int i = 0; i < user_groupid.length; ++i) {
            if (this.group != Integer.MIN_VALUE && this.group == user_groupid[i]) {
                return true;
            }
            if (this.groups == null) continue;
            for (int j = 0; j < this.groups.length; ++j) {
                if (this.groups[j] != user_groupid[i]) continue;
                return true;
            }
        }
        return false;
    }
}

