/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Version;

public class CJKAndStandardTokenizer
extends Tokenizer {
    private StandardTokenizer standardTokenizer;
    private Version matchVersion;
    private boolean replaceInvalidAcronym;
    private int maxTokenLength = 255;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private AttributeSource.State currState = null;
    private AttributeSource.State prevState = null;
    private boolean readAhead = false;

    public CJKAndStandardTokenizer(Reader input, boolean replaceInvalidAcronym) {
        this(Version.LUCENE_24, input, replaceInvalidAcronym);
    }

    public CJKAndStandardTokenizer(Reader input) {
        this(Version.LUCENE_24, input, true);
    }

    public CJKAndStandardTokenizer(Version matchVersion, Reader input, boolean replaceInvalidAcronym) {
        this.matchVersion = matchVersion;
        this.replaceInvalidAcronym = replaceInvalidAcronym;
        this.standardTokenizer = new StandardTokenizer(this.matchVersion, input);
        this.standardTokenizer.setReplaceInvalidAcronym(replaceInvalidAcronym);
        this.standardTokenizer.setMaxTokenLength(this.maxTokenLength);
        this.init(matchVersion);
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    private void init(Version matchVersion) {
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.readAhead) {
            if (!this.standardTokenizer.incrementToken()) {
                return false;
            }
            this.currState = this.standardTokenizer.captureState();
        } else {
            this.readAhead = false;
        }
        if (this.isCurrentTokenNotCJ()) {
            this.setAttributeForNonCJKToken();
            return true;
        }
        this.prevState = this.currState;
        if (!this.standardTokenizer.incrementToken()) {
            return false;
        }
        this.currState = this.standardTokenizer.captureState();
        if (this.isCurrentTokenNotCJ()) {
            this.prevState = null;
            this.setAttributeForNonCJKToken();
            return true;
        }
        this.setAttributeForCJKToken();
        this.readAhead = true;
        return true;
    }

    private boolean isCurrentTokenNotCJ() {
        return !StandardTokenizer.TOKEN_TYPES[7].equals(((TypeAttribute)this.standardTokenizer.getAttribute(TypeAttribute.class)).type());
    }

    private void setAttributeForCJKToken() {
        StringBuffer termSb = new StringBuffer();
        this.standardTokenizer.restoreState(this.prevState);
        termSb.append(((TermAttribute)this.standardTokenizer.getAttribute(TermAttribute.class)).term());
        int startOffset = ((OffsetAttribute)this.standardTokenizer.getAttribute(OffsetAttribute.class)).startOffset();
        this.standardTokenizer.restoreState(this.currState);
        termSb.append(((TermAttribute)this.standardTokenizer.getAttribute(TermAttribute.class)).term());
        this.termAtt.setTermBuffer(termSb.toString());
        this.offsetAtt.setOffset(startOffset, ((OffsetAttribute)this.standardTokenizer.getAttribute(OffsetAttribute.class)).endOffset());
        this.typeAtt.setType(((TypeAttribute)this.standardTokenizer.getAttribute(TypeAttribute.class)).type());
    }

    private void setAttributeForNonCJKToken() {
        this.termAtt.setTermBuffer(((TermAttribute)this.standardTokenizer.getAttribute(TermAttribute.class)).term());
        this.offsetAtt.setOffset(((OffsetAttribute)this.standardTokenizer.getAttribute(OffsetAttribute.class)).startOffset(), ((OffsetAttribute)this.standardTokenizer.getAttribute(OffsetAttribute.class)).endOffset());
        this.typeAtt.setType(((TypeAttribute)this.standardTokenizer.getAttribute(TypeAttribute.class)).type());
    }

    public void close() throws IOException {
        if (this.standardTokenizer != null) {
            this.standardTokenizer.close();
        }
    }

    public void reset(Reader input) throws IOException {
        this.standardTokenizer = new StandardTokenizer(this.matchVersion, input);
        this.standardTokenizer.setReplaceInvalidAcronym(this.replaceInvalidAcronym);
        this.standardTokenizer.setMaxTokenLength(this.maxTokenLength);
    }
}

