/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import jp.jasminesoft.jfc.textsearch.CharCounter;
import jp.jasminesoft.jfc.textsearch.TextExtractor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Xdoc2txtTextExtractor
extends TextExtractor {
    private static final Logger logger = LogManager.getLogger((String)Xdoc2txtTextExtractor.class.getName());
    protected String XDOC2TXT_PATH = "xdoc2txt.exe";
    private String option;

    public void setOption(String option) {
        this.option = option;
    }

    String getExtention(String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        String name = f.getName();
        if (name.lastIndexOf(".") > 0) {
            return name.substring(name.lastIndexOf("."));
        }
        return null;
    }

    File getRenamedFile(String ext, File f) throws Exception {
        File ret = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            ret = File.createTempFile(f.getName(), ext);
            byte[] buff = new byte[4048];
            fis = new FileInputStream(f);
            fos = new FileOutputStream(ret);
            int size = fis.read(buff);
            while (size > 0) {
                fos.write(buff, 0, size);
                size = fis.read(buff);
            }
        }
        catch (Exception e) {
            if (ret != null && ret.isFile() && !ret.delete()) {
                logger.warn("failed to delete file:" + ret);
            }
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extract(CharCounter cc, String filename, File f) throws Exception {
        if (cc.isOverLimit()) {
            return "";
        }
        logger.debug("extract");
        try {
            TextExtractor.isExtractable(f);
        }
        catch (Exception e) {
            logger.warn("filename:" + f.getAbsolutePath());
            return "";
        }
        File renamed = null;
        File target = f;
        String ext = this.getExtention(filename);
        if (ext != null) {
            target = renamed = this.getRenamedFile(ext, f);
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(this.XDOC2TXT_PATH + " " + (this.option != null ? this.option : "") + " " + target.getAbsolutePath());
            br = new BufferedReader(new InputStreamReader(p.getInputStream(), "Shift_JIS"));
            String s = br.readLine();
            while (s != null && !cc.isOverLimit()) {
                sb.append(cc.countChar(s));
                s = br.readLine();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (renamed != null && !renamed.delete()) {
                logger.warn("failed to delete file:" + renamed);
            }
        }
        return sb.toString();
    }
}

