/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch.servlet;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.ResultBean;
import jp.jasminesoft.jfc.TableConfigManager;
import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.textsearch.Indexer;
import jp.jasminesoft.jfc.textsearch.IndexerException;
import jp.jasminesoft.jfc.textsearch.Model2Map;
import jp.jasminesoft.util.FileUtil;
import net.arnx.jsonic.JSON;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class MakeTextIndex {
    private static final Logger logger = LogManager.getLogger((String)MakeTextIndex.class.getName());
    public static final String MODEL_INFO_MODELNAME = "model";
    public static final String MODEL_INFO_MODEL2MAP = "model2Map";
    public static final String MODEL_INFO_SHOWLISTBEAN = "showListBean";
    public static final String MODEL_INFO_CLASSNAME = "classname";
    @Autowired(required=false)
    private ServletContext servletContext;
    @Autowired
    private ApplicationContext appCtx;
    private ActionParameter p;
    @Autowired
    private JFCErrorManager errorManager;
    @Value(value="${wagby.MakeTextIndex.indexDir:/WEB-INF/idxdir}")
    private String indexDir;
    @Value(value="${wagby.MakeTextIndex.indexDirFSRoot:#{null}}")
    private String indexDirFSRoot;
    private String indexDirFS;
    private List<Map> indexInfo;
    private CreateIndexGetDataType createIndexGetDataType = CreateIndexGetDataType.Hibernate;
    public static final String MK_INDEX_QUERY = "SELECT * FROM ";
    public static final int MK_INDEX_FETCH_SIZE = 100;

    public void setActionParameter(ActionParameter p) {
        this.p = p;
    }

    public String getIndexDirFSRoot() {
        return this.indexDirFSRoot;
    }

    public void setIndexDirFSRoot(String indexDirFSRoot) {
        this.indexDirFSRoot = indexDirFSRoot;
        this.initIndexDirFS();
    }

    public String getIndexDirFS() {
        if (this.indexDirFS == null) {
            this.indexDirFS = this.initIndexDirFS();
        }
        return this.indexDirFS;
    }

    private String initIndexDirFS() {
        if (this.indexDir == null) {
            throw new IllegalStateException("indexDir is null");
        }
        if (!this.indexDir.startsWith("/WEB-INF/")) {
            return new File(this.indexDir).getPath();
        }
        if (this.servletContext != null) {
            return this.servletContext.getRealPath(this.indexDir);
        }
        if (this.indexDirFSRoot != null) {
            return new File(new File(this.indexDirFSRoot), this.indexDir).getPath();
        }
        throw new IllegalStateException("servletContext and indexDirFSRoot is null");
    }

    public void setIndexInfo(String indexInfo) throws Exception {
        this.checkIndexInfo(JSON.decode((String)indexInfo));
        this.indexInfo = (List)JSON.decode((String)indexInfo);
    }

    public int sizeIndexInfo() {
        return this.indexInfo.size();
    }

    void checkIndexInfo(Object o) throws Exception {
        if (!(o instanceof List)) {
            throw new Exception("unexpected data format:" + o);
        }
        List list = (List)o;
        for (Object elem : list) {
            if (!(elem instanceof Map)) {
                throw new Exception("unexpected data format:" + elem);
            }
            Map map = (Map)elem;
            for (String s : new String[]{MODEL_INFO_MODELNAME}) {
                if (map.containsKey(s)) continue;
                throw new Exception("no \"" + s + "\":" + elem);
            }
        }
    }

    public Indexer getIndexer(String tableName) {
        return new Indexer(this.getIndexDirFS() + File.separator + tableName);
    }

    Indexer getIndexer(String tableName, boolean newindex) throws Exception {
        try {
            return new Indexer(this.getIndexDirFS() + File.separator + tableName, newindex);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new Exception(e.getMessage(), e);
        }
    }

    boolean isIndexingNeeded(String tableName) throws Exception {
        try (Indexer idxer = null;){
            idxer = this.getIndexer(tableName, false);
            boolean bl = idxer.isIndexingNeeded();
            return bl;
        }
    }

    public boolean createIndex(boolean newindex) throws Exception {
        boolean isCreateIndex = false;
        try {
            logger.info("indexInfo.size() = " + this.indexInfo.size());
            for (Map modelInfo : this.indexInfo) {
                try {
                    this.createIndex1(modelInfo, newindex);
                }
                catch (Exception e) {
                    logger.error("failed to create index for " + modelInfo, (Throwable)e);
                }
            }
            logger.info("Index creation process completed.");
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new Exception(t.toString(), t);
        }
        return true;
    }

    public boolean createIndex(boolean newindex, String[] tableList) throws Exception {
        boolean isCreateIndex = false;
        try {
            for (Map modelInfo : this.indexInfo) {
                String tableName = (String)modelInfo.get(MODEL_INFO_MODELNAME);
                if (!MakeTextIndex.isTableIn(tableName, tableList)) continue;
                if (!isCreateIndex) {
                    logger.info("indexInfo.size() = " + this.indexInfo.size());
                    isCreateIndex = true;
                }
                this.createIndex1(modelInfo, newindex);
            }
            if (isCreateIndex) {
                logger.info("Index creation process completed.");
            }
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new Exception(t.toString(), t);
        }
        return isCreateIndex;
    }

    private static boolean isTableIn(String tableName, String[] tableList) {
        logger.debug("isTableIn:tableName:\"" + tableName + "\"");
        logger.debug("isTableIn:tableList:" + Arrays.asList(tableList));
        if (tableName != null) {
            tableName = tableName.trim();
        }
        for (String s : tableList) {
            if (s == null || !s.trim().equals(tableName)) continue;
            logger.debug("isTableIn:true:\"" + tableName + "\"");
            return true;
        }
        logger.debug("isTableIn:false:\"" + tableName + "\"");
        return false;
    }

    private void checkFields(Map modelInfo) throws Exception {
        if (modelInfo == null) {
            throw new Exception("no model info");
        }
        if (!(modelInfo.get(MODEL_INFO_MODELNAME) instanceof String)) {
            throw new Exception("no model:" + modelInfo);
        }
    }

    private void checkFieldsForProcessBean(Map modelInfo) throws Exception {
        if (modelInfo == null) {
            throw new Exception("no model info");
        }
        if (!(modelInfo.get(MODEL_INFO_MODEL2MAP) instanceof String)) {
            throw new Exception("no model2Map:" + modelInfo);
        }
        if (!(modelInfo.get(MODEL_INFO_SHOWLISTBEAN) instanceof String)) {
            throw new Exception("no showListBean:" + modelInfo);
        }
    }

    public void createIndex1(Map modelInfo, boolean newindex) throws Exception {
        logger.debug("*** createIndex1 ***");
        this.checkFields(modelInfo);
        String tableName = (String)modelInfo.get(MODEL_INFO_MODELNAME);
        String pkey = "__jfc_uniqueKey";
        try {
            boolean bl = newindex = newindex || this.isIndexingNeeded(tableName);
            if (newindex) {
                logger.info("start to create index for " + tableName);
                CreateIndexGetDataType type = this.getCreateIndexGetDataType();
                if (type == CreateIndexGetDataType.Hibernate) {
                    this.createIndexFromHibernate(modelInfo, newindex);
                } else if (type == CreateIndexGetDataType.ProcessBean) {
                    this.createIndexFromProcessBean(modelInfo, newindex);
                } else if (type == CreateIndexGetDataType.Table) {
                    this.createIndexFromTable(tableName, pkey, newindex);
                } else {
                    logger.error("Unknown type " + (Object)((Object)type));
                }
                logger.info("finish " + tableName);
            }
        }
        catch (Throwable e) {
            logger.error("failed to create index for " + tableName, e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public void setCreateIndexGetDataTypeString(String type) {
        this.createIndexGetDataType = CreateIndexGetDataType.valueOf(type);
    }

    public String getCreateIndexGetDataTypeString() {
        return this.createIndexGetDataType.toString();
    }

    public void setCreateIndexGetDataType(CreateIndexGetDataType type) {
        this.createIndexGetDataType = type;
    }

    public CreateIndexGetDataType getCreateIndexGetDataType() {
        return this.createIndexGetDataType;
    }

    private void createIndexFromTable(String tableName, String pKey, boolean newindex) throws Exception {
        logger.debug("*** createIndexFromTable ***");
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        String quote_id = ((TableConfigManager)this.appCtx.getBean("TableConfigManager", TableConfigManager.class)).getQuoteId();
        try {
            con = JFCUtils.getConnection();
            st = con.createStatement(1003, 1007);
            st.setFetchSize(100);
            rs = st.executeQuery(MK_INDEX_QUERY + quote_id + tableName + quote_id);
            ResultSetMetaData rm = rs.getMetaData();
            Indexer idxer = this.getIndexer(tableName, newindex);
            long count = this.addIndexTableWithLock(pKey, rs, rm, idxer);
            logger.info("Total " + count + " records are indexed");
        }
        catch (Exception e) {
            try {
                throw new Exception(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JFCUtils.releaseConnection(con, st, rs);
                throw throwable;
            }
        }
        JFCUtils.releaseConnection(con, st, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addIndexTableWithLock(String pKey, ResultSet rs, ResultSetMetaData rm, Indexer idxer) throws SQLException, IndexerException {
        long count = 0L;
        try {
            count = this.addIndexTable(pKey, rs, rm, idxer);
        }
        finally {
            idxer.close();
        }
        return count;
    }

    private long addIndexTable(String pKey, ResultSet rs, ResultSetMetaData rm, Indexer idxer) throws SQLException {
        long count = 0L;
        long period = System.currentTimeMillis();
        while (rs.next()) {
            HashMap<String, String> cntnt = new HashMap<String, String>();
            for (int idx = 1; idx <= rm.getColumnCount(); ++idx) {
                cntnt.put(rm.getColumnName(idx), rs.getString(idx));
            }
            logger.debug("content to register:" + cntnt);
            try {
                idxer.add((String)cntnt.get(pKey), cntnt);
                ++count;
            }
            catch (Exception e) {
                logger.error("failed to index data. keep creating index", (Throwable)e);
            }
            if (System.currentTimeMillis() <= period + 10000L) continue;
            logger.info("" + count + " records are indexed");
            period = System.currentTimeMillis();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFromProcessBean(Map modelInfo, boolean newindex) throws Exception {
        this.checkFieldsForProcessBean(modelInfo);
        String tableName = (String)modelInfo.get(MODEL_INFO_MODELNAME);
        String pKey = "__jfc_uniqueKey";
        String model2Map = (String)modelInfo.get(MODEL_INFO_MODEL2MAP);
        String showListBean = (String)modelInfo.get(MODEL_INFO_SHOWLISTBEAN);
        logger.debug("*** createIndexFromProcessBean ***");
        if (this.appCtx == null) {
            throw new Exception("failed to get appCtx. appCtx is null");
        }
        logger.debug("showListBean:" + showListBean);
        ProcessBean pbean = (ProcessBean)this.appCtx.getBean(showListBean, ProcessBean.class);
        pbean.setActionParameter(this.p);
        ResultBean rbean = new ResultBean();
        try {
            rbean.setProcessBean(pbean);
            rbean.setSizePerPage(100);
            rbean.setWishCloseConnection(true);
            rbean.processProcessBean(this.p, this.errorManager);
            long start = System.currentTimeMillis();
            logger.debug("model2MapBean:" + model2Map);
            Indexer idxer = this.getIndexer(tableName, newindex);
            long count = this.addIndexProcessBeanWithLock(pKey, model2Map, idxer, rbean, start);
            logger.info("Total " + count + " records are indexed. It takes " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec.");
        }
        finally {
            rbean.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addIndexProcessBeanWithLock(String pKey, String model2Map, Indexer idxer, ResultBean<?> rbean, long start) throws IndexerException {
        long count = 0L;
        try {
            count = this.addIndexProcessBean(pKey, model2Map, idxer, rbean, start);
        }
        finally {
            idxer.close();
        }
        return count;
    }

    private long addIndexProcessBean(String pKey, String model2Map, Indexer idxer, ResultBean<?> rbean, long start) throws IndexerException {
        long count = 0L;
        long period = start;
        boolean reachLast = false;
        while (!reachLast) {
            logger.info("current page :" + rbean.getCurrentPage());
            List<?> coll = rbean.getCurrentPageItemWithoutCache(this.p, this.errorManager);
            if (coll != null && coll.size() > 0) {
                for (Object o : coll) {
                    Model2Map m2m = (Model2Map)this.appCtx.getBean(model2Map, Model2Map.class);
                    Map<String, String> cntnt = null;
                    try {
                        cntnt = m2m.getMap(o);
                    }
                    catch (Exception e) {
                        logger.error("failed indexing data. keep creating index", (Throwable)e);
                    }
                    if (cntnt != null) {
                        logger.debug("content to register:" + cntnt);
                        idxer.add(cntnt.get(pKey), cntnt);
                        ++count;
                    }
                    if (System.currentTimeMillis() <= period + 10000L) continue;
                    logger.info("" + count + " records are indexed");
                    period = System.currentTimeMillis();
                }
            }
            int beforeNext = rbean.getCurrentPage();
            logger.debug("beforeNext:" + beforeNext);
            rbean.next();
            logger.debug("afterNext:" + rbean.getCurrentPage());
            if (beforeNext != rbean.getCurrentPage() && rbean.getCurrentPage() >= 0) continue;
            reachLast = true;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFromHibernate(Map modelInfo, boolean newindex) throws Exception {
        this.checkFieldsForProcessBean(modelInfo);
        String tableName = (String)modelInfo.get(MODEL_INFO_MODELNAME);
        String pKey = "__jfc_uniqueKey";
        String model2Map = (String)modelInfo.get(MODEL_INFO_MODEL2MAP);
        String classname = (String)modelInfo.get(MODEL_INFO_CLASSNAME);
        logger.debug("*** createIndexFromHibernate ***");
        if (this.appCtx == null) {
            throw new Exception("failed to get appCtx. appCtx is null");
        }
        Session session = null;
        ScrollableResults results = null;
        try {
            session = HibernateUtil.openSession();
            String expression = "select c from " + classname + " as c";
            Query query = session.createQuery(expression);
            query.setReadOnly(true);
            query.setCacheable(false);
            query.setFetchSize(100);
            results = query.scroll(ScrollMode.FORWARD_ONLY);
            long start = System.currentTimeMillis();
            logger.debug("model2MapBean:" + model2Map);
            Indexer idxer = this.getIndexer(tableName, newindex);
            long count = this.addIndexHibernateWithLock(pKey, model2Map, results, idxer, start);
            double secondPerMiliseconds = 1000.0;
            logger.info("Total " + count + " records are indexed. It takes " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec.");
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception e) {
                    logger.debug("failed to close results", (Throwable)e);
                }
            }
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addIndexHibernateWithLock(String pKey, String model2Map, ScrollableResults results, Indexer idxer, long start) throws IndexerException {
        long count = 0L;
        try {
            count = this.addIndexHibernate(pKey, model2Map, results, idxer, start);
        }
        finally {
            idxer.close();
        }
        return count;
    }

    private long addIndexHibernate(String pKey, String model2Map, ScrollableResults results, Indexer idxer, long start) throws IndexerException {
        long count = 0L;
        long period = start;
        while (results.next()) {
            Object o = results.get(0);
            Model2Map m2m = (Model2Map)this.appCtx.getBean(model2Map, Model2Map.class);
            Map<String, String> cntnt = null;
            try {
                cntnt = m2m.getMap(o);
            }
            catch (Exception e) {
                logger.error("failed to index data. keep creating index", (Throwable)e);
            }
            if (cntnt != null) {
                logger.debug("content to register:" + cntnt);
                idxer.add(cntnt.get(pKey), cntnt);
                ++count;
            }
            int waitTime = 10000;
            if (System.currentTimeMillis() <= period + 10000L) continue;
            logger.info("" + count + " records are indexed");
            period = System.currentTimeMillis();
        }
        return count;
    }

    public void optimizeIndex() throws Exception {
        try {
            logger.info("indexInfo.size() = " + this.indexInfo.size());
            for (Map modelInfo : this.indexInfo) {
                this.optimizeIndex(modelInfo);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new Exception(t.toString(), t);
        }
    }

    public void optimizeIndex(Map modelInfo) throws Exception {
        logger.debug("*** optimizeIndex ***");
        this.checkFields(modelInfo);
        String tableName = (String)modelInfo.get(MODEL_INFO_MODELNAME);
        try {
            this.optimizeIndex(tableName);
        }
        catch (Throwable e) {
            logger.error("failed to optimize index for " + tableName, e);
            throw new Exception(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optimizeIndex(String tableName) throws Exception {
        try (Indexer idxer = null;){
            idxer = this.getIndexer(tableName, false);
            if (!idxer.isIndexAvailable()) {
                return;
            }
            logger.info("start index optimizing... " + tableName);
            long period = System.currentTimeMillis();
            idxer.optimizeWithLock();
            logger.info("Optimizing is finished.  It takes " + (double)(System.currentTimeMillis() - period) / 1000.0 + " sec.");
        }
    }

    public void deleteIndex(String[] tableNames) throws Exception {
        for (String tableName : tableNames) {
            this.deleteIndex(tableName);
        }
    }

    public void deleteIndex(String tableName) throws Exception {
        File toRemove = new File(this.getIndexDirFS() + File.separator + tableName);
        if (!toRemove.isDirectory()) {
            logger.debug("no index:" + toRemove);
            return;
        }
        if (FileUtil.removeAll((File)toRemove)) {
            logger.info("delete index:" + toRemove);
        } else {
            logger.warn("failed to delete index:" + toRemove);
        }
    }

    static enum CreateIndexGetDataType {
        Table,
        ProcessBean,
        Hibernate;

    }
}

