/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.textsearch.servlet;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.textsearch.TextsearchPageUtil;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextsearchUI {
    private static final Logger logger = LogManager.getLogger((String)TextsearchUI.class.getName());
    private static final String CR = System.getProperty("line.separator");

    public static final String getHTMLContent(HttpServletRequest request, String sid, String pid, String form, String showUrl, String showListUrl, String showListFormname) {
        return new TextsearchUI().getHTMLContent0(request, sid, pid, form, showUrl, showListUrl, showListFormname);
    }

    private final String getHTMLContent0(HttpServletRequest request, String sid, String pid, String form, String showUrl, String SHOWLISTURL, String showListFormname) {
        long endVal;
        long startVal;
        long PAGE_SIZE_NONZ2;
        long endVal2;
        long PAGE_INDEX_SIZE;
        StringBuilder sb = new StringBuilder();
        HttpSession session = request.getSession();
        Map[] TEXTSEARCH_RESULT = (Map[])request.getAttribute("TEXTSEARCH_RESULT");
        if (TEXTSEARCH_RESULT == null || TEXTSEARCH_RESULT.length == 0) {
            return "";
        }
        long PAGE_SIZE = NumberUtils.toLong((String)((String)session.getAttribute("PAGE_SIZE")));
        if (PAGE_SIZE <= 0L) {
            PAGE_SIZE = 20L;
        }
        if ((PAGE_INDEX_SIZE = NumberUtils.toLong((String)((String)session.getAttribute("PAGE_INDEX_SIZE")))) <= 0L) {
            PAGE_INDEX_SIZE = 20L;
        }
        long TEXTSEARCH_CURRENT = 0L;
        String TEXTSEARCH_CURRENT_STR = (String)request.getAttribute("TEXTSEARCH_CURRENT");
        if (StringUtils.isNotBlank((CharSequence)TEXTSEARCH_CURRENT_STR)) {
            TEXTSEARCH_CURRENT = NumberUtils.toLong((String)TEXTSEARCH_CURRENT_STR);
        }
        if (TEXTSEARCH_CURRENT > (long)TEXTSEARCH_RESULT.length) {
            TEXTSEARCH_CURRENT = TEXTSEARCH_RESULT.length - 1;
        } else if (TEXTSEARCH_CURRENT < 0L) {
            TEXTSEARCH_CURRENT = 0L;
        }
        TEXTSEARCH_CURRENT -= TEXTSEARCH_CURRENT % PAGE_SIZE;
        long TO_INDEX = 0L;
        TO_INDEX = TEXTSEARCH_CURRENT + PAGE_SIZE - 1L < (long)(TEXTSEARCH_RESULT.length - 1) ? TEXTSEARCH_CURRENT + PAGE_SIZE - 1L : (long)(TEXTSEARCH_RESULT.length - 1);
        if (logger.isDebugEnabled()) {
            logger.debug("** PAGE_SIZE=" + PAGE_SIZE);
            logger.debug("** PAGE_INDEX_SIZE=" + PAGE_INDEX_SIZE);
            logger.debug("** TEXTSEARCH_CURRENT=" + TEXTSEARCH_CURRENT);
            logger.debug("** TO_INDEX=" + TO_INDEX);
        }
        String FORM_PREV = form + "Prev";
        String FORM_NEXT = form + "Next";
        if (sid == null && (sid = (String)request.getAttribute("__jfc_modelId")) == null) {
            return "";
        }
        if (pid == null) {
            pid = sid + "_lp";
        }
        String locale = (String)session.getAttribute("__jfc_locale");
        String msg = JFCUtils.getRValue("__jfc_common.search.status", String.valueOf(TEXTSEARCH_RESULT.length), String.valueOf(TEXTSEARCH_CURRENT + 1L), String.valueOf(TO_INDEX + 1L), locale);
        if (logger.isDebugEnabled()) {
            logger.debug("** FORM_PREV=" + FORM_PREV);
            logger.debug("** FORM_NEXT=" + FORM_NEXT);
            logger.debug("** SHOWLISTURL=" + SHOWLISTURL);
            logger.debug("** sid=" + sid);
            logger.debug("** pid=" + pid);
            logger.debug("** msg=" + msg);
        }
        sb.append(msg).append(CR);
        sb.append("<table width=\"100%\">").append(CR);
        sb.append("<tr align=\"center\">").append(CR);
        sb.append("<td>").append(CR);
        if (TEXTSEARCH_CURRENT - PAGE_SIZE >= 0L) {
            sb.append("<form name=\"");
            sb.append(StringEscapeUtils.escapeHtml4((String)FORM_PREV));
            sb.append("\" action=\"");
            sb.append(StringEscapeUtils.escapeHtml4((String)SHOWLISTURL));
            sb.append(" method=\"post\" onSubmit=\"buttonOff(); return true;\" style=\"margin:0;padding:0\">");
            sb.append(CR);
            sb.append("<input type=\"hidden\" name=\"SENDACTION\"/>").append(CR);
            sb.append("<input type=\"hidden\" name=\"sessionId\" value=\"");
            sb.append(StringUtil.getMD5Hash((String)session.getId()));
            sb.append("\"/>").append(CR);
            sb.append("<input type=\"hidden\" name=\"TEXTSEARCH_QMODE\" value=\"index\"/>").append(CR);
            sb.append("<input type=\"hidden\" name=\"TEXTSEARCH_CURRENT\" value=\"");
            sb.append(TEXTSEARCH_CURRENT - PAGE_SIZE);
            sb.append("\"/>").append(CR);
            sb.append("<input type=\"hidden\" name=\"TO_INDEX\" value=\"").append(TO_INDEX).append("\"/>");
            sb.append("<button type=\"submit\" name=\"btnPrev\" data-dojo-type=\"dijit/form/Button\" onClick=\"this.valueNode.form.SENDACTION.name='action_Prev'\">");
            sb.append(JFCUtils.getRValue("__jfc_common.textsearch.prev", locale));
            sb.append("</button>").append(CR);
            sb.append("</form>").append(CR);
        } else {
            sb.append("<button type=\"button\" name=\"btnPrev\" disabled=\"disabled\" data-dojo-type=\"dijit/form/Button\">");
            sb.append(JFCUtils.getRValue("__jfc_common.textsearch.prev", locale));
            sb.append("</button>").append(CR);
        }
        sb.append("</td>").append(CR);
        sb.append("<td>").append(CR);
        if (TEXTSEARCH_CURRENT + PAGE_SIZE < (long)TEXTSEARCH_RESULT.length) {
            sb.append("<form name=\"").append(FORM_NEXT).append("\" action=\"").append(SHOWLISTURL);
            sb.append("\" method=\"post\" onSubmit=\"buttonOff(); return true;\" style=\"margin:0;padding:0\">").append(CR);
            sb.append("<input type=\"hidden\" name=\"SENDACTION\"/>").append(CR);
            sb.append("<input type=\"hidden\" name=\"sessionId\" value=\"");
            sb.append(StringUtil.getMD5Hash((String)session.getId()));
            sb.append("\"/>").append(CR);
            sb.append("<input type=\"hidden\" name=\"TEXTSEARCH_QMODE\" value=\"index\"/>").append(CR);
            sb.append("<input type=\"hidden\" name=\"TEXTSEARCH_CURRENT\" value=\"");
            sb.append(TEXTSEARCH_CURRENT + PAGE_SIZE);
            sb.append("\"/>").append(CR);
            sb.append("<button type=\"submit\" name=\"btnNext\" data-dojo-type=\"dijit/form/Button\" onClick=\"this.valueNode.form.SENDACTION.name='action_Next'\">");
            sb.append(JFCUtils.getRValue("__jfc_common.textsearch.next", locale));
            sb.append("</button>").append(CR);
            sb.append("</form>").append(CR);
        } else {
            sb.append("<button type=\"button\" name=\"btnNext\" disabled=\"disabled\" data-dojo-type=\"dijit/form/Button\">");
            sb.append(JFCUtils.getRValue("__jfc_common.textsearch.next", locale));
            sb.append("</button>").append(CR);
        }
        sb.append("</td>").append(CR);
        sb.append("</tr>").append(CR);
        sb.append("</table>").append(CR);
        long PAGE_SIZE_NONZ = PAGE_SIZE > 0L ? PAGE_SIZE : 1L;
        long startVal2 = TEXTSEARCH_CURRENT / PAGE_SIZE_NONZ - PAGE_INDEX_SIZE / 2L <= 0L ? 1L : TEXTSEARCH_CURRENT / PAGE_SIZE_NONZ - PAGE_INDEX_SIZE / 2L + 1L;
        if (startVal2 - 1L + PAGE_INDEX_SIZE > (long)(TEXTSEARCH_RESULT.length - 1) / PAGE_SIZE_NONZ) {
            long endVal3 = (long)(TEXTSEARCH_RESULT.length - 1) / PAGE_SIZE_NONZ + 1L;
            startVal2 = endVal3 - 1L - PAGE_INDEX_SIZE <= 0L ? 1L : endVal3 - PAGE_INDEX_SIZE;
        } else {
            endVal2 = startVal2 + PAGE_INDEX_SIZE - 1L;
        }
        if (endVal2 > 1L) {
            for (long pageNum = startVal2; pageNum <= endVal2; ++pageNum) {
                if (pageNum > startVal2) {
                    sb.append(" | ");
                }
                if ((pageNum - 1L) * PAGE_SIZE == TEXTSEARCH_CURRENT) {
                    sb.append(pageNum);
                    continue;
                }
                sb.append("<a href=\"").append(SHOWLISTURL).append("?TEXTSEARCH_QMODE=index&TEXTSEARCH_CURRENT=");
                sb.append((pageNum - 1L) * PAGE_SIZE);
                sb.append("\">").append(pageNum).append("</a>");
            }
        }
        request.setAttribute("SID", (Object)sid);
        request.setAttribute("PID", (Object)pid);
        TextsearchPageUtil textsearchPageUtil = new TextsearchPageUtil(request, session);
        sb.append("<table width=\"95%\" cellspacing=\"1\">").append(CR);
        sb.append("<tr align=\"center\"><td>").append(CR);
        sb.append("<button id=\"").append(sid).append("_showDetail\" data-dojo-type=\"dijit/form/ToggleButton\" iconClass=\"plusIcon\">").append(CR);
        sb.append(JFCUtils.getRValue("__jfc_common.textsearch.show_detail", locale)).append(CR);
        sb.append("</button>").append(CR);
        sb.append("</td></tr>").append(CR);
        sb.append("</table>").append(CR);
        sb.append("<table width=\"95%\" cellspacing=\"1\">").append(CR);
        for (long i = TEXTSEARCH_CURRENT; i <= TO_INDEX; ++i) {
            Map result = TEXTSEARCH_RESULT[(int)i];
            if (logger.isDebugEnabled()) {
                logger.debug("RESULT[" + i + "]=" + result);
            }
            sb.append("<tr>").append(CR);
            sb.append("<td style=\"padding:1em 0px 1em 0px;border-bottom:1px solid #CCCCCC;text-align:left;\">").append(CR);
            long positionIndex = i;
            TextsearchPageUtil.TextsearchResult tResult = textsearchPageUtil.createTextsearchResult(result, (int)positionIndex);
            String title = tResult.getTitle();
            String digest = tResult.getDigest();
            ArrayList<String> pkeylist = new ArrayList<String>();
            for (String string : result.keySet()) {
                if (!string.startsWith("__jfc_urlencoded_")) continue;
                pkeylist.add(string.substring("__jfc_urlencoded_".length()));
            }
            sb.append(i + 1L).append(".");
            sb.append("<a href=\"show");
            sb.append(StringUtil.capFirst((String)sid));
            sb.append(".do?TEXTSEARCH_CURRENT=");
            sb.append(i).append("&");
            for (String string : pkeylist) {
                sb.append(string).append("=");
                sb.append(ExcelFunction.SANITIZING((String)((String)result.get("__jfc_urlencoded_" + string))));
                sb.append("&");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append("\">");
            sb.append(ExcelFunction.SANITIZING((String)title));
            sb.append("</a>").append(CR);
            sb.append("<button id=\"").append(sid).append("_").append(i + 1L);
            sb.append("_btn\" data-dojo-type=\"dijit/form/ToggleButton\" iconClass=\"plusIcon\" showLabel=\"false\"></button>").append(CR);
            sb.append("<br/>").append(CR);
            sb.append(digest).append(CR);
            if (tResult.getFilecontent().size() > 0) {
                sb.append("<br/>").append(CR);
                sb.append("<span style=\"font-size:80%;\">").append(CR);
                boolean isfirst = true;
                for (TextsearchPageUtil.Iteminfo filecontent : tResult.getFilecontent()) {
                    if (isfirst) {
                        isfirst = false;
                    } else {
                        sb.append("<br/>").append(CR);
                    }
                    String filename = StringEscapeUtils.escapeHtml4((String)filecontent.getFilename());
                    sb.append("<img style=\"width:16px;height:16px;\" src=\"img/" + filecontent.getFileIconPath() + "\" alt=\"" + filename + "\"/>").append(CR);
                    sb.append("<a href=\"" + filecontent.getFileUrl() + "\">" + filename + "</a>");
                }
                sb.append("</span>").append(CR);
            }
            if (tResult.getDetail().size() > 0) {
                sb.append("<br/>").append(CR);
                sb.append("<div id=\"").append(sid).append("_").append(i + 1L).append("\" style=\"height:auto;display:none;\">").append(CR);
                sb.append("<table>").append(CR);
                for (TextsearchPageUtil.DetailItem detailItem : tResult.getDetail()) {
                    sb.append("<tr>").append(CR);
                    sb.append("<th class=\"display_label\" align=\"left\" style=\"width:30%;font-size:80%;\">" + StringEscapeUtils.escapeHtml4((String)detailItem.getLabel()) + "</th>").append(CR);
                    sb.append("<td class=\"display_field_noalign\" style=\"font-size:80%;text-align:left;\">" + detailItem.getContent() + "</td>").append(CR);
                    sb.append("</tr>").append(CR);
                }
                sb.append("</table>").append(CR);
                sb.append("</div>").append(CR);
            }
            sb.append("</td>").append(CR);
            sb.append("</tr>").append(CR);
        }
        sb.append("</table>").append(CR);
        long l = PAGE_SIZE_NONZ2 = PAGE_SIZE > 0L ? PAGE_SIZE : 1L;
        if (TEXTSEARCH_CURRENT / PAGE_SIZE_NONZ2 - PAGE_INDEX_SIZE / 2L <= 0L) {
            long startVal22 = 1L;
        } else {
            startVal = TEXTSEARCH_CURRENT / PAGE_SIZE_NONZ2 - PAGE_INDEX_SIZE / 2L + 1L;
        }
        if (startVal - 1L + PAGE_INDEX_SIZE > (long)(TEXTSEARCH_RESULT.length - 1) / PAGE_SIZE_NONZ2) {
            endVal = (long)(TEXTSEARCH_RESULT.length - 1) / PAGE_SIZE_NONZ2 + 1L;
            startVal = endVal - 1L - PAGE_INDEX_SIZE <= 0L ? 1L : endVal - PAGE_INDEX_SIZE;
        } else {
            endVal = startVal + PAGE_INDEX_SIZE - 1L;
        }
        if (endVal > 1L) {
            for (long pageNum = startVal; pageNum <= endVal; ++pageNum) {
                if (pageNum > startVal) {
                    sb.append(" | ");
                }
                if ((pageNum - 1L) * PAGE_SIZE == TEXTSEARCH_CURRENT) {
                    sb.append(pageNum);
                    continue;
                }
                sb.append("<a href=\"").append(SHOWLISTURL).append("?TEXTSEARCH_QMODE=index&TEXTSEARCH_CURRENT=");
                sb.append((pageNum - 1L) * PAGE_SIZE);
                sb.append("\">").append(pageNum).append("</a>");
            }
        }
        return sb.toString();
    }
}

