/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.th;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.tag.CheckLogonBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JfcCheckLogonUtil {
    private static Logger logger = LogManager.getLogger((String)JfcCheckLogonUtil.class.getName());
    private CheckLogonBase checklogon = new CheckLogonBase();

    protected JfcCheckLogonUtil() {
    }

    protected JfcCheckLogonUtil(String attr) {
        this();
        this.setAttribute(attr);
    }

    public void setAttribute(String attributeValue) {
        if (StringUtils.isBlank((CharSequence)attributeValue)) {
            return;
        }
        Map<String, String> attrMap = this.getAttributeMap(attributeValue);
        if (attrMap.isEmpty()) {
            return;
        }
        this.setCheckLogonAttr(attrMap);
    }

    public boolean checkLogon(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        return this.checklogon.checkLogon(request);
    }

    private Map<String, String> getAttributeMap(String attributeValue) {
        Map<String, String> attrMap = Arrays.stream(attributeValue.split(",")).map(p -> p.trim().split("=")).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]));
        return attrMap;
    }

    private void setCheckLogonAttr(Map<String, String> attrMap) {
        attrMap.entrySet().forEach(m -> {
            if ("not".equals(m.getKey())) {
                this.setNot((String)m.getValue());
            } else if ("principals".equals(m.getKey())) {
                this.setPrincipals((String)m.getValue());
            } else if ("permclassname".equals(m.getKey())) {
                this.setPermclassname((String)m.getValue());
            } else if ("permname".equals(m.getKey())) {
                this.setPermname((String)m.getValue());
            } else if ("permactions".equals(m.getKey())) {
                this.setPermactions((String)m.getValue());
            }
        });
    }

    public void setNot(String isnot) {
        this.checklogon.setNot(isnot);
    }

    public void setPrincipals(String principals) {
        this.checklogon.setPrincipals(principals);
    }

    public void setPermclassname(String permclassname) {
        this.checklogon.setPermclassname(permclassname);
    }

    public void setPermname(String permname) {
        this.checklogon.setPermname(permname);
    }

    public void setPermactions(String permactions) {
        this.checklogon.setPermactions(permactions);
    }
}

