/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.th;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.JFCButtonControlUtil;
import jp.jasminesoft.jfc.JFCControlUtil;
import jp.jasminesoft.jfc.JFCLogonuserinfo;
import jp.jasminesoft.jfc.JFCPanelControlUtil;
import jp.jasminesoft.jfc.JFCStyleUtil;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.core.support.spring.security.MultipleSessionUtils;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemMultiString;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefBase;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefInt;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemString;
import jp.jasminesoft.jfc.textsearch.servlet.TextsearchUI;
import jp.jasminesoft.jfc.th.JfcCheckLogonUtil;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.ImageFormat;
import jp.jasminesoft.util.PDFConverter;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringURLFilter;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import jp.jasminesoft.util.XssSanitizer;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.taglibs.standard.util.EscapeXML;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class JfcUtil {
    private static Logger logger = LogManager.getLogger((String)JfcUtil.class.getName());
    private static final String BASE64_FILENAME_FOOTER = "_base64.txt";
    private static final long MAX_FILE_SIZE = 1000000000L;

    public String md5Hash(String sessionId) {
        String hashedSessionId = StringUtil.getMD5Hash((String)sessionId);
        if (StringUtils.isNotBlank((CharSequence)hashedSessionId)) {
            return hashedSessionId;
        }
        return "";
    }

    public String encodePrimaryKey(String key) {
        return JFCUtils.encodePrimaryKey(key);
    }

    public String encodePrimaryKey(String key, boolean isTextarea) {
        String value = this.encodePrimaryKey(key);
        if (isTextarea) {
            return WebStringEncodeUtilities.encodeCR((String)value);
        }
        return value;
    }

    public String encodePrimaryKey(String key, boolean isTextarea, boolean isJS) {
        if (isTextarea && isJS) {
            return EscapeXML.escape((String)StringURLFilter.escapeEcmaScript((String)key));
        }
        return this.encodePrimaryKey(key, isTextarea);
    }

    public String sanitize(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        XssSanitizer xss = new XssSanitizer();
        return xss.sanitize(str);
    }

    public String getFileExt(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return "";
        }
        return StringUtils.lowerCase((String)StringUtils.substringAfterLast((String)filename, (String)".")).trim();
    }

    public String getTime() {
        return String.valueOf(new Date().getTime());
    }

    public static String encodeURL(String str) {
        return StringURLFilter.encodeURL((String)str, (String)"UTF-8");
    }

    public static boolean HASMODELPERMISSION(User user, String permactions, String default_permname) {
        return JfcUtil.HASMODELPERMISSION(user, permactions, null, default_permname);
    }

    public static boolean HASMODELPERMISSION(User user, String permactions, String permname, String default_permname) {
        return JFCUtils.isValidPermission(user, permactions, permname, default_permname);
    }

    public static boolean HASMODELPERMISSION(String user, String permactions, String permname, String default_permname) {
        return true;
    }

    public static String getControlType2(HttpServletRequest request, String smodelname, String pmodelname, String modelitemname) {
        return JFCControlUtil.getControlType(request, smodelname, pmodelname, modelitemname).toString();
    }

    public static boolean buttonControl_show(HttpServletRequest request, String smodelname, String pmodelname, String linkId) {
        return JFCButtonControlUtil.getButtonControl4show(request, smodelname, pmodelname, linkId);
    }

    public static boolean buttonControl_show(HttpServletRequest request, String smodelname, String pmodelname, int itemIndex, String linkId) {
        return JFCButtonControlUtil.getButtonControl4show(request, smodelname, pmodelname, itemIndex, linkId);
    }

    public static boolean buttonControl_enable(HttpServletRequest request, String smodelname, String pmodelname, String linkId) {
        return JFCButtonControlUtil.getButtonControl4enable(request, smodelname, pmodelname, linkId);
    }

    public static boolean buttonControl_enable(HttpServletRequest request, String smodelname, String pmodelname, int itemIndex, String linkId) {
        return JFCButtonControlUtil.getButtonControl4enable(request, smodelname, pmodelname, itemIndex, linkId);
    }

    public static boolean buttonControl_condition(HttpServletRequest request, String smodelname, String pmodelname, String modelitemname) {
        return JFCButtonControlUtil.getButtonControl4condition(request, smodelname, pmodelname, modelitemname);
    }

    public static boolean buttonControl_conditionMulti(HttpServletRequest request, String smodelname, String pmodelname, String modelitemname, int index) {
        return JFCButtonControlUtil.getButtonControl4condition(request, smodelname, pmodelname, modelitemname, index);
    }

    public static String buttonControl_label(HttpServletRequest request, String smodelname, String pmodelname, String ditemId) {
        return JFCButtonControlUtil.getButtonControl4label(request, smodelname, pmodelname, ditemId);
    }

    public static boolean panelControl(HttpServletRequest request, String smodelname, String pmodelname, String panelId) {
        return JFCPanelControlUtil.getPanelControl(request, smodelname, pmodelname, panelId);
    }

    public String getFileImage(String filename, String src) {
        return this.getFileImage(filename, null, null, null, src);
    }

    public String getFileImage(String filename, String filename_jshfilename, String src) {
        return this.getFileImage(filename, filename_jshfilename, null, null, src);
    }

    public String getFileImage(String filename, String filename_jshfilename, DownloadFileObjectFactory dfof, HttpServletRequest request, String src) {
        String ext = this.getFileExt(filename);
        if ("jpg".equals(ext) || "jpeg".equals(ext) || "png".equals(ext) || "gif".equals(ext) || "bmp".equals(ext)) {
            return src + new Date().getTime();
        }
        if ("zip".equals(ext) || "lzh".equals(ext) || "tgz".equals(ext) || "tar".equals(ext)) {
            return "img/archiveicon.png";
        }
        if ("pdf".equals(ext)) {
            String base64str = this.createPDFBase64StringUseCache(filename_jshfilename, dfof, request);
            if (base64str != null) {
                return base64str;
            }
            return "img/pdficon.png";
        }
        if (StringUtils.contains((CharSequence)ext, (CharSequence)"doc")) {
            return "img/wordicon.png";
        }
        if (StringUtils.contains((CharSequence)ext, (CharSequence)"xls")) {
            return "img/excelicon.png";
        }
        if (StringUtils.contains((CharSequence)ext, (CharSequence)"ppt")) {
            return "img/ppticon.png";
        }
        return "img/unknownicon.png";
    }

    /*
     * Loose catch block
     */
    private String createPDFBase64StringUseCache(String filename_jshfilename, DownloadFileObjectFactory dfof, HttpServletRequest request) {
        String base64filename;
        block36: {
            if (filename_jshfilename == null || dfof == null || request == null) {
                return null;
            }
            String part = StringUtils.substringBeforeLast((String)filename_jshfilename, (String)".");
            base64filename = part + BASE64_FILENAME_FOOTER;
            Throwable throwable = null;
            try (DownloadFileObject dfocache = dfof.create(base64filename, request);){
                if (!dfocache.canRead()) break block36;
                try {
                    ByteArrayOutputStream baostream = new ByteArrayOutputStream();
                    dfocache.write(baostream);
                    String string = new String(baostream.toByteArray(), StandardCharsets.UTF_8);
                    return string;
                }
                catch (IOException e2222) {
                    String string;
                    block37: {
                        block38: {
                            logger.warn("Failed read base64 cache file " + base64filename, (Throwable)e2222);
                            string = null;
                            if (dfocache == null) break block37;
                            if (throwable == null) break block38;
                            try {
                                dfocache.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block37;
                        }
                        dfocache.close();
                    }
                    return string;
                    catch (Throwable e2222) {
                        throwable = e2222;
                        throw e2222;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        String base64str = null;
        try (DownloadFileObject dfo = dfof.create(filename_jshfilename, request);){
            if (dfo.canRead()) {
                base64str = this.createPDFBase64String(dfo);
            }
        }
        if (base64str == null) {
            return null;
        }
        Path base64filepath = Paths.get(base64filename, new String[0]);
        try {
            Files.write(base64filepath, Arrays.asList(base64str), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e3) {
            logger.warn("Failed write base64 cache file " + base64filepath, (Throwable)e3);
        }
        return base64str;
    }

    private String createPDFBase64String(DownloadFileObject dfo) {
        long length = dfo.length();
        if (length > 1000000000L) {
            logger.warn("Failed read pdf file " + dfo + ". PDF file is too large. length:" + length + " MAX_FILE_SIZE:" + 1000000000L);
            return null;
        }
        try {
            ByteArrayOutputStream baostream = new ByteArrayOutputStream();
            dfo.write(baostream);
            byte[] ba = baostream.toByteArray();
            StringBuilder sb = new StringBuilder();
            sb.append("data:image/jpg;base64,");
            sb.append(new PDFConverter(72).convertBase64String(ImageFormat.JPEG, ba, 1));
            return sb.toString();
        }
        catch (IOException e) {
            logger.warn("Failed read pdf file " + dfo, (Throwable)e);
            return null;
        }
    }

    public static String escapeEcmaScript(String script) {
        return StringURLFilter.escapeEcmaScript((String)script);
    }

    public static String textSearch(HttpServletRequest request, String sid, String pid, String form, String showUrl, String showListUrl, String showListFormname) {
        return TextsearchUI.getHTMLContent(request, sid, pid, form, showUrl, showListUrl, showListFormname);
    }

    public static String userId(HttpServletRequest request) {
        WebApplicationContext appctx = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request);
        JFCLogonuserinfo info = (JFCLogonuserinfo)appctx.getBean("JFCLogonuserinfo", JFCLogonuserinfo.class);
        if (info == null) {
            return "";
        }
        return info.getUsername(request);
    }

    public static String userName(HttpServletRequest request) {
        WebApplicationContext appctx = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request);
        JFCLogonuserinfo info = (JFCLogonuserinfo)appctx.getBean("JFCLogonuserinfo", JFCLogonuserinfo.class);
        return info.getMessage(request);
    }

    public static boolean ifLogon(HttpServletRequest request, String attr) {
        JfcCheckLogonUtil checkLogon = new JfcCheckLogonUtil(attr);
        return checkLogon.checkLogon(request);
    }

    public static String getItemsValue(List<JFCPresentationModelitemStorerefBase> items) {
        return JfcUtil.getItemsValue(items, false, null);
    }

    public static String getItemsValue(List<JFCPresentationModelitemStorerefBase> items, Boolean useContent) {
        return JfcUtil.getItemsValue(items, useContent, null);
    }

    public static String getItemsValue(List<JFCPresentationModelitemStorerefBase> items, Boolean useContent, String sep) {
        if (items == null) {
            return "";
        }
        String separator = StringUtils.isNotBlank((CharSequence)sep) ? sep : ",";
        return items.stream().filter(item -> item.getChoose()).map(item -> useContent != false ? item.getContent() : (item.getNoId() ? "" : item.getIdAsString())).collect(Collectors.joining(separator));
    }

    public static String getItemsPrimaryValue(List<JFCPresentationModelitemStorerefBase> items, String primaryKey) {
        if (items == null) {
            return "";
        }
        String getter = SourceGeneratorUtil.getterMethod((String)primaryKey);
        Optional<String> value = items.stream().filter(item -> item.getChoose()).findFirst().map(item -> {
            try {
                Object o = MethodUtils.invokeMethod((Object)item, (String)getter, null);
                return String.valueOf(o);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return null;
            }
        });
        return value.orElse("");
    }

    public static boolean ifItemSelected(List<JFCPresentationModelitemStorerefBase> items) {
        if (items == null) {
            return false;
        }
        return items.stream().anyMatch(item -> item.getChoose());
    }

    public static String replaceCharEntity(String s) {
        return WebStringEncodeUtilities.replaceCharEntity((String)s);
    }

    public static String formatNumber(String value, String pattern) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        if (!NumberUtils.isCreatable((String)value)) {
            logger.error("formatNumber Unable to convert value:[" + value + "] to number");
            return "";
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return value;
        }
        BigDecimal number = new BigDecimal(value);
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(number);
    }

    public static boolean checkUsername(HttpServletRequest request, String exceptPermname, String exceptPermaction, String owner) {
        return JfcUtil.checkUsername(request, exceptPermname, exceptPermaction, owner, null);
    }

    public static boolean checkUsername(HttpServletRequest request, String exceptPermname, String exceptPermaction, String[] owners) {
        return JfcUtil.checkUsername(request, exceptPermname, exceptPermaction, null, owners);
    }

    public static boolean checkUsername(HttpServletRequest request, String exceptPermname, String exceptPermaction, String owner, String[] owners) {
        User userObj;
        if (StringUtils.isNotBlank((CharSequence)exceptPermname) && StringUtils.isNotBlank((CharSequence)exceptPermaction)) {
            JfcCheckLogonUtil checkLogon = new JfcCheckLogonUtil();
            checkLogon.setPermname(exceptPermname);
            checkLogon.setPermactions(exceptPermaction);
            checkLogon.setPermclassname("jp.jasminesoft.jfc.JFCAppPermission");
            if (checkLogon.checkLogon(request)) {
                return true;
            }
        }
        if ((userObj = JFCUtils.getUserInSession(request.getSession(), request)) == null || !(userObj instanceof User)) {
            return false;
        }
        String username = userObj.getUsername();
        if (username == null) {
            return false;
        }
        if (owner != null && username.equals(owner)) {
            return true;
        }
        if (owners == null) {
            return false;
        }
        return Arrays.stream(owners).anyMatch(o -> username.equals(o));
    }

    public static boolean checkJgroupid(HttpServletRequest request, String exceptPermname, String exceptPermaction, boolean isSubGroup, JFCPresentationModelitemStorerefInt[] jgroupidjshparam) {
        HttpSession session = request.getSession();
        User userObj = JFCUtils.getUserInSession(session, request);
        if (userObj == null || !(userObj instanceof User)) {
            return false;
        }
        int[] user_groupid = isSubGroup ? userObj.getSubGroupIds() : userObj.getGroupId();
        if (user_groupid == null || user_groupid.length == 0 || jgroupidjshparam == null || jgroupidjshparam.length == 0) {
            return false;
        }
        Set groups = Arrays.stream(jgroupidjshparam).map(g -> g.getId()).collect(Collectors.toSet());
        return Arrays.stream(user_groupid).boxed().anyMatch(g -> groups.contains(g));
    }

    public static String showSourceModelHTML(HttpServletRequest request) {
        return (String)request.getAttribute("__jfc_latest_showSourceModel_html");
    }

    public static String style(HttpServletRequest request, String smodelname, String pmodelname, String modelitemname, String screenType) {
        return JFCStyleUtil.getStyle(request, smodelname, pmodelname, modelitemname, screenType);
    }

    public static String styleMulti(HttpServletRequest request, String smodelname, String pmodelname, String modelitemname, int index, String screenType) {
        return JFCStyleUtil.getStyle(request, smodelname, pmodelname, modelitemname, index, screenType);
    }

    public static int YEAR(String year) {
        return ExcelFunction.YEAR((String)year);
    }

    public static String TODAY() {
        return ExcelFunction.TODAYSTR();
    }

    public static String REMOVECR(String value) {
        return ExcelFunction.REMOVECR((String)value);
    }

    public static boolean isMobile(HttpServletRequest request) {
        return BaseController.isMobile(request);
    }

    public static boolean isInputError(JFCPresentationModelitemString item) {
        if (item == null) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)item.getErrorcode());
    }

    public static boolean isInputError(JFCPresentationModelitemStorerefBase[] items) {
        return Optional.ofNullable(items).map(Arrays::stream).orElse(Stream.empty()).anyMatch(item -> StringUtils.isNotBlank((CharSequence)item.getErrorcode()));
    }

    public static boolean isInputError(JFCPresentationModelitemMultiString item) {
        if (item == null) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)item.getErrorcode());
    }

    public static String multipleSessionAutoLogonUrl(HttpServletRequest request) {
        return MultipleSessionUtils.multipleSessionAutoLogonUrl(request);
    }

    public static boolean isDisplayGlobalLink(HttpServletRequest request) {
        Boolean isDisplayMenuIcon = (Boolean)request.getSession().getAttribute("__jfc_globallink_menuicon");
        Boolean isDisplayLogoffIcon = (Boolean)request.getSession().getAttribute("__jfc_globallink_logofficon");
        Boolean isSelectableFontSize = (Boolean)request.getAttribute("fontsize_selectable");
        Boolean isDisplayLogonUser = (Boolean)request.getSession().getAttribute("__jfc_bottomarea_mode");
        return isDisplayMenuIcon != false || isDisplayLogoffIcon != false || isSelectableFontSize != false || isDisplayLogonUser != false;
    }

    public static String substring(String value, int beginIndex, int endIndex) {
        if (StringUtils.isBlank((CharSequence)value) || beginIndex < 0 || beginIndex > value.length() || beginIndex > endIndex) {
            return "";
        }
        if (endIndex >= value.length()) {
            return value;
        }
        return value.substring(beginIndex, endIndex) + "...";
    }
}

