/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.th;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.jasminesoft.util.RandomString;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.XMLUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.EngineEventUtils;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.xml.sax.SAXException;

public class JfcXslNameAttributeTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor {
    private static final Logger logger = LogManager.getLogger(JfcXslNameAttributeTagProcessor.class);
    private String dialectPrefix;
    private ServletContext servletContext;

    public JfcXslNameAttributeTagProcessor(String dialectPrefix, ServletContext servletContext) {
        super(TemplateMode.HTML, dialectPrefix, "xslName", 1000, true);
        this.dialectPrefix = dialectPrefix;
        this.servletContext = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String result;
        XSLContext ctx = new XSLContext(context, tag, structureHandler);
        if (!ctx.isValid()) {
            return;
        }
        if (expressionResult == null) {
            return;
        }
        String _temporaryid = null;
        if (ctx.useTotalCache) {
            _temporaryid = this.getTotalCacheTemporaryid(expressionResult, ctx);
        }
        try {
            result = this.doProcess(attributeValue, expressionResult, ctx, _temporaryid);
        }
        catch (SAXException e) {
            logger.error("sax error " + attributeValue, (Throwable)e);
            return;
        }
        catch (IOException e) {
            logger.error("io error " + attributeValue, (Throwable)e);
            return;
        }
        finally {
            if (_temporaryid != null) {
                XMLUtil.clearCache((String)_temporaryid);
            }
        }
        if (result == null) {
            return;
        }
        structureHandler.setBody((CharSequence)result, false);
    }

    private String doProcess(String attributeValue, Object expressionResult, XSLContext ctx, String _temporaryid) throws SAXException, IOException {
        JAXBSource inputSource;
        HashMap<String, String> params = new HashMap<String, String>();
        if (_temporaryid != null) {
            params.put("__jfc_temporaryid", _temporaryid);
        }
        if (StringUtils.isNotEmpty((CharSequence)ctx.locale)) {
            params.put("__jfc_locale", ctx.locale);
        }
        if (ctx.xslParams != null) {
            params.putAll(this.getXSLParams(ctx.xslParams));
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{expressionResult.getClass()});
            inputSource = new JAXBSource(jaxbContext, expressionResult);
        }
        catch (JAXBException e) {
            logger.error("jaxb error " + attributeValue, (Throwable)e);
            return null;
        }
        StreamSource xslSource = this.getXSLSource(ctx.xslUri);
        if (xslSource == null) {
            logger.error("not found xsl resource " + ctx.xslUri);
            return null;
        }
        String result = this._transform((Source)inputSource, xslSource, params);
        if (logger.isDebugEnabled()) {
            logger.debug("result " + result);
        }
        return result;
    }

    private StreamSource getXSLSource(String xslUri) {
        InputStream istream = this.servletContext.getResourceAsStream(xslUri);
        if (istream == null) {
            return null;
        }
        return new StreamSource(istream);
    }

    private String getTotalCacheTemporaryid(Object obj, XSLContext ctx) {
        String _temporaryid = StringUtil.getMD5Hash((String)ctx.sessionId) + "-" + RandomString.createRandomString((int)16);
        XMLUtil.createCache((String)_temporaryid, (Object)obj, (String)ctx.countItemname, (String[])ctx.sumItemnames);
        return _temporaryid;
    }

    private Map<String, String> getXSLParams(String xslParams) {
        if (xslParams == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s1 : xslParams.split(";")) {
            String[] sa = s1.split(":");
            if (sa.length >= 2) {
                map.put(sa[0], sa[1]);
                continue;
            }
            if (sa.length != 1) continue;
            map.put(sa[0], "");
        }
        return map;
    }

    private Object getExpressionResult(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue) {
        Object expressionResult;
        StandardExpressionExecutionContext expressionExecutionContext = StandardExpressionExecutionContext.NORMAL;
        if (attributeValue != null) {
            IStandardExpression expression = EngineEventUtils.computeAttributeExpression((ITemplateContext)context, (IProcessableElementTag)tag, (AttributeName)attributeName, (String)attributeValue);
            if (expression != null && expression instanceof FragmentExpression) {
                FragmentExpression.ExecutedFragmentExpression executedFragmentExpression = FragmentExpression.createExecutedFragmentExpression((IExpressionContext)context, (FragmentExpression)((FragmentExpression)expression));
                expressionResult = FragmentExpression.resolveExecutedFragmentExpression((ITemplateContext)context, (FragmentExpression.ExecutedFragmentExpression)executedFragmentExpression, (boolean)true);
            } else {
                expressionResult = expression.execute((IExpressionContext)context, expressionExecutionContext);
            }
        } else {
            expressionResult = null;
        }
        return expressionResult;
    }

    private String _transform(Source inputSource, Source xslSource, Map<String, String> params) throws SAXException, IOException {
        try {
            StringWriter buffer = new StringWriter();
            StreamResult outputResult = new StreamResult(buffer);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslSource);
            if (transformer == null) {
                logger.error("transformer is null");
                return "";
            }
            this._setParams(transformer, params);
            transformer.transform(inputSource, outputResult);
            return buffer.toString();
        }
        catch (TransformerConfigurationException e) {
            logger.error("transformer configuration error", (Throwable)e);
            return "";
        }
        catch (TransformerException e) {
            logger.error("transformer error", (Throwable)e);
            return "";
        }
    }

    private void _setParams(Transformer transformer, Map<String, String> params) {
        Set<String> keys = params.keySet();
        for (String key : keys) {
            String value = params.get(key);
            transformer.setParameter(key, value);
        }
    }

    public class XSLContext {
        String xslUri;
        String xslParams;
        boolean useTotalCache;
        String countItemname;
        String[] sumItemnames;
        String sessionId;
        String locale;

        public XSLContext(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
            AttributeName localeAttrName;
            Object localeObj;
            AttributeName sessionIdAttrName;
            Object sessionIdObj;
            this.xslUri = tag.getAttributeValue(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslUri");
            structureHandler.removeAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslUri");
            this.xslParams = tag.getAttributeValue(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslParams");
            structureHandler.removeAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslParams");
            String sUseTotalCache = tag.getAttributeValue(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslUseTotalCache");
            structureHandler.removeAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslUseTotalCache");
            if (sUseTotalCache != null) {
                this.useTotalCache = Boolean.valueOf(sUseTotalCache);
            }
            this.countItemname = tag.getAttributeValue(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslTotalCoutItemname");
            structureHandler.removeAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslTotalCoutItemname");
            String s = tag.getAttributeValue(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslTotalSumItemname");
            structureHandler.removeAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslTotalSumItemname");
            if (s != null) {
                this.sumItemnames = s.split("[, ]");
            }
            IAttribute sessionIdAttr = tag.getAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslSessionId");
            structureHandler.removeAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslSessionId");
            if (sessionIdAttr != null && (sessionIdObj = JfcXslNameAttributeTagProcessor.this.getExpressionResult(context, tag, sessionIdAttrName = sessionIdAttr.getAttributeDefinition().getAttributeName(), sessionIdAttr.getValue())) != null) {
                this.sessionId = sessionIdObj.toString();
            }
            IAttribute localeAttr = tag.getAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslLocale");
            structureHandler.removeAttribute(JfcXslNameAttributeTagProcessor.this.dialectPrefix, "xslLocale");
            if (localeAttr != null && (localeObj = JfcXslNameAttributeTagProcessor.this.getExpressionResult(context, tag, localeAttrName = localeAttr.getAttributeDefinition().getAttributeName(), localeAttr.getValue())) != null) {
                this.locale = localeObj.toString();
            }
        }

        public boolean isValid() {
            if (StringUtils.isEmpty((CharSequence)this.xslUri)) {
                logger.error("none xslUri");
                return false;
            }
            if (this.useTotalCache && (StringUtils.isEmpty((CharSequence)this.countItemname) || this.sumItemnames == null || StringUtils.isEmpty((CharSequence)this.sessionId))) {
                logger.error("none useTotal parameters");
                logger.error("countItemname=" + this.countItemname);
                logger.error("sumItemnames=" + this.sumItemnames);
                logger.error("sessionId=" + this.sessionId);
                return false;
            }
            return true;
        }
    }
}

