/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import jp.jasminesoft.jfc.appgen.component.SimpleConditiondapter;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.StoreModelitem;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_parser;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.util.SourceGeneratorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class AbstractConditionAdapter
extends SimpleConditiondapter {
    protected StoreModelitem storeModelitem;

    public AbstractConditionAdapter(Condition condition, Model storeModel) {
        super(condition);
        this.storeModelitem = new StoreModel(storeModel).getModelitem(condition.getName());
    }

    public String getName() {
        return this.storeModelitem.getName();
    }

    public String getCond() {
        if (!"LIKE".equals(this.condition.getCond())) {
            return this.condition.getCond().toLowerCase();
        }
        if ("pre".equals(this.condition.getMatchtype())) {
            return "likePrefix";
        }
        if ("post".equals(this.condition.getMatchtype())) {
            return "likeSuffix";
        }
        if ("runtime".equals(this.condition.getMatchtype())) {
            return "likeRuntime";
        }
        return this.condition.getCond().toLowerCase();
    }

    public boolean isImplicit() {
        return this.condition.getImplicit();
    }

    public String getImplicitValue() {
        if (!this.isImplicit()) {
            return "null";
        }
        Object value = null;
        if ("username".equals(this.condition.getType())) {
            value = "user().getUsername()";
        } else if ("jgroupid".equals(this.condition.getType())) {
            value = "ArrayUtils.toObject(user().getGroupId())";
        } else if ("javacode".equals(this.condition.getType())) {
            value = this.condition.getValue();
            if (JavaSourceGenerator.isUseExpression((String)value)) {
                value = HelperGenerator_calc_parser.convertFunctionNames((String)value);
            }
        } else if ("function".equals(this.condition.getType())) {
            value = "null";
        }
        if (StringUtils.isBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)this.condition.getValue())) {
            value = this.condition.getValue();
            if (((String)value).trim().toLowerCase().equals("null")) {
                value = "NULLVALUE";
            } else if (JavaSourceGenerator.isUseExpression((String)value)) {
                value = HelperGenerator_calc_parser.convertFunctionNames((String)value);
            } else if ("string".equals(this.getStoreModelitem().getType())) {
                value = "\"" + (String)value + "\"";
            } else if (SourceGeneratorUtil.isBasicType((String)this.getStoreModelitem().getType())) {
                if (((String)value).indexOf(",") < 0) {
                    if (!NumberUtils.isCreatable((String)value)) {
                        throw new IllegalArgumentException((String)value);
                    }
                } else {
                    String[] tokens;
                    for (String token : tokens = ((String)value).split(",")) {
                        if (NumberUtils.isCreatable((String)token.trim())) continue;
                        throw new IllegalArgumentException(token);
                    }
                }
                value = SourceGeneratorUtil.castPrimitiveNumberCode((String)value, (String)this.getStoreModelitem().getType());
            } else if (JavaSourceGenerator.isDateOrTimeType(this.getStoreModelitem().getType())) {
                value = ((String)value).startsWith("now") ? this.convertNowFormat((String)value) : this.convertDateTimeCode((String)value);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.condition.getExceptPermname()) || StringUtils.isBlank((CharSequence)this.condition.getExceptPermaction())) {
            return value;
        }
        StringBuilder sb = new StringBuilder().append("new PermissionEvaluator(user(), \"").append(this.condition.getExceptPermname()).append("\", \"").append(this.condition.getExceptPermaction()).append("\").evaluate(null, ").append((String)value).append(")");
        return sb.toString();
    }

    protected String convertDateTimeCode(String value) {
        String type = this.getStoreModelitem().getType();
        if ("time".equals(type)) {
            value = "DateTimeUtil.getSQLTime(\"" + (String)value + "\")";
        } else if ("date".equals(type)) {
            value = "DateTimeUtil.getSQLDate(\"" + (String)value + "\")";
        } else if ("dateTime".equals(type)) {
            value = "DateTimeUtil.getSQLTimestamp(\"" + (String)value + "\")";
        }
        return value;
    }

    protected String convertNowFormat(String value) {
        String type = this.getStoreModelitem().getType();
        StringBuilder sb = new StringBuilder().append(JavaSourceGenerator.getProperSQLDateTimeConv(type)).append("(");
        if ("time".equals(type)) {
            sb.append("DateTimeUtil.getTimeWithNowFormat(\"");
            sb.append(value);
            sb.append("\")");
        } else {
            sb.append("DateTimeUtil.getDateWithNowFormat(\"");
            sb.append(value);
            sb.append("\")");
        }
        sb.append(")");
        return sb.toString();
    }

    public StoreModelitem getStoreModelitem() {
        return this.storeModelitem;
    }
}

