/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.generator;

import java.io.IOException;
import java.util.HashMap;
import jp.jasminesoft.jfc.appgen.generator.VelocityBasedGenerator;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Project;

public class EclipseSettingsGenerator {
    protected final Project project;

    public EclipseSettingsGenerator(Project project) {
        this.project = project;
    }

    public void generate() throws IOException {
        String[] options;
        VelocityBasedGenerator generator = new VelocityBasedGenerator(this.project, "eclipse");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("eclipseProjectName", "Wagby-9.3.3");
        context.put("contextName", AppSchemaUtil.getWebappName(this.project));
        String contextRoot = AppSchemaUtil.getWebappName(this.project);
        if (this.project.getEnvironment().getIsROOTdeployment()) {
            contextRoot = "/";
        }
        context.put("contextRoot", contextRoot);
        if (!this.project.getPackage().startsWith("jp.")) {
            String topLevelDomain = StringUtils.substringBefore((String)this.project.getPackage(), (String)".");
            context.put("classpathentryIncludings", "|" + topLevelDomain + "/**/*");
        } else {
            context.put("classpathentryIncludings", "");
        }
        StringBuilder sb = new StringBuilder();
        for (String option : options = this.project.getEnvironment().getTomcatOption().trim().split(" +")) {
            if (StringUtils.isBlank((CharSequence)option)) continue;
            sb.append("\"").append(option).append("\"");
            sb.append("\n");
        }
        context.put("options", sb);
        generator.addContext(context);
        generator.generate(".classpath.vm");
        generator.generate(".project.vm");
        generator.generate(".settings/.jsdtscope.vm");
        generator.generate(".settings/launchConfiguration.txt.vm");
        generator.generate(".settings/org.eclipse.jdt.core.prefs.vm");
        generator.generate(".settings/org.eclipse.wst.common.component.vm");
        generator.generate(".settings/org.eclipse.wst.common.project.facet.core.xml.vm");
        generator.generate(".settings/org.eclipse.wst.jsdt.ui.superType.container.vm");
        generator.generate(".settings/org.eclipse.wst.jsdt.ui.superType.name.vm");
        generator.generate(".settings/org.eclipse.wst.validation.prefs.vm");
    }
}

