/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CautionInnerDatabaseJspGenerator
extends ConfigGenerator {
    protected Logger logger = LogManager.getLogger((String)CautionInnerDatabaseJspGenerator.class.getName());
    public static final String FILENAME = "cautionInnerDatabase";
    public static final String SUFFIX = ".jsp";
    public static final String FULLFILENAME = "cautionInnerDatabase.jsp";
    private int limitSize = 1000;

    public CautionInnerDatabaseJspGenerator(String tmplatefilename, Project project) {
        super(tmplatefilename, project);
    }

    @Override
    public String getFileSuffix() {
        return SUFFIX;
    }

    @Override
    public String getFilename() {
        return FILENAME;
    }

    @Override
    public String getSubpackageName() {
        return "webpage";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        tplman.addContent("webencoding", JavaSourceGenerator.getWebEncoding(this.project));
        tplman.addContent("content", this.getContent());
        return tplman.getResult();
    }

    protected String getContent() {
        if (!DbTypeManager.isHSQLDB(this.project.getEnvironment())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<c:if test=\"${").append("jfc_result").append(".size > ").append(this.limitSize).append("}\">").append(CR).append("  ").append("<div class=\"errormsg\">").append(CR).append("    ").append("<fmt:message key=\"__jfc_common.text.caution.result.size\"> ").append(CR).append("      ").append("<fmt:param value=\"").append(this.limitSize).append("\"/> ").append(CR).append("    ").append("</fmt:message> ").append(CR).append("  ").append("</div>").append(CR).append("</c:if>").append(CR);
        return sb.toString();
    }
}

