/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ClassnameManager;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComparatorGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    protected Model model;
    protected Modelitem modelitem;
    protected ClassnameManager classnameman = new ClassnameManager();
    protected boolean isSelfReferenceFlag;
    protected Logger logger = LogManager.getLogger((String)ComparatorGenerator.class.getName());
    protected String[] defaultImportStatement = new String[]{"java.util.Comparator"};

    public ComparatorGenerator(Project project, Model model, Modelitem modelitem) {
        super(project);
        this.model = model;
        this.modelitem = modelitem;
        if ("storeref".equals(modelitem.getType())) {
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(modelitem);
            if (relation == null && !modelitem.getTransient()) {
                relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(model, modelitem);
            }
            if (relation != null && model != null && AppSchemaUtil.getRoleid(relation, project) != null && relation.getRolecontent() != null && relation.getIdref() != null && AppSchemaUtil.getRoleid(relation, project).equals(relation.getRolecontent()) && relation.getIdref().equals(AppSchemaUtil.getStoreModel(model).getId())) {
                this.isSelfReferenceFlag = true;
            }
        } else if ("combo".equals(modelitem.getDualinputmethod())) {
            this.isSelfReferenceFlag = true;
        } else if (modelitem.getTransient()) {
            this.isSelfReferenceFlag = true;
        }
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gComparatorMethod());
        sb.append(this.gEnd());
        return sb.toString();
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" implements Comparator");
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return this.getClassname();
    }

    @Override
    public String getClassname() {
        return AppSchemaUtil.getComparatorClassName(null, this.modelitem, this.model, this.model, this.isSelfReferenceFlag);
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, "comparator", this.model);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, "comparator", this.model);
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        for (int i = 0; i < this.defaultImportStatement.length; ++i) {
            if (importList.contains(this.defaultImportStatement[i])) continue;
            importList.add(this.defaultImportStatement[i]);
        }
        Model smodel = null;
        boolean isLSModel = false;
        if (AppSchemaUtil.isListStoreModel(this.model)) {
            smodel = AppSchemaUtil.getStoreModel(this.model);
            isLSModel = true;
        } else {
            smodel = this.model;
        }
        String suffix = null;
        String sc = AppSchemaUtil.getComparatorClassNameBase(this.model, this.isSelfReferenceFlag);
        suffix = sc.endsWith("Lp") ? "_lp" : (sc.endsWith("Lscp") ? "_lscp" : (sc.endsWith("Cp") ? "_cp" : (sc.endsWith("Tp") ? "_tp" : (sc.endsWith("P") ? "_p" : "_p"))));
        Model pmodel = AppSchemaUtil.getModel(this.project, smodel.getId(), "presentation");
        Object packagename = smodel.getPackage();
        if (packagename != null && ((String)packagename).length() > 0) {
            char c;
            int ptr;
            for (ptr = ((String)packagename).length() - 1; ptr > 0 && (c = ((String)packagename).charAt(ptr)) != '.'; --ptr) {
            }
            if (ptr > 0) {
                if ("_lp".equals(suffix) || "_tp".equals(suffix)) {
                    suffix = "_p";
                }
                packagename = ((String)packagename).substring(0, ptr + 1);
                packagename = (String)packagename + AppSchemaUtil.getStoreModelId(smodel.getId());
                packagename = (String)packagename + suffix;
            }
            packagename = (String)packagename + ".*";
        } else if ("master".equals(smodel.getType())) {
            packagename = "jp.jasminesoft.jfc.model.master.*";
        } else {
            Model target;
            packagename = this.project.getPackage();
            if (packagename != null && ((String)packagename).length() > 0) {
                StringBuilder sb = new StringBuilder((String)packagename);
                sb.append(".model.");
                packagename = sb.toString();
            } else {
                packagename = "";
            }
            Model model = target = pmodel != null ? pmodel : smodel;
            if (isLSModel) {
                packagename = (String)packagename + target.getId();
            } else {
                packagename = (String)packagename + AppSchemaUtil.getStoreModelId(target.getId());
                packagename = (String)packagename + suffix;
            }
            packagename = (String)packagename + ".*";
        }
        importList.add((String)packagename);
        return importList.toArray(new String[0]);
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            this.classnameman.setPackagename(this.project.getPackage() + "." + this.getSubpackageNameAsJavaRule());
        }
        if ((ary = this.getDefaultImport()) != null) {
            this.classnameman.setClassnames(ary);
        }
        sb.append(this.classnameman.outputPackageAndImportCode());
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected String gComparatorMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("/** " + rman.getValue("java.comment.constructor") + " */");
        sb.append(CR);
        sb.append("    ");
        sb.append("public ");
        sb.append(this.getClassname());
        sb.append("() {}");
        sb.append(CR);
        sb.append(CR);
        String[] msg_param = new String[]{"o1 Object", "o2 Object"};
        sb.append(CommentGenerator.gComment(rman.getValue("comparator.comment.compare"), msg_param, "int"));
        String classname = AppSchemaUtil.getModelitemClassname(this.modelitem);
        sb.append("    ");
        sb.append("public int compare(Object o1, Object o2) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (o1 == null || o2 == null || ");
        sb.append(CR);
        sb.append("            ");
        sb.append("!(o1 instanceof ");
        sb.append(classname);
        sb.append(") || !(o2 instanceof ");
        sb.append(classname);
        sb.append(")) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return 0;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append(classname);
        sb.append(" p1 = (");
        sb.append(classname);
        sb.append(")o1;");
        sb.append(CR);
        sb.append("        ");
        sb.append(classname);
        sb.append(" p2 = (");
        sb.append(classname);
        sb.append(")o2;");
        sb.append(CR);
        if (this.isSelfReferenceFlag) {
            this.gComparatorMethod_selfRef(classname, sb);
        } else {
            this.gComparatorMethod_normal(classname, sb);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected void gComparatorMethod_selfRef(String classname, StringBuilder sb) {
        sb.append("        ");
        sb.append("String cnt1 = p1.getContent();");
        sb.append(CR);
        sb.append("        ");
        sb.append("String cnt2 = p2.getContent();");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (cnt1 == null && cnt2 == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return 0;");
        sb.append(CR);
        sb.append("        ");
        sb.append("else if (cnt1 == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return -1;");
        sb.append(CR);
        sb.append("        ");
        sb.append("else if (cnt2 == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return 1;");
        sb.append(CR);
        sb.append("        ");
        sb.append("else");
        sb.append(CR);
        sb.append("            ");
        sb.append("return cnt1.compareTo(cnt2);");
        sb.append(CR);
    }

    protected void gComparatorMethod_normal(String classname, StringBuilder sb) {
        sb.append("        ");
        sb.append("int ret = 0;");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("int priority1 = (p1.getPriority() > 0) ? p1.getPriority() : 0;");
        sb.append(CR);
        sb.append("        ");
        sb.append("int priority2 = (p2.getPriority() > 0) ? p2.getPriority() : 0;");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (priority1 != priority2) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("ret = priority2 - priority1;");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else {");
        sb.append(CR);
        String type = null;
        if ("storeref".equals(this.modelitem.getType())) {
            type = AppSchemaUtil.getModelitemType(this.project, this.model.getId(), this.modelitem, "roleid");
            if ("int[]".equals(type = JavaSourceGenerator.getProperType(type))) {
                type = "int";
            }
        } else if ("masterref".equals(this.modelitem.getType())) {
            type = "int";
        } else if ("combo".equals(this.modelitem.getDualinputmethod())) {
            type = "String";
        } else if (this.modelitem.getTransient()) {
            type = "int";
        }
        if (type != null) {
            sb.append("            ");
            sb.append(type);
            sb.append(" id1 = p1.getId();");
            sb.append(CR);
            sb.append("            ");
            sb.append(type);
            sb.append(" id2 = p2.getId();");
            sb.append(CR);
            if (JavaSourceGenerator.isBasicType(type)) {
                sb.append("            ");
                sb.append("ret = id1 - id2;");
                sb.append(CR);
            } else {
                sb.append("            ");
                sb.append("if (id1 == null && id2 == null)");
                sb.append(CR);
                sb.append("                ");
                sb.append("ret = 0;");
                sb.append(CR);
                sb.append("            ");
                sb.append("else if (id1 == null)");
                sb.append(CR);
                sb.append("                ");
                sb.append("ret = -1;");
                sb.append(CR);
                sb.append("            ");
                sb.append("else if (id2 == null)");
                sb.append(CR);
                sb.append("                ");
                sb.append("ret = 1;");
                sb.append(CR);
                sb.append("            ");
                sb.append("else");
                sb.append(CR);
                sb.append("                ");
                sb.append("ret = id1.compareTo(id2);");
                sb.append(CR);
            }
        } else {
            this.logger.warn("type is null, model:" + this.model.getId() + ",modelitem:" + this.modelitem);
            sb.append("            ");
            sb.append("ret = 0;");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return ret;");
        sb.append(CR);
    }
}

